/*----------------------------------------------------------------------------
 * U S B  -  K e r n e l
 *----------------------------------------------------------------------------
 * Name:    usbuser.c
 * Purpose: USB Custom User Module
 * Version: V1.20
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2009 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include "type.h"

#include "usb.h"
#include "usbcfg_LPC13xx.h"
#include "usbhw_LPC13xx.h"
#include "usbcore.h"
#include "usbuser.h"

#include "hiduser.h"
#include "demo.h"



/*
 *  USB Reset Event Callback
 *   Called automatically on USB Reset Event
 */

#if USB_RESET_EVENT
void USB_Reset_Event (void) 
{
	USB_ResetCore();
}
#endif

/*
 *  USB Set Configuration Event Callback
 *   Called automatically on USB Set Configuration Request
 */

#if USB_CONFIGURE_EVENT
void USB_Configure_Event (void) 
{
	if (USB_Configuration)                    /* Check if USB is configured */
    {
		GetInReport();
		USB_WriteEP(HID_EP_IN, &InReport, sizeof(InReport));
	}
}
#endif


#define P_EP(n) ((USB_EP_EVENT & (1 << (n))) ? USB_EndPoint##n : NULL)

/* USB Endpoint Events Callback Pointers */
void (* const USB_P_EP[16]) (U32 event) = 
{
	P_EP(0),
	P_EP(1),
	P_EP(2),
	P_EP(3),
	P_EP(4),
	P_EP(5),
	P_EP(6),
	P_EP(7),
	P_EP(8),
	P_EP(9),
	P_EP(10),
	P_EP(11),
	P_EP(12),
	P_EP(13),
	P_EP(14),
	P_EP(15),
};


/*
 *  USB Endpoint 1 Event Callback
 *   Called automatically on USB Endpoint 1 Event
 *    Parameter:       event
 */

void USB_EndPoint1 (U32 event) 
{
	switch (event) 
	{
		case USB_EVT_IN:
			GetInReport();
			if(INPORT_NUM)
			{
				 
			/*	if(INPORT[0] != 0x04)
				{	
					USB_WriteEP(HID_EP_IN, &INPORT[0], INPORT_NUM);
					INPORT_NUM = 0;	
				}
				else */if(INPORT[4] == 0xFF)
				{
					//INPORT[0]=0x04;
					INPORT[1]=0x00;
					INPORT[2]=0x00;
					USB_WriteEP(HID_EP_IN, &INPORT[0], INPORT_NUM);
					INPORT_NUM = 0;
					INPORT[4] = 0x00;
				}
				else 
				{
					INPORT[4] = 0xFF;
					USB_WriteEP(HID_EP_IN, &INPORT[0], INPORT_NUM);
				}
			}
			else
			{
				INPORT[0]=0x00;
				INPORT[1]=0x00;
				INPORT[2]=0x00;
				USB_WriteEP(HID_EP_IN, &INPORT[0], INPORT_NUM);
			}  
			break;
	}
}


