
#include <LPC13xx.H>                        /* LPC13xx definitions */

#include "type.h"

#include "timer.h"
#include "gpio.h"

uint32_t gpio_test;

uint32_t IR_Status = 0;
uint32_t IR_HeadOtherStatus = 0;
uint32_t IR_DataBitNum = 0;
uint32_t IR_Data = 0;
uint32_t IR_DataShift = 0;
uint32_t IR_DataBufNum = 0;


void GPIO_Init(void)
{
	LPC_SYSCON -> SYSAHBCLKCTRL |= (1 << 6) | (1 << 16);

	// GPIO2_7: for LED output (IR data indication)
	LPC_GPIO2 -> DIR |= 0x80;		  		// GPIO2_7: output
	
	// GPIO3_0: for IR data input
	//LPC_IOCON -> PIO3_0 &= 0xFFFFFFD0;	  // GPIO3_0: pull_up resistor
	//LPC_IOCON -> PIO3_0 |= 0x50;

	LPC_GPIO3 -> DIR &= 0xFFFFFFFE;		  // GPIO3_0: input

	LPC_GPIO3 -> IS &= 0xFFFFFFFE;		  // GPIO3_0: sense interrupt

	LPC_GPIO3 -> IBE |= 0x01;		      // GPIO3_0: both edge

	LPC_GPIO3 -> IE |= 0x01;			      // GPIO3: enable GPIO3_0 interrupt

	NVIC_EnableIRQ(EINT3_IRQn);
}


// the polarity from this IR module is inverse with RC-6
//
// RC-6 Mode 6A
//
// Format:
//
// Leader:
// Start Bit:			0(B) ----> 1(B)
// Mode Bits:			001(B) ----> 110(B)
// long customer code: 7FF0(H) ----> 800F(H)
// info.			   xxxx(H)
void PIOINT3_IRQHandler(void)
{
	uint32_t tmp;

	if(LPC_GPIO3 -> MIS & 0x01)
	{	 gpio_test++;
		LPC_GPIO3 -> IC |= 0x01;
		tmp = (LPC_GPIO3 -> DATA & 0x01);
		if(tmp == 0) // falling edge
		{
			//LPC_GPIO2 -> DATA &=0xFFFFFF7F;     // LED on	   moved to case IR_DATA:
			switch(IR_Status)
			{
				case IR_IDEL:
					Enable_Timer32B0();
					IR_Status = IR_LEADERMARK;
					break;
				case IR_LEADERMARK:
					Reset_IR();
					return;
				case IR_HEADOTHER:
					tmp = GetValue_Timer32B0();
					Reset_Timer32B0();
					Enable_Timer32B0();
					switch(IR_HeadOtherStatus)
					{
						case 0:
						case 6:
						case 8:
							if((tmp < (RC6_MIN << 1)) || (tmp > (RC6_MAX << 1)))
							{
								Reset_IR();
								return;
							}
							IR_HeadOtherStatus++;
							break;
						case 2:
						case 4:
							if((tmp < (RC6_MIN)) || (tmp > (RC6_MAX)))
							{
								Reset_IR();
								return;
							}
							IR_HeadOtherStatus++;
							break;
						case 1:
						case 3:
						case 5:
						case 7:
						case 9:
						default:
							Reset_IR();
							return;
					}
					break;
				case IR_DATA:
					LPC_GPIO2 -> DATA &=0xFFFFFF7F;     // LED on
					tmp = GetValue_Timer32B0();
					Reset_Timer32B0();
					Enable_Timer32B0();
					if(IR_DataBitNum > 63)
					{
						Reset_IR();
						return;
					}
					if((tmp > (RC6_MIN << 1)) && (tmp < (RC6_MAX << 1)))
					{
						if((IR_DataBitNum % 2) == 1)
						{
							IR_DataShift = (IR_DataShift << 1) + 1;
							IR_DataBitNum += 2;
						}
						else
						{
							Reset_IR();
							return;
						}
					}
					else if((tmp > RC6_MIN) && (tmp < RC6_MAX))
					{
						if((IR_DataBitNum % 2) == 0)
						{
							IR_DataShift = (IR_DataShift << 1) + 1;
						}
						IR_DataBitNum += 1;
					}
					else
					{
						Reset_IR();
						return;
					}
					break;		
			}
		}
		else  // rising edge
		{
			LPC_GPIO2 -> DATA |=0x80;     // LED off
			switch(IR_Status)
			{
				case IR_IDEL:
					Reset_IR();
					return;
				case IR_LEADERMARK:
					tmp = GetValue_Timer32B0();
					Reset_Timer32B0();
					Enable_Timer32B0();
					if((tmp > (RC6_MIN * 6)) && (tmp < (RC6_MAX * 6)))
					{
						IR_Status = IR_HEADOTHER;
					}
					else
					{
						Reset_IR();
						return;
					}
					break;
				case IR_HEADOTHER:
					tmp = GetValue_Timer32B0();
					Reset_Timer32B0();
					Enable_Timer32B0();
					switch(IR_HeadOtherStatus)
					{
						case 9:
							if((tmp > (RC6_MIN << 1)) && (tmp < (RC6_MAX << 1)))
							{
								IR_Status = IR_DATA;
								IR_DataBitNum = 0;
							}
							else if((tmp > (RC6_MIN * 3)) && (tmp < (RC6_MAX * 3)))
							{
								IR_Status = IR_DATA;
								IR_DataBitNum = 1;
								IR_DataShift = 0x0;
							}
							else
							{
								Reset_IR();
								return;
							}
							break;
						case 1:
						case 3:
						case 5:
						case 7:
							if((tmp < (RC6_MIN)) || (tmp > (RC6_MAX)))
							{
								Reset_IR();
								return;
							}
							IR_HeadOtherStatus++;
							break;
						case 0:
						case 2:
						case 4:
						case 6:
						case 8:
						default:
							Reset_IR();
							return;
					}
					break;
				case IR_DATA:
					tmp = GetValue_Timer32B0();
					Reset_Timer32B0();
					Enable_Timer32B0();
					if(IR_DataBitNum > 63)
					{
						Reset_IR();
						return;
					}
					if((tmp > (RC6_MIN << 1)) && (tmp < (RC6_MAX << 1)))
					{
						if((IR_DataBitNum % 2) == 1)
						{
							IR_DataShift = (IR_DataShift << 1);
							IR_DataBitNum += 2;
						}
						else
						{
							Reset_IR();
							return;
						}
					}
					else if((tmp > RC6_MIN) && (tmp < RC6_MAX))
					{
						if((IR_DataBitNum % 2) == 0)
						{
							IR_DataShift = (IR_DataShift << 1);
						}
						IR_DataBitNum += 1;
					}
					else
					{
						Reset_IR();
						return;
					}
					break;		
			}
		}
	}
}

void Reset_IR(void)
{
	IR_Status = 0;
	IR_HeadOtherStatus = 0;
	IR_DataBitNum = 0;
	//IR_Data = 0;
	//IR_DataShift = 0;


	Disable_Timer32B0();
	Reset_Timer32B0();
}

