/****************************************************************************
 *   $Id:: lpc8xx_gpio.c 5137 2010-10-07 00:15:18Z nxp28433                        $
 *   Project: NXP LPC8xx GPIO example
 *
 *   Description:
 *     This file contains GPIO code example which include GPIO 
 *     initialization, GPIO interrupt handler, and related APIs for 
 *     GPIO access.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC8xx.h"			/* LPC8xx Peripheral Registers */
#include "lpc8xx_nmi.h"
#include "lpc8xx_gpio.h"
#include "mrt.h"


volatile uint32_t LastButtonValue = 0;
extern volatile uint32_t TimeTick;
volatile uint8_t DataMaskFlag = 0;
// P0.2,P0.3, P0.4, P0.5 arn't used for debug mode
volatile uint32_t OutputMask[] = {(1<<2),(1<<3),(1<<5),(1<<4),(1<<11),(1<<12),(1<<13),(1<<17)};


/*****************************************************************************
** Function name:		FLEX_INT0_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void FLEX_INT0_IRQHandler(void)
{
	uint32_t i=0, j=0;
	static uint8_t flag = 1;
	uint16_t ButtonValue;
	uint16_t button_temp[] = {BUTTEN_RECORDEDTV, BUTTEN_1, BUTTEN_2, BUTTEN_GUIDE, 
											BUTTEN_VOLUMEDOWN, BUTTEN_CHANNELDOWN, BUTTEN_DVDMENU,
											BUTTEN_LIVETV};
									
	LPC_GPIO -> CLR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// P0.2,P0.3, P0.5, P0.4 arn't used for debug mode
// otherwise i should be started from 0
	for(i = 0; i < 8; i++)
	{
		LPC_GPIO -> SET[0] = OutputMask[i];
		for(j = 0;j < 100; j++) __NOP();
		if(((LPC_GPIO -> PIN[0]) & (1<<PINT0_BIT)))
		{
			flag = !flag;
			if(flag) return;
			DataMaskFlag = !DataMaskFlag;	
			if(DataMaskFlag) ButtonValue = button_temp[i] & 0x7FFF;
			else ButtonValue = button_temp[i];
			Send_Data(ButtonValue);
			while(1)
			{
				TimeTick = 0;
				while(TimeTick < 5);
				TimeTick = 0;
				if(((LPC_GPIO -> PIN[0]) & (1<<PINT0_BIT)))
					Send_Data(ButtonValue);
				else
					break;
			}
			LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
														| (1 << 12) | (1 << 13)
														| (1 << 17) | (1 << 2)
														| (1 << 3) | (1 << 5));
			return;
		}
	}
}

/*****************************************************************************
** Function name:		FLEX_INT1_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void FLEX_INT1_IRQHandler(void)
{
	uint32_t i, j;
	static uint8_t flag = 1;
	uint16_t ButtonValue;
	uint16_t button_temp1[] = {BUTTEN_REWIND, BUTTEN_SKIPBACKWARD, BUTTEN_STOP, BUTTEN_PLAY, 
											BUTTEN_BACK, BUTTEN_FASTFORWARD, BUTTEN_MORE,
											BUTTEN_SKIPFORWARD};
	uint16_t button_temp2[] = {BUTTEN_MUTE, BUTTEN_RECORD, BUTTEN_PICTURES, BUTTEN_MUSIC, 
											BUTTEN_TV, BUTTEN_SLEEPTOGGLE, BUTTEN_VIDEOS,
											BUTTEN_PAUSE};
	
	LPC_GPIO -> CLR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// P0.2,P0.3, P0.5, P0.4 arn't used for debug mode
// otherwise i should be started from 0
	for(i = 0; i < 8; i++)
	{
		LPC_GPIO -> SET[0] = OutputMask[i];
		for(j = 0;j < 100; j++) __NOP();
		if(((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT2_BIT))))
		{
			flag = !flag;
			if(flag) return;
			DataMaskFlag = !DataMaskFlag;	
			if(DataMaskFlag) ButtonValue = button_temp1[i] & 0x7FFF;
			else ButtonValue = button_temp1[i];
			Send_Data(ButtonValue);
			while(1)
			{
				TimeTick = 0;
				while(TimeTick < 5);
				TimeTick = 0;
				if(((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT2_BIT))))
					Send_Data(ButtonValue);
				else
					break;
			}
			LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
														| (1 << 12) | (1 << 13)
														| (1 << 17) | (1 << 2)
														| (1 << 3) | (1 << 5));
			return;
		}
	}
	
	LPC_GPIO -> CLR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// P0.2,P0.3, P0.5, P0.4 arn't used for debug mode
// otherwise i should be started from 0
	for(i = 0; i < 8; i++)
	{
		LPC_GPIO -> SET[0] = OutputMask[i];
		for(j = 0;j < 100; j++) __NOP();
		if(((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT3_BIT))))
		{
			flag = !flag;
			if(flag) return;
			DataMaskFlag = !DataMaskFlag;	
			if(DataMaskFlag) ButtonValue = button_temp2[i] & 0x7FFF;
			else ButtonValue = button_temp2[i];
			Send_Data(ButtonValue);
			while(1)
			{
				TimeTick = 0;
				while(TimeTick < 5);
				TimeTick = 0;
				if(((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT3_BIT))))
					Send_Data(ButtonValue);
				else
					break;
			}
			LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
														| (1 << 12) | (1 << 13)
														| (1 << 17) | (1 << 2)
														| (1 << 3) | (1 << 5));
			return;
		}
	}
}


/*****************************************************************************
** Function name:		FLEX_INT2_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void FLEX_INT2_IRQHandler(void)
{
	uint32_t i=0, j=0;
	static uint8_t flag = 1;
	uint16_t ButtonValue;
	uint16_t button_temp[] = {BUTTEN_7, BUTTEN_4, BUTTEN_5, BUTTEN_8, 
											BUTTEN_STAR, BUTTEN_6, BUTTEN_3,
											BUTTEN_9};
									
	LPC_GPIO -> CLR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// P0.2,P0.3, P0.5, P0.4 arn't used for debug mode
// otherwise i should be started from 0
	for(i = 0; i < 8; i++)
	{
		LPC_GPIO -> SET[0] = OutputMask[i];
		for(j = 0;j < 100; j++) __NOP();
		if(((LPC_GPIO -> PIN[0]) & (1<<PINT2_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT))))
		{
			flag = !flag;
			if(flag) return;
			DataMaskFlag = !DataMaskFlag;	
			if(DataMaskFlag) ButtonValue = button_temp[i] & 0x7FFF;
			else ButtonValue = button_temp[i];
			Send_Data(ButtonValue);
			while(1)
			{
				TimeTick = 0;
				while(TimeTick < 5);
				TimeTick = 0;
				if(((LPC_GPIO -> PIN[0]) & (1<<PINT2_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT))))
					Send_Data(ButtonValue);
				else
					break;
			}
			LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
														| (1 << 12) | (1 << 13)
														| (1 << 17) | (1 << 2)
														| (1 << 3) | (1 << 5));
			return;
		}
	}
}

/*****************************************************************************
** Function name:		FLEX_INT3_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void FLEX_INT3_IRQHandler(void)
{
	uint32_t i=0, j=0;
	static uint8_t flag = 1;
	uint16_t ButtonValue;
	uint16_t button_temp[] = {BUTTEN_CLEAR, 0, BUTTEN_ENTER, BUTTEN_0, 
											0, 0, 0,
											BUTTEN_SHARP};
									
	LPC_GPIO -> CLR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// P0.2,P0.3, P0.5, P0.4 arn't used for debug mode
// otherwise i should be started from 0
	for(i = 0; i < 8; i++)
	{
		LPC_GPIO -> SET[0] = OutputMask[i];
		for(j = 0;j < 100; j++) __NOP();
		if(((LPC_GPIO -> PIN[0]) & (1<<PINT3_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT))))
		{
			flag = !flag;
			if(flag) return;
			DataMaskFlag = !DataMaskFlag;	
			if(DataMaskFlag) ButtonValue = button_temp[i] & 0x7FFF;
			else ButtonValue = button_temp[i];
			Send_Data(ButtonValue);
			while(1)
			{
				TimeTick = 0;
				while(TimeTick < 5);
				TimeTick = 0;
				if(((LPC_GPIO -> PIN[0]) & (1<<PINT3_BIT)) && (!((LPC_GPIO -> PIN[0]) & (1<<PINT1_BIT))))
					Send_Data(ButtonValue);
				else
					break;
			}
			LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
														| (1 << 12) | (1 << 13)
														| (1 << 17) | (1 << 2)
														| (1 << 3) | (1 << 5));
			return;
		}
	}
}

/*****************************************************************************
** Function name:		FLEX_INT4_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void FLEX_INT4_IRQHandler(void)
{
	uint32_t i, j;
	static uint8_t flag = 1;
	uint16_t ButtonValue;
	uint16_t button_temp[] = {BUTTEN_GREENSTART, BUTTEN_LEFT, BUTTEN_OK, BUTTEN_UP, 
											BUTTEN_VOLUMEUP, BUTTEN_CHANNELUP, BUTTEN_RIGHT,
											BUTTEN_DOWN};
											
	LPC_GPIO -> CLR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// P0.2,P0.3, P0.5, P0.4 arn't used for debug mode
// otherwise i should be started from 0
	for(i = 0; i < 8; i++)
	{
		LPC_GPIO -> SET[0] = OutputMask[i];
		for(j = 0;j < 100; j++) __NOP();
		if(((LPC_GPIO -> PIN[0]) & (1<<PINT4_BIT)))
		{
			flag = !flag;
			if(flag) return;
			DataMaskFlag = !DataMaskFlag;	
			if(DataMaskFlag) ButtonValue = button_temp[i] & 0x7FFF;
			else ButtonValue = button_temp[i];
			Send_Data(ButtonValue);
			while(1)
			{
				TimeTick = 0;
				while(TimeTick < 5);
				TimeTick = 0;
				if(((LPC_GPIO -> PIN[0]) & (1<<PINT4_BIT)))
					Send_Data(ButtonValue);
				else
					break;
			}
			LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
														| (1 << 12) | (1 << 13)
														| (1 << 17) | (1 << 2)
														| (1 << 3) | (1 << 5));
			return;
		}
	}
}

/*****************************************************************************
** Function name:		GPIOInit
**
** Descriptions:		Initialize GPIO and GPIO INT block
**
** parameters:			None
** Returned value:	None
** 
*****************************************************************************/
void GPIOInit( void )
{
  /* Enable AHB clock to the GPIO domain. */
  LPC_SYSCON -> SYSAHBCLKCTRL |= ((1<<6) | (1<<16));
	
	/* Peripheral reset control to GPIO and GPIO INT, a "1" bring it out of reset. */
	LPC_SYSCON -> PRESETCTRL &= ~(0x1<<10);
	LPC_SYSCON -> PRESETCTRL |= (0x1<<10);
  
	// IR & LED
	LPC_GPIO -> DIR[0] |= (1 << IR_BIT);
	LPC_IOCON -> PIO0_8 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_8 |= (0x01 << 3);
	LPC_GPIO -> CLR[0] |= (1 << IR_BIT);
	
	// P0.15 connected GND on test board. for power consumption decreation
	LPC_IOCON -> PIO0_15 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_15 |= (0x01 << 3);	
	LPC_IOCON -> PIO0_17 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_9 &= ~(0x03 << 3);
	LPC_GPIO -> DIR[0] |= 1<<9;
	LPC_GPIO -> CLR[0] |= 1<<9;
	
	// disable SWD /RESET function (P0.5, P0.2, P0.3)
 	*(uint32_t *)0x4000C1C0 |= (0x03 << 2) | (0x01 << 6);
	// KEYs -- output. no pull-up/down
	LPC_GPIO -> DIR[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
// 	LPC_IOCON -> PIO0_4 &= ~(0x03 << 3);
//  	LPC_IOCON -> PIO0_11 |= (0x01 << 8);
// 	LPC_IOCON -> PIO0_12 &= ~(0x03 << 3);
// 	LPC_IOCON -> PIO0_13 &= ~(0x03 << 3);
// 	LPC_IOCON -> PIO0_17 &= ~(0x03 << 3);
// 	LPC_IOCON -> PIO0_2 &= ~(0x03 << 3);
// 	LPC_IOCON -> PIO0_3 &= ~(0x03 << 3);
// 	LPC_IOCON -> PIO0_5 &= ~(0x03 << 3);
	LPC_GPIO -> SET[0] |= ((1 << 4) | (1 << 11)
												| (1 << 12) | (1 << 13)
												| (1 << 17) | (1 << 2)
												| (1 << 3) | (1 << 5));
	
	// KEYs -- input, pull-down
	// P0.0, P0.1, P0.6, P0.7, P0.14
	LPC_GPIO -> DIR[0] &= ~((1<<0)|(1<<1)|(1<<6)|(1<<7)|(1<<14));
	LPC_IOCON -> PIO0_0 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_0 |= 0x01 << 3;
	LPC_IOCON -> PIO0_1 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_1 |= 0x01 << 3;
	LPC_IOCON -> PIO0_6 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_6 |= 0x01 << 3;
	LPC_IOCON -> PIO0_7 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_7 |= 0x01 << 3;
	LPC_IOCON -> PIO0_14 &= ~(0x03 << 3);
	LPC_IOCON -> PIO0_14 |= 0x01 << 3;
	
	
	// select input pins to act as wakeup or int source
	LPC_SYSCON -> PINTSEL[0] = PINT0_BIT; 
	LPC_SYSCON -> PINTSEL[1] = PINT1_BIT;
	LPC_SYSCON -> PINTSEL[2] = PINT2_BIT;
	LPC_SYSCON -> PINTSEL[3] = PINT3_BIT;
	LPC_SYSCON -> PINTSEL[4] = PINT4_BIT;
	LPC_SYSCON -> STARTERP0 = 0x1F;	
	
	// hi level
	LPC_GPIO_PIN_INT -> ISEL = 0x1F; 
	LPC_GPIO_PIN_INT -> IENF = 0x1F;
	//LPC_GPIO_PIN_INT -> SIENF = 0x1F;
	LPC_GPIO_PIN_INT -> IENR = 0x1F;
	//LPC_GPIO_PIN_INT -> SIENR = 0x1F;
	
	NVIC_SetPriority(FLEX_INT0_IRQn, 3);
	NVIC_SetPriority(FLEX_INT1_IRQn, 3);
 	NVIC_SetPriority(FLEX_INT2_IRQn, 3);
 	NVIC_SetPriority(FLEX_INT3_IRQn, 3);
 	NVIC_SetPriority(FLEX_INT4_IRQn, 3);
	
	NVIC_EnableIRQ(FLEX_INT0_IRQn);
 	NVIC_EnableIRQ(FLEX_INT1_IRQn);
  NVIC_EnableIRQ(FLEX_INT2_IRQn);
  NVIC_EnableIRQ(FLEX_INT3_IRQn);
  NVIC_EnableIRQ(FLEX_INT4_IRQn);
}




/******************************************************************************
**                            End Of File
******************************************************************************/
