/****************************************************************************
 *   $Id:: sct_ctouch.h 8974 2014-03-23					$
 *   Project: NXP LPC8xx CMP example
 *
 *   Description:
 *     This file contains Capacitive Touch SCT related register and
 *     register-bits related definitions.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.

 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors'
 * relevant copyright in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers. This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
****************************************************************************/

#ifndef __SCT_CTOUCH_H__
#define __SCT_CTOUCH_H__

#include "sct_defs.h"

	/* This file was originally derived from the State-Red SCT Tool and was	 */
	/* edited to show how the register-setup would be without using the tool */
	/* the commented sections are remainders from the State-Red SCT Tool	 */

#define eVal_IntervalTimer ((SystemCoreClock / 5000) * 10)
#define eVal_StartSample   ((SystemCoreClock / 5000) *  6)

enum {
  eVal_MinValue	 = 10
} ;

enum {		/* input Defs	*/
  eCtrl_PwmInput = eCtrl_IOSel0,
} ;

enum {		/* output Defs	*/
  eOut_ButtonPress = ePin1,

  bOut_ButtonPress = bPin1
} ;

enum {		/* Mat/Cap Regs	*/
  eReg_IntervalTimer  = eReg0,	/* match high ctr	*/
  eReg_EnaLowTimer    = eReg1,	/* match high ctr	*/

  eReg_MatchPressed   = eReg0,	/* match low  ctr	*/
  eReg_EventWidth     = eReg1,	/* capt  low  ctr	*/

  eCtrl_IntervalTimer = eCtrl_Match0,
  eCtrl_EnaLowTimer   = eCtrl_Match1,

  eCtrl_MatchPressed  = eCtrl_Match0
} ;

enum {	/* Event Defs	*/
  eEvt_IntervalTimer  = eEvt0,
  eEvt_EnaLowTimer    = eEvt1,
  eEvt_ResetCounter   = eEvt2,
  eEvt_MatchPressed   = eEvt3,
  eEvt_MeasurePeriod  = eEvt4,

  bEvt_IntervalTimer  = bEvt0,
  bEvt_EnaLowTimer    = bEvt1,
  bEvt_ResetCounter   = bEvt2,
  bEvt_MatchPressed   = bEvt3,
  bEvt_MeasurePeriod  = bEvt4
} ;

extern void sct_ctouch_init (void) ;

/* macros for defining the mapping between IRQ and events */
//#define sct_fsm_IRQ_EVENT_Interval_timer_IRQ (0)

/* Input assignments */
//#define sct_fsm_INPUT_pwm_input (0)

/* Output assignments (and their defaults if specified) */
//#define sct_fsm_OUTPUT_button_press (1)
//#define sct_fsm_OUTPUTPRELOAD_button_press (1)

/* Capture registers */
//#define sct_fsm_CAPTURE_Oscillator_period LPC_SCT->CAP_L[1]
  #define sct_fsm_CAPTURE_Oscillator_period LPC_SCT->CAP[1].L

//#define sct_fsm_setOutputDefault() do {LPC_SCT->OUTPUT = (LPC_SCT->OUTPUT & ~0x00000002) | 0x00000002;} while(0)

/* Match register reload macro definitions */
//#define sct_fsm_reload_interval_timer(value) do {LPC_SCT->MATCHREL_H[0] = value;} while(0)
//#define sct_fsm_reload_min_value(value) do {LPC_SCT->MATCHREL_L[0] = value;} while(0)
//#define sct_fsm_reload_start_sample(value) do {LPC_SCT->MATCHREL_H[1] = value;} while(0)

#endif	/* __SCT_CTOUCH_H__	*/
