/****************************************************************************
 *   $Id:: lpc8xx_gpio.c 5137 2014-03-23				$
 *   Project: NXP LPC8xx GPIO example
 *
 *   Description:
 *     This file contains GPIO code example which include GPIO
 *     initialization, GPIO interrupt handler, and related APIs for
 *     GPIO access.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.

 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors'
 * relevant copyright in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers. This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
****************************************************************************/

#include "chip.h"

#include "lpc8xx_gpio.h"

/*****************************************************************************
** Function name:		GPIOInit
**
** Descriptions:		Initialize GPIO and GPIO INT block
**
** parameters:			None
** Returned value:	None
**
*****************************************************************************/
void GPIOInit( void )
{
  	/* Enable AHB clock to the GPIO domain. */
  Chip_GPIO_Init(LPC_GPIO_PORT) ;

	/* Peripheral reset control to GPIO and GPIO INT, a "1" bring it out of reset. */
  Chip_SYSCTL_PeriphReset(RESET_GPIO) ;

	/* LED1 port p0.13.  Set to output */
  Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 13) ;
  Chip_GPIO_SetPinState(LPC_GPIO_PORT, 0, 13, 1) ;

	/* LED2 port p0.12.  Set to output */
  Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 12) ;
  Chip_GPIO_SetPinState(LPC_GPIO_PORT, 0, 12, 1) ;

	/* LED3 port p0.11.  Set to output */
  Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 11) ;
  Chip_GPIO_SetPinState(LPC_GPIO_PORT, 0, 11, 1) ;

	/* LED4 port p0.10.  Set to output */
  Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 10) ;
  Chip_GPIO_SetPinState(LPC_GPIO_PORT, 0, 10, 1) ;

	/* Timing Measurement port p0.4.  Set to output */
  Chip_GPIO_SetPinDIROutput(LPC_GPIO_PORT, 0, 4) ;
  Chip_GPIO_SetPinState(LPC_GPIO_PORT, 0, 4, 1) ;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
