/****************************************************************************
 *   $Id:: lpc8xx_comp.c 8973 2014-03-23				$
 *   Project: NXP LPC8xx CMP example
 *
 *   Description:
 *     This file contains Comparator code example which include Comparator 
 *     initialization, COMP interrupt handler, and APIs.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation is hereby granted, under NXP Semiconductors' 
 * relevant copyright in the software, without fee, provided that it 
 * is used in conjunction with NXP Semiconductors microcontrollers. This 
 * copyright, permission, and disclaimer notice must appear in all copies of 
 * this code.
****************************************************************************/

#include "chip.h"

#include "lpc8xx_comp.h"

/*****************************************************************************
** Function name:		COMP_Init
**
** Descriptions:		Comparator initialization routine
**				
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
void COMP_Init( void )
{
	/* Comparator should be powered up first. Use of comparator requires BOD */
	/* Enable AHB clock to the Comparator. */
  Chip_ACMP_Init(LPC_CMP) ;

	/* Peripheral reset control to Comparator, a "1" bring it out of reset. */
  Chip_SYSCTL_PeriphReset(RESET_ACMP) ;

	/* configure PIO0_0  for ACMP_I1 */
  Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO0, PIN_MODE_INACTIVE) ;

	/* configure PIO0_1 for ACMP_I2 */
  Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO1, PIN_MODE_INACTIVE) ;

	/* configure PIO0_6 */
  Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO6, PIN_MODE_INACTIVE) ;

	/* configure PIO0_9 */
  Chip_IOCON_PinSetMode(LPC_IOCON, IOCON_PIO9, PIN_MODE_INACTIVE) ;

  LPC_SWM->PINENABLE0 = ~0x0000004fUL ;			/* P0.0 is ACMP_I1 and P0.1 is ACMP_I2  */

  Chip_ACMP_SetPosVoltRef(LPC_CMP, ACMP_POSIN_VLO) ;	 /* COMP_VP -> voltage ladder output	*/
  Chip_ACMP_SetNegVoltRef(LPC_CMP, ACMP_NEGIN_ACMP_I1) ; /* COMP_VM -> ACMP_I1			*/

  Chip_ACMP_EnableSyncCompOut(LPC_CMP) ;		/* COMP output is synchronized to the bus clock	*/

/*Chip_ACMP_SetHysteresis(LPC_CMP, ACMP_HYS_5MV) ;	 * hysteresis :  5 mV			*/
/*Chip_ACMP_SetHysteresis(LPC_CMP, ACMP_HYS_10MV) ;	 * hysteresis : 10 mV			*/
  Chip_ACMP_SetHysteresis(LPC_CMP, ACMP_HYS_20MV) ;	/* hysteresis : 20 mV			*/

  Chip_ACMP_SetupVoltLadder(LPC_CMP, 0x1f, 0) ;		/* enable ladder and set voltage to Vref/2	*/

  Chip_SWM_MovablePinAssign(SWM_ACMP_O_O, 0x06) ;	/* P0.6 is comparator output for button 1 */
  Chip_SWM_MovablePinAssign(SWM_CTIN_0_I, 0x06) ;	/* P0.6 is SCTIN_0 			*/
}

/******************************************************************************
**                            End Of File
******************************************************************************/

