/***************************************************************************
* @brief NXP LPC15xx I2C example
*
*	Description :
*					This module consists a number of exported declarations of the I2C
* 				driver package. Include this module in your source file if you want
*  				to make use of one of the interface functions of the package.
*
* @note
* Copyright(C) NXP Semiconductors, 2014
* All rights reserved.
*
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* LPC products.  This software is supplied "AS IS" without any warranties of
* any kind, and NXP Semiconductors and its licensor disclaim any and
* all warranties, express or implied, including all implied warranties of
* merchantability, fitness for a particular purpose and non-infringement of
* intellectual property rights.  NXP Semiconductors assumes no responsibility
* or liability for the use of the software, conveys no license or rights under any
* patent, copyright, mask work right, or any other intellectual property rights in
* or to any products. NXP Semiconductors reserves the right to make changes
* in the software without notification. NXP Semiconductors also makes no
* representation or warranty that such application will be suitable for the
* specified use without further testing or modification.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors' and its
* licensor's relevant copyrights in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************************/

#define SLA_PCA9500_IO           0x40      // I2C address of PCA9500 I/O port
#define SLA_PCA9500_EE           0xA0      // I2C address of PCA9500 EEPROM

typedef struct
{
    uint8_t  address;                      // slave address to sent/receive message
    uint8_t  nrBytes;                      // number of bytes in message buffer
    uint8_t  *buf;                         // pointer to I2C message buffer
    uint32_t  next;                        // address of next I2C message in chain
} I2C_MSG;

#define I2C_OK                   0         // transfer ended No Errors
#define I2C_BUSY                 1         // transfer busy
#define I2C_ERR                  2         // err: general error
#define I2C_NO_DATA              3         // err: No data in block
#define I2C_NACK_ON_DATA         4         // err: No ack on data
#define I2C_NACK_ON_ADDRESS      5         // err: No ack on address
#define I2C_ARBITRATION_LOST     6         // err: Arbitration lost
#define I2C_TIME_OUT             7         // err: Time out occurred
#define I2C_SLAVE_ERROR          8         // err: slave mode error
#define I2C_INIT_ERROR           9         // err: Initialization (not done)

extern uint8_t I2C_Transfer(I2C_MSG *p);
extern void    I2CMST_Init(void);
