/****************************************************************************
 *   Project     : Example for the NXP ARM7 IEC60335 Class B library	
 *   Description : Timer 0 driver code
 *	    
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC214x.h"
#include "IEC60335.h"
#include "target.h"
#include "test_config.h"

volatile UINT8 clock_100ms;

__irq void tc0(void)                       // Timer 0 Interrupt each 10ms @ 60 MHz CPU Clock
{
  static UINT32 ticks;

	#if CLK_TEST
    IEC60335_Clocktest_TimerIntHandler();
	#endif
    if (ticks++ >= 9)
    {
        ticks       = 0;
        clock_100ms = 1;
    }
    T0IR        = 1;                       // Clear interrupt flag
    VICVectAddr = 0;                       // Acknowledge Interrupt
}

void TC0_Init(void)
{
    T0MR0 = (Fpclk / 100) - 1;             // 10 msec = 100 Hz
		T0MCR = 3;                             // Interrupt and Reset on MR0
    T0TCR = 1;                             // Timer 0 enable
    VICVectAddr0  = (UINT32) &tc0;         // Set interrupt vector in 0
    VICVectCntl0  = 0x20 | 4;              // Use it for Timer 0 Interrupt
    VICIntEnable |= 0x00000010;            // Enable Timer 0 Interrupt
}
