#ifndef _BSCDEFS_H_
#define _BSCDEFS_H_

/* avoid confilicts with other packages*/
#define DEF_VOID		/*define "VOID" type*/
#define DEF_WIN32		/*define basic types used in Win32*/
// #define DEF_EMWIN		/*define basic types used in emWin*/
#define DEF_LINUX

#define PP_NULL		((void*)0)
#define E_OK						0L		
#define E_GENERIC					-1L
#define E_GNRC						-1L
#define E_GENERIC_OVERFLOW			-2L
#define E_GENERIC_UNDERFLOW			-3L
#define E_REENTER_DISALLOWED		-4L		
#define E_NOT_SUPPORTED				-5L
#define E_GENERIC_PARAM				-6L

#define E_USERBASE					-65536L

#define PP_TRUE	1
#define PP_FALSE 0

#define PP_ALIGN4	__align(4)
#define PP_ALIGN8	__align(8)
#define PP_ALIGN32	__align(32)
#define PP_ALIGN64	__align(64)
#define PP_ALIGN128 __align(128)
#define PP_PRIVATE	/*static*/

#ifndef NULL
#define NULL ((void*) 0)
#endif

#define PTR_I const
#define PTR_O
#define PTR_IO
#define PTR_I const
#define PTR_O
#define PTR_G	// I and O

#define PP_READONLY		const

#define PP_WEAKFUNC			__attribute__((weak))
#define PP_WEAKVAR			__attribute__((weak))
#define PP_NOINIT 			__attribute__((section("ER_SharedNoInitData") ))
#define PP_ZEROINIT 		__attribute__(( zero_init ))

#define PP_GET_SRAM_BBA_ADDR(addr,n) ((U32*)( 0x22000000+n*4 + ((U32)(addr) << 5) ))
#define PP_SET_BBAFLAG(n)  PP_GET_SRAM_BBA_ADDR(PPCFG_BIT_FLAG_ADDR,n)[0] = 1

#define MCR_Ofs8B2Ptr(ofs, ptrType)	(ptrType*) ( PPPLT_IRAM_BASE | ( (ofs) << 3 ) )
#define MCR_Ptr2Ofs8B(ptr, ofsType) (ofsType)((U32)(ptr)>>3)		// ofstype???U16, U8

#define PP_ALIGN(size, align)	(((size) + (align) - 1) & ~((align)-1))



#define GET_OFFSET(ds, field)  (unsigned int) (&(((ds*)(0))->field))

#define	MCRO_SRAM2BBAlias(a)	 (( ( (unsigned long)(a) - 0x20000000)*32 + 0x22000000 ))

#ifdef DEF_VOID
typedef void VOID;
#endif

#ifdef DEF_WIN32
	typedef unsigned char BYTE;
	typedef unsigned short WORD;
	typedef unsigned long DWORD;
#endif

#ifdef DEF_LINUX
	typedef unsigned char __u8;
	typedef unsigned short __u16;
	typedef unsigned long __u32;
	typedef signed char __s8;
	typedef signed short __s16;
	typedef signed long __s32;
#endif

#ifdef DEF_EMWIN
	typedef unsigned char U8;
	typedef signed char I8;
	typedef unsigned short U16;
	typedef signed short I16;
	typedef unsigned long U32;
	typedef signed long I32;
#endif

typedef unsigned char UI8;
typedef signed char S8, SI8;
typedef char C8, CI8;
typedef unsigned short UI16;
typedef signed short S16, SI16;
typedef unsigned long UI32;
typedef signed long S32, SI32;
typedef unsigned long long U64, UI64;
typedef long long S64, SI64;
typedef float FL32;
typedef double FL64;

typedef unsigned char UCHAR, *PUCHAR, uchar, INT8U;
typedef unsigned short USHORT, INT16U, *PUSHORT;
typedef unsigned long ULONG,  *PULONG, pp_size_t, ulong, INT32U;


typedef SI8 BOOL8;
typedef SI32 BOOL32;

#ifndef DEF_WIN32
typedef BOOL32 BOOL;
#endif

typedef SI8 INDEX8;
typedef SI16 INDEX16;
typedef SI32 ERRCODE, INDEX32;
typedef INDEX32 INDEX;

typedef UI32 HANDLE, handle_t;
typedef UI32 HMTX, HMTXGRP;


typedef volatile UI8 VUI8;
typedef volatile SI8 VSI8;
typedef volatile BOOL8 VBOOL8;
typedef volatile BOOL32 VBOOL32;
typedef volatile UI16 VUI16;
typedef volatile SI16 VSI16;
typedef volatile UI32 VUI32;
typedef volatile SI32 VSI32;
typedef volatile UI64 VUI64;
typedef volatile SI64 VSI64;

#ifdef DEF_EMWIN
typedef volatile UI8 VU8;
typedef volatile SI8 VS8;
typedef volatile UI16 VU6;
typedef volatile SI16 VS16;
typedef volatile UI32 VU32;
typedef volatile SI32 VS32;
typedef volatile UI64 VU64;
typedef volatile SI64 VS64;

#endif

typedef union _US_16Bit
{
	UI8 u8Ary[2];
	SI8 s8Ary[2];
	UI16 u16Ary[1];
	SI16 s16Ary[1];
	UI16 u16Val;
	SI16 s16Val;
}US_16Bit, U16FINE, UI16FINE;

typedef union _US_32Bit
{
	UI8 u8Ary[4];
	SI8 s8Ary[4];
	UI16 u16Ary[2];
	SI16 s16Ary[2];
	UI32 u32Ary[1];
	SI32 s32Ary[1];
	UI32 u32Val;
	SI32 s32Val;
	FL32 f32Val;
	void *pv;
	char *psz;
	UI8 *pu8;
	SI8 *ps8;
	UI16 *pu16;
	SI16 *ps16;
	SI32 *ps32;
	UI32 *pu32;
}US_32Bit, U32FINE, UI32FINE;

typedef union _US_64Bit
{
	UI8 u8Ary[8];
	SI8 s8Ary[8];
	UI16 u16Ary[4];
	SI16 s16Ary[4];
	UI32 u32Ary[2];
	SI32 s32Ary[2];
	UI64 u64Val;
	SI64 s64Val;
	FL32 f32Ary[2];
	FL64 f64Val;
}US_64Bit, U64FINE, UI64FINE;

typedef union _UFIXED24_t
{
	struct
	{
		UI32 u32bf24Int:24;
		UI32 u32bf8Frac:8;
	}fixed;
	UI32 u32Val;
}UFIXED24_t;


#ifndef PPDEF_UFAV_DEFINED
#define PPDEF_UFAV_DEFINED
	typedef unsigned long UIFAV, UIBASE;
	typedef volatile UIFAV VUIFAV, VUIBASE;
	#ifdef DEF_EMWIN
	typedef unsigned long UFAV, UBASE;
	typedef volatile unsigned long VUFAV, VUBASE;
	#endif
#endif

#ifndef PPDEF_SFAV_DEFINED
#define PPDEF_SFAV_DEFINED
	typedef signed long SIFAV, SIBASE;
	typedef volatile SIFAV VSIFAV, VSIBASE;
	#ifdef DEF_EMWIN
	typedef signed long SFAV, SBASE;
	typedef volatile signed long VSFAV, VSBASE;
	#endif
#endif

#ifndef PPDEF_CM3STACKELE_DEFINED
#define PPDEF_CM3STACKELE_DEFINED
typedef union _US_StackEle
{
	SI64 s64Val;
	UI64 u64Val;
	UI32 u32Ary[2];
	SI32 s32Ary[2];
	UI8	u8Ary[8];
}US_StackEle ;
#endif


#if !defined(__CC_ARM) && !defined(__ICCARM__) && !defined(__GNUC__) && !defined(__TASKING__)
typedef   signed          char int8_t;
typedef   signed short     int int16_t;
typedef   signed           int int32_t;
typedef   signed       __int64 int64_t;

    /* exact-width unsigned integer types */
typedef unsigned          char uint8_t;
typedef unsigned short     int uint16_t;
typedef unsigned           int uint32_t;
typedef unsigned       __int64 uint64_t;

    /* 7.18.1.2 */

    /* smallest type of at least n bits */
    /* minimum-width signed integer types */
typedef   signed          char int_least8_t;
typedef   signed short     int int_least16_t;
typedef   signed           int int_least32_t;
typedef   signed       __int64 int_least64_t;

    /* minimum-width unsigned integer types */
typedef unsigned          char uint_least8_t;
typedef unsigned short     int uint_least16_t;
typedef unsigned           int uint_least32_t;
typedef unsigned       __int64 uint_least64_t;

    /* 7.18.1.3 */

    /* fastest minimum-width signed integer types */
typedef   signed           int int_fast8_t;
typedef   signed           int int_fast16_t;
typedef   signed           int int_fast32_t;
typedef   signed       __int64 int_fast64_t;

    /* fastest minimum-width unsigned integer types */
typedef unsigned           int uint_fast8_t;
typedef unsigned           int uint_fast16_t;
typedef unsigned           int uint_fast32_t;
typedef unsigned       __int64 uint_fast64_t;

    /* 7.18.1.4 integer types capable of holding object pointers */
typedef   signed           int intptr_t;
typedef unsigned           int uintptr_t;

    /* 7.18.1.5 greatest-width integer types */
typedef   signed       __int64 intmax_t;
typedef unsigned       __int64 uintmax_t;
#endif

    /* 7.18.2.1 */

    /* minimum values of exact-width signed integer types */
#define INT8_MIN                   -128
#define INT16_MIN                -32768
#define INT32_MIN          (~0x7fffffff)   /* -2147483648 is unsigned */
#define INT64_MIN  __ESCAPE__(~0x7fffffffffffffffll) /* -9223372036854775808 is unsigned */

    /* maximum values of exact-width signed integer types */
#define INT8_MAX                    127
#define INT16_MAX                 32767
#define INT32_MAX            2147483647
#define INT64_MAX  __ESCAPE__(9223372036854775807ll)

    /* maximum values of exact-width unsigned integer types */
#define UINT8_MAX                   255
#define UINT16_MAX                65535
#define UINT32_MAX           4294967295u
#define UINT64_MAX __ESCAPE__(18446744073709551615ull)

    /* 7.18.2.2 */

    /* minimum values of minimum-width signed integer types */
#define INT_LEAST8_MIN                   -128
#define INT_LEAST16_MIN                -32768
#define INT_LEAST32_MIN          (~0x7fffffff)
#define INT_LEAST64_MIN  __ESCAPE__(~0x7fffffffffffffffll)

    /* maximum values of minimum-width signed integer types */
#define INT_LEAST8_MAX                    127
#define INT_LEAST16_MAX                 32767
#define INT_LEAST32_MAX            2147483647
#define INT_LEAST64_MAX  __ESCAPE__(9223372036854775807ll)

    /* maximum values of minimum-width unsigned integer types */
#define UINT_LEAST8_MAX                   255
#define UINT_LEAST16_MAX                65535
#define UINT_LEAST32_MAX           4294967295u
#define UINT_LEAST64_MAX __ESCAPE__(18446744073709551615ull)

    /* 7.18.2.3 */

    /* minimum values of fastest minimum-width signed integer types */
#define INT_FAST8_MIN           (~0x7fffffff)
#define INT_FAST16_MIN          (~0x7fffffff)
#define INT_FAST32_MIN          (~0x7fffffff)
#define INT_FAST64_MIN  __ESCAPE__(~0x7fffffffffffffffll)

    /* maximum values of fastest minimum-width signed integer types */
#define INT_FAST8_MAX             2147483647
#define INT_FAST16_MAX            2147483647
#define INT_FAST32_MAX            2147483647
#define INT_FAST64_MAX  __ESCAPE__(9223372036854775807ll)

    /* maximum values of fastest minimum-width unsigned integer types */
#define UINT_FAST8_MAX            4294967295u
#define UINT_FAST16_MAX           4294967295u
#define UINT_FAST32_MAX           4294967295u
#define UINT_FAST64_MAX __ESCAPE__(18446744073709551615ull)

    /* 7.18.2.4 */

    /* minimum value of pointer-holding signed integer type */
#define INTPTR_MIN (~0x7fffffff)

    /* maximum value of pointer-holding signed integer type */
#define INTPTR_MAX   2147483647

    /* maximum value of pointer-holding unsigned integer type */
#define UINTPTR_MAX  4294967295u

    /* 7.18.2.5 */

    /* minimum value of greatest-width signed integer type */
#define INTMAX_MIN  __ESCAPE__(~0x7fffffffffffffffll)

    /* maximum value of greatest-width signed integer type */
#define INTMAX_MAX  __ESCAPE__(9223372036854775807ll)

    /* maximum value of greatest-width unsigned integer type */
#define UINTMAX_MAX __ESCAPE__(18446744073709551615ull)

    /* 7.18.3 */

    /* limits of ptrdiff_t */
#define PTRDIFF_MIN (~0x7fffffff)
#define PTRDIFF_MAX   2147483647

    /* limits of sig_atomic_t */
#define SIG_ATOMIC_MIN (~0x7fffffff)
#define SIG_ATOMIC_MAX   2147483647

    /* limit of size_t */
#define SIZE_MAX 4294967295u

    /* limits of wchar_t */
    /* NB we have to undef and redef because they're defined in both
     * stdint.h and wchar.h */
#undef WCHAR_MIN
#undef WCHAR_MAX

#if defined(__WCHAR32)
  #define WCHAR_MIN   0
  #define WCHAR_MAX   0xffffffffU
#else
  #define WCHAR_MIN   0
  #define WCHAR_MAX   65535
#endif

    /* limits of wint_t */
#define WINT_MIN (~0x7fffffff)
#define WINT_MAX 2147483647



    /* 7.18.4.1 macros for minimum-width integer constants */
#define INT8_C(x)   (x)
#define INT16_C(x)  (x)
#define INT32_C(x)  (x)
#define INT64_C(x)  __ESCAPE__(x ## ll)

#define UINT8_C(x)  (x ## u)
#define UINT16_C(x) (x ## u)
#define UINT32_C(x) (x ## u)
#define UINT64_C(x) __ESCAPE__(x ## ull)

    /* 7.18.4.2 macros for greatest-width integer constants */
#define INTMAX_C(x)  __ESCAPE__(x ## ll)
#define UINTMAX_C(x) __ESCAPE__(x ## ull)


// utility macros
#define BVON(b0)				(	1UL<<(b0)								)			//bit value on
#define BVOFF(b0)				(	0UL<<(b0)								)			//bit value off
#define BVSET(val, b0)			( (val) |= BVON(b0)							)			//set bit value in val
#define BVCLR(val, b0)			( (val) &= ~(BVON(b0))						)   //clear bit value in val
#define BFMSK(b0, b1)			(	((1UL<<((b1)+1-(b0)))-1) << (b0)		)	//bit filter mask
#define BFMSKINV(b0, b1)		(	~(BFMSK((b0),(b1)))		)
#define BFVAL_MIN(val, b0)		(	(val)<<(b0))
#define BFVAL(val, b0, b1)		(	BFVAL_MIN((val),(b0)) & BFMSK((b0),(b1))		)
#define GETBV(v32, b0)			( (v32) & BVON(b0)						  	)
#define ISBVSET(v32, b0)		( 0 != ((v32) & BVON(b0))					)
#define ISBVCLR(v32, b0)		( 0 == ((v32) & BVON(b0))					)
#define BFVALGET(v32, b0, b1)	( ((v32)>>(b0)) & BFMSK(0,((b1)-(b0)))	)
#define BFVALSET(dst, v32, b0, b1) \
	do { \
		unsigned int t;	\
		t = dst & BFMSKINV(b0,b1);	\
		t |= BFVAL(v32,b0,b1); \
		dst = t; \
	}while(0)

#define ARYSIZE(ary)			( sizeof(ary) / sizeof(ary[0])				)
#define FUNC_IN_RAM	__attribute__((section("RAM_CODE")))
#define FUNC_IN_SDRAM	__attribute__((section("SDRAM_CODE")))
#define REG_WR32(a, d) ((volatile unsigned int *)(a))[0] = (d)

#define BEGIN_DO_WHILE_0 do
#define END_DO_WHILE_0	while(0);
	
#define DECLARE_GLOBAL_CRITICAL_SECTION()	unsigned int __m_prmsk__
#define ENTER_GLOBAL_CRITICAL() do {__m_prmsk__ = __get_PRIMASK(); __set_PRIMASK(1);} while(0)
#define LEAVE_GLOBAL_CRITICAL() __set_PRIMASK(__m_prmsk__)

#endif
