/***********************************************************************
 * $Id: main.c 3858 2012-09-25 15:33:12Z nxp39054 $
 *
 * Project: SCT Cammera Demo
 *
 * Description: main module
 *
 * Copyright(C) 2012, NXP Semiconductor
 * All rights reserved.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

/******************************************************************************
 * header files
 *****************************************************************************/
#include "LPC18xx.h"
#include "lpc18xx_cgu.h"
#include <stdio.h>
#include <string.h>
#include "GLCD.h"
#include "lpc18xx_i2c.h"
#include "AppDefs.h"
#include "FraBufQ.h"


/* Mode switch timeout variable */
volatile unsigned int g_msCnt;
volatile unsigned int g_procKeyPnd;
/* GLCD string buffer */
#define STRINGBUF_LEN   21

char StringBuf[STRINGBUF_LEN];

/* Extern variables */

int g_adVal;
volatile unsigned int t1;
volatile unsigned int g_free;
volatile unsigned int g_rfrshCnt = 0;
volatile unsigned int g_fps;

// define LCD frame buffers

extern DS_CamCB s_ccb;

// static VUI32 s_newLCDRefreshCnt;

/*-----------------------------------------------------------------------------
  SysTick IRQ Handler @ 250us
 *----------------------------------------------------------------------------*/
volatile unsigned int g_250usTick;
volatile unsigned int g_newTickCnt;

void SysTick_Handler (void) {	
	static unsigned long prevM0Cyc = 0, prevRfrshCnt = 0;
	if (!(++g_250usTick & (4-1)))
	{
		g_msCnt++;
		if (0 == (g_msCnt % 1000))
		{
			g_procKeyPnd++;
			g_free = (g_free >> 1) + ((s_ccb.m0CycCnt - prevM0Cyc) >> 1);
			g_fps = (g_fps >> 1) + ((g_rfrshCnt - prevRfrshCnt) >> 1);
			
			prevM0Cyc = s_ccb.m0CycCnt;
			prevRfrshCnt = g_rfrshCnt;
		}
	}
	g_newTickCnt++;
}

void LCD_IRQHandler(void)
{
	static unsigned int cnt;
	static BOOL32 ls_isFraBufChanged;
	LPC_LCD_Type *pLCD = LPC_LCD;
	
	if (ISBVSET(pLCD->INTSTAT, 2))
	{	
		US_VersatilePointer ptrNewFraBuf;
		cnt++;	
		#if TEST_MODE == TEST_OVERRUN
		if (0 == (cnt % 10))
		#endif
		{
			if (ls_isFraBufChanged)
			{
				FBQ_ConsumeDone();
				// s_newLCDRefreshCnt++;
			}
			ls_isFraBufChanged = 0;
			FBQ_GetConsumeIndex(&ptrNewFraBuf.pv);
			if ((void*)0 != ptrNewFraBuf.pv)
			{
				pLCD->UPBASE = ptrNewFraBuf.addr;
				ls_isFraBufChanged = 1;
			}
		}
	}
	// clear all flags
	pLCD->INTCLR = pLCD->INTRAW;
}



void PinInit(void)
{
	DS_PinMux2D *pm = (DS_PinMux2D*) LPC_SCU;
	LPC_GPIO_PORT_Type *pGP = LPC_GPIO_PORT;
	
	pm->a2d[SPT_MCLK][SPN_MCLK]				= ALT_MCLK | SPNCFG_OUT_HSPD;	

	// LEO_EN, CHIP_EN, VSYNC use GPIO (LDO_EN and CHIP_EN is not used in PixArt's 6180 cam sensor)
	pm->a2d[SPT_LDO_EN][SPN_LDO_EN] 		= ALT_LDO_EN| SPNCFG_OUT_GNRC | /* 20mA drive */ 3UL<<8;
	pm->a2d[SPT_CHIP_ENB][SPN_CHIP_ENB] = ALT_CHIP_ENB | SPNCFG_OUT_GNRC;
	
	#if SCT_MODULE
	pm->a2d[SPT_MCLK][SPN_MCLK]					= ALT_MCLK | SPNCFG_OUT_HSPD;	
	pm->a2d[SPT_LDO_EN][SPN_LDO_EN] 		= ALT_LDO_EN| SPNCFG_OUT_GNRC | /* 20mA drive */ 3UL<<8;
	pm->a2d[SPT_FLHLIGHT][SPN_FLHLIGHT] = ALT_FLHLIGHT | SPNCFG_OUT_GNRC | /* 20mA drive */ 3UL<<8;
	pm->a2d[SPT_CHIP_ENB][SPN_CHIP_ENB] = ALT_CHIP_ENB | SPNCFG_OUT_GNRC;
	pm->a2d[SPT_VSYNC][SPN_VSYNC] 			= ALT_VSYNC | SPNCFG_IN_PUP;
	pm->a2d[SPT_HSYNC][SPN_HSYNC] 			= ALT_HSYNC | SPNCFG_IN_PUP;
	pm->a2d[SPT_PXCLK][SPN_PXCLK] 			= ALT_PXCLK | SPNCFG_IN_PUP;

	//! D0-D7, must be pin 0-7 within the same GPIO port, they share the same configuration
	t1 = ALT_IMGD0 | SPNCFG_IN_GNRC;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+0] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+1] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+2] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+3] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+4] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+5] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+6] 		= t1;
	pm->a2d[SPT_IMGD0][SPN_IMGD0+7] 		= t1;
		
	
	//! Configure misc GPIO pins
	pGP->DIR[GPT_LDO_EN] 			|= 1UL<<GPN_LDO_EN;
	
	pGP->DIR[GPT_CHIP_ENB] 		|= 1UL<<GPN_CHIP_ENB;
	
	pGP->DIR[GPT_FLHLIGHT] 		|= 1UL<<GPN_FLHLIGHT;
	
	pGP->DIR[GPT_IMGD0] 			&= ~(0xFFUL<<GPN_IMGD0);
	
	//! MCLK is not GPIO

	//! Turn off flash light
	pGP->CLR[GPT_FLHLIGHT] = 1UL<<GPN_FLHLIGHT;
	#endif
	
}


const int cg_tabCnctOrd[8] = 
{
	sliceA, sliceI, sliceE, sliceJ, sliceC, sliceK, sliceF, sliceL,
};

void HardFault_Handler(void)
{
	// Unexpected vector fetch bus fault
	if (SCB->HFSR & SCB_HFSR_VECTTBL_Msk)
		SCB->HFSR = SCB_HFSR_VECTTBL_Msk;
	else
	{
		// Unexpected precise and imprecise bus fault
		if (SCB->CFSR & 3UL<<9)
		{
			SCB->CFSR = 3UL << 9;
		}
	}
	SCB->HFSR = SCB_HFSR_FORCED_Msk;
}



void Delay(unsigned int n) {
	while (n--) ;
}


	// warning: only 4kB is left to M0 RO+RW+ZI : from 0x10080000 to 0x10080FFF
	#ifndef IFLH_ALL
	#define M0IMGATTR 
	#define M0IMGFILE	"M0Img.c"
	#else
	#define M0IMGATTR __attribute__((section("SECT_M0Img")))
	#define M0IMGFILE	"M0ImgIFlhAll.c"
	#endif


extern signed int VideoRefresh(void);
extern void SystemInit (void);

int main(int zsi)
{
	signed int ret = ret;
	int stallCnt;
	DECLARE_GLOBAL_CRITICAL_SECTION();
	
	SystemInit();
    __set_PRIMASK(0);
    __set_FAULTMASK(0);    
 
    GLCD_Init();                          /* Graphical Display Init             */

// ------------------------------ lcd initial ----------------------------------------------
	GLCD_Clear (White);
	GLCD_SetBackColor  (DarkGreen);
	GLCD_SetTextColor  (White);
	GLCD_DisplayString (0, 0, 1, "       NXP SCT      ");
  GLCD_DisplayString (1, 0, 1, "     Camera Demo    ");

    GLCD_SetBackColor  (White);
    GLCD_SetTextColor  (0x04F5);

    GLCD_DisplayString (3, 0, 1, "   Please wait...   ");
	
	GLCD_DisplayString (5, 0, 1, "OmniVision OV7670");
	
	
	FBQ_Init(FRABUF_Q_CAPACITY);
	CamInit();
	__set_PRIMASK(0);
    __set_FAULTMASK(0);
	
	NVIC_EnableIRQ(LCD_IRQn);

	stallCnt = 0;
    while (1)
    {
		ERRCODE err = E_GNRC;

		#if 0 != IS_USE_ANTI_TEAR
		if (s_ccb.rdyRxBufCnt && !FBQ_IsFull())
		#endif
		{					
			err = VideoRefresh();
			ENTER_GLOBAL_CRITICAL();
			if (err >= E_OK)
			{
				g_rfrshCnt++;
				
				if (s_ccb.rdyRxBufCnt != 0)
					s_ccb.rdyRxBufCnt--;
				
				
			}
			// inc freeRxBufCnt regardless of whether refresh is OK, don't allow accumulate the received image!!!
			s_ccb.freeRxBufCnt++;
			
			LEAVE_GLOBAL_CRITICAL();
		}
		#if 0 != IS_USE_ANTI_TEAR
		else
		#endif
		{
			if (++stallCnt > 5)
			{
				if (0 == s_ccb.freeRxBufCnt)
					s_ccb.freeRxBufCnt = 1;
			}
		}
		__WFI();
			}
}

