#ifndef _FRABUFQ_H_
#define _FRABUF_Q_H

#include "AppDefs.h"

// versatile pointer union, to make a 32 bit integer easily to be interpreted to several type of pointers
typedef union _US_VersatilePointer
{
	UI8 *pu8;
	UI16 *pu16;
	UI32 *pu32;
	UI64 *pu64;
	void *pv;
	UI32 addr;
}US_VersatilePointer;


// -ߵģ֯LCD֡壬һζ
typedef struct _DS_LcdFBQueue
{
	VSI32 pdcNdx;	// ߵһ, dflt = 0
	VSI32 csmNdx;	// ߵһ, dflt = 0
	VSI32 cnt;	// , dflt = 0
	SI32 cap;		// 
	US_VersatilePointer ptrs[FRABUF_Q_CAPACITY];
}DS_LcdFBQueue;

// רڱLCD֡еٽ
// ҪΪҪں̨LCD ISRл
// ע⣺֧Ƕ!
#define FBQ_ENTER_CRITICAL()	__set_PRIMASK(1)	//NVIC_DisableIRQ(LCD_IRQn)
#define FBQ_LEAVE_CRITICAL()	__set_PRIMASK(0)	//NVIC_EnableIRQ(LCD_IRQn)



// LCD frame buffer queue routines, to avoid tearing effect

extern ERRCODE FBQ_GetProduceIndex(void **ppvFraBuf);
extern ERRCODE FBQ_ProduceDone(void);
extern ERRCODE FBQ_GetConsumeIndex(void **ppvFraBuf);
extern ERRCODE FBQ_ConsumeDone(void);

extern ERRCODE FBQ_Init(UI32 cap);
extern ERRCODE FBQ_Purge(void);
extern BOOL32 FBQ_IsFull(void);

#endif

