/*----------------------------------------------------------------------------
 *      RL-ARM - USB
 *----------------------------------------------------------------------------
 *      Name:    usb_config.c
 *      Purpose: System Configuration
 *      Rev.:    V4.22
 *----------------------------------------------------------------------------
 *      This code is part of the RealView Run-Time Library.
 *      Copyright (c) 2004-2011 KEIL - An ARM Company. All rights reserved.
 *---------------------------------------------------------------------------*/

//-------- <<< Use Configuration Wizard in Context Menu >>> -----------------

/*----------------------------------------------------------------------------
 *      USB Host Configuration
 *---------------------------------------------------------------------------*/

// <h> USB Host
//   <e> USB Host 0
//     <i> Enable the USB Host 0 functionality
//     <o1> Controller Interface 
//       <i> Selects the USB Host 0 controller interface
//       <0=> Custom <1=> OHCI
//   </e>
#define USBH0_ENABLE                0
#define USBH0_HC_IF                 0

//   <e> USB Host 1
//     <i> Enable the USB Host 1 functionality
//     <o1> Controller Interface 
//       <i> Selects the USB Host 1 controller interface
//       <0=> Custom <1=> OHCI
//   </e>
#define USBH1_ENABLE                0
#define USBH1_HC_IF                 0

//   <h> Class Configuration
//     <i> Selects supported classes
//     <e0.0> Mass Storage Device Class (MSC)
//       <o1> Number of concurrent MSC Devices on single USB Host controller <0-15>
//     </e>
//     <e0.1> Human Interface Device Class (HID)
//       <o2> Number of concurrent HID Devices on single USB Host controller <0-15>
//     </e>
//     <e0.2> USB Device Class
//       <o3> Number of concurrent Custom Class Devices on single USB Host controller <0-15>
//     </e>
//   </h>
#define USBH_CLASS                  0x0000
#define USBH_MSC_NUM                0
#define USBH_HID_NUM                0
#define USBH_CLS_NUM                0

// </h>


/*----------------------------------------------------------------------------
 *      USB Device Configuration
 *---------------------------------------------------------------------------*/

// <e> USB Device
//   <i> Enable the USB Device functionality
#define USBD_ENABLE                 1

//   <o0.0> High-speed
//     <i> Enable high-speed functionality (if device supports it)
#define USBD_HS_ENABLE              0

//   <h> Device Settings
//     <i> These settings affect Device Descriptor
//     <o0> Power
//       <i> Default Power Setting
//       <0=> Bus-powered
//       <1=> Self-powered
//     <o1> Max Endpoint 0 Packet Size
//       <i> Maximum packet size for endpoint zero (bMaxPacketSize0)
//       <8=> 8 Bytes <16=> 16 Bytes <32=> 32 Bytes <64=> 64 Bytes
//     <o2.0..15> Vendor ID <0x0000-0xFFFF>
//       <i> Vendor ID assigned by the USB-IF (idVendor)
//     <o3.0..15> Product ID <0x0000-0xFFFF>
//       <i> Product ID assigned by the manufacturer (idProduct)
//     <o4.0..15> Device Release Number <0x0000-0xFFFF>
//       <i> Device release number in binary-coded decimal (bcdDevice)
//   </h>
#define USBD_POWER                  0
#define USBD_MAX_PACKET0            8
#define USBD_DEVDESC_IDVENDOR       0xC251
#define USBD_DEVDESC_IDPRODUCT      0x3201
#define USBD_DEVDESC_BCDDEVICE      0x0100

//   <h> Configuration Settings
//     <i> These settings affect Configuration Descriptor
//     <o0.5> Remote Wakeup
//       <i> Configuration support for remote wakeup (D5: of bmAttributes)
//     <o1.0..7> Maximum Power Consumption (in mA) <0-510><#/2>
//       <i> Maximum power consumption of the USB device 
//       <i> from the bus in this specific configuration 
//       <i> when the device is fully operational (bMaxPower)
//   </h>
#define USBD_CFGDESC_BMATTRIBUTES   0x80
#define USBD_CFGDESC_BMAXPOWER      0x32

//   <h> String Settings
//     <i> These settings affect String Descriptor
//     <o0.0..15> Language ID <0x0000-0xFCFF>
//       <i> English (United States) = 0x0409
//     <s0.126> Manufacturer String
//       <i> String descriptor describing manufacturer
//     <s1.126> Product String
//       <i> String descriptor describing product
//     <e1.0> Serial Number
//       <i> Enable serial number string
//       <i> If disabled serial number string will not be assigned to the USB Device
//       <s2.126> Serial Number String
//         <i> String descriptor describing device's serial number
//     </e>
//   </h>
#define USBD_STRDESC_LANGID         0x0409
#define USBD_STRDESC_MAN            L"Keil Software"
#define USBD_STRDESC_PROD           L"LPC11U37-401 CMSIS-DAP"
#define USBD_STRDESC_SER_ENABLE     1
#define USBD_STRDESC_SER            L"A000000001"

//   <e0> Class Support
//     <i> Enables USB Device Class specific Requests
#define USBD_CLASS_ENABLE           1

//     <e0.0> Human Interface Device (HID)
//       <i> Enable class support for Human Interface Device (HID)
//       <h> Interrupt Endpoint Settings
//         <o1.0..4> Interrupt In Endpoint Number                  <1=>   1 <2=>   2 <3=>   3
//                                                 <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                                 <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                                 <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <o2.0..4> Interrupt Out Endpoint Number <0=>   Not used <1=>   1 <2=>   2 <3=>   3
//                                                 <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                                 <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                                 <12=>  12       <13=> 13 <14=> 14 <15=> 15
//           <i> If interrupt out endpoint is not used select "Not used"
//         <h> Endpoint Settings
//           <o3.0..7> Maximum Endpoint Packet Size (in bytes) <0-64>
//           <o4.0..7> Endpoint polling Interval (in ms) <1-255>
//           <e5> High-speed
//             <i> If high-speed is enabled set endpoint settings for it
//             <o6.0..10> Maximum Endpoint Packet Size (in bytes) <0-1024>
//             <o6.11..12> Additional transactions per microframe <0=> None <1=> 1 additional <2=> 2 additional
//             <o7.0..7> Endpoint polling Interval (in ms) <1=>      1 <2=>      2 <3=>      4 <4=>      8
//                                                         <5=>     16 <6=>     32 <7=>     64 <8=>    128
//                                                         <9=>    256 <10=>   512 <11=>  1024 <12=>  2048
//                                                         <13=>  4096 <14=>  8192 <15=> 16384 <16=> 32768
//           </e>
//         </h>
//       </h>
//       <h> Human Interface Device Settings
//         <i> Device specific settings
//         <s0.126> HID Interface String
//         <o8.0..4> Number of Input Reports <1-32>
//         <o9.0..4> Number of Output Reports <1-32>
//         <o10.0..15> Maximum Input Report Size (in bytes) <1-65535>
//         <o11.0..15> Maximum Output Report Size (in bytes) <1-65535>
//         <o12.0..15> Maximum Feature Report Size (in bytes) <1-65535>
//       </h>
//     </e>
#define USBD_HID_ENABLE             1
#define USBD_HID_EP_INTIN           1
#define USBD_HID_EP_INTOUT          1
#define USBD_HID_WMAXPACKETSIZE     64
#define USBD_HID_BINTERVAL          1
#define USBD_HID_HS_ENABLE          0
#define USBD_HID_HS_WMAXPACKETSIZE  64
#define USBD_HID_HS_BINTERVAL       1
#define USBD_HID_STRDESC            L"USB_HID"
#define USBD_HID_INREPORT_NUM       1
#define USBD_HID_OUTREPORT_NUM      1
#define USBD_HID_INREPORT_MAX_SZ    64
#define USBD_HID_OUTREPORT_MAX_SZ   64
#define USBD_HID_FEATREPORT_MAX_SZ  1

//     <e0.0> Mass Storage Device (MSC)
//       <i> Enable class support for Mass Storage Device (MSC)
//       <h> Bulk Endpoint Settings
//         <o1.0..4> Bulk In Endpoint Number                  <1=>   1 <2=>   2 <3=>   3
//                                            <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                            <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                            <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <o2.0..4> Bulk Out Endpoint Number                 <1=>   1 <2=>   2 <3=>   3
//                                            <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                            <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                            <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <h> Endpoint Settings
//           <o3> Maximum Packet Size <1-1024>
//           <e4> High-speed
//             <i> If high-speed is enabled set endpoint settings for it
//             <o5> Maximum Packet Size <1-1024>
//             <o6> Maximum NAK Rate <0-255>
//           </e>
//         </h>
//       </h>
//       <h> Mass Storage Device Settings
//         <i> Device specific settings
//         <s0.126> MSC Interface String
//         <h> Inquiry Data
//           <s1.8>  Vendor Identification
//           <s2.16> Product Identification
//           <s3.4>  Product Revision Level
//         </h>
//       </h>
//     </e>
#define USBD_MSC_ENABLE             0
#define USBD_MSC_EP_BULKIN          1
#define USBD_MSC_EP_BULKOUT         1
#define USBD_MSC_WMAXPACKETSIZE     64
#define USBD_MSC_HS_ENABLE          0
#define USBD_MSC_HS_WMAXPACKETSIZE  512
#define USBD_MSC_HS_BINTERVAL       0
#define USBD_MSC_STRDESC            L"USB_MSC"
#define USBD_MSC_INQUIRY_DATA       "Keil    "         \
                                    "LPC11Uxx Disk   " \
                                    "1.0 "

//     <e0.0> Audio Device (ADC)
//       <i> Enable class support for Audio Device (ADC)
//       <h> Isochronous Endpoint Settings
//         <o1.0..4> Isochronous Out Endpoint Number                 <1=>   1 <2=>   2 <3=>   3
//                                                   <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                                   <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                                   <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <h> Endpoint Settings
//           <o2.0..10> Maximum Endpoint Packet Size (in bytes) <0-1024>
//           <o3.0..10> Endpoint polling Interval (in ms) <1=>      1 <2=>      2 <3=>      4 <4=>      8
//                                                        <5=>     16 <6=>     32 <7=>     64 <8=>    128
//                                                        <9=>    256 <10=>   512 <11=>  1024 <12=>  2048
//                                                        <13=>  4096 <14=>  8192 <15=> 16384 <16=> 32768
//           <e4> High-speed
//             <i> If high-speed is enabled set endpoint settings for it
//             <o5.0..10> Maximum Endpoint Packet Size (in bytes) <0-1024>
//             <o5.11..12> Additional transactions per microframe <0=> None <1=> 1 additional <2=> 2 additional
//           </e>
//         </h>
//       </h>
//       <h> Audio Device Settings
//         <i> Device specific settings
//         <s0.126> Audio Control Interface String
//         <s1.126> Audio Streaming (Zero Bandwidth) Interface String
//         <s2.126> Audio Streaming (Operational) Interface String
//         <o6.0..7> Audio Subframe Size (in bytes) <0-255>
//         <o7.0..7> Sample Resolution (in bits) <0-255>
//         <o8.0..23> Sample Frequency (in Hz) <0-16777215>
//         <o9> Packet Size (in bytes) <1-256>
//         <o10> Packet Count <1-16>
//       </h>
//     </e>
#define USBD_ADC_ENABLE             0
#define USBD_ADC_EP_ISOOUT          3
#define USBD_ADC_WMAXPACKETSIZE     64
#define USBD_ADC_BINTERVAL          1
#define USBD_ADC_HS_ENABLE          0
#define USBD_ADC_HS_WMAXPACKETSIZE  64
#define USBD_ADC_CIF_STRDESC        L"USB_ADC"
#define USBD_ADC_SIF1_STRDESC       L"USB_ADC1"
#define USBD_ADC_SIF2_STRDESC       L"USB_ADC2"
#define USBD_ADC_BSUBFRAMESIZE      2
#define USBD_ADC_BBITRESOLUTION     16
#define USBD_ADC_TSAMFREQ           32000
#define USBD_ADC_CFG_P_S            32
#define USBD_ADC_CFG_P_C            1

//     <e0> Communication Device (CDC)
//       <i> Enable class support for Communication Device (CDC)
//       <h> Interrupt Endpoint Settings
//         <o1.0..4> Interrupt In Endpoint Number                 <1=>   1 <2=>   2 <3=>   3
//                                                <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                                <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                                <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <h> Endpoint Settings
//           <o2.0..10> Maximum Endpoint Packet Size (in bytes) <0-1024>
//           <o3.0..10> Endpoint polling Interval (in ms) <0-255>
//           <e4> High-speed
//             <i> If high-speed is enabled set endpoint settings for it
//             <o5.0..10> Maximum Endpoint Packet Size (in bytes) <0-1024>
//             <o5.11..12> Additional transactions per microframe <0=> None <1=> 1 additional <2=> 2 additional
//             <o6.0..10> Endpoint polling Interval (in ms) <1=>      1 <2=>      2 <3=>      4 <4=>      8
//                                                          <5=>     16 <6=>     32 <7=>     64 <8=>    128
//                                                          <9=>    256 <10=>   512 <11=>  1024 <12=>  2048
//                                                          <13=>  4096 <14=>  8192 <15=> 16384 <16=> 32768
//           </e4>
//         </h>
//       </h>
//       <h> Bulk Endpoint Settings
//         <o7.0..4> Bulk In Endpoint Number                  <1=>   1 <2=>   2 <3=>   3
//                                            <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                            <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                            <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <o8.0..4> Bulk Out Endpoint Number                 <1=>   1 <2=>   2 <3=>   3
//                                            <4=>   4        <5=>   5 <6=>   6 <7=>   7
//                                            <8=>   8        <9=>   9 <10=> 10 <11=> 11
//                                            <12=>  12       <13=> 13 <14=> 14 <15=> 15
//         <h> Endpoint Settings
//           <o9> Maximum Packet Size <1-1024>
//           <e10> High-speed
//             <i> If high-speed is enabled set endpoint settings for it
//             <o11> Maximum Packet Size <1-1024>
//             <o12> Maximum NAK Rate <0-255>
//           </e10>
//         </h>
//       </h>
//       <h> Communication Device Settings
//         <i> Device specific settings
//         <s0.126> Communication Class Interface String
//         <s1.126> Data Class Interface String
//         <o13> Maximum Communication Device Buffer Size
//            <8=> 8 Bytes <16=> 16 Bytes <32=> 32 Bytes <64=> 64 Bytes
//         <o14> Maximum Communication Device Output Buffer Size
//            <8=> 8 Bytes <16=> 16 Bytes <32=> 32 Bytes <64=> 64 Bytes <128=> 128 Bytes 
//       </h>
//     </e>
#define USBD_CDC_ENABLE             0
#define USBD_CDC_EP_INTIN           1
#define USBD_CDC_WMAXPACKETSIZE     16
#define USBD_CDC_BINTERVAL          2
#define USBD_CDC_HS_ENABLE          0
#define USBD_CDC_HS_WMAXPACKETSIZE  16
#define USBD_CDC_HS_BINTERVAL       2
#define USBD_CDC_EP_BULKIN          2
#define USBD_CDC_EP_BULKOUT         2
#define USBD_CDC_WMAXPACKETSIZE1    64
#define USBD_CDC_HS_ENABLE1         0
#define USBD_CDC_HS_WMAXPACKETSIZE1 64
#define USBD_CDC_HS_BINTERVAL1      0
#define USBD_CDC_CIF_STRDESC        L"USB_CDC"
#define USBD_CDC_DIF_STRDESC        L"USB_CDC1"
#define USBD_CDC_BUFSIZE            64
#define USBD_CDC_OUTBUFSIZE         128

//     <e0> Custom Class Device
//       <i> Enables USB Custom Class Requests
//       <i> Class IDs:
//       <i> 0x00 - Class Reserved ID
//       <i> 0x01 - Class Audio ID
//       <i> 0x02 - Class Communications ID
//       <i> 0x03 - Class Human Interface ID
//       <i> 0x04 - Class Monitor ID
//       <i> 0x05 - Class Physical Interface ID
//       <i> 0x06 - Class Power ID
//       <i> 0x07 - Class Printer ID
//       <i> 0x08 - Class Storage ID
//       <i> 0x09 - Class HUB ID
//       <i> 0xEF - Class Miscellaneous ID
//       <i> 0xFF - Class Vendor Specific ID
//     </e>
#define USBD_CLS_ENABLE             0

//   </e>
// </e>


/* USB Device Calculations --------------------------------------------------*/

#define USBD_IF_NUM                (USBD_HID_ENABLE+USBD_MSC_ENABLE+(USBD_ADC_ENABLE*2)+(USBD_CDC_ENABLE*2))
#define USBD_MULTI_IF              (USBD_CDC_ENABLE*(USBD_HID_ENABLE|USBD_MSC_ENABLE|USBD_ADC_ENABLE))
#define MAX(x, y)                (((x) < (y)) ? (y) : (x))
#define USBD_EP_NUM_CALC0           MAX((USBD_HID_ENABLE*(USBD_HID_EP_INTIN)),  (USBD_HID_ENABLE*(USBD_HID_EP_INTOUT!=0)*(USBD_HID_EP_INTOUT)))
#define USBD_EP_NUM_CALC1           MAX((USBD_MSC_ENABLE*(USBD_MSC_EP_BULKIN)), (USBD_MSC_ENABLE*(USBD_MSC_EP_BULKOUT)))
#define USBD_EP_NUM_CALC2           MAX((USBD_ADC_ENABLE*(USBD_ADC_EP_ISOOUT)), (USBD_CDC_ENABLE*(USBD_CDC_EP_INTIN)))
#define USBD_EP_NUM_CALC3           MAX((USBD_CDC_ENABLE*(USBD_CDC_EP_BULKIN)), (USBD_CDC_ENABLE*(USBD_CDC_EP_BULKOUT)))
#define USBD_EP_NUM_CALC4           MAX(USBD_EP_NUM_CALC0, USBD_EP_NUM_CALC1)
#define USBD_EP_NUM_CALC5           MAX(USBD_EP_NUM_CALC2, USBD_EP_NUM_CALC3)
#define USBD_EP_NUM_CALC6           MAX(USBD_EP_NUM_CALC4, USBD_EP_NUM_CALC5)
#define USBD_EP_NUM                (USBD_EP_NUM_CALC6)

#if    (USBD_HID_ENABLE)
#if    (USBD_MSC_ENABLE)
#if ((((USBD_HID_EP_INTIN   == USBD_MSC_EP_BULKIN)  || \
       (USBD_HID_EP_INTIN   == USBD_MSC_EP_BULKIN)))|| \
      ((USBD_HID_EP_INTOUT  != 0)                   && \
       (USBD_HID_EP_INTOUT  == USBD_MSC_EP_BULKIN)  || \
       (USBD_HID_EP_INTOUT  == USBD_MSC_EP_BULKOUT)))
#error "HID and Mass Storage Device Interface can not use same Endpoints!"
#endif
#endif
#if    (USBD_ADC_ENABLE)
#if   ((USBD_HID_EP_INTIN   == USBD_ADC_EP_ISOOUT)  || \
      ((USBD_HID_EP_INTOUT  != 0)                   && \
       (USBD_HID_EP_INTOUT  == USBD_ADC_EP_ISOOUT)))
#error "HID and Audio Device Interface can not use same Endpoints!"
#endif
#endif
#if    (USBD_CDC_ENABLE)
#if  (((USBD_HID_EP_INTIN   == USBD_CDC_EP_INTIN)   || \
       (USBD_HID_EP_INTIN   == USBD_CDC_EP_BULKIN)  || \
       (USBD_HID_EP_INTIN   == USBD_CDC_EP_BULKOUT))|| \
      ((USBD_HID_EP_INTOUT  != 0)                   && \
      ((USBD_HID_EP_INTOUT  == USBD_CDC_EP_INTIN)   || \
       (USBD_HID_EP_INTOUT  == USBD_CDC_EP_BULKIN)  || \
       (USBD_HID_EP_INTOUT  == USBD_CDC_EP_BULKOUT))))
#error "HID and Communication Device Interface can not use same Endpoints!"
#endif
#endif
#endif

#if    (USBD_MSC_ENABLE)
#if    (USBD_ADC_ENABLE)
#if   ((USBD_MSC_EP_BULKIN  == USBD_ADC_EP_ISOOUT)  || \
       (USBD_MSC_EP_BULKOUT == USBD_ADC_EP_ISOOUT))
#error "Mass Storage Device and Audio Device Interface can not use same Endpoints!"
#endif
#endif
#if    (USBD_CDC_ENABLE)
#if   ((USBD_MSC_EP_BULKIN  == USBD_CDC_EP_INTIN)   || \
       (USBD_MSC_EP_BULKIN  == USBD_CDC_EP_BULKIN)  || \
       (USBD_MSC_EP_BULKIN  == USBD_CDC_EP_BULKOUT) || \
       (USBD_MSC_EP_BULKOUT == USBD_CDC_EP_INTIN)   || \
       (USBD_MSC_EP_BULKOUT == USBD_CDC_EP_BULKIN)  || \
       (USBD_MSC_EP_BULKOUT == USBD_CDC_EP_BULKOUT))
#error "Mass Storage Device and Communication Device Interface can not use same Endpoints!"
#endif
#endif
#endif

#if    (USBD_ADC_ENABLE)
#if    (USBD_CDC_ENABLE)
#if   ((USBD_ADC_EP_ISOOUT  == USBD_CDC_EP_INTIN)   || \
       (USBD_ADC_EP_ISOOUT  == USBD_CDC_EP_BULKIN)  || \
       (USBD_ADC_EP_ISOOUT  == USBD_CDC_EP_BULKOUT))
#error "Audio Device and Communication Device Interface can not use same Endpoints!"
#endif
#endif
#endif

#define USBD_ADC_CIF_NUM           (0)
#define USBD_ADC_SIF1_NUM          (1)
#define USBD_ADC_SIF2_NUM          (2)
#define USBD_CDC_CIF_NUM           (USBD_ADC_ENABLE*2+0)
#define USBD_CDC_DIF_NUM           (USBD_ADC_ENABLE*2+1)
#define USBD_HID_IF_NUM            (USBD_ADC_ENABLE*2+USBD_CDC_ENABLE*2)
#define USBD_MSC_IF_NUM            (USBD_ADC_ENABLE*2+USBD_CDC_ENABLE*2+USBD_HID_ENABLE)

#define USBD_ADC_CIF_STR_NUM       (3+USBD_STRDESC_SER_ENABLE+0)
#define USBD_ADC_SIF1_STR_NUM      (3+USBD_STRDESC_SER_ENABLE+1)
#define USBD_ADC_SIF2_STR_NUM      (3+USBD_STRDESC_SER_ENABLE+2)
#define USBD_CDC_CIF_STR_NUM       (3+USBD_STRDESC_SER_ENABLE+USBD_ADC_ENABLE*3+0)
#define USBD_CDC_DIF_STR_NUM       (3+USBD_STRDESC_SER_ENABLE+USBD_ADC_ENABLE*3+1)
#define USBD_HID_IF_STR_NUM        (3+USBD_STRDESC_SER_ENABLE+USBD_ADC_ENABLE*3+USBD_CDC_ENABLE*2)
#define USBD_MSC_IF_STR_NUM        (3+USBD_STRDESC_SER_ENABLE+USBD_ADC_ENABLE*3+USBD_CDC_ENABLE*2+USBD_HID_ENABLE)

#if    (USBD_HID_ENABLE)
#if    (USBD_HID_HS_ENABLE)
#define USBD_HID_MAX_PACKET       ((USBD_HID_HS_WMAXPACKETSIZE > USBD_HID_WMAXPACKETSIZE) ? USBD_HID_HS_WMAXPACKETSIZE : USBD_HID_WMAXPACKETSIZE)
#else
#define USBD_HID_MAX_PACKET        (USBD_HID_WMAXPACKETSIZE)
#endif
#else
#define USBD_HID_MAX_PACKET        (0)
#endif
#if    (USBD_MSC_ENABLE)
#if    (USBD_MSC_HS_ENABLE)
#define USBD_MSC_MAX_PACKET       ((USBD_MSC_HS_WMAXPACKETSIZE > USBD_MSC_WMAXPACKETSIZE) ? USBD_MSC_HS_WMAXPACKETSIZE : USBD_MSC_WMAXPACKETSIZE)
#else
#define USBD_MSC_MAX_PACKET        (USBD_MSC_WMAXPACKETSIZE)
#endif
#else
#define USBD_MSC_MAX_PACKET        (0)
#endif
#if    (USBD_ADC_ENABLE)
#if    (USBD_ADC_HS_ENABLE)
#define USBD_ADC_MAX_PACKET       ((USBD_ADC_HS_WMAXPACKETSIZE > USBD_ADC_WMAXPACKETSIZE) ? USBD_ADC_HS_WMAXPACKETSIZE : USBD_ADC_WMAXPACKETSIZE)
#else
#define USBD_ADC_MAX_PACKET        (USBD_ADC_WMAXPACKETSIZE)
#endif
#else
#define USBD_ADC_MAX_PACKET        (0)
#endif
#if    (USBD_CDC_ENABLE)
#if    (USBD_CDC_HS_ENABLE)
#define USBD_CDC_MAX_PACKET       ((USBD_CDC_HS_WMAXPACKETSIZE > USBD_CDC_WMAXPACKETSIZE) ? USBD_CDC_HS_WMAXPACKETSIZE : USBD_CDC_WMAXPACKETSIZE)
#else
#define USBD_CDC_MAX_PACKET        (USBD_CDC_WMAXPACKETSIZE)
#endif
#if    (USBD_CDC_HS_ENABLE1)
#define USBD_CDC_MAX_PACKET1      ((USBD_CDC_HS_WMAXPACKETSIZE1 > USBD_CDC_WMAXPACKETSIZE1) ? USBD_CDC_HS_WMAXPACKETSIZE1 : USBD_CDC_WMAXPACKETSIZE1)
#else
#define USBD_CDC_MAX_PACKET1       (USBD_CDC_WMAXPACKETSIZE1)
#endif
#else
#define USBD_CDC_MAX_PACKET        (0)
#define USBD_CDC_MAX_PACKET1       (0)
#endif
#define USBD_MAX_PACKET_CALC0     ((USBD_HID_MAX_PACKET   > USBD_HID_MAX_PACKET  ) ? (USBD_HID_MAX_PACKET  ) : (USBD_HID_MAX_PACKET  ))
#define USBD_MAX_PACKET_CALC1     ((USBD_ADC_MAX_PACKET   > USBD_CDC_MAX_PACKET  ) ? (USBD_ADC_MAX_PACKET  ) : (USBD_CDC_MAX_PACKET  ))
#define USBD_MAX_PACKET_CALC2     ((USBD_MAX_PACKET_CALC0 > USBD_MAX_PACKET_CALC1) ? (USBD_MAX_PACKET_CALC0) : (USBD_MAX_PACKET_CALC1))
#define USBD_MAX_PACKET           ((USBD_MAX_PACKET_CALC2 > USBD_CDC_MAX_PACKET1 ) ? (USBD_MAX_PACKET_CALC2) : (USBD_CDC_MAX_PACKET1 ))


/*----------------------------------------------------------------------------
 *      USB Config Functions
 *---------------------------------------------------------------------------*/

#ifndef  __USB_CONFIG___
#define  __USB_CONFIG__

#ifndef  __NO_USB_LIB_C
#include <usb_lib.c>
#endif

#endif  /* __USB_CONFIG__ */
