/*********************************************************************
*                SEGGER MICROCONTROLLER GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2003-2012     SEGGER Microcontroller GmbH & Co KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

----------------------------------------------------------------------
File    : Main.c
Purpose : Calls hardware initialization and application.
--------  END-OF-HEADER  ---------------------------------------------
*/
#include <stdio.h>
#ifndef _WINDOWS
	#include "lpc_i2c.h"
	#include "lpc_pinsel.h"
	#include "LCDConf.h"
#else
	#include "WinConf.h"
#endif
#include "DIALOG.h"
#include <stdint.h>
#include <stdlib.h>

#ifdef __CROSSWORKS_ARM
extern void __low_level_init(); // hwconf.c
#endif
extern uint8_t move_start;
WM_HWIN hWinMainDialog;			/* Main dialog */
WM_HWIN hWinLastWindow;			/* Saves which windows was displayed last */
WM_HWIN hWinCurrentWindow;	/* Current displayed window */
WM_HWIN hWinCallBack;				/* Used for callback */
int DrawCustomSkin(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo);
volatile uint32_t time_to_move=0;

#define REPETITION_TIME   10000 

#ifndef _WINDOWS
#define LCD_YSIZE_PHYS  _LcdParams.LPP
#else
#define LCD_YSIZE_PHYS    FB_YSIZE

#endif
void MainTask(void);  // Defined in SEGGERDEMO.c


/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

#define ID_WINDOW_0     (GUI_ID_USER + 0x01)
#define ID_BUTTON_0     (GUI_ID_USER + 0x02)
#define ID_IMAGE_0     (GUI_ID_USER + 0x20)
#define ID_IMAGE_1     (GUI_ID_USER + 0x21)

#define BUTTON_BitmapSkin DrawCustomSkin

// USER END

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

extern const U8 _acImage_0[2240055];
extern GUI_CONST_STORAGE GUI_BITMAP bmnxplogo;
//extern GUI_CONST_STORAGE GUI_BITMAP bmblack_coffee;
uint8_t move_start;
#ifdef _WINDOWS
#include <windows.h>
#endif
// USER END

/*********************************************************************
*
*       _aDialogCreate
*/
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { WINDOW_CreateIndirect, "MainDialog", ID_WINDOW_0, 0, 0, VX_IMAGE_SIZE, VY_IMAGE_SIZE, 0, 0, 0 },
  { BUTTON_CreateIndirect, "Button3", ID_BUTTON_0, 30, 15, 110, 110, 0, 0, 0 },
	{ IMAGE_CreateIndirect, "Image", ID_IMAGE_0, 600, 25, 193, 112, WM_CF_BGND, IMAGE_CF_AUTOSIZE, 0 },
  { IMAGE_CreateIndirect, "Image", ID_IMAGE_1, 0, 0, VX_IMAGE_SIZE, VY_IMAGE_SIZE, WM_CF_BGND, IMAGE_CF_AUTOSIZE, 0 },
  // USER END
};

// USER END

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  int Id, NCode;
  
  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'Button3'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
	  BUTTON_SetText(hItem, "Press Here");
	  BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
    BUTTON_SetFont(hItem, GUI_FONT_20B_ASCII);
    
    hItem = WM_GetDialogItem(pMsg->hWin, ID_IMAGE_0);
	  IMAGE_SetBitmap(hItem, &bmnxplogo);
    //
    // Additional initialization of 'Image'
    //
		hItem = WM_GetDialogItem(pMsg->hWin, ID_IMAGE_1);
    IMAGE_SetBMP(hItem, _acImage_0, sizeof(_acImage_0));
		//
		// Additional initialization of 'Button3'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
		BUTTON_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_BOTTOM);
//		BUTTON_SetSkin(hItem, BUTTON_BitmapSkin);
   
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);
    NCode = pMsg->Data.v;
    switch(Id) {
    case ID_BUTTON_0: // Notifications sent by 'Button3'
      switch(NCode) {
      case WM_NOTIFICATION_CLICKED:
        // USER START (Optionally insert code for reacting on notification message)
				move_start=1;
        // USER END
        break;
      case WM_NOTIFICATION_RELEASED:
        // USER START (Optionally insert code for reacting on notification message)
		    // USER END
        break;
      // USER START (Optionally insert additional code for further notification handling)
      // USER END
      }
      break;
     // USER START (Optionally insert additional code for further Ids)
    // USER END
    }
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       CreateMainDialog
*/
WM_HWIN CreateMainDialog(void);
WM_HWIN CreateMainDialog(void) {
  WM_HWIN hWin;

  hWin = GUI_CreateDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 0, 0);
  return hWin;
}


/*********************************************************************
*
*       main()
*/
void MainTask(void);
void MainTask(void)
{

uint32_t i;	
#ifdef _WINDOWS
int64_t start_time;
#endif
 
  GUI_Init();
	/* Set skinning */
  BUTTON_SetDefaultSkin   (BUTTON_SKIN_FLEX);
  //
  // Set some further defaults
  //
  WIDGET_SetDefaultEffect(&WIDGET_Effect_3D);
  FRAMEWIN_SetDefaultFont(GUI_FONT_16_ASCII);
  FRAMEWIN_SetDefaultTextAlign(GUI_TA_HCENTER);

	/* Create windows */
  hWinMainDialog = CreateMainDialog();
  WM_EnableMemdev(hWinMainDialog);
#ifdef _WINDOWS
  start_time = GetTickCount();
#endif
while(1) {
		 
     GUI_Delay(1);
#ifdef _WINDOWS
		time_to_move = GetTickCount()-start_time;
#endif
		 	if(time_to_move>=REPETITION_TIME)
		 {
			 move_start=1;
			 
		 }
		if(move_start==1)
		{
		for(i=0;i<(VY_IMAGE_SIZE-LCD_YSIZE_PHYS);i++)
		{
			GUI_SetOrg(0, i);
			if(i==0)
				GUI_Delay(1000);
			else
				GUI_Delay(1);
		}
		i=0;
		GUI_Delay(2000);
		move_start=0;
		time_to_move=0;
#ifdef _WINDOWS
		start_time = GetTickCount();
#endif
		GUI_SetOrg(0, 0);
	 }
  }
}
