/**********************************************************************
* $Id$		otp_api.c		2011-08-02
*//**
* @file		otp_api.c
* @brief	This example describes how to use OTP API Library
* @version	1.0
* @date		02. August. 2011
* @author	NXP MCU SW Application Team
*
* Copyright(C) 2011, NXP Semiconductor
* All rights reserved.
*
***********************************************************************
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors'
* relevant copyright in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************/
#include "LPC18xx.h"

#include "otp.h"
#include "otprom.h"

/* Example group ----------------------------------------------------------- */
/** @defgroup OTP	OTP_API
 * @ingroup OTP_Examples
 * @{
 */

/**********************************************************************
 ** Function prototypes
 **********************************************************************/

// Note: OTP_fix is needed on some versions of the silicon due to an errata
// in the ROM driver. See the errata sheet for more details.
void OTP_fix(volatile unsigned dummy0,
volatile unsigned dummy1,
volatile unsigned dummy2,
volatile unsigned dummy3)
{
}


/*-------------------------MAIN FUNCTION------------------------------*/
/*********************************************************************//**
 * @brief		Main program body
 * @param[in]	None
 * @return 		int
 **********************************************************************/
volatile uint32_t rval;

int main(void) {                       /* Main Program                       */
  // No clock setup is needed to call OTP API calls because the OTP operation
	// is timed from the internal clock.
	rval = otp_Init();
	OTP_fix(0,0,0,0);
	
#warning If you run this code, your part will be permanently locked to boot from SPIFI.
#warning You can program QSPI flash via the debug port using many development tools
#warning such as Keil, LPCXpresso, or IAR.
#error remove this error directive to build
	rval = otp_ProgBootSrc(OTP_BOOTSRC_SPIFI);
   
	while(1);
}

/**
 * @}
 */
