/**********************************************************************
* $Id$		Blinky.c	2011-06-02
*//**
* @file		Blinky.c
* @brief	This example describes how to use SGPIO to PWM LEDs or other devices
* @version	1.0
* @date		20. July. 2012
* @author	NXP MCU SW Application Team
*
* Copyright(C) 2012, NXP Semiconductor
* All rights reserved.
*
***********************************************************************
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further datasendcountering or modification.
* Permission to use, copy, modify, and distribute this software and its
* documentation is hereby granted, under NXP Semiconductors'
* relevant copyright in the software, without fee, provided that it
* is used in conjunction with NXP Semiconductors microcontrollers.  This
* copyright, permission, and disclaimer notice must appear in all copies of
* this code.
**********************************************************************/
#include "lpc_types.h"
#include "lpc43xx_scu.h"
#include "lpc43xx_cgu.h"
#include "timer.h"
#include "sgpio_pwm.h"

/*-------------------------MAIN FUNCTION------------------------------*/
/*********************************************************************//**
 * @brief		Main program body
 * @param[in]	None
 * @return 		int
 **********************************************************************/

int c_entry (void) {                       /* Main Program                       */
	SystemInit();
	CGU_Init();	
	SGPIOPWMinit();													//Init the system, CGU and SGPIO
	TimerInit(0, 100000);                   //Init a timer for delays
	
	scu_pinmux(0x1, 1 , MD_PLN, FUNC3); 				//Function 3, SGPIO08, P1.1, Slice B(1)
	scu_pinmux(0x2, 6 , MD_PLN, FUNC0);				//Function 0, SGPIO07, P2.6, Slice L(11)
	scu_pinmux(0x2, 8 , MD_PLN, FUNC0);				//Function 0, SGPIO15, P2.8, Slice P(15)
	
	//Init SGPIO slice 1, 11 and 15 for PWM use at 100Khz.
	SGPIOPWMchaninit(100000, 1);
	SGPIOPWMchaninit(100000, 11);
	SGPIOPWMchaninit(100000, 15);

while (1)
	{
		//Change the PWM duty cycle of channel 15 and 11 every 250mS to create a nice blinky effect
		if(!SGPIOPWMstatus())
		{
			SGPIOPWMValue(0x1E, 15);
		}		
		DelayMs(0, 250);
		if(!SGPIOPWMstatus())
		{
			SGPIOPWMValue(0x03, 15);
		}
		DelayMs(0, 250);
		if(!SGPIOPWMstatus())
		{
			SGPIOPWMValue(0x1E, 11);
		}
		DelayMs(0, 250);
		if(!SGPIOPWMstatus())
		{
			SGPIOPWMValue(0x03, 11);
		}		
		DelayMs(0, 250);
		if(!SGPIOPWMstatus())
		{
			SGPIOPWMValue(0x1E, 1);
		}
		DelayMs(0, 250);
		if(!SGPIOPWMstatus())
		{
			SGPIOPWMValue(0x03, 1);
		}		
		DelayMs(0, 250);
	}
}


/* With ARM and GHS toolsets, the entry point is main() - this will
   allow the linker to generSate wrapper code to setup stacks, allocate
   heap area, and initialize and copy code and data segments. For GNU
   toolsets, the entry point is through __start() in the crt0_gnu.asm
   file, and that startup code will setup stacks and data */
int main(void)
{
    return c_entry();
}
/**
 * @}
 */
