	   /***********************************************************************
* $Id:: hw_i2cd_i2cmco.h     2011-04-26 17:41:11Z usb06052            $
*
* Project: I2CMCO I2C device controller definitions
*
* Description:
*     This file contains the structure definitions and manifest
*     constants for the I2CMCO component:
*         I2C Device Controller
*
***********************************************************************
*   Copyright(C) 2011, NXP Semiconductor
*   All rights reserved.
*
****************************************************************************
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.

* Permission to use, copy, modify, and distribute this software and its 
* documentation is hereby granted, under NXP Semiconductors 
* relevant copyright in the software, without fee, provided that it 
* is used in conjunction with NXP Semiconductors microcontrollers.  This 
* copyright, permission, and disclaimer notice must appear in all copies of 
* this code.

****************************************************************************/


#ifndef __HW_I2CD_I2CMCO_H
#define __HW_I2CD_I2CMCO_H

#include "error.h"
#include "hw_i2cd_rom_api.h"

/* For more info, read NXP's SE95 datasheet */
#define SE95_ADDR			0x90
#define SE95_ID				0x05
#define SE95_CONFIG			0x01
#define SE95_TEMP			0x00

#define SE95_ID_VALUE		0xA1		/* For slave test: SE95 ID reading */
#define SE95_TEMP_VALUE		0x155C		/* For slave test: fake TEMP reading value */

#define RD_BIT              0x01

#define MAX_BUF_SIZE		40

//*** Bit Definitions for I2C CONT register ***
#define  I2C_I2EN    (1<<6)    // enable the I2C
#define  I2C_STA     (1<<5)	   // start bit 
#define  I2C_STO     (1<<4)    // stop bit
#define  I2C_SI		 (1<<3)	   // interrupt bit, active high
#define  I2C_AA		 (1<<2)	   // Automatic ACK bit
#define  I2C_CLR_ALL  (I2C_STA | I2C_STO |I2C_SI | I2C_AA)
 
typedef volatile struct {        /* USB Structure          */
  volatile uint32_t CONSET;                 /*!< Offset: 0x000 I2C Control Set Register (R/W) */
  volatile uint32_t STAT;                   /*!< Offset: 0x004 I2C Status Register (R/ ) */
  volatile uint32_t DAT;                    /*!< Offset: 0x008 I2C Data Register (R/W) */
  volatile uint32_t ADR0;                   /*!< Offset: 0x00C I2C Slave Address Register 0 (R/W) */
  volatile uint32_t SCLH;                   /*!< Offset: 0x010 SCH Duty Cycle Register High Half Word (R/W) */
  volatile uint32_t SCLL;                   /*!< Offset: 0x014 SCL Duty Cycle Register Low Half Word (R/W) */
  volatile uint32_t CONCLR;                 /*!< Offset: 0x018 I2C Control Clear Register ( /W) */
  volatile uint32_t MMCTRL;                 /*!< Offset: 0x01C Monitor mode control register (R/W) */
  volatile uint32_t ADR1;                   /*!< Offset: 0x020 I2C Slave Address Register 1 (R/W) */
  volatile uint32_t ADR2;                   /*!< Offset: 0x024 I2C Slave Address Register 2 (R/W) */
  volatile uint32_t ADR3;                   /*!< Offset: 0x028 I2C Slave Address Register 3 (R/W) */
  volatile uint32_t DATA_BUFFER;            /*!< Offset: 0x02C Data buffer register ( /W) */
  volatile uint32_t MASK0;                  /*!< Offset: 0x030 I2C Slave address mask register 0 (R/W) */
  volatile uint32_t MASK1;                  /*!< Offset: 0x034 I2C Slave address mask register 1 (R/W) */
  volatile uint32_t MASK2;                  /*!< Offset: 0x038 I2C Slave address mask register 2 (R/W) */
  volatile uint32_t MASK3;                  /*!< Offset: 0x03C I2C Slave address mask register 3 (R/W) */
} I2C_REGS_T;
 
//***  

#endif /* __HW_I2CD_I2CMCO_H */


