/****************************************************************************
 *   $Id:: i2c_masterROM.c 5992 2010-12-22 21:10:51Z nxp28548                      $
 *   Project: NXP LPC11Axx I2C ROM Driver Master Mode
 *
 *   Description:
 *     The LPC11Axx is set as a master.  It is used to communicate 
 *     with a SE95 temperature sensor at address 0x48.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC11Axx.h"                        /* LPC11xx definitions */
#include "type.h"
#include "error.h"
#include "hw_i2cd_rom_api.h"
#include "hw_i2cd_i2cmco.h"
#define I2CROMD_PRESENT
#include "rom_drivers.h"

#define I2C_INTERRUPT_TEST		0

//*** Global Data ***
const I2CD_API_T*  pI2cApi ;  //define pointer to type API function addr table
I2C_PARAM*  ptop;   // define pointer to param of type 1 structure
I2C_PARAM   s1;     // s1 is a structure of type I2C_PARAM
I2C_RESULT* ptor;   // define pointer to return values of structure
I2C_RESULT  s2;	    // s2 is a structure of type I2C_result

I2C_HANDLE_T *i2c_handle;
ErrorCode_t error_code;
    
volatile uint32_t size_in_bytes;
volatile uint32_t ver_num;
volatile uint32_t i2c_counter = 0;
volatile uint32_t i2c_done = FALSE;
volatile uint8_t I2C_Handle[100];
volatile uint8_t I2C_TxBuffer[40];
volatile uint8_t I2C_RxBuffer[40];

//*******************************************************************
void init_i2c( void) {   // enable P_clock and pins for I2C

  LPC_SYSCON->PRESETCTRL |= (0x1<<1);
  LPC_SYSCON->SYSAHBCLKCTRL |= ((1 << 16) | (1 << 6) | (1<<5));
  // Turn on the P_clk to the I2C blcok, 16 = IOCON, 6=GPIO, 5=I2C 
						  
  //enable two pins for I2C use as SCL and SDA
	
	#if 1
  LPC_IOCON->PIO0_2 &= ~0x3F;	/*  I2C I/O config */
  LPC_IOCON->PIO0_2 |= 0x01;		/* I2C SCL */
  LPC_IOCON->PIO0_3 &= ~0x3F;	
  LPC_IOCON->PIO0_3 |= 0x01;		/* I2C SDA */
	#endif
	#if 0
  LPC_IOCON->PIO0_12 &= ~0x3F;	/*  I2C I/O config */
  LPC_IOCON->PIO0_12 |= 0x04;		/* I2C SCL */
  LPC_IOCON->PIO0_13 &= ~0x3F;	
  LPC_IOCON->PIO0_13 |= 0x04;		/* I2C SDA */
  LPC_IOCON->PIO0_12 |= (0x1<<10);	/* open drain pins */
  LPC_IOCON->PIO0_13 |= (0x1<<10);	/* open drain pins */
#endif
#if 0
  LPC_IOCON->PIO0_16 &= ~0x3F;	/*  I2C I/O config */
  LPC_IOCON->PIO0_16 |= 0x04;		/* I2C SCL */
  LPC_IOCON->PIO0_15 &= ~0x3F;	
  LPC_IOCON->PIO0_15 |= 0x04;		/* I2C SDA */
  LPC_IOCON->PIO0_16 |= (0x1<<10);	/* open drain pins */
  LPC_IOCON->PIO0_15 |= (0x1<<10);	/* open drain pins */
#endif
#if 0
  LPC_IOCON->PIO0_24 &= ~0x3F;	/*  I2C I/O config */
  LPC_IOCON->PIO0_24 |= 0x01;		/* I2C SCL */
  LPC_IOCON->PIO0_25 &= ~0x3F;	
  LPC_IOCON->PIO0_25 |= 0x01;		/* I2C SDA */
  LPC_IOCON->PIO0_24 |= (0x1<<10);	/* open drain pins */
  LPC_IOCON->PIO0_25 |= (0x1<<10);	/* open drain pins */
#endif
	
  ptop = &s1;    // addr of PARAM struct, s1 is assigned to pointer ptop
  ptor = &s2;    // addr of RESULT struct, s2 is assigned to pointer ptor
}

//*******************************************************************
void I2C_IRQHandler( void){	   // Application Program enables interrupts and calls ISR

     i2c_counter++; 	 // bump counter for debug
	 pI2cApi->i2c_isr_handler( (I2C_HANDLE_T*) i2c_handle );  
}	  

//*******************************************************************
void I2c_polling_test( void )
{
  I2C_TxBuffer[0] = SE95_ADDR;    //slave addr in first byte of TX buffer
  I2C_TxBuffer[1] = SE95_ID;
  I2C_RxBuffer[0] = SE95_ADDR | RD_BIT; //slave addre in first byte of RX buffer
  ptop->num_bytes_send =2;
  ptop->num_bytes_rec = 1;
  ptop->buffer_ptr_send	= (uint8_t *)&I2C_TxBuffer[0];
  ptop->buffer_ptr_rec = (uint8_t *)&I2C_RxBuffer[0];
  ptop->stop_flag = 1;
	error_code = pI2cApi->i2c_master_tx_rx_poll((I2C_HANDLE_T*)i2c_handle,  
		(I2C_PARAM*)ptop, (I2C_RESULT*)ptor);

  I2C_TxBuffer[0] = SE95_ADDR;    //slave addr in first byte of rec buffer
  I2C_TxBuffer[1] = SE95_CONFIG;
  I2C_TxBuffer[2] = 0x00; 
  ptop->num_bytes_send =3;
  ptop->num_bytes_rec = 0;
  ptop->buffer_ptr_send	= (uint8_t *)&I2C_TxBuffer[0];
  ptop->buffer_ptr_rec = NULL;
  ptop->stop_flag = 1;
  error_code = pI2cApi->i2c_master_transmit_poll((I2C_HANDLE_T*)i2c_handle,  
		(I2C_PARAM*)ptop, (I2C_RESULT*)ptor);

  I2C_TxBuffer[0] = SE95_ADDR;    //slave addr in first byte of TX buffer
  I2C_TxBuffer[1] = SE95_TEMP;
  I2C_RxBuffer[0] = SE95_ADDR | RD_BIT; //slave addr in first byte of RX buffer
  ptop->num_bytes_send =2;
  ptop->num_bytes_rec = 2;
  ptop->buffer_ptr_send	= (uint8_t *)&I2C_TxBuffer[0];
  ptop->buffer_ptr_rec = (uint8_t *)&I2C_RxBuffer[0];
  ptop->stop_flag = 1;
  error_code = pI2cApi->i2c_master_tx_rx_poll((I2C_HANDLE_T*)i2c_handle,  
		(I2C_PARAM*)ptop, (I2C_RESULT*)ptor);
  return;
}

void callback_func( void )
{
  i2c_done = TRUE;
}

//*******************************************************************
void I2c_interrupt_test( void )
{
  I2C_TxBuffer[0] = SE95_ADDR;    //slave addr in first byte of TX buffer
  I2C_TxBuffer[1] = SE95_ID;
  I2C_RxBuffer[0] = SE95_ADDR | RD_BIT; 
  ptop->num_bytes_send =2;
  ptop->num_bytes_rec = 1;
  ptop->buffer_ptr_send	= (uint8_t *)&I2C_TxBuffer[0];
  ptop->buffer_ptr_rec = (uint8_t *)&I2C_RxBuffer[0];
  ptop->stop_flag = 1;
  ptop->func_pt = (I2C_CALLBK_T)callback_func;  
  i2c_done = FALSE;
  error_code = pI2cApi->i2c_master_tx_rx_intr((I2C_HANDLE_T*)i2c_handle,  
		(I2C_PARAM*)ptop, (I2C_RESULT*)ptor);
  while ( i2c_done == FALSE );
  
  I2C_TxBuffer[0] = SE95_ADDR;    //slave addr in first byte of TX buffer
  I2C_TxBuffer[1] = SE95_CONFIG;
  I2C_TxBuffer[2] = 0x00; 
  ptop->num_bytes_send =3;
  ptop->num_bytes_rec = 0;
  ptop->buffer_ptr_send	= (uint8_t *)&I2C_TxBuffer[0];
  ptop->buffer_ptr_rec = NULL;
  ptop->stop_flag = 1;
  ptop->func_pt = (I2C_CALLBK_T)callback_func;
  i2c_done = FALSE;
  error_code = pI2cApi->i2c_master_transmit_intr((I2C_HANDLE_T*)i2c_handle,  
		(I2C_PARAM*)ptop, (I2C_RESULT*)ptor);
  while ( i2c_done == FALSE );

  I2C_TxBuffer[0] = SE95_ADDR;    //slave addr in first byte of TX buffer
  I2C_TxBuffer[1] = SE95_TEMP;
  I2C_RxBuffer[0] = SE95_ADDR | RD_BIT; 
  ptop->num_bytes_send =2;
  ptop->num_bytes_rec = 2;
  ptop->buffer_ptr_send	= (uint8_t *)&I2C_TxBuffer[0];
  ptop->buffer_ptr_rec = (uint8_t *)&I2C_RxBuffer[0];
  ptop->stop_flag = 1;
  ptop->func_pt = (I2C_CALLBK_T)callback_func;
  i2c_done = FALSE;
  error_code = pI2cApi->i2c_master_tx_rx_intr((I2C_HANDLE_T*)i2c_handle,  
		(I2C_PARAM*)ptop, (I2C_RESULT*)ptor);
  while ( i2c_done == FALSE );
  return;
}

/* Main Program */

int main (void) 
{
  SystemCoreClockUpdate();
	
  /* get I2C ROM API table pointer */  

  pI2cApi = ROM_DRIVERS_PTR->pI2CD; 
	    	  
  size_in_bytes =  pI2cApi->i2c_get_mem_size(); 

#if 0
  if ( RAMBLOCK_H < (size_in_bytes /4) ) {
     while (1) ;   // here forever if not enough ram for handle
  }
#endif
 				   	    
  init_i2c() ;   //   assign pins for I2C, set Pclock to I2C 
				    
  i2c_handle = pI2cApi->i2c_setup(  LPC_I2C_BASE, (uint32_t *)&I2C_Handle[0] );
  
  // (P_clk_in_hz, bitrate_in_bps)	  
	// Periperal clock set to 48MHz
	// Requested I2C clock frequency is 100kHz
  error_code = pI2cApi->i2c_set_bitrate((I2C_HANDLE_T*)i2c_handle, 48000000, 100000);
	
	ver_num = pI2cApi->i2c_get_status((I2C_HANDLE_T*)i2c_handle);

  ver_num = pI2cApi->i2c_get_firmware_version();
#if I2C_INTERRUPT_TEST
  NVIC_EnableIRQ(I2C_IRQn);
  I2c_interrupt_test();
#else
  I2c_polling_test();
#endif

  while ( 1 );			/* Never exit from main for easy debugging. */

}
