
////////////////////////////////////////////////////////////////////////////////
//
//	setup VGA using sGPIO
//
//  and copy data to it from SDRAM
//
//

#include "LPC43xx.h"
#include "scu.h"
//#include "cgu.h"
#include "sgpio_vga.h"


#define hsyncHIvsyncHI		0x8BAB8BAB
#define hsyncHIvsyncLOW		0x01210121
#define hsyncLOWvsyncHI		0xDAFADAFA
#define hsyncLOWvsyncLOW	0x50705070

// By assigning some local pointers to the following macros and the writes to the shadow register
// and looking at the resultant assembly code what was originally marginal at 25 MHz now runs up past 30 MHz (marginal at 35)

//#define	sgpio_wait4reload 				while ((LPC_SGPIO->STATUS_1 & 1) == 0);
//#define	sgpio_wait4reload 				while ((sgpio_status1[0] & 1) == 0);
#define	sgpio_wait4reload 				while ((sgpio_status1[0] & 8) == 0);
//#define sgpio_clear_status				LPC_SGPIO->CTR_STATUS_1 = 0xffff
#define sgpio_clear_status				sgpio_status1[1] = 0xffff			 // shotgun clear them all -- capture clock

int *pixelPTR;


//             			
//		SDCE0  really-bit 4			bit 4				-NOThorz
//		SDCLK  really-bit 5			bit 5	- pixel clock
//		SDLE                    	bit 6				-NOThorz
//		GDCLK  really-bit   7		bit 0				-horz

//		GDSP   really-bit 3			bit 3							-vert

// 		GDOE   really-bit	1		bit 1							-vert
//		SDOE   really-bit	0		bot 7							-vert


// based on clklo -- first nibble


#define SDCE0hi		0xB9B9A8A8;  //  0xd9F9d9F9			//	0x9bBB9bBB

#define GDCLKgoLO	0x313139B9;  //  0x59795979			//  0x59F9d9F9			//	0x9aBB9bBB
#define GDCLKlo		0x31313131;  //  0x59795979			//	0x9aBA9aBA
#define SDLEgoHI	0x75757571;  //  0x5B7B5979			//	0xdaFA9aBA
#define SDLEhi		0x75757575;  //  0x5b7B5b7B			//	0xdaFAdaFA
#define SDLEgoLO	0x91111115;  //  0x59595b7B			//	0x9a9A9aFA		// clock goes low here

		// vertical setting change here
		// warning VERY VERY sensitive to SDLE go low to GDCLK go high (even though no clocks happening)

#define GDCLKgoHI	0x99999999;  //  0xd9D9d9D9			//	0x9b9B9b9B		// clock stays low here -- 2 clock times inserted here
#define GDCLKhiCLK  0xA9999999;
#define SDCE0goLO	0xA8A8A8A8;  //  0xc9E9c9E9			//	0x8bAB8bAB
#define SDCE0lo		0xA8A8A8A8;  //  0xc9E9c9E9			//	0x8bAB8bAB
                      

//const unsigned int EINKcontrol[] = { SDCE0hi, SDCE0hi, GDCLKgoLO, GDCLKlo, GDCLKlo };

#define USE_DATA 1

#define GDCLKloREPEAT	7		// was 6

int run_value[16] ={ 0,0,0,0xffffffff, 0,0,0,0, 0,0,0,0, 0,0,0,0};
int run_count = 0, run_index =0, run_value1=0x55555555, run_value2=0xaaaaaaAA;

void lineEINK(int line, int vertical) {
	int i;			// pixel is a count of 4 control times -- defined by CLK low CLK hi CLK low CLK hi

	// the following pointers MUST be assigned to registers < r8 for the code to run fast enough
	volatile unsigned int *sgpio_shadow = &LPC_SGPIO->REG_SS[0];
	volatile unsigned int *sgpio_status1 = (volatile unsigned int *)&LPC_SGPIO->STATUS1;
	
		sgpio_wait4reload;
		sgpio_clear_status;	
#if USE_DATA
		sgpio_shadow[10] = *pixelPTR++;
		sgpio_shadow[2]  = *pixelPTR++;
#endif
		sgpio_shadow[12]  =	
		sgpio_shadow[1]  =	vertical;   

		sgpio_shadow[15] =	GDCLKgoHI;   
		sgpio_shadow[7]  =	GDCLKhiCLK; //GDCLKhiCLK;  
		sgpio_shadow[14] =	SDCE0goLO;			
		sgpio_shadow[3]  =	SDCE0lo;

		sgpio_wait4reload;
		sgpio_clear_status;	

#if USE_DATA
		sgpio_shadow[11] = *pixelPTR++;
		sgpio_shadow[5]  = *pixelPTR++;	
		sgpio_shadow[10] = *pixelPTR++;
		sgpio_shadow[2]  = *pixelPTR++;
#else			
		if ((line & 0x40) || !(i & 1)) {
			sgpio_shadow[11] = 
			sgpio_shadow[5]  =	
			sgpio_shadow[10] = 
			sgpio_shadow[2]  =  run_value1;
		} else {
			sgpio_shadow[11] = 
			sgpio_shadow[5]  =	
			sgpio_shadow[10] = 
			sgpio_shadow[2]  =  run_value2;
		}
#endif				

		sgpio_shadow[12]  =	
		sgpio_shadow[1]  =	vertical;   
								
		sgpio_shadow[15] = SDCE0lo;			// pixels really start here
		sgpio_shadow[7]  = SDCE0lo;
		sgpio_shadow[14] = SDCE0lo;
		sgpio_shadow[3]  = SDCE0lo;

		sgpio_wait4reload;
		sgpio_clear_status;	

#if USE_DATA
		sgpio_shadow[11] = *pixelPTR++;
		sgpio_shadow[5]  = *pixelPTR++;	
		sgpio_shadow[10] = *pixelPTR++;
		sgpio_shadow[2]  = *pixelPTR++;
#else			
		if ((line & 0x40) || !(i & 1)) {
			sgpio_shadow[11] = 
			sgpio_shadow[5]  =	
			sgpio_shadow[10] = 
			sgpio_shadow[2]  =  run_value1;
		} else {
			sgpio_shadow[11] = 
			sgpio_shadow[5]  =	
			sgpio_shadow[10] = 
			sgpio_shadow[2]  =  run_value2;
		}
#endif				
						
		sgpio_shadow[15]  =	SDCE0lo;
		sgpio_shadow[7]   =	SDCE0lo;
		sgpio_shadow[14]  =	SDCE0lo;
		sgpio_shadow[3]   =	SDCE0lo;
					
		for (i = 1; i <= 5; i++) {
			
			sgpio_wait4reload;
#if USE_DATA
			sgpio_shadow[11] = *pixelPTR++;
			sgpio_shadow[5]  = *pixelPTR++;	
			sgpio_shadow[10] = *pixelPTR++;
			sgpio_shadow[2]  = *pixelPTR++;
#else			
			if ((line & 0x40) || !(i & 1)) {
				sgpio_shadow[11] = 
				sgpio_shadow[5]  =	
				sgpio_shadow[10] = 
				sgpio_shadow[2]  =  run_value1;
			} else {
				sgpio_shadow[11] = 
				sgpio_shadow[5]  =	
				sgpio_shadow[10] = 
				sgpio_shadow[2]  =  run_value2;
			}
#endif				
			sgpio_clear_status;	
			
			sgpio_wait4reload;
#if USE_DATA
				sgpio_shadow[11] = *pixelPTR++;
				sgpio_shadow[5]  = *pixelPTR++;	
				sgpio_shadow[10] = *pixelPTR++;
				sgpio_shadow[2]  = *pixelPTR++;
#else			
			if ((line & 0x40) || !(i & 1)) {
				sgpio_shadow[11] = 
				sgpio_shadow[5]  =	
				sgpio_shadow[10] = 
				sgpio_shadow[2]  =  run_value1;
			} else {
				sgpio_shadow[11] = 
				sgpio_shadow[5]  =	
				sgpio_shadow[10] = 
				sgpio_shadow[2]  =  run_value2;											 7
			}
#endif				
			sgpio_clear_status;																	
		}
								
		sgpio_wait4reload;
		sgpio_clear_status;	
						
		sgpio_shadow[15] =	SDCE0hi;
		sgpio_shadow[7]  =	GDCLKgoLO;
		sgpio_shadow[14] =	GDCLKlo;  
		sgpio_shadow[3]  =	GDCLKlo;  

		sgpio_wait4reload;
		sgpio_clear_status;	
						
		sgpio_shadow[15]  =	GDCLKlo;
		sgpio_shadow[7]   =	GDCLKlo;
		sgpio_shadow[14]  =	GDCLKlo;
		sgpio_shadow[3]   =	GDCLKlo;
				
		sgpio_wait4reload;
		sgpio_clear_status;	
		
		sgpio_shadow[15]  =	GDCLKlo;
		sgpio_shadow[7]   =	GDCLKlo;
		sgpio_shadow[14]  =	GDCLKlo;
		sgpio_shadow[3]   =	GDCLKlo;

		sgpio_wait4reload;
		sgpio_clear_status;		
		
		sgpio_wait4reload;
		sgpio_clear_status;				
		
		sgpio_wait4reload;
		sgpio_clear_status;							
		
				
		sgpio_shadow[15]  =	GDCLKlo ;
		sgpio_shadow[7]   =	SDLEgoHI ;
		sgpio_shadow[14]  =	SDLEhi ;
		sgpio_shadow[3]   =	SDLEgoLO;				
		
}


extern const char Pixels[];

void screenEINK(void) {
	int line;
////////////////////////////////////////////////////////////////////////

	LPC_SGPIO->CTRL_ENABLE = 0xffff;		// turn em all on


	pixelPTR = (int *) 0x10000000;

	for (line = 0; line< 600; line++) lineEINK(line, 0xffffffff);		// pixel region

	pixelPTR = (int *) 0x1001E000;	  	// points to a region of all 0s for data

	for (line = 0; line< 14;  line++) lineEINK(line, 0xeeeeeeee);		// vertical retrace
	for (line = 0; line< 8;   line++) lineEINK(line, 0xcccccccc);
	for (line = 0; line< 1;   line++) lineEINK(line, 0x66666666);
	for (line = 0; line< 3;   line++) lineEINK(line, 0xeeeeeeee);

	LPC_SGPIO->CTRL_ENABLE = 0;			// turn em all off
	
}


//////////////////////////////////////////////////////////////
//

//#define MHZ25_175
//#define MHZ30

#ifdef MHZ25_175
  #define	PLL0mdiv	0x23e14e9
  #define	PLL0npdiv	0xf500e
#elif defined MHZ30
  #define	PLL0mdiv	0xc2e4ccc
  #define	PLL0npdiv	0x202017
#elif defined MHZ35					// runs here -monitor is UNHAPPY -- can't always keep up -- marginal
  #define	PLL0mdiv	0x43e5b69
  #define	PLL0npdiv	0xc7015
#elif defined MHZ41				   	// can't keep up here
  #define	PLL0mdiv	0xb2a54cc
  #define	PLL0npdiv	0x20200a
#elif defined MHZ43		  // broke -- wrong freq
  #define	PLL0mdiv	0x53e36c1
  #define	PLL0npdiv	0x3d008
#elif defined MHZ45		  		  	// can't keep up here
  #define	PLL0mdiv	0xc2e4ccc
  #define	PLL0npdiv	0x20200a
#elif defined MHZ50					// can't keep up here		  
  #define	PLL0mdiv	0x73e35b2
  #define	PLL0npdiv	0xb005
#elif defined MHZ55					// can not quite keep up on internal RAM
  #define	PLL0mdiv	0xe3833bb
  #define	PLL0npdiv	0x1002
#else	// 24.576 MHz   -- 44.1KHz audio
  #define	PLL0mdiv	0x23e34d3
  #define	PLL0npdiv	0x3f00e
#endif


uint32_t CGU_SetPLL0audio2vga(void){

#if 1


#else  // use PLL0 audio
    /* disable clock, disable skew enable, power down pll,
    * (dis/en)able post divider, (dis/en)able pre-divider,
    * disable free running mode, disable bandsel,
    * enable up limmiter, disable bypass
    */
    LPC_CGU->PLL0AUDIO_CTRL = (6 << 24)   /* source = XTAL OSC 12 MHz */
                      | (1 << 0); /* power down */

	LPC_CGU->PLL0AUDIO_MDIV = PLL0mdiv;	  		
	LPC_CGU->PLL0AUDIO_NP_DIV = PLL0npdiv;

    LPC_CGU->PLL0AUDIO_CTRL = (6 << 24)   /* source = XTAL OSC 12 MHz */
					  | (6<< 12)		  // fractional divider off and bypassed
                      | (1 << 4);   /* CLKEN */
    /* wait for lock */
    while (!(LPC_CGU->PLL0AUDIO_STAT & 1)); 
    
	LPC_CGU->BASE_PERIPH_CLK =	(8 << 24);		// PLL0 for audio to SGPIO
#endif
        
	return 0;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//
//	set up SGPIO for output
//

	
#define INV_OUT_CLK   (1<<3)

#define CONCAT_ENABLE (1<<11)
#define SELFLOOP	  (0<<12)
#define SLICE_2		  (1<<12)
#define SLICE_4		  (2<<12)
#define SLICE_8		  (3<<12)	

#define BIT_MODE	  (0<<6)
#define BIT2_MODE	  (1<<6)
#define NIBBLE_MODE	  (2<<6)
#define BYTE_MODE	  (3<<6)

                        
void setupSYNCs(void) {

////////////////////////////////////////////////////////////////////////////////
//
//	set all the clocks to either 16MHz or 32 MHz
//

// horizontal and pixel clock -- the later forces 32 MHz operation

	LPC_SGPIO->PRESET[15] =		
	LPC_SGPIO->PRESET[7]  =		
	LPC_SGPIO->PRESET[14] =		
	LPC_SGPIO->PRESET[3]  =	 5;		// use SGPIO CLK  == PLL1 CLK/6 -- registers work faster with faster clock

	LPC_SGPIO->COUNT[15] =		
	LPC_SGPIO->COUNT[7]  =		
	LPC_SGPIO->COUNT[14] =		
	LPC_SGPIO->COUNT[3]  =	0;
		
	LPC_SGPIO->SLICE_MUX_CFG[15] = 	
	LPC_SGPIO->SLICE_MUX_CFG[7]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[14] = 	
	LPC_SGPIO->SLICE_MUX_CFG[3]  = NIBBLE_MODE;	

	LPC_SGPIO->SGPIO_MUX_CFG[15] = 	
	LPC_SGPIO->SGPIO_MUX_CFG[7]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[14] = 	
	LPC_SGPIO->SGPIO_MUX_CFG[3]  = CONCAT_ENABLE | SLICE_4;	
	
	LPC_SGPIO->POS[15] = 	
	LPC_SGPIO->POS[7]  = 	
	LPC_SGPIO->POS[14] = 	
	LPC_SGPIO->POS[3]  = ((0x020-1)<<8) | (0x020-1);
	
	LPC_SGPIO->OUT_MUX_CFG[12]  = 	
	LPC_SGPIO->OUT_MUX_CFG[13]  = 	
	LPC_SGPIO->OUT_MUX_CFG[14]  = 	
	LPC_SGPIO->OUT_MUX_CFG[15]  = 7;		// P0-3	
	
// vertical syncs
	
	LPC_SGPIO->PRESET[12] =		
	LPC_SGPIO->PRESET[1]  =  11;		// use SGPIO CLK  == PLL1 CLK/12 -- registers work faster with faster clock
		
	/* Load counter with initial value */

	LPC_SGPIO->COUNT[12] =		
	LPC_SGPIO->COUNT[1]  =	0;		
	
	LPC_SGPIO->SLICE_MUX_CFG[12] = 	
	LPC_SGPIO->SLICE_MUX_CFG[1]  = NIBBLE_MODE;	
		
	LPC_SGPIO->SGPIO_MUX_CFG[12] = 	
	LPC_SGPIO->SGPIO_MUX_CFG[1]  = CONCAT_ENABLE | SLICE_2;	
		
	LPC_SGPIO->POS[12] = 	
	LPC_SGPIO->POS[1]  = ((0x10-1)<<8) | (0x10-1);
	
	LPC_SGPIO->OUT_MUX_CFG[8]  = 	
	LPC_SGPIO->OUT_MUX_CFG[9]  = 	
	LPC_SGPIO->OUT_MUX_CFG[10]  = 	
	LPC_SGPIO->OUT_MUX_CFG[11]  = 6;		// M0-3
			
}



void setupPIXELs(void) {

////////////////////////////////////////////////////////////////////////////////
//
//	set all the clocks to the same frequency
//


	LPC_SGPIO->PRESET[2]  = 
	LPC_SGPIO->PRESET[10] = 			
	LPC_SGPIO->PRESET[5]  = 
	LPC_SGPIO->PRESET[11] = 11;		// use SGPIO CLK  == PLL1 CLK/12 -- registers work faster with faster clock
		
	/* Load counter with initial value */

	LPC_SGPIO->COUNT[2]  =
	LPC_SGPIO->COUNT[10] = 			
	LPC_SGPIO->COUNT[5]  =
	LPC_SGPIO->COUNT[11] = 0;		// 8 slice buffer 
	
	
	
	/*************************************/
	/* Program slice A(0) as pixel buffer */
	/*************************************/

	LPC_SGPIO->SLICE_MUX_CFG[2]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[10] = 	
	LPC_SGPIO->SLICE_MUX_CFG[5]  = 	
	LPC_SGPIO->SLICE_MUX_CFG[11] = BYTE_MODE;	
	
	LPC_SGPIO->SGPIO_MUX_CFG[2]  = 	
	LPC_SGPIO->SGPIO_MUX_CFG[10] = 	
	LPC_SGPIO->SGPIO_MUX_CFG[5]  = 	
//	LPC_SGPIO->SGPIO_MUX_CFG[11] = CONCAT_ENABLE | SLICE_8;	
	LPC_SGPIO->SGPIO_MUX_CFG[11] = CONCAT_ENABLE | SLICE_4;	
	
	LPC_SGPIO->POS[2]  = 	
	LPC_SGPIO->POS[10] = 	
	LPC_SGPIO->POS[5]  = 	
//	LPC_SGPIO->POS[11] = ((0x020-1)<<8) | (0x020-1);
	LPC_SGPIO->POS[11] = ((0x010-1)<<8) | (0x010-1);
	
	LPC_SGPIO->OUT_MUX_CFG[0]  = 	
	LPC_SGPIO->OUT_MUX_CFG[1]  = 	
	LPC_SGPIO->OUT_MUX_CFG[2]  = 	
	LPC_SGPIO->OUT_MUX_CFG[3]  = 	
	LPC_SGPIO->OUT_MUX_CFG[4]  = 	
	LPC_SGPIO->OUT_MUX_CFG[5]  = 	
	LPC_SGPIO->OUT_MUX_CFG[6]  = 	
	LPC_SGPIO->OUT_MUX_CFG[7]  = 0xb;				// output the data bit on SGPIO0-7
		
}

////////////////////////// setup sGPIO ///////////////////////
//
//
void setupVGA(void) {

	CGU_SetPLL0audio2vga();		// yes its the audio PLL, but being used here to generate pixel clock
	
    LPC_SGPIO->CLR_EN0	= 0xffff;		// disable interrupting on clock
    LPC_SGPIO->CLR_EN1	= 0xffff;		// disable interrupting on clock

	/* Disable all counters (should be in this state after reset but just make sure) */
	LPC_SGPIO->CTRL_ENABLE = 0;	

	/* Set all pins as output */
	LPC_SGPIO->GPIO_OEREG = 0xFFFF;

	setupPIXELs();	
	setupSYNCs();
	
/////////////////////////////////////////////////////////////////////////////////
	/* Enable counter under test to start pixel stream generation */
//	LPC_SGPIO->CTRL_ENABLE = (1<<0) | (1<<8) | (1<<4) | (1<<9)
//							| (1<<2) | (1<<10) | (1<<5) | (1<<11) 
//							| (1<<1);
	LPC_SGPIO->CTRL_ENABLE = 0xffff;		// turn em all on
							
	

// and SGPIO pins
///////////////////////////// setup SGPIO ///////////////////
//
//	handle the pin mux setup for SGPIO
//

#if 1
	// NXP pixel board

	scu_pinmux(0x0 ,0 , MD_PDN, FUNC3);	//  SGPIO0: sliceL0 2bit pixels
	scu_pinmux(0x0 ,1 , MD_PDN, FUNC3);	//  SGPIO1: sliceL1 2bit pixels
	scu_pinmux(0x1 ,15, MD_PDN, FUNC2);	//  SGPIO2: sliceL2 2bit pixels
	scu_pinmux(0x9 ,5 , MD_PDN, FUNC6);	//  SGPIO3: sliceL3 2bit pixels
	scu_pinmux(0x7 ,0 , MD_PDN, FUNC7);	//  SGPIO4: sliceL4 2bit pixels
	scu_pinmux(0x6 ,6 , MD_PDN, FUNC2);	//  SGPIO5: sliceL5 2bit pixels
	scu_pinmux(0x6 ,7 , MD_PDN, FUNC2);	//  SGPIO6: sliceL6 2bit pixels
	scu_pinmux(0x7 ,7 , MD_PDN, FUNC7);	//  SGPIO7: sliceL7 2bit pixels
	
	scu_pinmux(0x9 ,6 , MD_PDN, FUNC6);	//  SGPIO8: sliceB0 -- SDOE   bit 0	
	scu_pinmux(0x4 ,3 , MD_PDN, FUNC7);	//  SGPIO9: sliceB0 -- GDOE   bit 1
//	scu_pinmux(0x1 ,3 , MD_PDN, FUNC2);	//  SGPIO10: sliceB0 --              
	scu_pinmux(0x1 ,4 , MD_PDN, FUNC2);	//  SGPIO11: sliceB0 -- GDSP   bit 3
	scu_pinmux(0x2 ,3 , MD_PDN, FUNC0);	//  SGPIO12: sliceB0 -- SDCE0  bit 4
	scu_pinmux(0x2 ,4 , MD_PDN, FUNC0);	//  SGPIO13: sliceB0 -- SDCLK  bit 5
	scu_pinmux(0x2 ,5 , MD_PDN, FUNC0);	//  SGPIO14: sliceB0 -- SDLE   bit 6
	scu_pinmux(0x1 ,5 , MD_PDN, FUNC6);	//  SGPIO15: sliceB0 -- GDCLK   bot 7
	
	
	
	
	
	
	//\\\\\\\\\\////////////// DEBUG \\\\\\\\\\\\\\\\\\\\\\//////////////////
//  clkout pin
//	scu_pinmux(0xF, 3, MD_PDN, FUNC4); 			// CLKOUT

//  wiggle this pin for debug
	scu_pinmux(0x5 ,3 , MD_PDN, FUNC0); 		// GPIO2[12]  -- a line to wiggle for debug
	
	LPC_GPIO2->DIR |= (1<<12);			

#else
	/* validation board with 256BGA */

	scu_pinmux(0x9 ,0 , MD_PDN, FUNC6);	//  SGPIO0: sliceL0 -- SV11.4	hsync
	scu_pinmux(0x9 ,1 , MD_PDN, FUNC6);	//  SGPIO1: sliceL1 -- SV13.4	vsync
	scu_pinmux(0x9 ,2 , MD_PDN, FUNC6);	//  SGPIO2: sliceL2 -- SV15.4
	scu_pinmux(0x9 ,5 , MD_PDN, FUNC6);	//  SGPIO3: sliceL3 -- SV5.4	blue
	scu_pinmux(0x6 ,3 , MD_PDN, FUNC2);	//  SGPIO4: sliceL4 -- SV5.2
	scu_pinmux(0x7 ,1 , MD_PDN, FUNC7);	//  SGPIO5: sliceL5 -- X11.22	green
//	scu_pinmux(0x7 ,2 , MD_PDN, FUNC7);	//  SGPIO6: sliceL6 -- X11.21
//	scu_pinmux(0x7 ,7 , MD_PDN, FUNC7);	//  SGPIO7: sliceL7 -- X11.34				

	scu_pinmux(0xf ,7 , MD_PDN, FUNC6);	//  SGPIO6: sliceL6 -- X5.18
	scu_pinmux(0xf ,8 , MD_PDN, FUNC6);	//  SGPIO7: sliceL7 -- X5.20	red

	//\\\\\\\\\\////////////// DEBUG \\\\\\\\\\\\\\\\\\\\\\//////////////////
//  clkout pin
//	scu_pinmux(0xF, 3, MD_PDN, FUNC4); 			// CLKOUT

//  wiggle this pin for debug
	scu_pinmux(0xF, 3, MD_PDN, FUNC4); 			// GPIO7[18]  -- a line to wiggle for debug

#endif


	
}

