

#include "bbI2C.h"
#include "LPC43xx.h"

#ifndef CR
 #define CR 			0xD
 #define LF 			0xA
 #define BACKSPACE	0x8
 #define TAB	 		0x09
#endif




unsigned disableIRQ(void);
unsigned restoreIRQ(unsigned oldCPSR);
unsigned enableIRQ(void);

///////////////////////////////////////////////////////////////
//
// WAIT in milliseconds
//
// 

// use WAITmicro for microseconds, avoid call overhead -- more accurate -- need to declare start to use it


void WAITmicro(int time)  {
	int start;

	start=(int)LPC_TIMER0->TC; 
	while (((int)LPC_TIMER0->TC - start) < time) ;
}

void WAITmsec( int time ) {
	int start1, start2;
	
	start1 = (int) LPC_TIMER0->TC;				// use registers -- for speed
	start2 = time;
	if (start2 > 4200000) {		// handle long delays 
		while (start2--) {
			while ((((int) LPC_TIMER0->TC) - start1) < 1000) ;
			start1 += 1000;		
		}
	} else {
		start2 *= 1000;
		while ((((int) LPC_TIMER0->TC) - start1) < start2) ;
	}
}


///////////////////////////////////////////////////////////////////////////////
//
//  use a global pointer to the GPIOs for support beyond port0
//		  

LPC_GPIOn_Type *LPC_GPIOda = I2C_SDA_PORT;
LPC_GPIOn_Type *LPC_GPIOck = I2C_SCL_PORT;

#define SET_SCL_HIGH	LPC_GPIOck->SET = scl_mask		
#define SET_SDA_HIGH	LPC_GPIOda->SET = sda_mask		
                                         
#define SET_SCL_LOW		LPC_GPIOck->CLR = scl_mask		
#define SET_SDA_LOW		LPC_GPIOda->CLR = sda_mask

#define DRV_SCL_LOW		LPC_GPIOck->DIR |= scl_mask
#define FLT_SCL_HIGH	LPC_GPIOck->DIR &= ~scl_mask
#define DRV_SDA_LOW		LPC_GPIOda->DIR |= sda_mask
#define FLT_SDA_HIGH	LPC_GPIOda->DIR &= ~sda_mask


#define i2c_stall()	WAITmicro(2)



int i2c_start (int sda_mask, int scl_mask) {
	int start;

	
	FLT_SCL_HIGH; FLT_SDA_HIGH;			// don't drive SDA or SCL,  
	SET_SCL_LOW;  SET_SDA_LOW;			// drive both low when enabled
	
	start = LPC_TIMER0->TC;
		
	while (LPC_TIMER0->TC-start < 100000) {						

		if ((LPC_GPIOda->PIN & sda_mask) && (LPC_GPIOck->PIN & scl_mask)) {
			DRV_SDA_LOW;					// drive SDA low
			i2c_stall();
			if ((LPC_GPIOck->PIN & scl_mask) == 0) {	// check we got control
				FLT_SCL_HIGH; FLT_SDA_HIGH;						// release both
			} else {
				DRV_SCL_LOW;			// drive SCL low
				return 0;				// we got control
			}
		}
	}
	return -1;
}

void i2c_stop (int sda_mask, int scl_mask) {
	DRV_SDA_LOW;		// drive SDA low

	i2c_stall();
	FLT_SCL_HIGH;		// release SCL high
	i2c_stall();
	FLT_SDA_HIGH;		// release SDA high
}

// shift out 8 bits, return ACK, leave SCL low, SDA float -- probably driven by slave for a bit

char i2c_shift (int sda_mask, int scl_mask, char value) {		// returns TRUE when ACK'd
	int i;
	
	i=7;
//	i2c_stall();
	while (i >= 0) {
		DRV_SCL_LOW;		// drive SCL low
		i2c_stall();
		if (value & (1<<i)) 	FLT_SDA_HIGH;		// release SDA high
		else 					DRV_SDA_LOW;		// drive SDA low
	// REMOVE THIS NEXT ONE FOR 400 KB RATE	
//		i2c_stall();
		FLT_SCL_HIGH;		// release SCL high
		while ((LPC_GPIOck->PIN & scl_mask) ==0);		// allow clock stretching
		i2c_stall();
		i--;
	}
	DRV_SCL_LOW;			// drive SCL low
	FLT_SDA_HIGH;			// let SDA float
	i2c_stall();
	i2c_stall();
	FLT_SCL_HIGH;			// release SCL high

	i2c_stall();
	i = LPC_GPIOda->PIN & sda_mask;	// check ACK here (save value in i, 0 was ACK'd
	
	i2c_stall();
	DRV_SCL_LOW;			// drive SCL low

	return i==0;			// was it ACK'd	
}


int I2C_Read(int sdi_pin, int scl_pin, int addr, int reg) {
//void I2CINx (int sdi_pin, int scl_pin, int addr, int reg, int cnt, char *list) {	// U16 to allow -1 for unused
	unsigned char itsOK;	// also set to 0 when last data sent
	unsigned char data;
	unsigned char i;
	unsigned int sda_mask, scl_mask;
	
	sda_mask = 1<<sdi_pin;
	scl_mask = 1<<scl_pin;

	if (i2c_start(sda_mask, scl_mask)) return -1;	// was not able to get the bus
	itsOK = 1;

	if ((reg != -1)) {		  		// special case where we just read the addressed device
		itsOK = i2c_shift(sda_mask, scl_mask, addr & 0xfe);		// write out ther reg 
		if (itsOK) itsOK = i2c_shift(sda_mask, scl_mask, reg);
	}
	
	if (itsOK) {	
		if (reg != -1) {
			FLT_SDA_HIGH;			// release SDA high  
			i2c_stall();
			FLT_SCL_HIGH;			// release SCL high 
			i2c_stall();
			DRV_SDA_LOW;			// drive SDA low -- repeated START
		}

		if (i2c_shift(sda_mask, scl_mask, addr | 1)) {		// read this time
			data = 0;
			i = 8;
			while (i > 0) {
				DRV_SCL_LOW;		// drive SCL low
				i2c_stall();
				i--;
				FLT_SCL_HIGH;		// release SCL high
				i2c_stall();
				data |= (LPC_GPIOda->PIN & sda_mask)? (1 << i) :0;
			}		
			DRV_SCL_LOW;			// drive SCL low
//			if ((itsOK = saveList(data))) DRV_SDA_LOW;	// ACK for repeated read
			i2c_stall();
//			i2c_stall();
			i2c_stall();
			FLT_SCL_HIGH;			// release SCL high
		
			i2c_stall();
//			master (me would ACK here for a sequenctial read				
			DRV_SCL_LOW;			// drive SCL low
			FLT_SDA_HIGH;			// release SDA high  
//			i2c_stall();

		}
	} 
	i2c_stop(sda_mask, scl_mask);

	if (itsOK) return data; else return -1;
}


int I2C_Write(int sdi_pin, int scl_pin, int addr, int reg, int data) {
//int I2COUTx (int sdi_pin, int scl_pin, int addr, int cnt, char *list) {
	unsigned char itsOK;
	unsigned int sda_mask, scl_mask;

	sda_mask = 1<<sdi_pin;
	scl_mask = 1<<scl_pin;
	
	if (i2c_start(sda_mask, scl_mask)) return -1;	// was not able to get the bus
	itsOK = i2c_shift(sda_mask, scl_mask, addr & 0xfe);
	
	if (itsOK) itsOK = i2c_shift(sda_mask, scl_mask, reg);
	if (itsOK) itsOK = i2c_shift(sda_mask, scl_mask, data);
		
	i2c_stop(sda_mask, scl_mask);	
	return itsOK;
}


void I2C_init(void) {
	SET_I2C_SDA_MUX;		// GPIO	defined in .h file
	SET_I2C_SCL_MUX;		// 
}
