/***********************************************************************
 * $Id:: BLDC.c 3871 2010-07-16 11:50:22Z gerritdewaard                $
 *
 * Project: LPC1100 BLDC Motor Control AN
 *
 * Description:
 *
 *
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/


/******************************************************************************
 * Includes
 *****************************************************************************/
#include "application.h"

#define GRAPH_LIMIT	64-8
/******************************************************************************
 * External global variables
 *****************************************************************************/
extern volatile uint32_t SysTick_cntr;
extern volatile MOTOR_TypeDef Motor;
/******************************************************************************
 * Local variables
 *****************************************************************************/
volatile uint8_t blink = 0;
volatile uint8_t TXBUF[0xFF];
volatile uint8_t RXBUF[0xFF];
uint16_t connTimer=0;			// Timer for connection timeout
volatile uint8_t oled_X = 0;
volatile uint8_t oled_Y = 0;
volatile uint8_t oled_Y_PixBUF[96];

volatile uint8_t show_graph = FALSE;
volatile uint8_t show_temperature = FALSE;
volatile uint8_t clear_screen = TRUE;
volatile uint8_t sec5 = 5;

/******************************************************************************
 * Local Functions
 *****************************************************************************/


/******************************************************************************
** Function name: Call_5ms
**
** Descriptions:
**
** parameters:
** Returned value:
**
******************************************************************************/
void Call_5ms(void)
{
	if (Motor.Enable && (Motor.RampingUp == FALSE))
	{
		/* Do the PID calculations */
		vPID_RPM(&Motor);
	}

}
/******************************************************************************
** Function name:
**
** Descriptions:
**
** parameters:
** Returned value:
**
******************************************************************************/
void Call_25ms(void)
{
#if MC_BOARD_ENABLE_OLED == 1
	if (show_graph == TRUE)
	{
		/* Down scale the actual RPM value to screen size */
		oled_Y = (Motor.RPM/80);

		/* Clip the output */
		if (oled_Y >= GRAPH_LIMIT) oled_Y = GRAPH_LIMIT;

		/* Clear the previous pixel */
		oled_putPixel(oled_X, oled_Y_PixBUF[oled_X] , OLED_COLOR_BLACK);

		oled_Y = 64 - oled_Y;
		oled_putPixel(oled_X, oled_Y , OLED_COLOR_WHITE);

		oled_Y_PixBUF[oled_X] = oled_Y;
		oled_X++;

		if (oled_X == 96) oled_X = 0;
	}
#endif
}
/******************************************************************************
** Function name:
**
** Descriptions:
**
** parameters:
** Returned value:
**
******************************************************************************/
void Call_100ms(void)
{
	if (Motor.Enable && Motor.RampingUp)
	{
		if (clear_screen == TRUE)
		{
			/* Clear the OLED screen */
			oled_clearScreen(OLED_COLOR_BLACK);
			clear_screen = FALSE;
		}
		/* Ramp-up the motor.. */
		vBLDC_RampUp (&Motor, Motor.sp);
	}

}
/******************************************************************************
** Function name:
**
** Descriptions:
**
** parameters:
** Returned value:
**
******************************************************************************/
void Call_1s(void)
{
	/* */
	vCOMMS_send(&Motor);

#if (MC_BOARD_ENABLE_OLED == 1)
#if (MC_BOARD_ENABLE_LM75 == 1)
    static uint8_t firstTime = 1;
	uint8_t  buffer[13] = "Temp: xx.x C";
	uint16_t temperature;

	if (show_temperature == TRUE)
	{
		if (firstTime)
		{
			/* Clear the OLED screen */
			oled_clearScreen(OLED_COLOR_BLACK);
			oled_putString(1, 1, (char *)buffer, OLED_COLOR_WHITE, OLED_COLOR_BLACK);
			firstTime = 0;
		}

		temperature = (uint16_t)lm75a_readTemp();
		temperature = (temperature + 5) / 10; //round to 0.1 degree
		buffer[6] = ((temperature / 100) % 10) + '0';
		buffer[7] = ((temperature / 10) % 10) + '0';
		buffer[8] = '\0';
		oled_putString((6*6), 1, (char *)&buffer[6], OLED_COLOR_WHITE, OLED_COLOR_BLACK);
		buffer[9] = (temperature % 10) + '0';
		buffer[10] = '\0';
		oled_putString((9*6), 1, (char *)&buffer[9], OLED_COLOR_WHITE, OLED_COLOR_BLACK);
	}
	else firstTime = 1;

#endif //MC_BOARD_ENABLE_OLED
#endif //MC_BOARD_ENABLE_LM75
}

/******************************************************************************
** Function name:
**
** Descriptions:
**
** parameters:
** Returned value:
**
******************************************************************************/
void Call_5s(void)
{
}

/******************************************************************************
** Function name:
**
** Descriptions:
**
** parameters:
** Returned value:
**
******************************************************************************/
void Appl_Init (void)
{
	/****************************************************/
	/* SYSTICK 											*/
	/****************************************************/
	SysTick_Config (SysTick_VALUE);

	/****************************************************/
	/* FREERUNNING COUNTER								*/
	/****************************************************/
	/* Setup Timer16 1 as free running counter for e.g. RPM calc..  */
	/* Enable the clock to Timer16 1 */
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<8);
	/* Set the prescaler to get never get an overflow */
	LPC_TMR16B1->PR = 55;
	/* RESET timer16 1  */
	LPC_TMR16B1->TCR = 1<<1;
	/* ENABLE timer16 1 */
	LPC_TMR16B1->TCR = 1;

	/****************************************************/
	/* BLDC MOTOR INIT									*/
	/****************************************************/
	vBLDC_Init(&Motor);

	/****************************************************/
	/* HALL sensors	INIT								*/
	/****************************************************/
	GPIOInit();
	GPIOSetDir( LED_PORT, LED_BIT, 1 );
	GPIOSetValue( LED_PORT, LED_BIT, 0 );
	/* Set the direction to input */
	GPIOSetDir(HALL_A_PORT,HALL_A_PIN,0);	// HALL A
	GPIOSetDir(HALL_B_PORT,HALL_B_PIN,0);	// HALL B
	GPIOSetDir(HALL_C_PORT,HALL_C_PIN,0);	// HALL C

	/* Setup the interrupt, seq: portNum, bitPosi, sense = edge, single = both, event*/
	GPIOSetInterrupt(HALL_A_PORT,HALL_A_PIN,0,1,1);
	GPIOSetInterrupt(HALL_B_PORT,HALL_B_PIN,0,1,1);
	GPIOSetInterrupt(HALL_C_PORT,HALL_C_PIN,0,1,1);

	/* Enable the interrupts */
	GPIOIntEnable(HALL_A_PORT,HALL_A_PIN);	// HALL A
	GPIOIntEnable(HALL_B_PORT,HALL_B_PIN);	// HALL B
	GPIOIntEnable(HALL_C_PORT,HALL_C_PIN);	// HALL C

	NVIC_EnableIRQ(EINT2_IRQn);

	/****************************************************/
	/* I2C INIT      									*/
	/****************************************************/
    I2CInit( (uint32_t)I2CMASTER);

	/****************************************************/
	/* OLED INIT      									*/
	/****************************************************/
#if MC_BOARD_ENABLE_OLED == 1
    /* Initialize the OLED */
    oled_init();
    /* Clear the OLED screen */
    oled_clearScreen(OLED_COLOR_BLACK);
#endif //MC_BOARD_ENABLE_OLED

#if USE_STARTUP_GUI == 1
	/****************************************************/
	/* Startup message on OLED							*/
	/****************************************************/
    vGUI_StartupMessage();
#else
    vGUI_PrintInstruction();
#endif //USE_STARTUP_GUI
	/****************************************************/
	/* JOYSTICK INIT   									*/
	/****************************************************/
#if MC_BOARD_ENABLE_JOYSTICK == 1
    joystick_init();
#endif

	/****************************************************/
	/* CAN ROM DRIVER INIT								*/
	/****************************************************/
#if (USE_CAN == 1)
	/* Initialize the CAN ROM driver handlers */
	vCAN_initRomHandlers();
#endif

	/****************************************************/
	/* UART INIT      									*/
	/****************************************************/
	/* Initialize the UART */
#if (USE_UART == 1)
	/* Push UART_RS485 high for UART -> USB mode */
	GPIOSetDir(3,4,1);
	GPIOSetValue(3,4,1);
	/* Initialize UART */
	UARTInit(115200);

	/* Add a 5 sec delay before sending startup message to UART. */
	/* Delay added to allow for USB enumeration on PC after reset. */
	SysTick_cntr = 0;
	while (SysTick_cntr > 5000);
	SysTick_cntr = 0;

	UARTSend((uint8_t *)"\n\r/**********************************************/", 50);
	UARTSend((uint8_t *)"\n\r/*                                            */", 50);
	UARTSend((uint8_t *)"\n\r/* BLDC Motor Control Demo Application on     */", 50);
	UARTSend((uint8_t *)"\n\r/* LPCXpresso Motor Control Board             */", 50);
	UARTSend((uint8_t *)"\n\r/* Date: 2011-02-14, rev A                    */", 50);
	UARTSend((uint8_t *)"\n\r/*                                            */", 50);
	UARTSend((uint8_t *)"\n\r/**********************************************/", 50);
	UARTSend((uint8_t *)"\n\rRPM\tMV\tActive\tDirection\n\r", 27);

#endif // (USE_UART == 1)
}

/******************************************************************************
 * MAIN
 *****************************************************************************/
int main (void) {

	/* Variable declaration */
	uint32_t cnt_5s 	=0,
			 cnt_1s		=0,
			 cnt_5ms	=0,
			 cnt_25ms	=0,
			 cnt_100ms	=0;

	/* Initialize the application */
	Appl_Init ();

	/* Disable the Motor */
	Motor.Enable = 0;

	/* Loop forever */
	while (1)
	{
		/* Tune scheduler */
		if ( SysTick_cntr >= cnt_5ms )		{cnt_5ms = SysTick_cntr+10;		Call_5ms();}
		if ( SysTick_cntr >= cnt_25ms )		{cnt_25ms = SysTick_cntr+25;	Call_25ms();}
		if ( SysTick_cntr >= cnt_100ms )	{cnt_100ms =SysTick_cntr +100;	Call_100ms();}
		if ( SysTick_cntr >= cnt_1s )		{cnt_1s = SysTick_cntr+1000;	Call_1s();}
		if ( SysTick_cntr >= cnt_5s )		{cnt_5s = SysTick_cntr+5000;	Call_5s();}
	}
}


