/***********************************************************************
 * $Id:: BLDC.c 3871 2010-07-16 11:50:22Z gerritdewaard                $
 *
 * Project: LPC1100 BLDC Motor Control AN
 *
 * Description:
 *
 *
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/


/******************************************************************************
 * Includes
 *****************************************************************************/
#include "application.h"
#define CRLF UARTSend((uint8_t *)"\n\r", 2)
#define TAB UARTSend((uint8_t *)"\t", 1)

void vDec2Ascii (uint32_t val, uint8_t *buffer, uint8_t *size)
{
	static uint8_t temp_buf[9], i;

	/* Flush temp_buf */
	for (i = 0; i<10; i++ )
		temp_buf[i] = 0;

	/* Return ASCII 0 if val = 0 */
	if (val == 0)
	{
		*buffer = (0 + '0');
		*size = 1;
		return;
	}

	i = 0;
	while (val)
	{
		temp_buf[i] = (val % 10) + '0';
		val = val / 10;
		i++;
	}

	/* Set the size of the string length.. */
	*size = i;

	while (i)
	{
		*buffer++ = temp_buf[i-1];
		i--;
	}
}

void vCOMMS_send (MOTOR_TypeDef *ptr)
{

#if (USE_UART == 1)
	uint8_t buf[10] = {0};
	uint8_t size = 0;

	vDec2Ascii((uint32_t)ptr->RPM, buf, &size);
	UARTSend((uint8_t *)buf, size );
	TAB;
	vDec2Ascii((uint32_t)ptr->mv, buf, &size);
	UARTSend((uint8_t *)buf, size );
	TAB;
	if (ptr->Enable)
		UARTSend((uint8_t *)"Enabled", 7 );
	else
		UARTSend((uint8_t *)"Disabled", 8 );
	TAB;
	if(ptr->Direction == CCW)
		UARTSend((uint8_t *)"CCW", 3 );
	else
		UARTSend((uint8_t *)"CW", 2 );
	CRLF;

#elif (USE_CAN == 1)
	/* Send a simple one time CAN message */
	msg_obj.msgobj  = 0;
	msg_obj.mode_id = 0x100;
	msg_obj.mask    = 0x0;
	msg_obj.dlc     = 4;
	msg_obj.data[0] = (uint8_t)((ptr->RPM>>8)& 0xFF);
	msg_obj.data[1] = (uint8_t)(ptr->RPM & 0xFF);
	msg_obj.data[2] = (uint8_t)((ptr->mv>>8)& 0xFF);
	msg_obj.data[3] = (uint8_t)(ptr->mv & 0xFF);
	vCAN_sendObj(&msg_obj);

#endif

}
