/*****************************************************************************
 *   joystick.c:  Driver for the Joystick switch
 *
 *   Copyright(C) 2009, Embedded Artists AB
 *   All rights reserved.
 *
 ******************************************************************************/

/*
 * NOTE: GPIOInit must have been called before using any functions in this
 * file.
 *
 */


/******************************************************************************
 * Includes
 *****************************************************************************/
#include "application.h"
#if MC_BOARD_ENABLE_JOYSTICK == 1
/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

/******************************************************************************
 * External global variables
 *****************************************************************************/

/******************************************************************************
 * Local variables
 *****************************************************************************/


/******************************************************************************
 * Local Functions
 *****************************************************************************/


/******************************************************************************
 * Public Functions
 *****************************************************************************/

/******************************************************************************
 *
 * Description:
 *    Initialize the Joystick Driver
 *
 *****************************************************************************/
void joystick_init (void)
{
	/*					    HYST   |  PU/PD | FUNC */
	LPC_IOCON->PIO2_6 = 	(1<<5) | (2<<3) | (0);
	LPC_IOCON->PIO2_7 = 	(1<<5) | (2<<3) | (0);
	LPC_IOCON->PIO2_8 = 	(1<<5) | (2<<3) | (0);
	LPC_IOCON->PIO2_9 = 	(1<<5) | (2<<3) | (0);
	LPC_IOCON->PIO2_10 = 	(1<<5) | (2<<3) | (0);

	/* set the GPIOs as inputs */
    GPIOSetDir( JOYSTICK_PORT, JOY_C_PIN, 0 ); // JOY_CENTER
    GPIOSetDir( JOYSTICK_PORT, JOY_U_PIN, 0 ); // JOY_UP
    GPIOSetDir( JOYSTICK_PORT, JOY_D_PIN, 0 ); // JOY_DOWN
    GPIOSetDir( JOYSTICK_PORT, JOY_L_PIN, 0 ); // JOY_LEFT
    GPIOSetDir( JOYSTICK_PORT, JOY_R_PIN, 0 ); // JOY_RIGHT

#ifdef USE_JOYSTICK_INTERRUPT
	/* Setup the interrupt, seq: portNum, bitPosi, sense = edge, single = both, event*/
	GPIOSetInterrupt(JOYSTICK_PORT, JOY_C_PIN ,0,0,0);
	GPIOSetInterrupt(JOYSTICK_PORT, JOY_U_PIN ,0,0,0);
	GPIOSetInterrupt(JOYSTICK_PORT, JOY_D_PIN ,0,0,0);
	GPIOSetInterrupt(JOYSTICK_PORT, JOY_L_PIN ,0,0,0);
	GPIOSetInterrupt(JOYSTICK_PORT, JOY_R_PIN ,0,0,0);

	/* Enable the interrupts */
	GPIOIntEnable(JOYSTICK_PORT, JOY_C_PIN );
	GPIOIntEnable(JOYSTICK_PORT, JOY_U_PIN );
	GPIOIntEnable(JOYSTICK_PORT, JOY_D_PIN );
	GPIOIntEnable(JOYSTICK_PORT, JOY_L_PIN );
	GPIOIntEnable(JOYSTICK_PORT, JOY_R_PIN );
#endif

}

/******************************************************************************
 *
 * Description:
 *    Read the joystick status
 *
 * Returns:
 *   The joystick status. The returned value is a bit mask. More than one
 *   direction may be active at any given time (e.g. UP and RIGHT)
 *
 *****************************************************************************/
uint8_t joystick_read(void)
{
    uint8_t status = 0;
//
//    if (!GPIOGetValue(2, 6)) {
//        status |= JOYSTICK_CENTER;
//    }
//
//    if (!GPIOGetValue(2, 8)) {
//        status |= JOYSTICK_DOWN;
//    }
//
//    if (!GPIOGetValue(2, 9)) {
//        status |= JOYSTICK_RIGHT;
//    }
//
//    if (!GPIOGetValue(2, 7)) {
//        status |= JOYSTICK_UP;
//    }
//
//
//    if (!GPIOGetValue(2, 10)) {
//        status |= JOYSTICK_LEFT;
//    }
//
    return status;
}
#endif //MC_BOARD_ENABLE_JOYSTICK
