/***********************************************************************//**
 * @file		uda1380.h
 * @brief		Header file for audio driver code for UDA1380 audio codec
 * 				used on code_red RDB1768v2 board
 * @version		1.0
 * @date		04. May. 2011
 * @author		CT-PIM
 **************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **************************************************************************/


#ifndef UDA1380_H_
#define UDA1380_H_

/* I2C address of the Codec */
#define UDA1380_ADDR	(0x30 >>1)


#if 0
#define UDA1380_REG00_EVALCLK	  0x00 /* Evaluation modes, WSPLL settings, clock divider and clock selectors    */
#define UDA1380_REG01_I2S		  0x01 /* I2S-bus I/O settings                                                   */
#define UDA1380_REG02_PWRCTRL	  0x02 /* Power control settings                                                 */
#define UDA1380_REG03_ANAMIX	  0x03 /* Analog mixer settings                                                  */
#define UDA1380_REG04_HEADAMP	  0x04 /* Headphone amplifier settings                                           */
#define UDA1380_REG10_MSTRVOL	  0x10 /* Master volume control                                                  */
#define UDA1380_REG11_MIXVOL	  0x11 /* Mixer volume control                                                   */
#define UDA1380_REG13_MODEBBT	  0x12 /* Mode selection, left and right bass boost, and treble settings         */
#define UDA1380_REG13_MSTRMUTE    0x13 /* Master mute, channel 1 and channel 2 de-emphasis and channel mute      */
#define UDA1380_REG14_MIXSDO	  0x14 /* Mixer, silence detector and interpolation filter oversampling settings */
#define UDA1380_REG20_DECVOL	  0x20 /* Decimator volume control                                               */
#define UDA1380_REG21_PGA		  0x21 /* PGA settings and mute                                                  */
#define UDA1380_REG22_ADC		  0x22 /* ADC settings                                                           */
#define UDA1380_REG23_AGC		  0x23 /* AGC settings                                                           */
#define UDA1380_REG7F_SW_RESET    0x7F /* Restore L3-default values                                              */
#endif

/* Register map of control settings (write) */
typedef enum
{
	UDA1380_REG00_EVALCLK = 0x00, /* Evaluation modes, WSPLL settings, clock divider and clock selectors    */
	UDA1380_REG01_I2S,            /* I2S-bus I/O settings                                                   */
	UDA1380_REG02_PWRCTRL,        /* Power control settings                                                 */
	UDA1380_REG03_ANAMIX,         /* Analog mixer settings                                                  */
	UDA1380_REG04_HEADAMP,        /* Headphone amplifier settings                                           */
	UDA1380_REG10_MSTRVOL = 0x10, /* Master volume control                                                  */
	UDA1380_REG11_MIXVOL,         /* Mixer volume control                                                   */
	UDA1380_REG12_MODEBBT,        /* Mode selection, left and right bass boost, and treble settings         */
	UDA1380_REG13_MSTRMUTE,       /* Master mute, channel 1 and channel 2 de-emphasis and channel mute      */
	UDA1380_REG14_MIXSDO,         /* Mixer, silence detector and interpolation filter oversampling settings */
	UDA1380_REG20_DECVOL =  0x20, /* Decimator volume control                                               */
	UDA1380_REG21_PGA,            /* PGA settings and mute                                                  */
	UDA1380_REG22_ADC,            /* ADC settings                                                           */
	UDA1380_REG23_AGC,            /* AGC settings                                                           */
	UDA1380_REG7F_SW_RESET = 0x7F /* Restore L3-default values                                              */
} UDA1380_Registers;


/* Register map of status bits (read-out) */
#define UDA1380_REG18_HEADPHONE   0x18 /* Interpolation filter status */
#define UDA1380_REG28_DEC 		  0x28 /* Decimator status            */

/* Evaluation modes and clock settings*/
#define REG00_EV(x)	 		(x << 13)
#define REG00_EN_ADC 		(1 << 11)
#define REG00_EN_DEC 		(1 << 10)
#define REG00_EN_DAC 		(1 << 9)
#define REG00_EN_INT 		(1 << 8)
#define REG00_ADC_CLK 		(1 << 5)
#define REG00_DAC_CLK		(1 << 4)
#define REG00_SYS_DIV_768Fs	(3 << 2)
#define REG00_SYS_DIV_512Fs	(2 << 2)
#define REG00_SYS_DIV_384Fs	(1 << 2)
#define REG00_SYS_DIV_256Fs	(0 << 2)
#define REG00_PLL_50_TO_100        3
#define REG00_PLL_25_TO_50         2
#define REG00_PLL_12_5_TO_25       1
#define REG00_PLL_6_25_TO_12_25    0

/* I2S-bus input and output settings */
#define REG01_SFORI_I2S_BUS			(0 << 8)
#define REG01_SFORI_LSB_JUSTIFIED_16BIT	(1 << 8)
#define REG01_SFORI_LSB_JUSTIFIED_18BIT	(2 << 8)
#define REG01_SFORI_LSB_JUSTIFIED_20BIT	(3 << 8)
#define REG01_SFORI_MSB_JUSTIFIED		(5 << 8)
#define REG01_SFORO_I2S_BUS				0
#define REG01_SFORO_LSB_JUSTIFIED_16BIT	1
#define REG01_SFORO_LSB_JUSTIFIED_18BIT	2
#define REG01_SFORO_LSB_JUSTIFIED_20BIT	3
#define REG01_SFORO_MSB_JUSTIFIED		5
#define REG01_SEL_SOURCE_DOUT_DECIMATOR (0 << 6)
#define REG01_SEL_SOURCE_DOUT_MIXER		(1 << 6)
#define REG01_SIM_INTERFACE_SLAVE		(0 << 4)
#define REG01_SIM_INTERFACE_MASTER		(1 << 4)

/* Power control settings */
#define REG02_PON_PLL   (1 << 15)
#define REG02_PON_HP	(1 << 13)
#define REG02_PON_DAC	(1 << 10)
#define REG02_PON_BIAS 	(1 << 8)
#define REG02_EN_AVC 	(1 << 7)
#define REG02_PON_AVC 	(1 << 6)
#define REG02_PON_LNA 	(1 << 4)
#define REG02_PON_PGAL 	(1 << 3)
#define REG02_PON_ADCL 	(1 << 2)
#define REG02_PON_PGAR 	(1 << 1)
#define REG02_PON_ADCR 	(1 << 0)

/* ADC settings */
#define REG22_ADC_ADCPOL_INV(value)	(value << 12)
#define REG22_VGA_CTRL(value)			((value & 0xF) << 8)
#define REG22_SEL_LNA_ENABLE			(1 << 3)
#define REG22_SEL_MIC_ENABLE			(1 << 2)
#define REG22_SKIP_DCFIL				(1 << 1)
#define REG22_EN_DCFIL                  (1 << 0)

#define ADC_L_LINE_IN   0
#define ADC_L_SEL_MIC   1

#define MULTIPLEXER_ADC_R 0
#define MULTIPLEXER_ADC_L 1  /*  */

void UDA1380_vfAudioInit(void);
//void UDA1380_I2S_IRQHandler(void);

extern int UDA1380_EnableAudioOut(int32_t enable);
extern int UDA1380_EnableAudioIn(int32_t enable);
extern void UDA1380_CodecInit(void);

#endif /* UDA1380_H_ */
