/***********************************************************************
 * $Id: spifi_rom_api.c 6475 2011-02-16 19:09:07Z nxp27266 $
 *
 * Project: LPC18xx Rev '-' SPIFI Example
 *
 * Description: SPIFI example project.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/   
#include "spifi_rom_api.h"

#define BOOTROM_BASE		0x10000000
#define SPIFI_API_TABLE_OFFSET	0x00405C78

static unsigned long *BOOTROM_API_TABLE = (unsigned long *)(BOOTROM_BASE + SPIFI_API_TABLE_OFFSET);

int (* ROM_spifi_init)(SPIFIobj *obj, unsigned clksel, unsigned clkdiv, int clkFast,
				unsigned csHigh, int mode3, unsigned timeout, unsigned dummies);
int (* spifi_program)(SPIFIobj *obj, char *source, char *dest,	unsigned length,
                  char *scratch, int protect, int force_erase);
int (* spifi_erase)(SPIFIobj *obj, char *start, unsigned length, char *scratch,
				 int protect);

int spifi_init(SPIFIobj *obj, unsigned clksel, unsigned clkdiv, int minimal,
				unsigned csHigh, int mode3, unsigned timeout, unsigned dummies)
{
	ROM_spifi_init	= (int (*)(SPIFIobj *, unsigned , unsigned , int, unsigned , int, unsigned , unsigned ))BOOTROM_API_TABLE[0];
	spifi_program	= (int (*)(SPIFIobj *, char *, char *, unsigned, char *, int, int))BOOTROM_API_TABLE[3];
	spifi_erase		= (int (*)(SPIFIobj *, char *, unsigned , char *, int))BOOTROM_API_TABLE[4];

	return ROM_spifi_init(obj, clksel, clkdiv, minimal, csHigh, mode3, timeout, dummies);
}
