/***********************************************************************
 * $Id:: printf.c 7005 2011-03-28 19:57:41Z nxp28548                   $
 *
 *     Copyright (C) 2010 NXP Semiconductors.
 *
 * Description:
 *     This implements printf (using UART0) and snprintf with the
 *     library project "lib_small_printf_m0". No support for
 *     floating point is included.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/
#include "small_printf.h"
#include "LPC122x.h"
#include "uart.h"

#ifndef PRINTF_UART	//Default to 0, allow project settings to overwrite
#define PRINTF_UART 0
#endif

static int putcharUART0 (char c)
{
	/* THRE status, contain valid data */
#if (0==PRINTF_UART)
	while ( !(LPC_UART0->LSR & LSR_THRE) );
	LPC_UART0->THR = c;
#else
	while ( !(LPC_UART1->LSR & LSR_THRE) );
	LPC_UART1->THR = c;
#endif
	return 0;
}

int printf(const char *format, ...)
{
	va_list args;
	va_start( args, format );
	return func_printf_nofloat (putcharUART0, format, args);
}

int snprintf(char *buffer, int buffer_length, const char *format, ...)
{
    va_list args;
    va_start( args, format );
    nsprintf_write_init(buffer, buffer_length);
    return printf_format(nsprintf_write, format, args);
}
