/****************************************************************************
 *   $Id:: clkconfig.h 6782 2011-03-11 21:53:54Z nxp28548                   $
 *   Project: NXP LPC122x software example
 *
 *   Description:
 *     This file contains definition and prototype for clock configuration.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#ifndef __CLKCONFIG_H 
#define __CLKCONFIG_H

typedef enum{
	WDT_IRC = 0,
	WDT_WDO = 1
}CLK_SOURCE_WDOSC;

typedef enum{
	MAIN_IRC = 0,
	MAIN_IRC_PLL = 1,	/* @24MHz */
	MAIN_SYSOSC = 2,
	MAIN_SYSOSC_PLL = 3,/* @24MHz */
	MAIN_WDO = 4
}CLK_SOURCE_MAINCLK;

typedef enum{
	CLKOUT_IRC = 0,
	CLKOUT_SYSOSC = 1,
	CLKOUT_WDO = 2,
	CLKOUT_MAIN = 3
}CLK_SOURCE_CLKOUT;

#define PWR_MASK_PLL (1<<7)
#define PWR_MASK_WDO (1<<6)
#define PWR_MASK_SYSOSC (1<<5)
#define PWR_MASK_IRC (1<<1)
#define PWR_MASK_IRCOUT (1<<0)

void Setup_WDOsc ( const uint32_t clksrc, const uint32_t oscdiv, const uint32_t freqsel );
void Setup_CLKOUT ( const uint32_t clksrc, const uint32_t divider );
void Setup_SystemCoreClock (const CLK_SOURCE_MAINCLK sel);
#endif /* end __CLKCONFIG_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
