/****************************************************************************
 *   $Id:: ezh.c 3742 2010-06-25 19:12:05Z usb00423                         $
 *   Project: NXP LPC122x EZH example
 *
 *   Description:
 *     This file contains EZH code APIs
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "lpc122x.h"

/*****************************************************************************
** Function name:		ezh_start
**
** Descriptions:		Start the EZH engine
**
** parameters:			pointer to the function
** Returned value:		None
** 
*****************************************************************************/
void ezh_start(uint32_t *function) 
{
  LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 18);			 // Enable Clock for EZH module
  LPC_SYSCON->EZHBOOT = (unsigned int)function;		 // Assign Start of Code
  LPC_SYSCON->EZHCTRL = 0xC0DE0001;					 // Start Execution
  return;
}
