/****************************************************************************
 *   $Id:: nmi.h 3964 2010-07-27 18:54:02Z usb00423                         $
 *   Project: NXP LPC122x NMI software example
 *
 *   Description:
 *     This file contains definition and prototype for NMI interrupt.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#ifndef __NMI_H 
#define __NMI_H

#define NMI_ENABLED          0

#define MAX_NMI_NUM          32

/* NMI interrupt source */
#define I2C_NMI              0
#define TMR16_0_NMI          1
#define TMR16_1_NMI          2
#define TMR32_0_NMI          3
#define TMR32_1_NMI          4
#define SSP_NMI              5
#define UART0_NMI            6
#define UART1_NMI            7
#define COMP_NMI             8
#define ADC_NMI              9
#define WDT_NMI              10
#define BOD_NMI              11
#define FLASH_NMI            12
#define PIO0_NMI             13
#define PIO1_NMI             14
#define PIO2_NMI             15
#define PMU_NMI              16
#define DMA_NMI              17
#define RTC_NMI              18
#define EZH_NMI              19
#define EZH20_NMI            20
#define EZH21_NMI            21
#define EZH22_NMI            22
#define EZH23_NMI            23

void NMI_Init( uint32_t NMI_num );
void NMI_Handler(void);
#endif /* end __NMI_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
