/****************************************************************************
*   $Id:: LPC_ROM_DIV.c 6753 2011-03-08 20:02:17Z nxp28548         $        *
*   Project: Division API Example					    *
*									    *
*   Description:							    *
*			This project demonstrates LPC122x ROM based Division*
*
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
/* LPC12xx Peripheral Registers */
#include "LPC122x.h"
#include "LPC_ROM_DIV.h"

/*****************************************************************************
These are the stock signatures from ARM for EABI division

int __aeabi_idiv(int numerator, int denominator); 
unsigned __aeabi_uidiv(unsigned numerator, unsigned denominator); 
typedef struct { int quot, int rem; } idiv_return; 

typedef struct { unsigned quot, unsigned rem; } uidiv_return; 
__value_in_regs idiv_return __aeabi_idivmod(int numerator, int denominator); 
__value_in_regs uidiv_return __aeabi_uidivmod(unsigned numerator, unsigned denominator);
******************************************************************************/
__no_init static LPC_ROM_DIV_STRUCT buffer;
static LPC_ROM_DIV_STRUCT const *const pROMDiv = &buffer;

void ROM_Divide_Init(void)
{
  if ( (LPC_SYSCON->DEVICE_ID & 0xF0000000UL)>>28 <2)
  {
    while(1); //Trap Error on prototype devices (without ROM Division)
  }
  
  LPC_ROM_DIV_STRUCT* pTable = *((LPC_ROM_DIV_STRUCT**) LPC_122x_DIVROM_LOC);
  buffer.sidiv = pTable->sidiv;
  buffer.uidiv = pTable->uidiv;
  buffer.sidivmod = pTable->sidivmod;
  buffer.uidivmod = pTable->uidivmod;
}

int __aeabi_idiv(int numerator, int denominator)
{	   
  return ( pROMDiv->sidiv(numerator,denominator) );
}

unsigned __aeabi_uidiv(unsigned numerator, unsigned denominator)
{
  return ( pROMDiv->uidiv(numerator,denominator) );
}

__value_in_regs idiv_return __aeabi_idivmod(int numerator, int denominator)
{
  return pROMDiv->sidivmod(numerator,denominator);	
}

__value_in_regs uidiv_return __aeabi_uidivmod(unsigned numerator, unsigned denominator)
{
  return pROMDiv->uidivmod(numerator,denominator);
}
