/***********************************************************************
 * $Id$
 * Project:	
 * File:	
 * Description:
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/
#include <LPC17xx.h>
#include <stdint.h>
#include <stdio.h>
#include <math.h>

#include "config.h"
#include "adc.h"
#include "uart.h"

uint32_t au32Result[ADC_NBR_OCCUR];
uint32_t refvalue;

uint32_t lower = 0;
uint32_t higher = 0;

char temp[100];
char len;

void display_graph(void){
  uint32_t max, i, j, po;

  /* Search for Maximum value  */
  max = au32Result[0];
  for (i=1; i<ADC_NBR_OCCUR; i++){
     if (au32Result[i] > max)
	   max = au32Result[i];
  }

  len = sprintf(temp, "\r\nADC Results Graph: %d samples\r\n\n", ADC_NBR_SAMPLES);  
  UARTSend( 1, (uint8_t *)temp, len);

  len = sprintf(temp,"     (Occurrences vs Sampled Values) \r\n");  
  UARTSend( 1, (uint8_t *)temp, len);

  for (i=0; i<ADC_NBR_OCCUR; i++){
    UARTSend( 1, (uint8_t *)"  ", 2);
  }
  UARTSend( 1, (uint8_t *)"Occurrences\r\n", 13);

  for (i=0; i<10; i++){
	for (j = ADC_NBR_OCCUR-1; j >= ADC_NBR_OCCUR/2 ; j--) {
	  if (au32Result[j] < (max-(i*max/10)))
	    len = sprintf(temp, "%c ", ' ');
	  else
	    len = sprintf(temp, "%c ", 219); 
	  UARTSend( 1, (uint8_t *)temp, len);
	}
	for (j = 0; j < ADC_NBR_OCCUR/2 ; j++) {
	  if (au32Result[j] < (max-(i*max/10)))
	    len = sprintf(temp, "%c ", ' ');
	  else							  
	    len = sprintf(temp, "%c ", 219);	
	  UARTSend( 1, (uint8_t *)temp, len);
	}    
	len = sprintf(temp, "%c %d\r\n", 195, (max-(i*max/10))/10*10);
	UARTSend( 1, (uint8_t *)temp, len);
  }
  for (i=0; i<ADC_NBR_OCCUR; i++){
    UARTSend( 1, (uint8_t *)"--", 2);
  } 
  UARTSend( 1, (uint8_t *)"\r\n", 2);
  /* display the X-axis   */
  for (i=0; i<4; i++){
    for (j = ADC_NBR_OCCUR-1; j >= ADC_NBR_OCCUR/2 ; j--) {
	  po = pow(10,(3-i+1));
	  max = ((refvalue-(j-(ADC_NBR_OCCUR/2)+1)) % po) / pow(10,(3-i));		 
	  len = sprintf(temp, "%d ", max);
	  UARTSend( 1, (uint8_t *)temp, len);
	}
	for (j = 0; j < ADC_NBR_OCCUR/2 ; j++) {
	  po = pow(10,(3-i+1));
	  max = ((refvalue+j) % po) / pow(10,(3-i));
	  len = sprintf(temp, "%d ", max);
	  UARTSend( 1, (uint8_t *)temp, len);
	}
	UARTSend( 1, (uint8_t *)"\r\n", 2);
  }
  UARTSend( 1, (uint8_t *)"Sampled Values -->\r\n", 20);
}

void display_table(void) {
  uint32_t j;

  len = sprintf(temp, "Test Results (%d Samples)\r\n",ADC_NBR_SAMPLES);
  UARTSend( 1, (uint8_t *)temp, len);
#if EXPORT_EXCEL == 0
  UARTSend( 1, (uint8_t *)"\r\nValue - Occurrencies\r\n", 26);  
#endif

  for (j = ADC_NBR_OCCUR-1; j >= ADC_NBR_OCCUR/2 ; j--) {
#if EXPORT_EXCEL == 0
    if (au32Result[j] == 0)
	  continue;
#endif
#if EXPORT_EXCEL
    len = sprintf(temp, "%d,%d\r\n", (refvalue-(j-(ADC_NBR_OCCUR/2)+1)), au32Result[j]);
#else
	len = sprintf(temp, "%d  -  %d\r\n", (refvalue-(j-(ADC_NBR_OCCUR/2)+1)), au32Result[j]);
#endif
	UARTSend( 1, (uint8_t *)temp, len);
  }
  for (j = 0; j < ADC_NBR_OCCUR/2 ; j++) {
#if EXPORT_EXCEL == 0
    if (au32Result[j] == 0)
	  continue;
#endif
#if EXPORT_EXCEL
    len = sprintf(temp, "%d,%d\r\n", (refvalue+j), au32Result[j]);
#else
	len = sprintf(temp, "%d  -  %d\r\n", (refvalue+j), au32Result[j]);
#endif
	UARTSend( 1, (uint8_t *)temp, len);
  }
  if (lower>0 || higher>0){
	UARTSend( 1, (uint8_t *)"\r\nOut of Range values:\r\n", 24);
	if (lower>0){
#if EXPORT_EXCEL
	  len = sprintf(temp, "Lower limit,%d\r\n", lower);
#else
	  len = sprintf(temp, "Lower limit: %d\r\n", lower);
#endif
	  UARTSend( 1, (uint8_t *)temp, len);
	}
	if (higher>0){
#if EXPORT_EXCEL
	  len = sprintf(temp, "Higher limit,%d\r\n", higher);
#else
	  len = sprintf(temp, "Higher limit: %d\r\n", higher);
#endif
	  UARTSend( 1, (uint8_t *)temp, len);
	}
  }
}



int main(void)
{    	
	uint32_t i, value;
	int32_t diff;

	SystemInit(); 

	/* Initialize UART used to output test data */
	(void)UARTInit( 1, 9600);

	/* Initialize ADC */
	vADC_Init();

	UARTSend( 1, (uint8_t *)"\r\nLPC176x ADC Demo board test program\r\n", 39);

	/* Now start a conversion */
	LPC_ADC->ADCR |= (1UL << 24);
	
	for (i = 0; i < ADC_NBR_SAMPLES; i++)
	{
		while ((LPC_ADC->ADGDR & 0x80000000UL) == 0);   	/* Bit 31 is the done bit, set to 1 when conversion is complete */
		value = (LPC_ADC->ADGDR >> 4);
		value &= 0x00000FFFUL;

		if (i==0) {
		  refvalue = value;
		  au32Result[0]++;
		}else {
          diff = value - refvalue;
		  if (diff < 0){
		    if ((diff * -1) > (ADC_NBR_OCCUR/2))
			  lower++;
			else 
		      au32Result[(ADC_NBR_OCCUR/2)-1-diff]++;
		  }else{
		    if (diff > ((ADC_NBR_OCCUR/2)-1))
			  higher++;
			else
		  	  au32Result[diff]++;	
		  }
		}

		/* Now start the next conversion */
		LPC_ADC->ADCR |= (1UL << 24);
	}
	display_table();
#if EXPORT_EXCEL == 0
    display_graph();
#endif
    while(1);
}

