/***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/
#include "adc.h"
#include "lpc17xx.h"
#include "config.h"

/***********************************************************************
 * Intialise the ADC
 **********************************************************************/
void vADC_Init(void)
{
	uint32_t u32PCLKDIV, u32PCLK,i;

	/* Enable POWER and CLOCK for ADC controller */
  	LPC_SC->PCONP |= (1 << 12);

	/* Configure Pin Connect for ADC pin   */
	switch (ADCChannel)
	{
	 	case 0:
	  		LPC_PINCON->PINSEL1 |= (1U<<14);
			break;
	 	case 1:
	  		LPC_PINCON->PINSEL1 |= (1U<<16);
			break;
	 	case 2:
	  		LPC_PINCON->PINSEL1 |= (1U<<18);
			break;
	 	case 3:
	  		LPC_PINCON->PINSEL1 |= (1U<<20);
			break;
	 	case 4:
	  		LPC_PINCON->PINSEL3 |= (3U<<28);
			break;
	 	case 5:
	  		LPC_PINCON->PINSEL3 |= (3U<<30);
			break;
	 	case 6:
	  		LPC_PINCON->PINSEL0 |= (2U<<6);
			break;
	 	case 7:
	  		LPC_PINCON->PINSEL0 |= (2U<<4);
			break;
	}
	/* After configuring PINSEL, ADC needs a delay before starting sampling (Otherwise, higher values will be read)  */
	for (i = 0; i < 5000000; i++);

	/* Read value of peripheral clock divider and then use this value
	   to calculate clock frequency to ADC */	
  	u32PCLKDIV = (LPC_SC->PCLKSEL0 >> 6) & 0x03;
  	
	switch ( u32PCLKDIV )
  	{
		case 0x00:
		default:
	  		u32PCLK = SystemFrequency/4;
			break;
		case 0x01:
	  		u32PCLK = SystemFrequency;
			break; 
		case 0x02:
	  		u32PCLK = SystemFrequency/2;
			break; 
		case 0x03:
	  		u32PCLK = SystemFrequency/8;
			break;
  	}

	/* Configure ADC */
	LPC_ADC->ADCR = ( 1 << ADCChannel ) | 	/* Select the Channel */		
					( ( u32PCLK  / ADC_CLK - 1 ) << 8 ) |  /* CLKDIV = Fpclk / ADC_Clk - 1 */ 
					( 0 << 16 ) | 		/* BURST = 0, no BURST, software controlled */
					( 0 << 17 ) |  		/* CLKS = 0, 11 clocks/10 bits */
					( 1 << 21 ) |		/* PDN = 1, normal operation */
					( 0 << 24 ) |  		/* START = 0 A/D conversion stops */					
					( 0 << 27 );		/* EDGE = 0 (CAP/MAT singal falling,trigger A/D conversion) */ 

}


/******************************************************************************
**                            End Of File
******************************************************************************/
