/*****************************************************************************
 *  flashoff.c:  PMU module API file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2008.11.28  ver 1.00    Prelimnary version, first Release
 *
*****************************************************************************/
#include "LPC29xx.h"					/* LPC29xx definitions */
#include "flashoff.h"


/*****************************************************************************
** Function name:		sleepFlashOff
**
** Descriptions:		Disable Flash memory controller and set PwerDown bit 
**                      in PMU register to go to sleep. 
**                      This code needs to be place in TCM
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/

void sleepFlashOff( void )
{
    // Disable flash (Power Down)
    FCTR |=0x200;
	  
    // Switch selected clocks off (resumed at event)
    // At the moment the PMU powerdown bit is set all clocks with wakeup 
    // enable are stopped. The PD bit will be cleared by a wakeup event.
    PMU_PM =0x1;

    // Re-enable flash. This is the first instruction executed after the wakeup event.
    FCTR &=~0x200;

	return;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
