/*****************************************************************************
 *   extint.c:  Event router for external interrupt C file for NXP LPC29xx 
 *   Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.07.20  ver 1.00    Prelimnary version, first Release
 *
*****************************************************************************/
#include "LPC29xx.h"                        /* LPC29xx definitions */
#include "type.h"
#include "irq.h"
#include "target.h"
#include "extint.h"

volatile DWORD eint_flag = 0;

/*****************************************************************************
** Function name:		EventRouter_Handler
**
** Descriptions:		Event Router handler for External Interrupts
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
void EventRouter_Handler(void)
{
  DWORD regVal;
  /* either EXTINT4 or EXTINT5 buttons are pressed,
  an interrupt will be triggered to the event router. */
  regVal = ER_PEND;
  if ( regVal & (0x01<<EXINT_sleep) )
  {
	eint_flag=(1<<EXINT_sleep);
	ER_INT_CLR |= (0x01<<EXINT_sleep);
  }

  if ( regVal & (0x01 <<EXINT_wake) )
  {
	eint_flag=(1<<EXINT_wake);
	ER_INT_CLR |= (0x01<<EXINT_wake);
  }
  return;
}

/*****************************************************************************
** Function name:		EventRouter_Init
**
** Descriptions:		Initialize event router for external interrupt, 
**						install the event router interrupt handler
**
** parameters:			None
** Returned value:		None
** 
*****************************************************************************/
void EventRouter_Init( void )
{
  /* EINT4 and EINT5 are edge trigger, rising edge. */
  ER_APR = (0x01<<EXINT_sleep)|(0x01<<EXINT_wake);
  ER_ATR = (0x01<<EXINT_sleep)|(0x01<<EXINT_wake);

  /* P1.31 and P1.30 are configured as EXTINT4 and EXTINT5. */
#if ((EXINT_sleep == 0) || (EXINT_wake == 0))
  SFSP1_0 = (0x01<<2)|(0x01<<0);	/* Digital no PU and PD, func. 1. */
#endif
#if ((EXINT_sleep == 1) || (EXINT_wake == 1))
  SFSP1_1 = (0x01<<2)|(0x01<<0);	/* Digital no PU and PD, func. 1. */
#endif
#if ((EXINT_sleep == 2) || (EXINT_wake == 2))
  SFSP1_12 = (0x01<<2)|(0x01<<0);	/* Digital no PU and PD, func. 1. */
#endif
#if ((EXINT_sleep == 3) || (EXINT_wake == 3))
  SFSP1_13 = (0x01<<2)|(0x01<<0);	/* Digital no PU and PD, func. 1. */
#endif
#if ((EXINT_sleep == 4) || (EXINT_wake == 4))
  SFSP1_30 = (0x01<<2)|(0x03<<0);	/* Digital no PU and PD, func. 3. */
#endif
#if ((EXINT_sleep == 5) || (EXINT_wake == 5))
  SFSP1_31 = (0x01<<2)|(0x03<<0);	/* Digital no PU and PD, func. 3. */
#endif
#if ((EXINT_sleep == 6) || (EXINT_wake == 6))
  SFSP2_26 = (0x01<<2)|(0x03<<0);	/* Digital no PU and PD, func. 3. */
#endif
#if ((EXINT_sleep == 7) || (EXINT_wake == 7))
  SFSP2_27 = (0x01<<2)|(0x03<<0);	/* Digital no PU and PD, func. 3. */
#endif
  

  ER_INT_CLR = 0x3FFFFFF;
  ER_MASK_CLR = 0x3FFFFFF;

  install_irq( EVT_INT, (void *)EventRouter_Handler, HIGHEST_PRIORITY );
  EnableIntReq_IRQ( EVT_INT, ACTIVE_HIGH, HIGHEST_PRIORITY );
  ER_MASK_SET |= ((0x01<<EXINT_sleep)|(0x01<<EXINT_wake));	/* Enable interrupt on EINT1 and EINT1 */    
  return;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
