;/*****************************************************************************
;*   vicopy.s:  Interrupt vector copy file for Philips Family Microprocessors
;*
;*   Copyright(C) 2007, NXP Semiconductor
;*   All rights reserved.
;*
;*   History
;*   2007.09.01  ver 1.00    Prelimnary version, first Release
;*
;*****************************************************************************/

	PRESERVE8

VECTOR_RAM_SRC		EQU		0x80000000
VECTOR_FLASH_SRC	EQU		0x20000000
VECTOR_DST			EQU		0x00000000

	EXPORT VectorRemap
	AREA BlockCopy, CODE, READONLY      ; name this block of code

VectorRemap
	STMFD   sp!, {r0, r1, r4-r11}	; save registers
    IF :DEF: REMAP_RAM
	LDR     r0, =VECTOR_RAM_SRC
    ELSE
	LDR     r0, =VECTOR_FLASH_SRC	; r0 = pointer to source block
    ENDIF
	LDR     r1, =VECTOR_DST			; r1 = pointer to destination block      
	LDMIA   r0!, {r4-r11}			; remap first 16 words from 0x20000000
	STMIA   r1!, {r4-r11}			; to address 0x00000000 for interrupt
	LDMIA   r0!, {r4-r11}			; exception handler
	STMIA   r1!, {r4-r11}  
	LDMFD   sp!, {r0, r1, r4-r11}	; restore registers

	END

