/*****************************************************************************
 *   target.c:  Target C file for Philips LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.09.01  ver 1.00    Prelimnary version, first Release
 *
*****************************************************************************/
#include "LPC29xx.h"
#include "type.h"
#include "irq.h"
#include "target.h"

void Release_Security(void)
{ 
    SEC_DIS = 1;	// Seting this bit will diable security
    // normally enabled by the flash index sector
    return;
}

/******************************************************************************
** Function name:	TargetResetInit
**
** Descriptions:	Initialize the target board before running the main()
**					function; User may change it as needed, but may not
**					deleted it.
**
** parameters:		None
** Returned value:	None
**
******************************************************************************/
void TargetResetInit(void)
{
    CGU_OSC_CTRL = (0x1<<2) | (0x1<<0);		// (re-)enable the osc
    while ( !(CGU_RDET & XTAL_PRESENT) ){NOP;}   // wait for osc to start up

    /* Disable all interrupts */
    init_VIC();

    FCTR = FS_DCR | FS_CS;
    FBWST = SPECALWAYS | 0x04;

    /* sys clk config, source is Xtal - 10MHz on Keil MCB2900 */
    SYS_CLK_CONF = CLK_SEL_XTAL | AUTOBLK;

    /* PLL, 3-phase output control enable, and power down PLL. */
    CGU_PLL_CTRL = PLL_PD;
    /* PLL, MSEL=16, 3-phase output control enable, PLL normal operation. */
    CGU_PLL_CTRL = PLL_XTAL_SEL | (PLL_M_VALUE<<MSEL_SHIFT) | P23EN;
                             
    /* Check lock bit, if unlocked, PLL_LOCK is always 0 */
    while ( !(CGU_PLL_STAT & PLL_LOCK) ){NOP;}
    /* Check clock detection register to make sure PLL is present now. */
    while ( !(CGU_RDET & PLL_PRESENT) ){NOP;}

    /* PLL is 240Mhz, SYS_CLK and TMR_CLK is 120Mhz */
    SYS_CLK_CONF = CLK_SEL_PLL | AUTOBLK | DIV2;    // 120MHz
    IVNSS_CLK_CONF = CLK_SEL_PLL | AUTOBLK | DIV2;  // 120MHz
    MSCSS_CLK_CONF = CLK_SEL_PLL | AUTOBLK | DIV2;  // 120MHz
    UART_CLK_CONF = CLK_SEL_PLL | AUTOBLK | DIV2;   // 120MHz
    TMR_CLK_CONF = CLK_SEL_PLL | AUTOBLK | DIV2;    // 120MHz
    SPI_CLK_CONF = CLK_SEL_XTAL | AUTOBLK | DIV2;   // 8MHz
    ADC_CLK_CONF = CLK_SEL_XTAL | AUTOBLK | DIV4;   // 4MHz

    return;
}
/******************************************************************************
**                            End Of File
******************************************************************************/
