/*****************************************************************************
 *   target.h:  Header file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.09.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __TARGET_H 
#define __TARGET_H

#ifdef __cplusplus
   extern "C" {
#endif

/* The ring osc is 400Khz. */ 
#define RING_OSC	475000 

/* The CCO clock is 240Mhz, the Post divider is 2. So, the 
CPU_CLK is Clk_CCO/P = 120Mhz */
#define PLL_M_VALUE		24-1	/* OSC is 10Mhz, multiplier is 24 */
#define CPU_CLK		120000000

/* Below PERIPH_CLK can be configured in different frequencies for 
different peripherals. This clock is used for TIMER block only. */
#define PERIPH_CLK	120000000

#define IRAM0_BASE_ADDR	0x80000000
#define IRAM0_SIZE	0x8000
#define IRAM1_BASE_ADDR	0x80008000
#define IRAM1_SIZE	0x4000


extern void TargetResetInit( void );

#ifdef __cplusplus
   }
#endif
 
#endif /* end __TARGET_H */
/******************************************************************************
**                            End Of File
******************************************************************************/
