/*****************************************************************************
 *   lpc29xx.h:  Master Header file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.09.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __LPC29XX_H
#define __LPC29XX_H

#define NOP __asm{ NOP }

#define LPC2917 17
#define LPC2917 17
#define LPC2917 17
#define LPC2917 17
#define LPC2917 17
#define LPC2917 17

/* Embedded flash memory controller */
#define FMC_BASE_ADDR        0x20200000
#define FCTR                 (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x000))
#define   FS_LOADREQ         (1 << 15)
#define   FS_CACHECLR        (1 << 14)
#define   FS_CACHEBYP        (1 << 13)
#define   FS_PROGREQ         (1 << 12)
#define   FS_RLS             (1 << 11)
#define   FS_PDL             (1 << 10)
#define   FS_PD              (1 <<  9)
#define   FS_WPB             (1 <<  7)
#define   FS_ISS             (1 <<  6)
#define   FS_RLD             (1 <<  5)
#define   FS_DCR             (1 <<  4)
#define   FS_WEB             (1 <<  2)
#define   FS_WRE             (1 <<  1)
#define   FS_CS              (1 <<  0)
#define FPTR                 (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x008))
#define FTCTR                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x00C))
#define FBWST                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x010))
#define   CACHE2EN           0x8000
#define   SPECALWAYS         0x4000
#define   WST4               4
#define FCRA                 (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x01C))

#define FMSSTART             (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x020))
#define FMSSTOP              (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x024))
#define   MISR_START         (1 << 17)

#define FMS16                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x028))

#define FMSW0                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x02C))
#define FMSW1                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x030))
#define FMSW2                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x034))
#define FMSW3                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x038))
// EEPROM registers
#define EECMD                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x080))
#define EEADDR                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x084))
#define EEWDATA                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x088))
#define EERDATA                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x08C))
#define EEWSTATE                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x090))
#define EECLKDIV                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x094))
#define EEPWRDWN                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x098))
#define EESSTART                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x09C))
#define EEMSSTOP                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x0A0))
#define EEMSSIG                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x0A4))
#define POS_DCM_COUNT                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x0A8))
#define NEG_DCM_COUNT                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x0AC))
#define EEDEV1STATUS4                (*(volatile unsigned long *)(FMC_BASE_ADDR + 0x0B0))
// Registers shared by Flash and EEPROM
#define FMC_INT_CLR_ENABLE   (*(volatile unsigned long *)(FMC_BASE_ADDR + 0xFD8))
#define FMC_INT_SET_ENABLE   (*(volatile unsigned long *)(FMC_BASE_ADDR + 0xFDC))
#define FMC_INT_STATUS       (*(volatile unsigned long *)(FMC_BASE_ADDR + 0xFE0))
#define FMC_INT_ENABLE       (*(volatile unsigned long *)(FMC_BASE_ADDR + 0xFE4))
#define FMC_INT_CLR_STATUS   (*(volatile unsigned long *)(FMC_BASE_ADDR + 0xFE8))
#define FMC_INT_SET_STATUS   (*(volatile unsigned long *)(FMC_BASE_ADDR + 0xFEC))


#define FMC_BASE_ADDR1        0x20000000

#define FMC_INX_SECTOR      (*(volatile unsigned long *)(FMC_BASE_ADDR1))	  // MS

#define FMC_INX_SECTOR_11   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xCB0))
#define FMC_INX_SECTOR_12   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xCC0))
#define FMC_INX_SECTOR_13   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xCD0))
#define FMC_INX_SECTOR_14   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xCE0))
#define FMC_INX_SECTOR_15   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xCF0))
#define FMC_INX_SECTOR_16   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xE00))
#define FMC_INX_SECTOR_17   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xE10))
#define FMC_INX_SECTOR_18   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xE20))

#define FMC_INX_SECTOR_0    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC00))
#define FMC_INX_SECTOR_1    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC10))
#define FMC_INX_SECTOR_2    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC20))
#define FMC_INX_SECTOR_3    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC30))
#define FMC_INX_SECTOR_4    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC40))
#define FMC_INX_SECTOR_5    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC50))
#define FMC_INX_SECTOR_6    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC60))
#define FMC_INX_SECTOR_7    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC70))
#define FMC_INX_SECTOR_8    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC80))
#define FMC_INX_SECTOR_9    (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xC90))
#define FMC_INX_SECTOR_10   (*(volatile unsigned long *)(FMC_BASE_ADDR1 + 0xCA0))


/* External static memory address */
#define ESMC_BASE_ADDR       0x40000000

/* External static memory controller */
#define SMC_BASE_ADDR        0x60000000
#define SMC_IDCYR0           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x000))
#define SMC_WST1R0           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x004))
#define SMC_WST2R0           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x008))
#define SMC_WSTOENR0         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x00C))
#define SMC_WSTWENR0         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x010))
#define SMC_CR0              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x014))
#define SMC_SR0              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x018))

#define SMC_IDCYR1           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x01C))
#define SMC_WST1R1           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x020))
#define SMC_WST2R1           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x024))
#define SMC_WSTOENR1         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x028))
#define SMC_WSTWENR1         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x02C))
#define SMC_CR1              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x030))
#define SMC_SR1              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x034))

#define SMC_IDCYR2           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x038))
#define SMC_WST1R2           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x03C))
#define SMC_WST2R2           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x040))
#define SMC_WSTOENR2         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x044))
#define SMC_WSTWENR2         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x048))
#define SMC_CR2              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x04C))
#define SMC_SR2              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x050))

#define SMC_IDCYR3           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x054))
#define SMC_WST1R3           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x058))
#define SMC_WST2R3           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x05C))
#define SMC_WSTOENR3         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x060))
#define SMC_WSTWENR3         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x064))
#define SMC_CR3              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x068))
#define SMC_SR3              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x06C))

#define SMC_IDCYR4           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x070))
#define SMC_WST1R4           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x074))
#define SMC_WST2R4           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x078))
#define SMC_WSTOENR4         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x07C))
#define SMC_WSTWENR4         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x080))
#define SMC_CR4              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x084))
#define SMC_SR4              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x088))

#define SMC_IDCYR5           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x08C))
#define SMC_WST1R5           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x090))
#define SMC_WST2R5           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x094))
#define SMC_WSTOENR5         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x098))
#define SMC_WSTWENR5         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x09C))
#define SMC_CR5              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0A0))
#define SMC_SR5              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0A4))

#define SMC_IDCYR6           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0A8))
#define SMC_WST1R6           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0AC))
#define SMC_WST2R6           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0B0))
#define SMC_WSTOENR6         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0B4))
#define SMC_WSTWENR6         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0B8))
#define SMC_CR6              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0BC))
#define SMC_SR6              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0C0))

#define SMC_IDCYR7           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0C4))
#define SMC_WST1R7           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0C8))
#define SMC_WST2R7           (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0CC))
#define SMC_WSTOENR7         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0D0))
#define SMC_WSTWENR7         (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0D4))
#define SMC_CR7              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0D8))
#define SMC_SR7              (*(volatile unsigned long *)(SMC_BASE_ADDR + 0x0DC))

/* Chip/Feature ID register */
#define CFID_BASE_ADDR       0xE0000000
#define CFID_CHIPID          (*(volatile unsigned long *)(CFID_BASE_ADDR + 0x000))
#define CFID_FEAT0           (*(volatile unsigned long *)(CFID_BASE_ADDR + 0x100))
#define CFID_FEAT1           (*(volatile unsigned long *)(CFID_BASE_ADDR + 0x104))
#define CFID_FEAT2           (*(volatile unsigned long *)(CFID_BASE_ADDR + 0x108))
#define CFID_FEAT3           (*(volatile unsigned long *)(CFID_BASE_ADDR + 0x10c))

/* System Control Unit register */
#define SCU_BASE_ADDR        0xE0001000
#define SFSP0_BASE           (SCU_BASE_ADDR + 0x000)
#define SFSP0_0              (*(volatile unsigned long *)(SFSP0_BASE + 0x00))
#define SFSP0_1              (*(volatile unsigned long *)(SFSP0_BASE + 0x04))
#define SFSP0_2              (*(volatile unsigned long *)(SFSP0_BASE + 0x08))
#define SFSP0_3              (*(volatile unsigned long *)(SFSP0_BASE + 0x0C))
#define SFSP0_4              (*(volatile unsigned long *)(SFSP0_BASE + 0x10))
#define SFSP0_5              (*(volatile unsigned long *)(SFSP0_BASE + 0x14))
#define SFSP0_6              (*(volatile unsigned long *)(SFSP0_BASE + 0x18))
#define SFSP0_7              (*(volatile unsigned long *)(SFSP0_BASE + 0x1C))
#define SFSP0_8              (*(volatile unsigned long *)(SFSP0_BASE + 0x20))
#define SFSP0_9              (*(volatile unsigned long *)(SFSP0_BASE + 0x24))
#define SFSP0_10             (*(volatile unsigned long *)(SFSP0_BASE + 0x28))
#define SFSP0_11             (*(volatile unsigned long *)(SFSP0_BASE + 0x2C))
#define SFSP0_12             (*(volatile unsigned long *)(SFSP0_BASE + 0x30))
#define SFSP0_13             (*(volatile unsigned long *)(SFSP0_BASE + 0x34))
#define SFSP0_14             (*(volatile unsigned long *)(SFSP0_BASE + 0x38))
#define SFSP0_15             (*(volatile unsigned long *)(SFSP0_BASE + 0x3C))
#define SFSP0_16             (*(volatile unsigned long *)(SFSP0_BASE + 0x40))
#define SFSP0_17             (*(volatile unsigned long *)(SFSP0_BASE + 0x44))
#define SFSP0_18             (*(volatile unsigned long *)(SFSP0_BASE + 0x48))
#define SFSP0_19             (*(volatile unsigned long *)(SFSP0_BASE + 0x4C))
#define SFSP0_20             (*(volatile unsigned long *)(SFSP0_BASE + 0x50))
#define SFSP0_21             (*(volatile unsigned long *)(SFSP0_BASE + 0x54))
#define SFSP0_22             (*(volatile unsigned long *)(SFSP0_BASE + 0x58))
#define SFSP0_23             (*(volatile unsigned long *)(SFSP0_BASE + 0x5C))
#define SFSP0_24             (*(volatile unsigned long *)(SFSP0_BASE + 0x60))
#define SFSP0_25             (*(volatile unsigned long *)(SFSP0_BASE + 0x64))
#define SFSP0_26             (*(volatile unsigned long *)(SFSP0_BASE + 0x68))
#define SFSP0_27             (*(volatile unsigned long *)(SFSP0_BASE + 0x6C))
#define SFSP0_28             (*(volatile unsigned long *)(SFSP0_BASE + 0x70))
#define SFSP0_29             (*(volatile unsigned long *)(SFSP0_BASE + 0x74))
#define SFSP0_30             (*(volatile unsigned long *)(SFSP0_BASE + 0x78))
#define SFSP0_31             (*(volatile unsigned long *)(SFSP0_BASE + 0x7C))

#define SFSP1_BASE           (SCU_BASE_ADDR + 0x100)
#define SFSP1_0              (*(volatile unsigned long *)(SFSP1_BASE + 0x00))
#define SFSP1_1              (*(volatile unsigned long *)(SFSP1_BASE + 0x04))
#define SFSP1_2              (*(volatile unsigned long *)(SFSP1_BASE + 0x08))
#define SFSP1_3              (*(volatile unsigned long *)(SFSP1_BASE + 0x0C))
#define SFSP1_4              (*(volatile unsigned long *)(SFSP1_BASE + 0x10))
#define SFSP1_5              (*(volatile unsigned long *)(SFSP1_BASE + 0x14))
#define SFSP1_6              (*(volatile unsigned long *)(SFSP1_BASE + 0x18))
#define SFSP1_7              (*(volatile unsigned long *)(SFSP1_BASE + 0x1C))
#define SFSP1_8              (*(volatile unsigned long *)(SFSP1_BASE + 0x20))
#define SFSP1_9              (*(volatile unsigned long *)(SFSP1_BASE + 0x24))
#define SFSP1_10             (*(volatile unsigned long *)(SFSP1_BASE + 0x28))
#define SFSP1_11             (*(volatile unsigned long *)(SFSP1_BASE + 0x2C))
#define SFSP1_12             (*(volatile unsigned long *)(SFSP1_BASE + 0x30))
#define SFSP1_13             (*(volatile unsigned long *)(SFSP1_BASE + 0x34))
#define SFSP1_14             (*(volatile unsigned long *)(SFSP1_BASE + 0x38))
#define SFSP1_15             (*(volatile unsigned long *)(SFSP1_BASE + 0x3C))
#define SFSP1_16             (*(volatile unsigned long *)(SFSP1_BASE + 0x40))
#define SFSP1_17             (*(volatile unsigned long *)(SFSP1_BASE + 0x44))
#define SFSP1_18             (*(volatile unsigned long *)(SFSP1_BASE + 0x48))
#define SFSP1_19             (*(volatile unsigned long *)(SFSP1_BASE + 0x4C))
#define SFSP1_20             (*(volatile unsigned long *)(SFSP1_BASE + 0x50))
#define SFSP1_21             (*(volatile unsigned long *)(SFSP1_BASE + 0x54))
#define SFSP1_22             (*(volatile unsigned long *)(SFSP1_BASE + 0x58))
#define SFSP1_23             (*(volatile unsigned long *)(SFSP1_BASE + 0x5C))
#define SFSP1_24             (*(volatile unsigned long *)(SFSP1_BASE + 0x60))
#define SFSP1_25             (*(volatile unsigned long *)(SFSP1_BASE + 0x64))
#define SFSP1_26             (*(volatile unsigned long *)(SFSP1_BASE + 0x68))
#define SFSP1_27             (*(volatile unsigned long *)(SFSP1_BASE + 0x6C))
#define SFSP1_28             (*(volatile unsigned long *)(SFSP1_BASE + 0x70))
#define SFSP1_29             (*(volatile unsigned long *)(SFSP1_BASE + 0x74))
#define SFSP1_30             (*(volatile unsigned long *)(SFSP1_BASE + 0x78))
#define SFSP1_31             (*(volatile unsigned long *)(SFSP1_BASE + 0x7C))

#define SFSP2_BASE           (SCU_BASE_ADDR + 0x200)
#define SFSP2_0              (*(volatile unsigned long *)(SFSP2_BASE + 0x00))
#define SFSP2_1              (*(volatile unsigned long *)(SFSP2_BASE + 0x04))
#define SFSP2_2              (*(volatile unsigned long *)(SFSP2_BASE + 0x08))
#define SFSP2_3              (*(volatile unsigned long *)(SFSP2_BASE + 0x0C))
#define SFSP2_4              (*(volatile unsigned long *)(SFSP2_BASE + 0x10))
#define SFSP2_5              (*(volatile unsigned long *)(SFSP2_BASE + 0x14))
#define SFSP2_6              (*(volatile unsigned long *)(SFSP2_BASE + 0x18))
#define SFSP2_7              (*(volatile unsigned long *)(SFSP2_BASE + 0x1C))
#define SFSP2_8              (*(volatile unsigned long *)(SFSP2_BASE + 0x20))
#define SFSP2_9              (*(volatile unsigned long *)(SFSP2_BASE + 0x24))
#define SFSP2_10             (*(volatile unsigned long *)(SFSP2_BASE + 0x28))
#define SFSP2_11             (*(volatile unsigned long *)(SFSP2_BASE + 0x2C))
#define SFSP2_12             (*(volatile unsigned long *)(SFSP2_BASE + 0x30))
#define SFSP2_13             (*(volatile unsigned long *)(SFSP2_BASE + 0x34))
#define SFSP2_14             (*(volatile unsigned long *)(SFSP2_BASE + 0x38))
#define SFSP2_15             (*(volatile unsigned long *)(SFSP2_BASE + 0x3C))
#define SFSP2_16             (*(volatile unsigned long *)(SFSP2_BASE + 0x40))
#define SFSP2_17             (*(volatile unsigned long *)(SFSP2_BASE + 0x44))
#define SFSP2_18             (*(volatile unsigned long *)(SFSP2_BASE + 0x48))
#define SFSP2_19             (*(volatile unsigned long *)(SFSP2_BASE + 0x4C))
#define SFSP2_20             (*(volatile unsigned long *)(SFSP2_BASE + 0x50))
#define SFSP2_21             (*(volatile unsigned long *)(SFSP2_BASE + 0x54))
#define SFSP2_22             (*(volatile unsigned long *)(SFSP2_BASE + 0x58))
#define SFSP2_23             (*(volatile unsigned long *)(SFSP2_BASE + 0x5C))
#define SFSP2_24             (*(volatile unsigned long *)(SFSP2_BASE + 0x60))
#define SFSP2_25             (*(volatile unsigned long *)(SFSP2_BASE + 0x64))
#define SFSP2_26             (*(volatile unsigned long *)(SFSP2_BASE + 0x68))
#define SFSP2_27             (*(volatile unsigned long *)(SFSP2_BASE + 0x6C))

#define SFSP3_BASE           (SCU_BASE_ADDR + 0x300)
#define SFSP3_0              (*(volatile unsigned long *)(SFSP3_BASE + 0x00))
#define SFSP3_1              (*(volatile unsigned long *)(SFSP3_BASE + 0x04))
#define SFSP3_2              (*(volatile unsigned long *)(SFSP3_BASE + 0x08))
#define SFSP3_3              (*(volatile unsigned long *)(SFSP3_BASE + 0x0C))
#define SFSP3_4              (*(volatile unsigned long *)(SFSP3_BASE + 0x10))
#define SFSP3_5              (*(volatile unsigned long *)(SFSP3_BASE + 0x14))
#define SFSP3_6              (*(volatile unsigned long *)(SFSP3_BASE + 0x18))
#define SFSP3_7              (*(volatile unsigned long *)(SFSP3_BASE + 0x1C))
#define SFSP3_8              (*(volatile unsigned long *)(SFSP3_BASE + 0x20))
#define SFSP3_9              (*(volatile unsigned long *)(SFSP3_BASE + 0x24))
#define SFSP3_10             (*(volatile unsigned long *)(SFSP3_BASE + 0x28))
#define SFSP3_11             (*(volatile unsigned long *)(SFSP3_BASE + 0x2C))
#define SFSP3_12             (*(volatile unsigned long *)(SFSP3_BASE + 0x30))
#define SFSP3_13             (*(volatile unsigned long *)(SFSP3_BASE + 0x34))
#define SFSP3_14             (*(volatile unsigned long *)(SFSP3_BASE + 0x38))
#define SFSP3_15             (*(volatile unsigned long *)(SFSP3_BASE + 0x3C))
#define SFSP3_16             (*(volatile unsigned long *)(SFSP3_BASE + 0x40))
#define SFSP3_17             (*(volatile unsigned long *)(SFSP3_BASE + 0x44))
#define SFSP3_18             (*(volatile unsigned long *)(SFSP3_BASE + 0x48))
#define SFSP3_19             (*(volatile unsigned long *)(SFSP3_BASE + 0x4C))
#define SFSP3_20             (*(volatile unsigned long *)(SFSP3_BASE + 0x50))
#define SFSP3_21             (*(volatile unsigned long *)(SFSP3_BASE + 0x54))
#define SFSP3_22             (*(volatile unsigned long *)(SFSP3_BASE + 0x58))
#define SFSP3_23             (*(volatile unsigned long *)(SFSP3_BASE + 0x5C))
#define SFSP3_24             (*(volatile unsigned long *)(SFSP3_BASE + 0x60))
#define SFSP3_25             (*(volatile unsigned long *)(SFSP3_BASE + 0x64))
#define SFSP3_26             (*(volatile unsigned long *)(SFSP3_BASE + 0x68))
#define SFSP3_27             (*(volatile unsigned long *)(SFSP3_BASE + 0x6C))
#define SFSP3_28             (*(volatile unsigned long *)(SFSP3_BASE + 0x70))
#define SFSP3_29             (*(volatile unsigned long *)(SFSP3_BASE + 0x74))
#define SFSP3_30             (*(volatile unsigned long *)(SFSP3_BASE + 0x78))
#define SFSP3_31             (*(volatile unsigned long *)(SFSP3_BASE + 0x7C))

#define SFSP4_BASE           (SCU_BASE_ADDR + 0x400)
#define SFSP4_0              (*(volatile unsigned long *)(SFSP4_BASE + 0x00))
#define SFSP4_1              (*(volatile unsigned long *)(SFSP4_BASE + 0x04))
#define SFSP4_2              (*(volatile unsigned long *)(SFSP4_BASE + 0x08))
#define SFSP4_3              (*(volatile unsigned long *)(SFSP4_BASE + 0x0C))
#define SFSP4_4              (*(volatile unsigned long *)(SFSP4_BASE + 0x10))
#define SFSP4_5              (*(volatile unsigned long *)(SFSP4_BASE + 0x14))
#define SFSP4_6              (*(volatile unsigned long *)(SFSP4_BASE + 0x18))
#define SFSP4_7              (*(volatile unsigned long *)(SFSP4_BASE + 0x1C))
#define SFSP4_8              (*(volatile unsigned long *)(SFSP4_BASE + 0x20))
#define SFSP4_9              (*(volatile unsigned long *)(SFSP4_BASE + 0x24))
#define SFSP4_10             (*(volatile unsigned long *)(SFSP4_BASE + 0x28))
#define SFSP4_11             (*(volatile unsigned long *)(SFSP4_BASE + 0x2C))
#define SFSP4_12             (*(volatile unsigned long *)(SFSP4_BASE + 0x30))
#define SFSP4_13             (*(volatile unsigned long *)(SFSP4_BASE + 0x34))
#define SFSP4_14             (*(volatile unsigned long *)(SFSP4_BASE + 0x38))
#define SFSP4_15             (*(volatile unsigned long *)(SFSP4_BASE + 0x3C))
#define SFSP4_16             (*(volatile unsigned long *)(SFSP4_BASE + 0x40))
#define SFSP4_17             (*(volatile unsigned long *)(SFSP4_BASE + 0x44))
#define SFSP4_18             (*(volatile unsigned long *)(SFSP4_BASE + 0x48))
#define SFSP4_19             (*(volatile unsigned long *)(SFSP4_BASE + 0x4C))
#define SFSP4_20             (*(volatile unsigned long *)(SFSP4_BASE + 0x50))
#define SFSP4_21             (*(volatile unsigned long *)(SFSP4_BASE + 0x54))
#define SFSP4_22             (*(volatile unsigned long *)(SFSP4_BASE + 0x58))
#define SFSP4_23             (*(volatile unsigned long *)(SFSP4_BASE + 0x5C))
#define SFSP4_24             (*(volatile unsigned long *)(SFSP4_BASE + 0x60))
#define SFSP4_25             (*(volatile unsigned long *)(SFSP4_BASE + 0x64))
#define SFSP4_26             (*(volatile unsigned long *)(SFSP4_BASE + 0x68))
#define SFSP4_27             (*(volatile unsigned long *)(SFSP4_BASE + 0x6C))
#define SFSP4_28             (*(volatile unsigned long *)(SFSP4_BASE + 0x70))
#define SFSP4_29             (*(volatile unsigned long *)(SFSP4_BASE + 0x74))
#define SFSP4_30             (*(volatile unsigned long *)(SFSP4_BASE + 0x78))
#define SFSP4_31             (*(volatile unsigned long *)(SFSP4_BASE + 0x7C))

#define SFSP5_BASE           (SCU_BASE_ADDR + 0x500)
#define SFSP5_0              (*(volatile unsigned long *)(SFSP5_BASE + 0x00))
#define SFSP5_1              (*(volatile unsigned long *)(SFSP5_BASE + 0x04))
#define SFSP5_2              (*(volatile unsigned long *)(SFSP5_BASE + 0x08))
#define SFSP5_3              (*(volatile unsigned long *)(SFSP5_BASE + 0x0C))
#define SFSP5_4              (*(volatile unsigned long *)(SFSP5_BASE + 0x10))
#define SFSP5_5              (*(volatile unsigned long *)(SFSP5_BASE + 0x14))
#define SFSP5_6              (*(volatile unsigned long *)(SFSP5_BASE + 0x18))
#define SFSP5_7              (*(volatile unsigned long *)(SFSP5_BASE + 0x1C))
#define SFSP5_8              (*(volatile unsigned long *)(SFSP5_BASE + 0x20))
#define SFSP5_9              (*(volatile unsigned long *)(SFSP5_BASE + 0x24))
#define SFSP5_10             (*(volatile unsigned long *)(SFSP5_BASE + 0x28))
#define SFSP5_11             (*(volatile unsigned long *)(SFSP5_BASE + 0x2C))
#define SFSP5_12             (*(volatile unsigned long *)(SFSP5_BASE + 0x30))
#define SFSP5_13             (*(volatile unsigned long *)(SFSP5_BASE + 0x34))
#define SFSP5_14             (*(volatile unsigned long *)(SFSP5_BASE + 0x38))
#define SFSP5_15             (*(volatile unsigned long *)(SFSP5_BASE + 0x3C))
#define SFSP5_16             (*(volatile unsigned long *)(SFSP5_BASE + 0x40))
#define SFSP5_17             (*(volatile unsigned long *)(SFSP5_BASE + 0x44))
#define SFSP5_18             (*(volatile unsigned long *)(SFSP5_BASE + 0x48))
#define SFSP5_19             (*(volatile unsigned long *)(SFSP5_BASE + 0x4C))


#define SEC_BASE             (SCU_BASE_ADDR + 0x000)
#define SEC_DIS              (*(volatile unsigned long *)(SEC_BASE + 0xB00))
#define SEC_STA              (*(volatile unsigned long *)(SEC_BASE + 0xB04))

#define SSSM_BASE            (SCU_BASE_ADDR + 0x000)
#define SSMM_0               (*(volatile unsigned long *)(SSSM_BASE + 0xC00))
#define SSMM_1               (*(volatile unsigned long *)(SSSM_BASE + 0xC04))
#define SSMM_2               (*(volatile unsigned long *)(SSSM_BASE + 0xC08))
#define SSMM_3               (*(volatile unsigned long *)(SSSM_BASE + 0xC0C))

/* Event Router register base */
#define ER_BASE_ADDR      0xE0002000
#define ER_PEND              (*(volatile unsigned long *)(ER_BASE_ADDR + 0xC00))
#define ER_INT_CLR           (*(volatile unsigned long *)(ER_BASE_ADDR + 0xC20))
#define ER_INT_SET           (*(volatile unsigned long *)(ER_BASE_ADDR + 0xC40))
#define ER_MASK              (*(volatile unsigned long *)(ER_BASE_ADDR + 0xC60))
#define ER_MASK_CLR          (*(volatile unsigned long *)(ER_BASE_ADDR + 0xC80))
#define ER_MASK_SET          (*(volatile unsigned long *)(ER_BASE_ADDR + 0xCA0))
#define ER_APR               (*(volatile unsigned long *)(ER_BASE_ADDR + 0xCC0))
#define ER_ATR               (*(volatile unsigned long *)(ER_BASE_ADDR + 0xCE0))
#define ER_RSR               (*(volatile unsigned long *)(ER_BASE_ADDR + 0xD20))

/* Watchdog register base */
#define WDT_BASE_ADDR      0xE0040000
#define WDT_WTCR             (*(volatile unsigned long *)(WDT_BASE_ADDR + 0x000))
#define WDT_TC               (*(volatile unsigned long *)(WDT_BASE_ADDR + 0x004))
#define WDT_PR               (*(volatile unsigned long *)(WDT_BASE_ADDR + 0x008))
#define WDT_WD_KEY           (*(volatile unsigned long *)(WDT_BASE_ADDR + 0x038))
#define WDT_TIMEOUT          (*(volatile unsigned long *)(WDT_BASE_ADDR + 0x03C))
#define WDT_DEBUG            (*(volatile unsigned long *)(WDT_BASE_ADDR + 0x040))
#define WDT_INT_CLR_ENABLE   (*(volatile unsigned long *)(WDT_BASE_ADDR + 0xFD8))
#define WDT_INT_SET_ENABLE   (*(volatile unsigned long *)(WDT_BASE_ADDR + 0xFDC))
#define WDT_INT_STATUS       (*(volatile unsigned long *)(WDT_BASE_ADDR + 0xFE0))
#define WDT_INT_ENABLE       (*(volatile unsigned long *)(WDT_BASE_ADDR + 0xFE4))
#define WDT_INT_CLR_STATUS   (*(volatile unsigned long *)(WDT_BASE_ADDR + 0xFE8))
#define WDT_INT_SET_STATUS   (*(volatile unsigned long *)(WDT_BASE_ADDR + 0xFEC))

/* Timer related reqiesters */
#define TMR0_BASE_ADDR       0xE0041000
#define TIM0_TCR             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x000))
#define TIM0_TC              (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x004))
#define TIM0_PR              (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x008))
#define TIM0_MCR             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x00C))
#define TIM0_EMR             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x010))
#define TIM0_MR0             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x014))
#define TIM0_MR1             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x018))
#define TIM0_MR2             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x01C))
#define TIM0_MR3             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x020))
#define TIM0_CCR             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x024))
#define TIM0_CR0             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x028))
#define TIM0_CR1             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x02C))
#define TIM0_CR2             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x030))
#define TIM0_CR3             (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0x034))
#define TIM0_INT_CLR_ENABLE  (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0xFD8))
#define TIM0_INT_SET_ENABLE  (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0xFDC))
#define TIM0_INT_STATUS      (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0xFE0))
#define TIM0_INT_ENABLE      (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0xFE4))
#define TIM0_INT_CLR_STATUS  (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0xFE8))
#define TIM0_INT_SET_STATUS  (*(volatile unsigned long *)(TMR0_BASE_ADDR + 0xFEC))

#define TMR1_BASE_ADDR       0xE0042000
#define TIM1_TCR             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x000))
#define TIM1_TC              (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x004))
#define TIM1_PR              (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x008))
#define TIM1_MCR             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x00C))
#define TIM1_EMR             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x010))
#define TIM1_MR0             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x014))
#define TIM1_MR1             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x018))
#define TIM1_MR2             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x01C))
#define TIM1_MR3             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x020))
#define TIM1_CCR             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x024))
#define TIM1_CR0             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x028))
#define TIM1_CR1             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x02C))
#define TIM1_CR2             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x030))
#define TIM1_CR3             (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0x034))
#define TIM1_INT_CLR_ENABLE  (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0xFD8))
#define TIM1_INT_SET_ENABLE  (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0xFDC))
#define TIM1_INT_STATUS      (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0xFE0))
#define TIM1_INT_ENABLE      (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0xFE4))
#define TIM1_INT_CLR_STATUS  (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0xFE8))
#define TIM1_INT_SET_STATUS  (*(volatile unsigned long *)(TMR1_BASE_ADDR + 0xFEC))

#define TMR2_BASE_ADDR       0xE0043000
#define TIM2_TCR             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x000))
#define TIM2_TC              (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x004))
#define TIM2_PR              (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x008))
#define TIM2_MCR             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x00C))
#define TIM2_EMR             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x010))
#define TIM2_MR0             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x014))
#define TIM2_MR1             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x018))
#define TIM2_MR2             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x01C))
#define TIM2_MR3             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x020))
#define TIM2_CCR             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x024))
#define TIM2_CR0             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x028))
#define TIM2_CR1             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x02C))
#define TIM2_CR2             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x030))
#define TIM2_CR3             (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0x034))
#define TIM2_INT_CLR_ENABLE  (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0xFD8))
#define TIM2_INT_SET_ENABLE  (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0xFDC))
#define TIM2_INT_STATUS      (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0xFE0))
#define TIM2_INT_ENABLE      (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0xFE4))
#define TIM2_INT_CLR_STATUS  (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0xFE8))
#define TIM2_INT_SET_STATUS  (*(volatile unsigned long *)(TMR2_BASE_ADDR + 0xFEC))

#define TMR3_BASE_ADDR       0xE0044000
#define TIM3_TCR             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x000))
#define TIM3_TC              (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x004))
#define TIM3_PR              (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x008))
#define TIM3_MCR             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x00C))
#define TIM3_EMR             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x010))
#define TIM3_MR0             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x014))
#define TIM3_MR1             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x018))
#define TIM3_MR2             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x01C))
#define TIM3_MR3             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x020))
#define TIM3_CCR             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x024))
#define TIM3_CR0             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x028))
#define TIM3_CR1             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x02C))
#define TIM3_CR2             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x030))
#define TIM3_CR3             (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0x034))
#define TIM3_INT_CLR_ENABLE  (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0xFD8))
#define TIM3_INT_SET_ENABLE  (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0xFDC))
#define TIM3_INT_STATUS      (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0xFE0))
#define TIM3_INT_ENABLE      (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0xFE4))
#define TIM3_INT_CLR_STATUS  (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0xFE8))
#define TIM3_INT_SET_STATUS  (*(volatile unsigned long *)(TMR3_BASE_ADDR + 0xFEC))

/* UART register base */
#define UART0_BASE_ADDR      0xE0045000
#define U0RBR                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x00))
#define U0THR                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x00))
#define U0DLL                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x00))
#define U0DLM                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x04))
#define U0IER                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x04))
#define U0IIR                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x08))
#define U0FCR                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x08))
#define U0LCR                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x0C))
#define U0LSR                (*(volatile unsigned long *)(UART0_BASE_ADDR + 0x14))

#define UART1_BASE_ADDR      0xE0046000
#define U1RBR                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x00))
#define U1THR                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x00))
#define U1DLL                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x00))
#define U1DLM                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x04))
#define U1IER                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x04))
#define U1IIR                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x08))
#define U1FCR                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x08))
#define U1LCR                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x0C))
#define U1LSR                (*(volatile unsigned long *)(UART1_BASE_ADDR + 0x14))

/* SPIx register base */
#define SPI0_BASE_ADDR       0xE0047000
#define SPI0_CONFIG          (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x000))
#define SPI0_SLV_ENABLE      (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x004))
#define SPI0_TX_FIFO_FLUSH   (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x008))
#define SPI0_FIFO_DATA       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x00C))
#define SPI0_FIFO_POP        (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x010))
#define SPI0_RD_FIFO_RDMODE  (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x014))
#define SPI0_STAT            (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x01C))
#define SPI0_SLV0_SET1       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x024))
#define SPI0_SLV0_SET2       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x028))
#define SPI0_SLV1_SET1       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x02C))
#define SPI0_SLV1_SET2       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x030))
#define SPI0_SLV2_SET1       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x034))
#define SPI0_SLV2_SET2       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x038))
#define SPI0_SLV3_SET1       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x03C))
#define SPI0_SLV3_SET2       (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0x040))

#define SPI0_INT_THRESHOLD   (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFD4))
#define SPI0_INT_CLR_ENABLE  (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFD8))
#define SPI0_INT_SET_ENABLE  (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFDC))
#define SPI0_INT_STATUS      (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFE0))
#define SPI0_INT_ENABLE      (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFE4))
#define SPI0_INT_CLR_STATUS  (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFE8))
#define SPI0_INT_SET_STATUS  (*(volatile unsigned long *)(SPI0_BASE_ADDR + 0xFEC))

#define SPI1_BASE_ADDR       0xE0048000
#define SPI1_CONFIG          (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x000))
#define SPI1_SLV_ENABLE      (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x004))
#define SPI1_TX_FIFO_FLUSH   (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x008))
#define SPI1_FIFO_DATA       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x00C))
#define SPI1_FIFO_POP        (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x010))
#define SPI1_RD_FIFO_RDMODE  (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x014))
#define SPI1_STAT            (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x01C))
#define SPI1_SLV0_SET1       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x024))
#define SPI1_SLV0_SET2       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x028))
#define SPI1_SLV1_SET1       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x02C))
#define SPI1_SLV1_SET2       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x030))
#define SPI1_SLV2_SET1       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x034))
#define SPI1_SLV2_SET2       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x038))
#define SPI1_SLV3_SET1       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x03C))
#define SPI1_SLV3_SET2       (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0x040))

#define SPI1_INT_THRESHOLD   (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFD4))
#define SPI1_INT_CLR_ENABLE  (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFD8))
#define SPI1_INT_SET_ENABLE  (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFDC))
#define SPI1_INT_STATUS      (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFE0))
#define SPI1_INT_ENABLE      (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFE4))
#define SPI1_INT_CLR_STATUS  (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFE8))
#define SPI1_INT_SET_STATUS  (*(volatile unsigned long *)(SPI1_BASE_ADDR + 0xFEC))

#define SPI2_BASE_ADDR       0xE0049000
#define SPI2_CONFIG          (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x000))
#define SPI2_SLV_ENABLE      (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x004))
#define SPI2_TX_FIFO_FLUSH   (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x008))
#define SPI2_FIFO_DATA       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x00C))
#define SPI2_FIFO_POP        (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x010))
#define SPI2_RD_FIFO_RDMODE  (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x014))
#define SPI2_STAT            (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x01C))
#define SPI2_SLV0_SET1       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x024))
#define SPI2_SLV0_SET2       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x028))
#define SPI2_SLV1_SET1       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x02C))
#define SPI2_SLV1_SET2       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x030))
#define SPI2_SLV2_SET1       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x034))
#define SPI2_SLV2_SET2       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x038))
#define SPI2_SLV3_SET1       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x03C))
#define SPI2_SLV3_SET2       (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0x040))

#define SPI2_INT_THRESHOLD   (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFD4))
#define SPI2_INT_CLR_ENABLE  (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFD8))
#define SPI2_INT_SET_ENABLE  (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFDC))
#define SPI2_INT_STATUS      (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFE0))
#define SPI2_INT_ENABLE      (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFE4))
#define SPI2_INT_CLR_STATUS  (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFE8))
#define SPI2_INT_SET_STATUS  (*(volatile unsigned long *)(SPI2_BASE_ADDR + 0xFEC))

/* I2Cx registers base */
/* I2C0 interface */
#define I2C0_BASE_ADDR       0xE0082000
#define I2C0CONSET           (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x0000))
#define I2C0STAT             (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x0004))
#define I2C0DAT              (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x0008))
#define I2C0ADR              (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x000C))
#define I2C0SCLH             (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x0010))
#define I2C0SCLL             (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x0014))
#define I2C0CONCLR           (*(volatile unsigned long *)(I2C0_BASE_ADDR + 0x0018))

/* I2C1 interface */
#define I2C1_BASE_ADDR       0xE0083000
#define I2C1CONSET           (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x0000))
#define I2C1STAT             (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x0004))
#define I2C1DAT              (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x0008))
#define I2C1ADR              (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x000C))
#define I2C1SCLH             (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x0010))
#define I2C1SCLL             (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x0014))
#define I2C1CONCLR           (*(volatile unsigned long *)(I2C1_BASE_ADDR + 0x0018))

/* GPIO register controller base address */
#define GPIO0_BASE_ADDR      0xE004A000
#define GPIO0_PINS           (*(volatile unsigned long *)(GPIO0_BASE_ADDR + 0x000))
#define GPIO0_OR             (*(volatile unsigned long *)(GPIO0_BASE_ADDR + 0x004))
#define GPIO0_DR             (*(volatile unsigned long *)(GPIO0_BASE_ADDR + 0x008))

#define GPIO1_BASE_ADDR      0xE004B000
#define GPIO1_PINS           (*(volatile unsigned long *)(GPIO1_BASE_ADDR + 0x000))
#define GPIO1_OR             (*(volatile unsigned long *)(GPIO1_BASE_ADDR + 0x004))
#define GPIO1_DR             (*(volatile unsigned long *)(GPIO1_BASE_ADDR + 0x008))

#define GPIO2_BASE_ADDR      0xE004C000
#define GPIO2_PINS           (*(volatile unsigned long *)(GPIO2_BASE_ADDR + 0x000))
#define GPIO2_OR             (*(volatile unsigned long *)(GPIO2_BASE_ADDR + 0x004))
#define GPIO2_DR             (*(volatile unsigned long *)(GPIO2_BASE_ADDR + 0x008))

#define GPIO3_BASE_ADDR      0xE004D000
#define GPIO3_PINS           (*(volatile unsigned long *)(GPIO3_BASE_ADDR + 0x000))
#define GPIO3_OR             (*(volatile unsigned long *)(GPIO3_BASE_ADDR + 0x004))
#define GPIO3_DR             (*(volatile unsigned long *)(GPIO3_BASE_ADDR + 0x008))

#define GPIO4_BASE_ADDR      0xE004E000
#define GPIO4_PINS           (*(volatile unsigned long *)(GPIO4_BASE_ADDR + 0x000))
#define GPIO4_OR             (*(volatile unsigned long *)(GPIO4_BASE_ADDR + 0x004))
#define GPIO4_DR             (*(volatile unsigned long *)(GPIO4_BASE_ADDR + 0x008))

#define GPIO5_BASE_ADDR      0xE004F000
#define GPIO5_PINS           (*(volatile unsigned long *)(GPIO5_BASE_ADDR + 0x000))
#define GPIO5_OR             (*(volatile unsigned long *)(GPIO5_BASE_ADDR + 0x004))
#define GPIO5_DR             (*(volatile unsigned long *)(GPIO5_BASE_ADDR + 0x008))

/* CAN related registers */
#define CAN0_BASE_ADDR		0xE0080000
#define CAN0MOD 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x00))  	
#define CAN0CMR 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x04))  	
#define CAN0GSR 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x08))  	
#define CAN0ICR 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x0C))  	
#define CAN0IER 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x10))
#define CAN0BTR 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x14))  	
#define CAN0EWL 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x18))  	
#define CAN0SR 		(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x1C))  	
#define CAN0RFS 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x20))  	
#define CAN0RID 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x24))
#define CAN0RDA 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x28))  	
#define CAN0RDB 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x2C))
  	
#define CAN0TFI1 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x30))  	
#define CAN0TID1 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x34))  	
#define CAN0TDA1 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x38))
#define CAN0TDB1 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x3C))  	
#define CAN0TFI2 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x40))  	
#define CAN0TID2 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x44))  	
#define CAN0TDA2 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x48))  	
#define CAN0TDB2 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x4C))
#define CAN0TFI3 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x50))  	
#define CAN0TID3 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x54))  	
#define CAN0TDA3 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x58))  	
#define CAN0TDB3 	(*(volatile unsigned long *)(CAN0_BASE_ADDR + 0x5C))

#define CAN1_BASE_ADDR		0xE0081000
#define CAN1MOD 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x00))  	
#define CAN1CMR 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x04))  	
#define CAN1GSR 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x08))  	
#define CAN1ICR 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x0C))  	
#define CAN1IER 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x10))
#define CAN1BTR 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x14))  	
#define CAN1EWL 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x18))  	
#define CAN1SR 		(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x1C))  	
#define CAN1RFS 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x20))  	
#define CAN1RID 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x24))
#define CAN1RDA 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x28))  	
#define CAN1RDB 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x2C))
  	
#define CAN1TFI1 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x30))  	
#define CAN1TID1 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x34))  	
#define CAN1TDA1 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x38))
#define CAN1TDB1 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x3C))  	
#define CAN1TFI2 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x40))  	
#define CAN1TID2 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x44))  	
#define CAN1TDA2 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x48))  	
#define CAN1TDB2 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x4C))
#define CAN1TFI3 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x50))  	
#define CAN1TID3 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x54))  	
#define CAN1TDA3 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x58))  	
#define CAN1TDB3 	(*(volatile unsigned long *)(CAN1_BASE_ADDR + 0x5C))

#define CAN_AFR_BASE_ADDR			0xE0086000

/* CAN CONTROLLERS AND ACCEPTANCE FILTER */
#define CAN_ACCEPT_BASE_ADDR		0xE0087000
#define CAN_AFMR		(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x00))  	
#define CAN_SFF_SA 		(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x04))  	
#define CAN_SFF_GRP_SA 	(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x08))
#define CAN_EFF_SA 		(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x0C))
#define CAN_EFF_GRP_SA 	(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x10))  	
#define CAN_EOT 		(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x14))
#define CAN_LUT_ERR_ADR (*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x18))  	
#define CAN_LUT_ERR 	(*(volatile unsigned long *)(CAN_ACCEPT_BASE_ADDR + 0x1C))

#define CAN_CENTRAL_BASE_ADDR		0xE0088000  	
#define CAN_TX_SR 	(*(volatile unsigned long *)(CAN_CENTRAL_BASE_ADDR + 0x00))  	
#define CAN_RX_SR 	(*(volatile unsigned long *)(CAN_CENTRAL_BASE_ADDR + 0x04))  	
#define CAN_MSR 	(*(volatile unsigned long *)(CAN_CENTRAL_BASE_ADDR + 0x08))

/* LIN controller register base */
#define LIN0_BASE_ADDR		0xE0089000
#define LIN0_LMODE		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x00))  	
#define LIN0_LCFG 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x04))  	
#define LIN0_LCMD 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x08))
#define LIN0_LFBRG 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x0C))
#define LIN0_LSTAT 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x10))  	
#define LIN0_LIC 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x14))
#define LIN0_LIE 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x18))  	
#define LIN0_LCS 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x20))
#define LIN0_LTO 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x24))
#define LIN0_LID 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x28))
#define LIN0_LDATA 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x2C))  	
#define LIN0_LDATB 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x30))
#define LIN0_LDATC 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x34))  	
#define LIN0_LDATD 		(*(volatile unsigned long *)(LIN0_BASE_ADDR + 0x38))

#define LIN1_BASE_ADDR		0xE008A000
#define LIN1_LMODE		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x00))  	
#define LIN1_LCFG 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x04))  	
#define LIN1_LCMD 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x08))
#define LIN1_LFBRG 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x0C))
#define LIN1_LSTAT 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x10))  	
#define LIN1_LIC 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x14))
#define LIN1_LIE 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x18))  	
#define LIN1_LCS 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x20))
#define LIN1_LTO 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x24))
#define LIN1_LID 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x28))
#define LIN1_LDATA 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x2C))  	
#define LIN1_LDATB 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x30))
#define LIN1_LDATC 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x34))  	
#define LIN1_LDATD 		(*(volatile unsigned long *)(LIN1_BASE_ADDR + 0x38))

/* Modulation and Sampling Control Subsystem(MSCSS) Timer related reqiesters */
#define MTMR0_BASE_ADDR       0xE00C0000
#define MTIM0_TCR             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x000))
#define MTIM0_TC              (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x004))
#define MTIM0_PR              (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x008))
#define MTIM0_MCR             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x00C))
#define MTIM0_EMR             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x010))
#define MTIM0_MR0             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x014))
#define MTIM0_MR1             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x018))
#define MTIM0_MR2             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x01C))
#define MTIM0_MR3             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x020))
#define MTIM0_CCR             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x024))
#define MTIM0_CR0             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x028))
#define MTIM0_CR1             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x02C))
#define MTIM0_CR2             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x030))
#define MTIM0_CR3             (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0x034))
#define MTIM0_INT_CLR_ENABLE  (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0xFD8))
#define MTIM0_INT_SET_ENABLE  (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0xFDC))
#define MTIM0_INT_STATUS      (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0xFE0))
#define MTIM0_INT_ENABLE      (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0xFE4))
#define MTIM0_INT_CLR_STATUS  (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0xFE8))
#define MTIM0_INT_SET_STATUS  (*(volatile unsigned long *)(MTMR0_BASE_ADDR + 0xFEC))

#define MTMR1_BASE_ADDR       0xE00C1000
#define MTIM1_TCR             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x000))
#define MTIM1_TC              (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x004))
#define MTIM1_PR              (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x008))
#define MTIM1_MCR             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x00C))
#define MTIM1_EMR             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x010))
#define MTIM1_MR0             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x014))
#define MTIM1_MR1             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x018))
#define MTIM1_MR2             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x01C))
#define MTIM1_MR3             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x020))
#define MTIM1_CCR             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x024))
#define MTIM1_CR0             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x028))
#define MTIM1_CR1             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x02C))
#define MTIM1_CR2             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x030))
#define MTIM1_CR3             (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0x034))
#define MTIM1_INT_CLR_ENABLE  (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0xFD8))
#define MTIM1_INT_SET_ENABLE  (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0xFDC))
#define MTIM1_INT_STATUS      (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0xFE0))
#define MTIM1_INT_ENABLE      (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0xFE4))
#define MTIM1_INT_CLR_STATUS  (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0xFE8))
#define MTIM1_INT_SET_STATUS  (*(volatile unsigned long *)(MTMR1_BASE_ADDR + 0xFEC))

//  ADC0( 5V) added in gallardo rev2
#define ADC0_BASE_ADDR       0xE00C2000
#define ADC0_ACC0            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x000))
#define ADC0_ACC1            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x004))
#define ADC0_ACC2            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x008))
#define ADC0_ACC3            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x00C))
#define ADC0_ACC4            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x010))
#define ADC0_ACC5            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x014))
#define ADC0_ACC6            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x018))
#define ADC0_ACC7            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x01C))
#define ADC0_ACC8            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x020))
#define ADC0_ACC9            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x024))
#define ADC0_ACC10           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x028))
#define ADC0_ACC11           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x02C))
#define ADC0_ACC12           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x030))
#define ADC0_ACC13           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x034))
#define ADC0_ACC14           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x038))
#define ADC0_ACC15           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x03C))

#define ADC0_COMP0           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x100))
#define ADC0_COMP1           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x104))
#define ADC0_COMP2           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x108))
#define ADC0_COMP3           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x10C))
#define ADC0_COMP4           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x110))
#define ADC0_COMP5           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x114))
#define ADC0_COMP6           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x118))
#define ADC0_COMP7           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x11C))
#define ADC0_COMP8           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x120))
#define ADC0_COMP9           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x124))
#define ADC0_COMP10          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x128))
#define ADC0_COMP11          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x12C))
#define ADC0_COMP12          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x130))
#define ADC0_COMP13          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x134))
#define ADC0_COMP14          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x138))
#define ADC0_COMP15          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x13C))

#define ADC0_ACD0            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x200))
#define ADC0_ACD1            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x204))
#define ADC0_ACD2            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x208))
#define ADC0_ACD3            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x20C))
#define ADC0_ACD4            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x210))
#define ADC0_ACD5            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x214))
#define ADC0_ACD6            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x218))
#define ADC0_ACD7            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x21C))
#define ADC0_ACD8            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x220))
#define ADC0_ACD9            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x224))
#define ADC0_ACD10           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x228))
#define ADC0_ACD11           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x22C))
#define ADC0_ACD12           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x230))
#define ADC0_ACD13           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x234))
#define ADC0_ACD14           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x238))
#define ADC0_ACD15           (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x23C))

#define ADC0_COMP_STAT       (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x300))
#define ADC0_COMPSTAT_CLR    (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x304))
#define ADC0_CONFIG          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x400))
#define ADC0_CTRL            (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x404))
#define ADC0_STATUS          (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0x408))

#define ADC0_INT_CLR_ENABLE  (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0xFD8))
#define ADC0_INT_SET_ENABLE  (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0xFDC))
#define ADC0_INT_STATUS      (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0xFE0))
#define ADC0_INT_ENABLE      (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0xFE4))
#define ADC0_INT_CLR_STATUS  (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0xFE8))
#define ADC0_INT_SET_STATUS  (*(volatile unsigned long *)(ADC0_BASE_ADDR + 0xFEC))

#define ADC1_BASE_ADDR       0xE00C3000
#define ADC1_ACC0            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x000))
#define ADC1_ACC1            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x004))
#define ADC1_ACC2            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x008))
#define ADC1_ACC3            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x00C))
#define ADC1_ACC4            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x010))
#define ADC1_ACC5            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x014))
#define ADC1_ACC6            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x018))
#define ADC1_ACC7            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x01C))
#define ADC1_ACC8            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x020))
#define ADC1_ACC9            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x024))
#define ADC1_ACC10           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x028))
#define ADC1_ACC11           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x02C))
#define ADC1_ACC12           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x030))
#define ADC1_ACC13           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x034))
#define ADC1_ACC14           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x038))
#define ADC1_ACC15           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x03C))

#define ADC1_COMP0           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x100))
#define ADC1_COMP1           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x104))
#define ADC1_COMP2           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x108))
#define ADC1_COMP3           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x10C))
#define ADC1_COMP4           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x110))
#define ADC1_COMP5           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x114))
#define ADC1_COMP6           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x118))
#define ADC1_COMP7           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x11C))
#define ADC1_COMP8           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x120))
#define ADC1_COMP9           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x124))
#define ADC1_COMP10          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x128))
#define ADC1_COMP11          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x12C))
#define ADC1_COMP12          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x130))
#define ADC1_COMP13          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x134))
#define ADC1_COMP14          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x138))
#define ADC1_COMP15          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x13C))

#define ADC1_ACD0            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x200))
#define ADC1_ACD1            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x204))
#define ADC1_ACD2            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x208))
#define ADC1_ACD3            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x20C))
#define ADC1_ACD4            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x210))
#define ADC1_ACD5            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x214))
#define ADC1_ACD6            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x218))
#define ADC1_ACD7            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x21C))
#define ADC1_ACD8            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x220))
#define ADC1_ACD9            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x224))
#define ADC1_ACD10           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x228))
#define ADC1_ACD11           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x22C))
#define ADC1_ACD12           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x230))
#define ADC1_ACD13           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x234))
#define ADC1_ACD14           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x238))
#define ADC1_ACD15           (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x23C))

#define ADC1_COMP_STAT       (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x300))
#define ADC1_COMPSTAT_CLR    (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x304))
#define ADC1_CONFIG          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x400))
#define ADC1_CTRL            (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x404))
#define ADC1_STATUS          (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0x408))

#define ADC1_INT_CLR_ENABLE  (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0xFD8))
#define ADC1_INT_SET_ENABLE  (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0xFDC))
#define ADC1_INT_STATUS      (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0xFE0))
#define ADC1_INT_ENABLE      (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0xFE4))
#define ADC1_INT_CLR_STATUS  (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0xFE8))
#define ADC1_INT_SET_STATUS  (*(volatile unsigned long *)(ADC1_BASE_ADDR + 0xFEC))

#define ADC2_BASE_ADDR       0xE00C4000
#define ADC2_ACC0            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x000))
#define ADC2_ACC1            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x004))
#define ADC2_ACC2            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x008))
#define ADC2_ACC3            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x00C))
#define ADC2_ACC4            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x010))
#define ADC2_ACC5            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x014))
#define ADC2_ACC6            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x018))
#define ADC2_ACC7            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x01C))
#define ADC2_ACC8            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x020))
#define ADC2_ACC9            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x024))
#define ADC2_ACC10           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x028))
#define ADC2_ACC11           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x02C))
#define ADC2_ACC12           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x030))
#define ADC2_ACC13           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x034))
#define ADC2_ACC14           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x038))
#define ADC2_ACC15           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x03C))

#define ADC2_COMP0           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x100))
#define ADC2_COMP1           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x104))
#define ADC2_COMP2           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x108))
#define ADC2_COMP3           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x10C))
#define ADC2_COMP4           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x110))
#define ADC2_COMP5           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x114))
#define ADC2_COMP6           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x118))
#define ADC2_COMP7           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x11C))
#define ADC2_COMP8           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x120))
#define ADC2_COMP9           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x124))
#define ADC2_COMP10          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x128))
#define ADC2_COMP11          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x12C))
#define ADC2_COMP12          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x130))
#define ADC2_COMP13          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x134))
#define ADC2_COMP14          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x138))
#define ADC2_COMP15          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x13C))

#define ADC2_ACD0            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x200))
#define ADC2_ACD1            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x204))
#define ADC2_ACD2            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x208))
#define ADC2_ACD3            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x20C))
#define ADC2_ACD4            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x210))
#define ADC2_ACD5            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x214))
#define ADC2_ACD6            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x218))
#define ADC2_ACD7            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x21C))
#define ADC2_ACD8            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x220))
#define ADC2_ACD9            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x224))
#define ADC2_ACD10           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x228))
#define ADC2_ACD11           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x22C))
#define ADC2_ACD12           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x230))
#define ADC2_ACD13           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x234))
#define ADC2_ACD14           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x238))
#define ADC2_ACD15           (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x23C))

#define ADC2_COMP_STAT       (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x300))
#define ADC2_COMPSTAT_CLR    (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x304))
#define ADC2_CONFIG          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x400))
#define ADC2_CTRL            (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x404))
#define ADC2_STATUS          (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0x408))

#define ADC2_INT_CLR_ENABLE  (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0xFD8))
#define ADC2_INT_SET_ENABLE  (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0xFDC))
#define ADC2_INT_STATUS      (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0xFE0))
#define ADC2_INT_ENABLE      (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0xFE4))
#define ADC2_INT_CLR_STATUS  (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0xFE8))
#define ADC2_INT_SET_STATUS  (*(volatile unsigned long *)(ADC2_BASE_ADDR + 0xFEC))

/* PWM base register */
#define PWM0_BASE_ADDR       0xE00C5000
#define PWM0_MODECTL         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x000))
#define PWM0_TRPCTL          (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x004))
#define PWM0_CAPCTL          (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x008))
#define PWM0_CAPTSRC         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x00C))
#define PWM0_CTRL            (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x010))
#define PWM0_PRD             (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x014))
#define PWM0_PRSC            (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x018))
#define PWM0_SYNDEL          (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x01C))
#define PWM0_CNT             (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x020))
#define PWM0_MATCHA0         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x100))
#define PWM0_MATCHA1         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x104))
#define PWM0_MATCHA2         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x108))
#define PWM0_MATCHA3         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x10C))
#define PWM0_MATCHA4         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x110))
#define PWM0_MATCHA5         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x114))
#define PWM0_MATCHDA0        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x200))
#define PWM0_MATCHDA1        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x204))
#define PWM0_MATCHDA2        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x208))
#define PWM0_MATCHDA3        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x20C))
#define PWM0_MATCHDA4        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x210))
#define PWM0_MATCHDA5        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x214))
#define PWM0_CAPT0           (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x300))
#define PWM0_CAPT1           (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x304))
#define PWM0_CAPT2           (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x308))
#define PWM0_CAPT3           (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x30C))

#define PWM0_MODECTLS        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x800))
#define PWM0_TRPCTLS         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x804))
#define PWM0_CAPTCTLS        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x808))
#define PWM0_CAPTSRCS        (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x80C))
#define PWM0_CTRLS           (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x810))
#define PWM0_PRDS            (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x814))
#define PWM0_PRSCS           (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x818))
#define PWM0_SYNDELS         (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x81C))
#define PWM0_MATCHACTS0      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x900))
#define PWM0_MATCHACTS1      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x904))
#define PWM0_MATCHACTS2      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x908))
#define PWM0_MATCHACTS3      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x90C))
#define PWM0_MATCHACTS4      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x910))
#define PWM0_MATCHACTS5      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0x914))
#define PWM0_MATCHDACTS0     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xA00))
#define PWM0_MATCHDACTS1     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xA04))
#define PWM0_MATCHDACTS2     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xA08))
#define PWM0_MATCHDACTS3     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xA0C))
#define PWM0_MATCHDACTS4     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xA10))
#define PWM0_MATCHDACTS5     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xA14))

#define PWM0_INT_CLR_ENABLE  (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xF90))
#define PWM0_INT_SET_ENABLE  (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xF94))
#define PWM0_INT_STATUS      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xF98))
#define PWM0_INT_ENABLE      (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xF9C))
#define PWM0_INT_CLR_STATUS  (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFA0))
#define PWM0_INT_SET_STATUS  (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFA4))

#define PWM0_INTM_CLR_ENABLE (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFA8))
#define PWM0_INTM_SET_ENABLE (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFAC))
#define PWM0_INTM_STATUS     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFB0))
#define PWM0_INTM_ENABLE     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFB4))
#define PWM0_INTM_CLR_STATUS (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFB8))
#define PWM0_INTM_SET_STATUS (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFBC))

#define PWM0_INTC_CLR_ENABLE (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFC0))
#define PWM0_INTC_SET_ENABLE (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFC4))
#define PWM0_INTC_STATUS     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFC8))
#define PWM0_INTC_ENABLE     (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFCC))
#define PWM0_INTC_CLR_STATUS (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFD0))
#define PWM0_INTC_SET_STATUS (*(volatile unsigned long *)(PWM0_BASE_ADDR + 0xFD4))

#define PWM1_BASE_ADDR       0xE00C6000
#define PWM1_MODECTL         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x000))
#define PWM1_TRPCTL          (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x004))
#define PWM1_CAPCTL          (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x008))
#define PWM1_CAPTSRC         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x00C))
#define PWM1_CTRL            (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x010))
#define PWM1_PRD             (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x014))
#define PWM1_PRSC            (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x018))
#define PWM1_SYNDEL          (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x01C))
#define PWM1_CNT             (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x020))
#define PWM1_MATCHA0         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x100))
#define PWM1_MATCHA1         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x104))
#define PWM1_MATCHA2         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x108))
#define PWM1_MATCHA3         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x10C))
#define PWM1_MATCHA4         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x110))
#define PWM1_MATCHA5         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x114))
#define PWM1_MATCHDA0        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x200))
#define PWM1_MATCHDA1        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x204))
#define PWM1_MATCHDA2        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x208))
#define PWM1_MATCHDA3        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x20C))
#define PWM1_MATCHDA4        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x210))
#define PWM1_MATCHDA5        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x214))
#define PWM1_CAPT0           (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x300))
#define PWM1_CAPT1           (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x304))
#define PWM1_CAPT2           (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x308))
#define PWM1_CAPT3           (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x30C))

#define PWM1_MODECTLS        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x800))
#define PWM1_TRPCTLS         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x804))
#define PWM1_CAPTCTLS        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x808))
#define PWM1_CAPTSRCS        (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x80C))
#define PWM1_CTRLS           (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x810))
#define PWM1_PRDS            (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x814))
#define PWM1_PRSCS           (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x818))
#define PWM1_SYNDELS         (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x81C))
#define PWM1_MATCHACTS0      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x900))
#define PWM1_MATCHACTS1      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x904))
#define PWM1_MATCHACTS2      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x908))
#define PWM1_MATCHACTS3      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x90C))
#define PWM1_MATCHACTS4      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x910))
#define PWM1_MATCHACTS5      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0x914))
#define PWM1_MATCHDACTS0     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xA00))
#define PWM1_MATCHDACTS1     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xA04))
#define PWM1_MATCHDACTS2     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xA08))
#define PWM1_MATCHDACTS3     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xA0C))
#define PWM1_MATCHDACTS4     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xA10))
#define PWM1_MATCHDACTS5     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xA14))

#define PWM1_INT_CLR_ENABLE  (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xF90))
#define PWM1_INT_SET_ENABLE  (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xF94))
#define PWM1_INT_STATUS      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xF98))
#define PWM1_INT_ENABLE      (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xF9C))
#define PWM1_INT_CLR_STATUS  (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFA0))
#define PWM1_INT_SET_STATUS  (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFA4))

#define PWM1_INTM_CLR_ENABLE (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFA8))
#define PWM1_INTM_SET_ENABLE (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFAC))
#define PWM1_INTM_STATUS     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFB0))
#define PWM1_INTM_ENABLE     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFB4))
#define PWM1_INTM_CLR_STATUS (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFB8))
#define PWM1_INTM_SET_STATUS (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFBC))

#define PWM1_INTC_CLR_ENABLE (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFC0))
#define PWM1_INTC_SET_ENABLE (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFC4))
#define PWM1_INTC_STATUS     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFC8))
#define PWM1_INTC_ENABLE     (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFCC))
#define PWM1_INTC_CLR_STATUS (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFD0))
#define PWM1_INTC_SET_STATUS (*(volatile unsigned long *)(PWM1_BASE_ADDR + 0xFD4))

#define PWM2_BASE_ADDR       0xE00C7000
#define PWM2_MODECTL         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x000))
#define PWM2_TRPCTL          (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x004))
#define PWM2_CAPCTL          (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x008))
#define PWM2_CAPTSRC         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x00C))
#define PWM2_CTRL            (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x010))
#define PWM2_PRD             (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x014))
#define PWM2_PRSC            (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x018))
#define PWM2_SYNDEL          (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x01C))
#define PWM2_CNT             (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x020))
#define PWM2_MATCHA0         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x100))
#define PWM2_MATCHA1         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x104))
#define PWM2_MATCHA2         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x108))
#define PWM2_MATCHA3         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x10C))
#define PWM2_MATCHA4         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x110))
#define PWM2_MATCHA5         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x114))
#define PWM2_MATCHDA0        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x200))
#define PWM2_MATCHDA1        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x204))
#define PWM2_MATCHDA2        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x208))
#define PWM2_MATCHDA3        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x20C))
#define PWM2_MATCHDA4        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x210))
#define PWM2_MATCHDA5        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x214))
#define PWM2_CAPT0           (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x300))
#define PWM2_CAPT1           (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x304))
#define PWM2_CAPT2           (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x308))
#define PWM2_CAPT3           (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x30C))

#define PWM2_MODECTLS        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x800))
#define PWM2_TRPCTLS         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x804))
#define PWM2_CAPTCTLS        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x808))
#define PWM2_CAPTSRCS        (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x80C))
#define PWM2_CTRLS           (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x810))
#define PWM2_PRDS            (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x814))
#define PWM2_PRSCS           (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x818))
#define PWM2_SYNDELS         (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x81C))
#define PWM2_MATCHACTS0      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x900))
#define PWM2_MATCHACTS1      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x904))
#define PWM2_MATCHACTS2      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x908))
#define PWM2_MATCHACTS3      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x90C))
#define PWM2_MATCHACTS4      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x910))
#define PWM2_MATCHACTS5      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0x914))
#define PWM2_MATCHDACTS0     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xA00))
#define PWM2_MATCHDACTS1     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xA04))
#define PWM2_MATCHDACTS2     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xA08))
#define PWM2_MATCHDACTS3     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xA0C))
#define PWM2_MATCHDACTS4     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xA10))
#define PWM2_MATCHDACTS5     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xA14))

#define PWM2_INT_CLR_ENABLE  (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xF90))
#define PWM2_INT_SET_ENABLE  (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xF94))
#define PWM2_INT_STATUS      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xF98))
#define PWM2_INT_ENABLE      (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xF9C))
#define PWM2_INT_CLR_STATUS  (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFA0))
#define PWM2_INT_SET_STATUS  (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFA4))

#define PWM2_INTM_CLR_ENABLE (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFA8))
#define PWM2_INTM_SET_ENABLE (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFAC))
#define PWM2_INTM_STATUS     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFB0))
#define PWM2_INTM_ENABLE     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFB4))
#define PWM2_INTM_CLR_STATUS (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFB8))
#define PWM2_INTM_SET_STATUS (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFBC))

#define PWM2_INTC_CLR_ENABLE (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFC0))
#define PWM2_INTC_SET_ENABLE (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFC4))
#define PWM2_INTC_STATUS     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFC8))
#define PWM2_INTC_ENABLE     (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFCC))
#define PWM2_INTC_CLR_STATUS (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFD0))
#define PWM2_INTC_SET_STATUS (*(volatile unsigned long *)(PWM2_BASE_ADDR + 0xFD4))

#define PWM3_BASE_ADDR       0xE00C8000
#define PWM3_MODECTL         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x000))
#define PWM3_TRPCTL          (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x004))
#define PWM3_CAPCTL          (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x008))
#define PWM3_CAPTSRC         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x00C))
#define PWM3_CTRL            (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x010))
#define PWM3_PRD             (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x014))
#define PWM3_PRSC            (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x018))
#define PWM3_SYNDEL          (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x01C))
#define PWM3_CNT             (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x020))
#define PWM3_MATCHA0         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x100))
#define PWM3_MATCHA1         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x104))
#define PWM3_MATCHA2         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x108))
#define PWM3_MATCHA3         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x10C))
#define PWM3_MATCHA4         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x110))
#define PWM3_MATCHA5         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x114))
#define PWM3_MATCHDA0        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x200))
#define PWM3_MATCHDA1        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x204))
#define PWM3_MATCHDA2        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x208))
#define PWM3_MATCHDA3        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x20C))
#define PWM3_MATCHDA4        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x210))
#define PWM3_MATCHDA5        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x214))
#define PWM3_CAPT0           (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x300))
#define PWM3_CAPT1           (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x304))
#define PWM3_CAPT2           (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x308))
#define PWM3_CAPT3           (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x30C))

#define PWM3_MODECTLS        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x800))
#define PWM3_TRPCTLS         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x804))
#define PWM3_CAPTCTLS        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x808))
#define PWM3_CAPTSRCS        (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x80C))
#define PWM3_CTRLS           (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x810))
#define PWM3_PRDS            (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x814))
#define PWM3_PRSCS           (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x818))
#define PWM3_SYNDELS         (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x81C))
#define PWM3_MATCHACTS0      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x900))
#define PWM3_MATCHACTS1      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x904))
#define PWM3_MATCHACTS2      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x908))
#define PWM3_MATCHACTS3      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x90C))
#define PWM3_MATCHACTS4      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x910))
#define PWM3_MATCHACTS5      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0x914))
#define PWM3_MATCHDACTS0     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xA00))
#define PWM3_MATCHDACTS1     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xA04))
#define PWM3_MATCHDACTS2     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xA08))
#define PWM3_MATCHDACTS3     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xA0C))
#define PWM3_MATCHDACTS4     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xA10))
#define PWM3_MATCHDACTS5     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xA14))

#define PWM3_INT_CLR_ENABLE  (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xF90))
#define PWM3_INT_SET_ENABLE  (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xF94))
#define PWM3_INT_STATUS      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xF98))
#define PWM3_INT_ENABLE      (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xF9C))
#define PWM3_INT_CLR_STATUS  (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFA0))
#define PWM3_INT_SET_STATUS  (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFA4))

#define PWM3_INTM_CLR_ENABLE (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFA8))
#define PWM3_INTM_SET_ENABLE (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFAC))
#define PWM3_INTM_STATUS     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFB0))
#define PWM3_INTM_ENABLE     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFB4))
#define PWM3_INTM_CLR_STATUS (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFB8))
#define PWM3_INTM_SET_STATUS (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFBC))

#define PWM3_INTC_CLR_ENABLE (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFC0))
#define PWM3_INTC_SET_ENABLE (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFC4))
#define PWM3_INTC_STATUS     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFC8))
#define PWM3_INTC_ENABLE     (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFCC))
#define PWM3_INTC_CLR_STATUS (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFD0))
#define PWM3_INTC_SET_STATUS (*(volatile unsigned long *)(PWM3_BASE_ADDR + 0xFD4))

/* Clock configuration Unit register base addr. */
#define CGU_BASE_ADDR        0xFFFF8000
#define CGU_FREQ_MON         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x14))
#define CGU_RDET             (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x18))
#define   LPOSC_PRESENT      (1<<0)
#define   XTAL_PRESENT       (1<<1)
#define   PLL_PRESENT        (1<<2)
#define   PLL120_PRESENT     (1<<3)
#define   PLL240_PRESENT     (1<<4)
#define   FDIV0_PRESENT      (1<<5)
#define   FDIV1_PRESENT      (1<<6)
#define   FDIV2_PRESENT      (1<<7)
#define   FDIV3_PRESENT      (1<<8)
#define   FDIV4_PRESENT      (1<<9)
#define   FDIV5_PRESENT      (1<<10)
#define   FDIV6_PRESENT      (1<<11)
#define CGU_OSC_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x1C))
#define CGU_OSC_CTRL         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x20))
#define CGU_PLL_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x24))
#define   PLL_LOCK           1
#define CGU_PLL_CTRL         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x28))
#define   PLL_XTAL_SEL       0x01000000
#define   MSEL_SHIFT         16
#define   P23EN              4
#define   PLL_PD             1
#define CGU_FDIV_STAT0       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x2C))
#define CGU_FDIV_CONF0       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x30))
#define CGU_FDIV_STAT1       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x34))
#define CGU_FDIV_CONF1       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x38))
#define CGU_FDIV_STAT2       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x3C))
#define CGU_FDIV_CONF2       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x40))
#define CGU_FDIV_STAT3       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x44))
#define CGU_FDIV_CONF3       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x48))
#define CGU_FDIV_STAT4       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x4C))
#define CGU_FDIV_CONF4       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x50))
#define CGU_FDIV_STAT5       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x54))
#define CGU_FDIV_CONF5       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x58))
#define CGU_FDIV_STAT6       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x5C))
#define CGU_FDIV_CONF6       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x60))

#define SAFE_CLK_STAT        (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x64))
#define SAFE_CLK_CONF        (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x68))
#define SYS_CLK_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x6C))
#define SYS_CLK_CONF         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x70))
#define   CLK_SEL_XTAL       0x01000000
#define   CLK_SEL_PLL        0x02000000
#define   CLK_SEL_PLL_120	 0x03000000
#define   CLK_SEL_PLL_240    0x04000000
#define   CLK_SEL_PLL_FDIV0	 0x05000000
#define   CLK_SEL_PLL_FDIV1  0x06000000
#define   CLK_SEL_PLL_FDIV2	 0x07000000
#define   CLK_SEL_PLL_FDIV3  0x08000000
#define   CLK_SEL_PLL_FDIV4	 0x09000000
#define   CLK_SEL_PLL_FDIV5  0x0A000000
#define   CLK_SEL_PLL_FDIV6  0x0B000000
#define   AUTOBLK            0x800
#define   DIV8               0x1C
#define   DIV7               0x18
#define   DIV6               0x14
#define   DIV5               0x10
#define   DIV4               0xC
#define   DIV3               0x8
#define   DIV2               0x4
#define   DIV1               0x0
#define PCR_CLK_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x74))
#define PCR_CLK_CONF         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x78))
#define IVNSS_CLK_STAT       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x7C))
#define IVNSS_CLK_CONF       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x80))
#define MSCSS_CLK_STAT       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x84))
#define MSCSS_CLK_CONF       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x88))

#define ICLK0_CLK_STAT       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x8C))
#define ICLK0_CLK_CONF       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x90))
#define UART_CLK_STAT        (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x94))
#define UART_CLK_CONF        (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x98))
#define SPI_CLK_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0x9C))
#define SPI_CLK_CONF         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xA0))
#define TMR_CLK_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xA4))
#define TMR_CLK_CONF         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xA8))
#define ADC_CLK_STAT         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xAC))
#define ADC_CLK_CONF         (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xB0))
#define CTEST_CLK_STAT       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xB4))
#define CTEST_CLK_CONF       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xB8))
#define ICLK1_CLK_STAT       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xBC))
#define ICLK1_CLK_CONF       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xC0))

#define CGU_INT_CLR_ENABLE   (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFD8))
#define CGU_INT_SET_ENABLE   (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFDC))
#define CGU_INT_STATUS       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFE0))
#define CGU_INT_ENABLE       (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFE4))
#define CGU_INT_CLR_STATUS   (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFE8))
#define CGU_INT_SET_STATUS   (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFEC))
#define CGU_BUS_DISABLE      (*(volatile unsigned long *)(CGU_BASE_ADDR + 0xFF4))

// CGU1 HAS BEEN ADDED  TO GENERATE CLOCKS FOR THE USB
/* Clock configuration Unit 1 register base addr. */
#define CGU1_BASE_ADDR       0xFFFFB000
#define CGU1_FREQ_MON        (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x14))
#define CGU1_RDET            (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x18))
#define CGU1_PLL_STAT        (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x1C))
#define CGU1_PLL_CTRL        (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x20))
#define CGU1_FDIV_STAT0      (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x24))
#define CGU1_FDIV_CONF0      (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x28))
#define USB_CLK_STAT         (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x2C))
#define USB_CLK_CONF         (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x30))
#define USB_I2C_CLK_STAT     (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x34))
#define USB_I2C_CLK_CONF     (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x38))
#define OUT_CLK_STAT         (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x3C))
#define OUT_CLK_CONF         (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0x40))
#define   CLK_SEL_ICLK0       0x00000000
#define   CLK_SEL_ICLK1       0x01000000
#define CGU1_INT_CLR_ENABLE   (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFD8))
#define CGU1_INT_SET_ENABLE   (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFDC))
#define CGU1_INT_STATUS       (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFE0))
#define CGU1_INT_ENABLE       (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFE4))
#define CGU1_INT_CLR_STATUS   (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFE8))
#define CGU1_INT_SET_STATUS   (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFEC))
#define CGU1_BUS_DISABLE      (*(volatile unsigned long *)(CGU1_BASE_ADDR + 0xFF4))

/* Reset Generation Unit register base addr. */
#define RGU_BASE_ADDR        0xFFFF9000
#define RGU_RESET_CTRL0      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x100))
#define RGU_RESET_CTRL1      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x104))
#define RGU_RESET_STAT0      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x110))
#define RGU_RESET_STAT1      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x114))
#define RGU_RESET_STAT2      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x118))
#define RGU_RESET_STAT3      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x11C))

#define RGU_RST_ACTIVE_STAT0 (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x150))
#define RGU_RST_ACTIVE_STAT1 (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x154))
#define RGU_RST_SRC          (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x404))
#define RGU_PCR_RST_SRC      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x408))
#define RGU_COLD_RST_SRC     (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x40C))
#define RGU_WARM_RST_SRC     (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x410))

#define RGU_SCU_RST_SRC      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x480))
#define RGU_CFID_RST_SRC     (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x484))
#define RGU_FMC_RST_SRC      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x490))
#define RGU_EMC_RST_SRC      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x494))
#define RGU_SMC_SRC          (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x498))
#define RGU_GESS_A2V_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4A0))
#define RGU_PESS_A2V_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4A4))
#define RGU_GPIO_RST_SRC     (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4A8))
#define RGU_UART_RST_SRC     (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4AC))
#define RGU_TMR_RST_SRC      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4B0))
#define RGU_SPI_RST_SRC      (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4B4))

#define RGU_IVNSS_A2V_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4B8))
#define RGU_IVNSS_CAN_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4BC))
#define RGU_IVNSS_LIN_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4C0))
#define RGU_MSCSS_A2V_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4C4))
#define RGU_MSCSS_PWM_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4C8))
#define RGU_MSCSS_ADC_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4CC))
#define RGU_MSCSS_TMR_RST_SRC (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4D0))
#define RGU_VIC_RST_SRC       (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4F0))
#define RGU_AHB_RST_SRC       (*(volatile unsigned long *)(RGU_BASE_ADDR + 0x4F4))
#define RGU_BUS_DISABLE       (*(volatile unsigned long *)(RGU_BASE_ADDR + 0xFF4))

/* Power Management Unit register base addr. */
#define PMU_BASE_ADDR        0xFFFFA000
#define PMU_PM                (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x000))
#define PMU_BASE_STAT         (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x004))
#define PMU_CLK_CFG_SAFE      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x100))
#define PMU_CLK_STAT_SAFE     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x104))
#define PMU_CLK_CFG_CPU       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x200))
#define PMU_CLK_STAT_CPU      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x204))
#define PMU_CLK_CFG_SYS       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x208))
#define PMU_CLK_STAT_SYS      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x20C))
#define PMU_CLK_CFG_PCR       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x210))
#define PMU_CLK_STAT_PCR      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x214))

#define PMU_CLK_CFG_FMC       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x218))
#define PMU_CLK_STAT_FMC      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x21C))
#define PMU_CLK_CFG_RAM0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x220))
#define PMU_CLK_STAT_RAM0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x224))
#define PMU_CLK_CFG_RAM1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x228))
#define PMU_CLK_STAT_RAM1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x22C))

#define PMU_CLK_CFG_SMC       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x230))
#define PMU_CLK_STAT_SMC      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x234))
#define PMU_CLK_CFG_GESS      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x238))
#define PMU_CLK_STAT_GESS     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x23C))
#define PMU_CLK_CFG_VIC       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x240))
#define PMU_CLK_STAT_VIC      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x244))
#define PMU_CLK_CFG_PESS      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x248))
#define PMU_CLK_STAT_PESS     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x24C))

#define PMU_CLK_CFG_GPIO0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x250))
#define PMU_CLK_STAT_GPIO0    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x254))
#define PMU_CLK_CFG_GPIO1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x258))
#define PMU_CLK_STAT_GPIO1    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x25C))
#define PMU_CLK_CFG_GPIO2     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x260))
#define PMU_CLK_STAT_GPIO2    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x264))
#define PMU_CLK_CFG_GPIO3     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x268))
#define PMU_CLK_STAT_GPIO3    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x26C))
#define PMU_CLK_CFG_IVNSSA    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x270))
#define PMU_CLK_STAT_IVNSSA   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x274))
#define PMU_CLK_CFG_MSCSSA    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x278))
#define PMU_CLK_STAT_MSCSSA   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x27C))

#define PMU_CLK_CFG_GPIO4     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x280))
#define PMU_CLK_STAT_GPIO4    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x284))
#define PMU_CLK_CFG_GPIO5     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x288))
#define PMU_CLK_STAT_GPIO5    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x28C))
#define PMU_CLK_CFG_DMA       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x290))
#define PMU_CLK_STAT_DMA      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x294))
#define PMU_CLK_CFG_USB       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x298))
#define PMU_CLK_STAT_USB      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x29C))

#define PMU_CLK_CFG_PCR_IP    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x300))
#define PMU_CLK_STAT_PCR_IP   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x304))

#define PMU_CLK_CFG_IVNSS_VPB  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x400))
#define PMU_CLK_STAT_IVNSS_VPB (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x404))
#define PMU_CLK_CFG_CANCA     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x408))
#define PMU_CLK_STAT_CANCA    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x40C))
#define PMU_CLK_CFG_CANC0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x410))
#define PMU_CLK_STAT_CANC0    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x414))
#define PMU_CLK_CFG_CANC1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x418))
#define PMU_CLK_STAT_CANC1    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x41C))

#define PMU_CLK_CFG_I2C0       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x420))
#define PMU_CLK_STAT_I2C0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x424))
#define PMU_CLK_CFG_I2C1       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x428))
#define PMU_CLK_STAT_I2C1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x42C))
//
#define PMU_CLK_CFG_LIN0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x440))
#define PMU_CLK_STAT_LIN0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x444))
#define PMU_CLK_CFG_LIN1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x448))
#define PMU_CLK_STAT_LIN1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x44C))

#define PMU_CLK_CFG_MSCSS_VPB  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x500))
#define PMU_CLK_STAT_MSCSS_VPB (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x504))
#define PMU_CLK_CFG_MTMR0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x508))
#define PMU_CLK_STAT_MTMR0    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x50C))
#define PMU_CLK_CFG_MTMR1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x510))
#define PMU_CLK_STAT_MTMR1    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x514))
#define PMU_CLK_CFG_PWM0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x518))
#define PMU_CLK_STAT_PWM0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x51C))
#define PMU_CLK_CFG_PWM1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x520))
#define PMU_CLK_STAT_PWM1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x524))
#define PMU_CLK_CFG_PWM2      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x528))
#define PMU_CLK_STAT_PWM2     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x52C))
#define PMU_CLK_CFG_PWM3      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x530))
#define PMU_CLK_STAT_PWM3     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x534))

#define PMU_CLK_CFG_ADC0_VPB  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x538))
#define PMU_CLK_STAT_ADC0_VPB (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x53C))

#define PMU_CLK_CFG_ADC1_VPB  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x540))
#define PMU_CLK_STAT_ADC1_VPB (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x544))
#define PMU_CLK_CFG_ADC2_VPB  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x548))
#define PMU_CLK_STAT_ADC2_VPB (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x54C))

#define PMU_CLK_CFG_QEI       (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x550))
#define PMU_CLK_STAT_QEI      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x554))

#define PMU_CLK_CFG_OUT_CLK   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x600))
#define PMU_CLK_STAT_OUT_CLK  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x604))

#define PMU_CLK_CFG_UART0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x700))
#define PMU_CLK_STAT_UART0    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x704))
#define PMU_CLK_CFG_UART1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x708))
#define PMU_CLK_STAT_UART1    (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x70C))

#define PMU_CLK_CFG_SPI0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x800))
#define PMU_CLK_STAT_SPI0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x804))
#define PMU_CLK_CFG_SPI1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x808))
#define PMU_CLK_STAT_SPI1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x80C))
#define PMU_CLK_CFG_SPI2      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x810))
#define PMU_CLK_STAT_SPI2     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x814))

#define PMU_CLK_CFG_TMR0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x900))
#define PMU_CLK_STAT_TMR0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x904))
#define PMU_CLK_CFG_TMR1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x908))
#define PMU_CLK_STAT_TMR1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x90C))
#define PMU_CLK_CFG_TMR2      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x910))
#define PMU_CLK_STAT_TMR2     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x914))
#define PMU_CLK_CFG_TMR3      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x918))
#define PMU_CLK_STAT_TMR3     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0x91C))

#define PMU_CLK_CFG_ADC0      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xA00))
#define PMU_CLK_STAT_ADC0     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xA04))

#define PMU_CLK_CFG_ADC1      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xA08))
#define PMU_CLK_STAT_ADC1     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xA0C))
#define PMU_CLK_CFG_ADC2      (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xA10))
#define PMU_CLK_STAT_ADC2     (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xA14))

#define PMU_CLK_CFG_TSSHELL   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xB00))
#define PMU_CLK_STAT_TSSHELL  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xB04))

#define PMU_CLK_CFG_USB_I2C   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xC00))
#define PMU_CLK_STAT_USB_I2C  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xC04))

#define PMU_CLK_CFG_USB_CLK   (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xD00))
#define PMU_CLK_STAT_USB_CLK  (*(volatile unsigned long *)(PMU_BASE_ADDR + 0xD04))

/* General-purpose DMA Controller */
#define DMA_BASE_ADDR		0xE0140000
#define GPDMA_INT_STAT         (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x000))
#define GPDMA_INT_TCSTAT       (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x004))
#define GPDMA_INT_TCCLR        (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x008))
#define GPDMA_INT_ERR_STAT     (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x00C))
#define GPDMA_INT_ERR_CLR      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x010))
#define GPDMA_RAW_INT_TCSTAT   (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x014))
#define GPDMA_RAW_INT_ERR_STAT (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x018))
#define GPDMA_ENABLED_CHNS     (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x01C))
#define GPDMA_SOFT_BREQ        (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x020))
#define GPDMA_SOFT_SREQ        (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x024))
#define GPDMA_SOFT_LBREQ       (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x028))
#define GPDMA_SOFT_LSREQ       (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x02C))
#define GPDMA_CONFIG           (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x030))
#define GPDMA_SYNC             (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x034))

/* DMA channel 0 registers */
#define GPDMA_CH0_SRC      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x100))
#define GPDMA_CH0_DEST     (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x104))
#define GPDMA_CH0_LLI      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x108))
#define GPDMA_CH0_CTRL     (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x10C))
#define GPDMA_CH0_CFG      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x110))

/* DMA channel 1 registers */
#define GPDMA_CH1_SRC      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x120))
#define GPDMA_CH1_DEST     (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x124))
#define GPDMA_CH1_LLI      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x128))
#define GPDMA_CH1_CTRL     (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x12C))
#define GPDMA_CH1_CFG      (*(volatile unsigned long *)(DMA_BASE_ADDR + 0x130))


/* USB Controller */
#define USB_BASE_ADDR		0xE0100200		/* USB Device Base Address */

/* USB Device Interrupt Registers */
#define DEV_INT_STAT    (*(volatile unsigned long *)(USB_BASE_ADDR + 0x00))
#define DEV_INT_EN      (*(volatile unsigned long *)(USB_BASE_ADDR + 0x04))
#define DEV_INT_CLR     (*(volatile unsigned long *)(USB_BASE_ADDR + 0x08))
#define DEV_INT_SET     (*(volatile unsigned long *)(USB_BASE_ADDR + 0x0C))
#define DEV_INT_PRIO    (*(volatile unsigned long *)(USB_BASE_ADDR + 0x2C))

/* USB Device Endpoint Interrupt Registers */
#define EP_INT_STAT     (*(volatile unsigned long *)(USB_BASE_ADDR + 0x30))
#define EP_INT_EN       (*(volatile unsigned long *)(USB_BASE_ADDR + 0x34))
#define EP_INT_CLR      (*(volatile unsigned long *)(USB_BASE_ADDR + 0x38))
#define EP_INT_SET      (*(volatile unsigned long *)(USB_BASE_ADDR + 0x3C))
#define EP_INT_PRIO     (*(volatile unsigned long *)(USB_BASE_ADDR + 0x40))

/* USB Device Endpoint Realization Registers */
#define REALIZE_EP      (*(volatile unsigned long *)(USB_BASE_ADDR + 0x44))
#define EP_INDEX        (*(volatile unsigned long *)(USB_BASE_ADDR + 0x48))
#define MAXPACKET_SIZE  (*(volatile unsigned long *)(USB_BASE_ADDR + 0x4C))

/* USB Device Command Reagisters */
#define CMD_CODE        (*(volatile unsigned long *)(USB_BASE_ADDR + 0x10))
#define CMD_DATA        (*(volatile unsigned long *)(USB_BASE_ADDR + 0x14))

/* USB Device Data Transfer Registers */
#define RX_DATA         (*(volatile unsigned long *)(USB_BASE_ADDR + 0x18))
#define TX_DATA         (*(volatile unsigned long *)(USB_BASE_ADDR + 0x1C))
#define RX_PLENGTH      (*(volatile unsigned long *)(USB_BASE_ADDR + 0x20))
#define TX_PLENGTH      (*(volatile unsigned long *)(USB_BASE_ADDR + 0x24))
#define USB_CTRL        (*(volatile unsigned long *)(USB_BASE_ADDR + 0x28))

/* USB Device DMA Registers */
#define DMA_REQ_STAT        (*(volatile unsigned long *)(USB_BASE_ADDR + 0x50))
#define DMA_REQ_CLR         (*(volatile unsigned long *)(USB_BASE_ADDR + 0x54))
#define DMA_REQ_SET         (*(volatile unsigned long *)(USB_BASE_ADDR + 0x58))
#define UDCA_HEAD           (*(volatile unsigned long *)(USB_BASE_ADDR + 0x80))
#define EP_DMA_STAT         (*(volatile unsigned long *)(USB_BASE_ADDR + 0x84))
#define EP_DMA_EN           (*(volatile unsigned long *)(USB_BASE_ADDR + 0x88))
#define EP_DMA_DIS          (*(volatile unsigned long *)(USB_BASE_ADDR + 0x8C))
#define DMA_INT_STAT        (*(volatile unsigned long *)(USB_BASE_ADDR + 0x90))
#define DMA_INT_EN          (*(volatile unsigned long *)(USB_BASE_ADDR + 0x94))
#define EOT_INT_STAT        (*(volatile unsigned long *)(USB_BASE_ADDR + 0xA0))
#define EOT_INT_CLR         (*(volatile unsigned long *)(USB_BASE_ADDR + 0xA4))
#define EOT_INT_SET         (*(volatile unsigned long *)(USB_BASE_ADDR + 0xA8))
#define NDD_REQ_INT_STAT    (*(volatile unsigned long *)(USB_BASE_ADDR + 0xAC))
#define NDD_REQ_INT_CLR     (*(volatile unsigned long *)(USB_BASE_ADDR + 0xB0))
#define NDD_REQ_INT_SET     (*(volatile unsigned long *)(USB_BASE_ADDR + 0xB4))
#define SYS_ERR_INT_STAT    (*(volatile unsigned long *)(USB_BASE_ADDR + 0xB8))
#define SYS_ERR_INT_CLR     (*(volatile unsigned long *)(USB_BASE_ADDR + 0xBC))
#define SYS_ERR_INT_SET     (*(volatile unsigned long *)(USB_BASE_ADDR + 0xC0))

/* USB Host and OTG registers are for LPC292x/LPC293x only */
/* USB Host Controller */
#define USBHC_BASE_ADDR		0xE0100000
#define HC_REVISION         (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x00))
#define HC_CONTROL          (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x04))
#define HC_CMD_STAT         (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x08))
#define HC_INT_STAT         (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x0C))
#define HC_INT_EN           (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x10))
#define HC_INT_DIS          (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x14))
#define HC_HCCA             (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x18))
#define HC_PERIOD_CUR_ED    (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x1C))
#define HC_CTRL_HEAD_ED     (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x20))
#define HC_CTRL_CUR_ED      (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x24))
#define HC_BULK_HEAD_ED     (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x28))
#define HC_BULK_CUR_ED      (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x2C))
#define HC_DONE_HEAD        (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x30))
#define HC_FM_INTERVAL      (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x34))
#define HC_FM_REMAINING     (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x38))
#define HC_FM_NUMBER        (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x3C))
#define HC_PERIOD_START     (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x40))
#define HC_LS_THRHLD        (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x44))
#define HC_RH_DESCA         (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x48))
#define HC_RH_DESCB         (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x4C))
#define HC_RH_STAT          (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x50))
#define HC_RH_PORT_STAT1    (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x54))
#define HC_RH_PORT_STAT2    (*(volatile unsigned long *)(USBHC_BASE_ADDR + 0x58))

/* USB OTG Controller */
#define USBOTG_BASE_ADDR	0xE0100100
#define OTG_INT_STAT        (*(volatile unsigned long *)(USBOTG_BASE_ADDR + 0x00))
#define OTG_INT_EN          (*(volatile unsigned long *)(USBOTG_BASE_ADDR + 0x04))
#define OTG_INT_SET         (*(volatile unsigned long *)(USBOTG_BASE_ADDR + 0x08))
#define OTG_INT_CLR         (*(volatile unsigned long *)(USBOTG_BASE_ADDR + 0x0C)) 
#define OTG_STAT_CTRL       (*(volatile unsigned long *)(USBOTG_BASE_ADDR + 0x10))
#define OTG_TIMER           (*(volatile unsigned long *)(USBOTG_BASE_ADDR + 0x14))

#define USBOTG_I2C_BASE_ADDR	0xE0100300
#define OTG_I2C_RX          (*(volatile unsigned long *)(USBOTG_I2C_BASE_ADDR + 0x00))
#define OTG_I2C_TX          (*(volatile unsigned long *)(USBOTG_I2C_BASE_ADDR + 0x00))
#define OTG_I2C_STS         (*(volatile unsigned long *)(USBOTG_I2C_BASE_ADDR + 0x04))
#define OTG_I2C_CTL         (*(volatile unsigned long *)(USBOTG_I2C_BASE_ADDR + 0x08))
#define OTG_I2C_CLKHI       (*(volatile unsigned long *)(USBOTG_I2C_BASE_ADDR + 0x0C))
#define OTG_I2C_CLKLO       (*(volatile unsigned long *)(USBOTG_I2C_BASE_ADDR + 0x10))

#define USBOTG_CLK_BASE_ADDR	0xE0100FF0
#define OTG_CLK_CTRL        (*(volatile unsigned long *)(USBOTG_CLK_BASE_ADDR + 0x04))
#define OTG_CLK_STAT        (*(volatile unsigned long *)(USBOTG_CLK_BASE_ADDR + 0x08))

/* Vector Interrupt Controller register base addr. */
#define VIC_BASE_ADDR        0xFFFFF000
#define INT_PRIOR_MASK_0     (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x000))
#define INT_PRIOR_MASK_1     (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x004))
#define INT_VECTOR_0         (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x100))
#define INT_VECTOR_1         (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x104))
#define INT_PENDING_1_31     (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x200))
#define INT_PENDING_32_53    (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x204))
#define INT_FEATURES         (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x300))
#define INT_REQUEST_(x)      (*(volatile unsigned long *)(VIC_BASE_ADDR + 0x400 + ((x)*4)))
#define INT_REQUEST_1        INT_REQUEST_( 1)
#define INT_REQUEST_2        INT_REQUEST_( 2)
#define INT_REQUEST_3        INT_REQUEST_( 3)
#define INT_REQUEST_4        INT_REQUEST_( 4)
#define INT_REQUEST_5        INT_REQUEST_( 5)
#define INT_REQUEST_6        INT_REQUEST_( 6)
#define INT_REQUEST_7        INT_REQUEST_( 7)
#define INT_REQUEST_8        INT_REQUEST_( 8)
#define INT_REQUEST_9        INT_REQUEST_( 9)
#define INT_REQUEST_10       INT_REQUEST_(10)
#define INT_REQUEST_11       INT_REQUEST_(11)
#define INT_REQUEST_12       INT_REQUEST_(12)
#define INT_REQUEST_13       INT_REQUEST_(13)
#define INT_REQUEST_14       INT_REQUEST_(14)
#define INT_REQUEST_15       INT_REQUEST_(15)
#define INT_REQUEST_16       INT_REQUEST_(16)
#define INT_REQUEST_17       INT_REQUEST_(17)
#define INT_REQUEST_18       INT_REQUEST_(18)
#define INT_REQUEST_19       INT_REQUEST_(19)
#define INT_REQUEST_20       INT_REQUEST_(20)
#define INT_REQUEST_21       INT_REQUEST_(21)
#define INT_REQUEST_22       INT_REQUEST_(22)
#define INT_REQUEST_23       INT_REQUEST_(23)
#define INT_REQUEST_24       INT_REQUEST_(24)
#define INT_REQUEST_25       INT_REQUEST_(25)
#define INT_REQUEST_26       INT_REQUEST_(26)
#define INT_REQUEST_27       INT_REQUEST_(27)
#define INT_REQUEST_28       INT_REQUEST_(28)
#define INT_REQUEST_29       INT_REQUEST_(29)
#define INT_REQUEST_30       INT_REQUEST_(30)
#define INT_REQUEST_31       INT_REQUEST_(31)
#define INT_REQUEST_32       INT_REQUEST_(32)
#define INT_REQUEST_33       INT_REQUEST_(33)
#define INT_REQUEST_34       INT_REQUEST_(34)
#define INT_REQUEST_35       INT_REQUEST_(35)
#define INT_REQUEST_36       INT_REQUEST_(36)
#define INT_REQUEST_37       INT_REQUEST_(37)
#define INT_REQUEST_38       INT_REQUEST_(38)
#define INT_REQUEST_39       INT_REQUEST_(39)
#define INT_REQUEST_40       INT_REQUEST_(40)
#define INT_REQUEST_41       INT_REQUEST_(41)
#define INT_REQUEST_42       INT_REQUEST_(42)
#define INT_REQUEST_43       INT_REQUEST_(43)
#define INT_REQUEST_44       INT_REQUEST_(44)
#define INT_REQUEST_45       INT_REQUEST_(45)
#define INT_REQUEST_46       INT_REQUEST_(46)
#define INT_REQUEST_47       INT_REQUEST_(47)
#define INT_REQUEST_48       INT_REQUEST_(48)
#define INT_REQUEST_49       INT_REQUEST_(49)
#define INT_REQUEST_50       INT_REQUEST_(50)
#define INT_REQUEST_51       INT_REQUEST_(51)
#define INT_REQUEST_52       INT_REQUEST_(52)
#define INT_REQUEST_53       INT_REQUEST_(53)
#define INT_REQUEST_54       INT_REQUEST_(54)
#define INT_REQUEST_55       INT_REQUEST_(55)


#endif  // __LPC29XX_H
