 /****************************************************************
 *		Tone Generator
 *
 *
 *
 *
 *
 ****************************************************************/


// ----- Parameters and Variables for Sine Wave Generator ----- 

#include <stdio.h>                         /* standard I/O .h-file */
#include <LPC23xx.H>                       /* LPC23xx definitions  */
#include <math.h>

extern short AD_last;

int volatile timeval;

void init_timer (void);
 
unsigned long OutFreq = 20000;       /* Output Frequency (Range  1Hz - 1000Hz) */
#define OutAmpl 600                 /* Output Amplitute (Range  0 - 0.99)     */
#define PI  3.1415926
#define SAMPLEFreq  50000             /* Timer  Reload Frequency               */

struct tone  {                      /* struct for Sine Wave Generator Signal  */
  float  cos;                         /* cosine factor                          */
  float   y1;                      	  /* y[-1] value                            */
  float   y2;                         /* y[-2] value                            */
};                                                                            

static unsigned int oldval;  
int diff;

int  NewFreq;                       /* New Frequency Setup indication         */

long tval;
signed char cval;
struct tone Tone;

extern void LED_On (unsigned int num);
extern void LED_Off (unsigned int num);

/*
 * Generate Sine Wave Tone
 */
static void Generate_Sine (struct tone *t)  {
  float  y;
  y = (t->cos*(t->y1)) - t->y2;
  t->y2 = t->y1;
  t->y1 = y;
  tval = t->y1;

}


/*
 * Initialize the Sine Wave Tone Generator
 */
__inline void Init_Sine (int OutFreq) {
  Tone.cos = 2*(cos (2*PI*((float)OutFreq/SAMPLEFreq))) ;
  Tone.y1  = 0;
  Tone.y2  = (sin (2*PI*((float)OutFreq/SAMPLEFreq)) * OutAmpl*32768);

}


/* Timer Counter 1 Interrupt executes each 10ms @ 60 MHz CPU Clock */
__irq void tc1 (void) {
  ++timeval;
  LED_On (1);
  FIO1SET = (1 << 18);
  diff = AD_last - oldval;

  if (diff > 6 || diff < -6)  
  	{
    oldval = AD_last;
    NewFreq = (AD_last<<4); // temp potentiometer control
	}
  if (NewFreq)  	 /* The frequency changes when a new ADC value is measured */
  {   
    LED_On (0);
	Init_Sine (NewFreq);
    NewFreq = 0;
	LED_Off (0);
  }

  Generate_Sine (&Tone);
  DACR = ((tval >> 10) & 0xFFC0) + 0x8000;   
  T1IR        = 1;                             /* Clear interrupt flag        */
  VICVectAddr = 0;                             /* Acknowledge Interrupt       */  
  LED_Off (1);
}


/* Setup the Timer Counter 1 Interrupt (40.00 khz)*/
void init_timer (void) {
//  T0MR0 = 1874;                                /* 125uSec = 1875-1 counts (15Mhz)  */
  T1MR0 = 599;                                /* 50 uSec = 600-1 counts (20Khz @ 12 mhz)  */
  T1MCR = 3;                                   /* Interrupt and Reset on MR0  */
  T1TCR = 1;                                   /* Timer1 Enable               */
  VICVectAddr5 = (unsigned long)tc1;           /* set interrupt vector   */
  VICVectCntl5 = 12; 	                    /* use it for Timer1 Interrupt */
  VICIntEnable  = (1  << 5);                   /* Enable Timer1 Interrupt     */
}
