/***************************************************
*  VIV.c
*
*
*   VIC initialization
*	- Timer priority 0 (highest)
*	- UART1 priority 1
*
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.
*
*****************************************************/

#include "LPC230x.H"                   /* LPC21xx definitions */
#include "Timer.h"
#include "serial.h"


void VIC_init (void)  
{
	VICVectAddr4 = (unsigned long)tc0;	 		//ISR pointer for the timer       
	VICVectAddr7 = (unsigned long)serial_1;		//ISR pointer for UART1
	VICVectCntl4 =0;							// Timer is highest priority

// all other interrupt sources are at lowest level of 0xF and have no ISR pointer

	VICIntSelect = 0x00000000; 					// 0 = IRQ, 1 = FIQ	
	VICIntEnable = 0x00040090;                  // Enable Timer0, UART1 Interrupt,ADC
}



