/****************************************************************************
* FILENAME:      lpc2200nand.h                                              *
*                                                                           *
* VERSION:       V1.0                                                       *
*                                                                           *
* DESCRIPTION:   Header File for lpc2200Nand.c                              *  
*                                                                           *
* TOOLS:         ARM Development Suite ADS1.2                               *
*                Flash Magic V3.33.157                                      *
*                                                                           *
*                                                                           *
* REVISION HISTORY:                                                         *
* Version  Author          Date          Remarks                            *
* 1.0      Xiaodong Xie    12/12/2006    Created                            *         
*****************************************************************************/

/**
 * @file
 * LPC2200 interface to NAND flash reference design Header File
 */

#ifndef _NAND_FLASH_H_
#define _NAND_FLASH_H_

//NAND Flash command set definition
#define	NAND_CMD_BLOCKERASE_I	0x60
#define	NAND_CMD_BLOCKERASE_II	0xd0
#define	NAND_CMD_PAGEPROG_I		0x80
#define	NAND_CMD_PAGEPROG_II	0x10
#define	NAND_CMD_AREA_A			0x00
#define	NAND_CMD_AREA_B			0x01
#define	NAND_CMD_AREA_C			0x50
#define	NAND_CMD_RD_STATUS		0x70
#define	NAND_CMD_RD_DONE		0x00
#define	NAND_CMD_RD_ID			0x90
#define	NAND_CMD_RESET			0xff
#define	NAND_CMD_COPYBACK_I		0x00
#define	NAND_CMD_COPYBACK_II	0x8a


//connect LPC2214 Addr1 and Addr2 to NAND CLE and ALE respectively
#define	NAND_DATA				0x80000000
#define	NAND_ALE				0x80000004
#define	NAND_CLE				0x80000008

//Functions of Hardware Dependent Layer
//define macro for NAND flash basic operation
//LPC2200 GPIO for NAND flash interface
#define nandOpen()	  			( IO0CLR |= ( 1<<19 ) )						//pin for CS, change here!!!
#define nandClose()				( IO0SET |= ( 1<<19 ) )
#define	nandRd_ReadyBusy()		( IO0PIN & ( 1<<18 ) )
#define	nandWr_Cmd(nand_cmd)	*(volatile unsigned char *)NAND_CLE = (nand_cmd)
#define	nandWr_Addr(nand_addr)	*(volatile unsigned char *)NAND_ALE = (nand_addr)
#define	nandWr_Data(nand_data)	*(volatile unsigned char *)NAND_DATA = (nand_data)
#define	nandRd_Data()			*(volatile unsigned char *)NAND_DATA

//Functions of Hardware Independent Layer
extern void nandFlashInit( void );
extern unsigned int nandFlashReadID( void );
extern unsigned char nandFlashBlockErase( unsigned int NandAddr );
extern unsigned char nandFlashPageWrite( unsigned int NandAddr , unsigned char *Buffer );
extern void nandFlashPageRead( unsigned int NandAddr , unsigned char *Buffer );
extern unsigned char nandFlashSpareWrite( unsigned int NandAddr , unsigned char *Buffer );
extern void nandFlashSpareRead( unsigned int NandAddr , unsigned char *Buffer );
extern unsigned char nandFlashStatusRegRead( void );
extern unsigned char nandFlashReset( void );
extern unsigned char nandFlashCopyBack( unsigned int SrcAddr , unsigned int DestAddr );

#endif