/*==================================================================================================
*   (c) Copyright 2014-2016 Freescale Semiconductor, Inc.
*   Copyright 2019 NXP
*   NXP Confidential. This software is owned or controlled by NXP and may only be used strictly
*   in accordance with the applicable license terms. By expressly accepting
*   such terms or by downloading, installing, activating and/or otherwise using
*   the software, you are agreeing that you have read, and that you agree to
*   comply with and are bound by, such license terms. If you do not agree to
*   be bound by the applicable license terms, then you may not retain,
*   install, activate or otherwise use the software.
==================================================================================================*/

/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "pit.h"
#include <MPC577xC.h>
/*==================================================================================================
*                                       GLOBAL FUNCTIONS
==================================================================================================*/
uint32_t pit0_read_values_ns(void)
{
	return ((uint32_t)0xFFFFFFFF - (PIT.TIMER[0].CVAL.R)* SCALE_TO_NS);
}

void pit0_start_wait_ns(uint32_t time_ns)
{
	PIT.TIMER[0].TCTRL.B.TEN = 0;	// disable PIT first
	PIT.MCR.B.MDIS = 0;
	PIT.TIMER[0].LDVAL.R = ((100 * (time_ns / 1000)) - 1); // timer clk is 100 MHz (period 10 ns)
	PIT.TIMER[0].TCTRL.B.TEN = 1;
}

void pit0_stop(void)
{
	PIT.TIMER[0].TCTRL.B.TEN = 0;
}

uint8_t pit0_read_flag(void)
{

	if(PIT.TIMER[0].TFLG.B.TIF)
	{
		//pit_stop();
		PIT.TIMER[0].TFLG.B.TIF = 1; // Clear the timer flag
		return 1;
	}
	return 0;

}

void pit0_irq_config(uint8_t irq)
{
	PIT.TIMER[0].TCTRL.B.TIE = irq;
}
