/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __TEST_ECDOUBLEMUL_H
#define __TEST_ECDOUBLEMUL_H

#include <stdint.h>

uint32_t test_ecddoublemul_base[2][2 * 8] = {
    {0xD898C296, 0xF4A13945, 0x2DEB33A0, 0x77037D81, 0x63A440F2, 0xF8BCE6E5, 0xE12C4247, 0x6B17D1F2, 0x37BF51F5,
     0xCBB64068, 0x6B315ECE, 0x2BCE3357, 0x7C0F9E16, 0x8EE7EB4A, 0xFE1A7F9B, 0x4FE342E2},
    {0xDC98970E, 0x9002FB08, 0x7200358A, 0xE7F40934, 0xA4340190, 0x99E6594B, 0xBA3EDAF, 0xD72CEB43, 0x866D8ED3,
     0xC7B548E9, 0xE27C8238, 0x537D2761, 0x95434984, 0x735746C, 0xDBAACE42, 0xCA5129B7}};

uint32_t test_ecddoublemul_scalars[128][2 * 8] = {
    {0xFE0F4AB5, 0xB5B2B15A, 0x53BE6777, 0x3BAD70D0, 0x8D4FC6D4, 0xE1AA11CB, 0x247C7AAF, 0x5BE45242, 0x406FB795,
     0x9C8C50B8, 0x9F04856F, 0x54DF21DD, 0xBCEDCF1D, 0x93D539D8, 0x5A25C0FF, 0x310A13B9},
    {0xCC286B24, 0x75CEC37D, 0xC03C1001, 0x2B13FEAF, 0x98F5006F, 0xF1608092, 0x280C6C16, 0x3C52250B, 0x8D94861E,
     0xF378517A, 0x8633883F, 0x645CAD99, 0x9830199, 0xD8235F1A, 0x9DACBE98, 0x333D4B6B},
    {0x9B97A8A6, 0x1C3AA2D3, 0x96B6717B, 0xE1756873, 0x42F272, 0x268456D1, 0xA2BAA966, 0x2018427A, 0xCA9B452F,
     0x1BA412F7, 0xD1CD90A1, 0x6D04A684, 0x542554EA, 0xE4B1042B, 0x3840986E, 0x71139F44},
    {0x5A650C09, 0xF34D31A6, 0x2F0CCD05, 0x2381D1C4, 0x6CE96EBC, 0xF3A75D9E, 0x235DD8D9, 0xEEAB6EC, 0xD1409C6,
     0x98E01974, 0x68899F40, 0x8E7A18C7, 0x8109D28D, 0x3F424906, 0x15F4AE8B, 0x82E0C693},
    {0x5BD66980, 0x1B4F98C7, 0xEFCDA2A8, 0xB7E42B36, 0x79FC4370, 0xC146F5B4, 0xB3AAAD6C, 0x56C11E17, 0x174C6802,
     0x6C4F9C12, 0x3716E38, 0x1987499F, 0x85927E5F, 0x80823CBE, 0x7054C86F, 0x77CBE32},
    {0x338FC3B8, 0xA4B989B, 0xAC0F8B33, 0x8B61BA0F, 0x985DCB86, 0x9F217F33, 0x65B6112A, 0x54A9553, 0x36CD36E0,
     0x3000D2AB, 0x21F54EA2, 0x3D494F2E, 0xDF0A843B, 0x148B2B8C, 0x6336009D, 0xE0DFA08F},
    {0xAF57D557, 0x3FB14B03, 0x99690366, 0xCE760F2F, 0x598F80D3, 0xB414D52A, 0x14879925, 0x4260CE6D, 0xF0F41ED5,
     0x406E4DD6, 0xEB7AD3B7, 0xCF1F927A, 0xDB25DF6A, 0xAD622868, 0xCC647D37, 0x9C19B951},
    {0x1085B2D7, 0x4BD9DD38, 0x40792F7C, 0x9E0A31F8, 0x1ADE0C7, 0xC39423E3, 0x6D8D531A, 0x7501D377, 0x66EC7BC,
     0x6EDA55ED, 0x936C2DB4, 0x83E5045F, 0x2CA6CF8F, 0xDA6D86C1, 0xBEC994DD, 0xC71BBC2B},
    {0xE952DBD, 0x30AD7E4E, 0xB0C5E5F3, 0x37A604CB, 0x661BDB22, 0x98B81974, 0xE97DFB5E, 0x78849DE9, 0x9A25F8C9,
     0xD8E6EC96, 0x38204BE8, 0x4C231926, 0x5C60DDE0, 0x8494A9EB, 0x7F019BDC, 0x9B3FC959},
    {0x7EC73920, 0xC4BC4D24, 0x914A0795, 0xADC1511A, 0x668F9CD6, 0x688AF653, 0x1E24B383, 0xE53071BF, 0x3BC645AF,
     0x6B665035, 0xC546E0C3, 0x472A66E8, 0x5977E472, 0xFFAB02C9, 0x9A649E26, 0xFD0F9462},
    {0x49F67814, 0x49F88F3D, 0xA0676276, 0x2065EB3A, 0x7B896A3B, 0x6957B64A, 0x1BA2A993, 0xC2F751D0, 0x265F2A59,
     0x300BA0C5, 0x638544AF, 0x8FE7D480, 0xEC825C50, 0xC0FF9170, 0xFB5CF5DB, 0xAFDB53FA},
    {0x2C83DE55, 0xC77FE88B, 0xA9497388, 0x6C9C3CD, 0xE063A07, 0x81E2A771, 0xCE8B72CD, 0x6C140A2C, 0xAAB04747,
     0xCCFAFD2E, 0x5E6E2BC3, 0x59C1829B, 0x11449E4E, 0xB34A55E5, 0xC4764522, 0x2F99943},
    {0xFC0DEDCC, 0x5F439029, 0x47FA197B, 0x1940BF89, 0x27F549E3, 0xEB60A7CD, 0xC9CDFA63, 0x402D3A3B, 0x65723771,
     0x593E2D6D, 0xCEA54F55, 0x4FD83503, 0x2FF8FD54, 0x9762BD7, 0x2298ADB, 0x697ABC40},
    {0x56178249, 0x662FD215, 0xFC45451B, 0x215BF79E, 0xF7EFAD38, 0x6CFCFD69, 0xCF28CFE6, 0xBC99623E, 0x1704E33C,
     0x4DCC76A7, 0x8959252F, 0xE50BA1, 0xF2F02888, 0x2CCB099, 0x78FAA5AB, 0xE0DC153F},
    {0x9BE3E14F, 0xF55E65E8, 0x626B80E9, 0x8B1E17F2, 0x357C9151, 0x5B64BE3A, 0x6D0E5C54, 0xA5783A44, 0x306D71A0,
     0x9A9889FC, 0x86BC480C, 0x28EA28FB, 0x328335B5, 0xE2BE780F, 0xF2F212AE, 0xD6FA0DDD},
    {0xCC0830EC, 0x75FFCA1C, 0x2B757978, 0x6FC9A4A4, 0xE9F71914, 0x9C17872B, 0x4A977CBD, 0x5D41B868, 0xF786FC82,
     0x53F58F0C, 0x1EE560F6, 0xE59C34C4, 0xD1C27BE5, 0xA2A5F63, 0x6DF379E0, 0xCD3755DC},
    {0xB9A1CC16, 0x73DAA421, 0xA64CB32B, 0x3BFF2B23, 0x7597D655, 0xD8FFB05, 0x61D12C5C, 0x6C4CDC07, 0xD22D0810,
     0x5AAB0FC8, 0x534FE8AE, 0x41555283, 0xAD138DD0, 0x9CC39E8E, 0xC432660F, 0xA82D49E0},
    {0x7C3F59F9, 0x703323AF, 0xDE7F89BA, 0x5F425BA3, 0x7D70A48E, 0x899F1E31, 0x593E4BC6, 0xA52FD5F7, 0x8EF80C98,
     0x53DAE74E, 0xCC04AE35, 0x5DCBF0, 0x8276CF2, 0xB74C1E06, 0x1D6E4AD2, 0xC9095DA3},
    {0x40BD8D61, 0x5F1E3163, 0x2E3A98F2, 0xC709B283, 0x789A2AE6, 0x837BD5D3, 0x277FB1A6, 0xC6331139, 0xD06DFE81,
     0xBE8111C3, 0xBDAC6694, 0x55410778, 0x491BBD4, 0xBC70CF08, 0x74C724F4, 0x65EE55A4},
    {0xBD4664BF, 0x464D922E, 0xF5CE4559, 0x234E5EEC, 0xBABBC703, 0x3254EFD9, 0xF1A6C956, 0xD624E19C, 0x1CCD5020,
     0xAFEE019A, 0xA09F91A8, 0xFC4BD350, 0xA52D0475, 0xB7D50EBC, 0x990D15A7, 0xF71738D8},
    {0x742A3EA7, 0x20083B56, 0x3735032, 0xAB3207C0, 0x73775DB2, 0xE1977D10, 0xB0C18BE5, 0x5BB5AE39, 0xBE99C5A6,
     0x13EFC581, 0xE05303C8, 0x976996C0, 0xF268815C, 0x1E764434, 0xBFD888C, 0x945CD9BA},
    {0xA7502556, 0xFD69041A, 0x71BC4DE0, 0x70C044C3, 0x83B4BBBE, 0xE70725B1, 0xBF863B50, 0x2B72C3A6, 0x1124A8F0,
     0x15B41B95, 0x45ECB19E, 0x87B629F, 0xDF35440F, 0xD49390C7, 0xEA14671A, 0xFF1A52ED},
    {0xEF5075F, 0x7689483B, 0x10CE88B, 0xB0B05058, 0xFB195C7C, 0x497E4FF3, 0x2D2AE3A5, 0xD9BEE057, 0x90F77C26,
     0x5AE8BE31, 0x64517F38, 0x6C443095, 0x85B42D97, 0xF3D1653, 0xC166FD04, 0x9D11208B},
    {0x3BC72F89, 0xC4B01944, 0xF22DB71A, 0x3DAE41E3, 0x29B1B11E, 0x430C8791, 0xCF675C8C, 0x7C8B9278, 0x500AD206,
     0xA2621E59, 0xB8E69CDD, 0x7058BC52, 0x5D635621, 0x667830FD, 0x48148888, 0xBAD8560A},
    {0x94AB24AC, 0xE64CAB4A, 0xD61C08EE, 0xE51FDFFE, 0x222FFF50, 0x4BC98DBC, 0xF5EF6221, 0x3355E0DB, 0x283D331E,
     0x6BFD3C83, 0x5605AD8E, 0x656D7159, 0xB61E24CA, 0x4C3D2CEB, 0xF947E236, 0xC237D36B},
    {0x8C235869, 0x49AD06AF, 0xF8FB7EA9, 0xA181DC09, 0xCFAB1731, 0x7C4DCAD5, 0xE7BB1910, 0xDDD5399A, 0xF9D5C403,
     0xF939F126, 0x6C0238A8, 0x9C48B30E, 0x592EEBF7, 0x7BD49971, 0xD475DF84, 0x95D64ECC},
    {0x4FA27C4D, 0xA6FC480C, 0x9668E1B7, 0x7E3C6568, 0x10B44028, 0xB474F158, 0x7A68D23, 0xC43EF004, 0x34527F1C,
     0x407437A5, 0xFF169FEE, 0xB114BA69, 0x33C369D3, 0xE6A2603C, 0x913B9919, 0xAD7CEBCF},
    {0x9CEB422C, 0xDE2D3D4A, 0xD36FD105, 0x603DAF68, 0xA96860CA, 0x3853BE94, 0x4C0B9B66, 0x3BD60B35, 0xCCF15A33,
     0x50D34448, 0xF468EEFB, 0x80C17FE7, 0x3D1BD170, 0xEE853A8C, 0x4B1D05A1, 0x38166792},
    {0x3E638F44, 0xA5363ACD, 0x1F850A3, 0x2F0E0CEB, 0xC7B05634, 0x4CF0FCFC, 0xDA6240FE, 0xFF8C3184, 0x32A88876,
     0x4C101BBA, 0x32D0790F, 0x2EB18981, 0xB4E371F9, 0x4327B6B2, 0x96B5BB79, 0x664E789B},
    {0xC05FA148, 0x546C8A4A, 0xB3D7585A, 0x3DF94CDD, 0x85360EDF, 0x5716A710, 0xFB4C9C05, 0x1EFE34A5, 0x1EEBC984,
     0xEC92551B, 0x527254E3, 0x5072B30, 0xE8989C01, 0x1E57252D, 0xFEBA9C6A, 0x2E699FA3},
    {0x6C0610C0, 0x8E125956, 0xCE1B27F6, 0x6BF56062, 0x90E5A13C, 0x862E8F1C, 0xEE1E5644, 0x292B390C, 0x4CD73E9B,
     0x69C07E7F, 0xBDAD8ADA, 0x337D56DF, 0xF86AA343, 0x202EB3E6, 0x961A22A2, 0xEBCF514C},
    {0x854214A6, 0x69678BCC, 0xC0071705, 0x1337A2E9, 0xF67806EF, 0x7A3BADFF, 0xFAA26430, 0x1FEB9912, 0x89101B6F,
     0x3D2DF9A9, 0xA186B7CF, 0x73C01BCF, 0xEC6C674A, 0x1C0DA095, 0x641E0D07, 0x2DFB83B3},
    {0x666649AA, 0x95B7A2D, 0xD826D6B7, 0x5DE0CE92, 0x6E9C2423, 0x7C9AFBDD, 0xFA87CD40, 0x3FA036BC, 0x7E56135D,
     0xC9F6DB2E, 0x4B60217C, 0xFD6703F6, 0xE3DB1E49, 0x813C83D6, 0x2786095, 0x2AF2415B},
    {0x3DD3B1E2, 0x41561EE9, 0x46C0E71, 0x6D013767, 0x47E09CE5, 0xE9C20935, 0x6264E446, 0x4E94659, 0xEBD3D42F,
     0x2B34D103, 0x90F40369, 0xFF33F8, 0xE67AEE2F, 0xA46D7AF2, 0xEF274DC9, 0x55B09BED},
    {0x39B05ED5, 0x3C9D30E5, 0xAAD85232, 0x93C1D52C, 0xAAAD23D8, 0x9D566510, 0xC715AD2C, 0x68C29EBD, 0x2B443BFA,
     0x8ADCBDA8, 0x87CF1D56, 0x8B32BB7C, 0x457BD15B, 0xA4B61461, 0x6F03B8A4, 0x3CB96639},
    {0x8CCB44AD, 0xDEA02D34, 0xBB9B5EDF, 0xAAF1336B, 0xD8C751C5, 0xFD838759, 0xDF1A19B, 0x402E21DC, 0xD192AE31,
     0x55A5A19E, 0x2F462136, 0x68A782C8, 0x32F957F, 0xDE856390, 0xF67D495F, 0xD54B2C33},
    {0xF8A84DCB, 0x7E4E03D9, 0x8F4E1C4A, 0x5D3E05B7, 0x93676233, 0xD4C1A6F3, 0xF5337997, 0xD2D9BF60, 0xCFE2D4AB,
     0x2230F8F2, 0xC3420AB4, 0xF37C3639, 0xFDC369D0, 0x3649400F, 0x5592B585, 0x7FB8E777},
    {0x1140AA91, 0x5F33A945, 0x16B385D, 0x2F40E66C, 0x698B981F, 0x3E93FACF, 0xF4124498, 0x19BB0FDF, 0xC9F11BF1,
     0xA1679C81, 0xA966F313, 0xDFE9FB49, 0xDD9B4D19, 0xFC534378, 0xF1116F35, 0x43DC1355},
    {0x1659BD86, 0xA71B0C12, 0x14FA67CD, 0xCE487D3A, 0xB10B6EAE, 0xF256C3, 0xFE6D7B51, 0x200C53B6, 0xF8629278,
     0x19238D19, 0xCCEFF1A1, 0x24798499, 0x9D82750A, 0x323BA125, 0x2BA70E91, 0xD59783B3},
    {0xD623FEE2, 0xE9A268B2, 0x96B611E8, 0xB313B1A2, 0xA760ABBB, 0xE1960018, 0xD922F6CE, 0xEB24F510, 0xF726A1F3,
     0x195AA7C1, 0xBD51C78E, 0x648A0F4C, 0x85B4C45, 0x27E90A84, 0x4BDEFC2F, 0xE3F72C65},
    {0x28F7BC82, 0xA3E8543B, 0x389DBF28, 0x1DAC82F0, 0xAEEBEF51, 0xFE2A2C9C, 0xD02D3E2A, 0xFE426EAF, 0x56DA7233,
     0x52AFBD0E, 0xE6A1A08C, 0x69EAD1E0, 0x6153E2, 0xAFB413D6, 0xDAD7CC4D, 0xAB822D2B},
    {0xE81A4CB6, 0x7F446893, 0x56618BBB, 0x4F746EF6, 0x8719AB3A, 0x8AA24D07, 0x72CA2196, 0xA971D385, 0x38509EF1,
     0x7010FFDB, 0x529EDBC4, 0x68063775, 0xF4E491E3, 0x5BAA6189, 0xB1F04B1, 0xE4A5F1A1},
    {0xE5E0489A, 0x370831F, 0xCB91423C, 0xF3E2DD8, 0x9EA07DBE, 0xA3E6B674, 0x7EF695E1, 0xAB0F609, 0xF4FD760, 0x214472AB,
     0x4E270B60, 0x27BDB07F, 0xD3063691, 0xC0E8B4C5, 0x5B032F41, 0x64FD115A},
    {0x62558581, 0x58D09017, 0x9268B282, 0xE2656559, 0xDBF78083, 0xDD194BDB, 0x441A2670, 0x8E0A0266, 0xAB0F63B7,
     0x53B1D1E8, 0xFC05A495, 0x635C601, 0x2A9E3F61, 0xF1897BF6, 0x2AE7218C, 0x9858F89C},
    {0x69B77B01, 0xA17A07AC, 0x2EA84885, 0x35F04287, 0xF04C9979, 0x138F93A1, 0x615D990F, 0x7C9B834C, 0xFBCA8B74,
     0xBB488487, 0x58F4EBEF, 0xA64E40A5, 0x49B639B6, 0xCC0D266C, 0x9D662899, 0x593E5E24},
    {0x45F19A82, 0x324127F1, 0x34207523, 0xDD698F43, 0x58E49C4C, 0x62EBCC7D, 0x4ECE3DD, 0xC2128168, 0x3B6197CC,
     0x40D02200, 0x3A2825FF, 0x46C4C7A, 0x4022761F, 0xC576CCA1, 0x36E518A8, 0x6323A70C},
    {0x9E4EEC6E, 0xD75C23D3, 0x9AB777D2, 0xB4B6C36A, 0xE6DE4FF0, 0xC4D388EF, 0xB12F3007, 0x3AC5A7D4, 0xD17EB77E,
     0x74E1082C, 0x4ADA34A7, 0x9DEEACE5, 0x334B6FA8, 0xF8FA76DF, 0x1DA3E096, 0xDBF3D73E},
    {0x2B94BA40, 0xA100FC47, 0x5C6CE07F, 0x2ABD5B11, 0x9FCD74CD, 0xF17A41D2, 0x789101C8, 0xADE442BC, 0x1EEBE9D0,
     0x7D1173BF, 0xD689D7DD, 0xC5706988, 0xDF04EC6A, 0x2339BE53, 0xC0622BB1, 0xD66B198E},
    {0x60A697A7, 0x58075D9B, 0x7C14BA20, 0xE7C6A982, 0xED26A36B, 0xE48DEB9F, 0x8EB35692, 0xF13C7E9C, 0x340C4AF3,
     0xF278C338, 0xA62795B7, 0xEE7D515A, 0xBEFFF309, 0xF333CDF5, 0x163AAD5F, 0x7EDA2018},
    {0x7C04260B, 0x54FCF4A9, 0xA614303B, 0x45979B4F, 0x6018FEE6, 0x27B39F74, 0xE3EBC12E, 0x2A119E7, 0x6E745071,
     0xB57515F5, 0x86CF2A28, 0x58E57F04, 0xABF5AC8C, 0xBE113B14, 0x6F1AF633, 0x1DEB527A},
    {0x554E24F8, 0x21B35144, 0xDD818EB2, 0x421DADF1, 0xF6E770E6, 0x917EE160, 0xBAD5E87D, 0xE193E6A, 0x53569C82,
     0x6D63F98F, 0xB4003149, 0x7B918E7F, 0x7778AD91, 0x2ED0382B, 0xD9504F0B, 0x14D51AAA},
    {0x967CD15E, 0xC85D6BE2, 0x479FE0FF, 0xA02621A2, 0x4D3B3159, 0x8E2346D, 0xC49C5459, 0xCF141B2D, 0xAF3E60F,
     0x753A7C5A, 0xA78FB9DF, 0xDF8E4DA5, 0xB0E1E781, 0x99D5A8B2, 0x3B31D564, 0x2E16F27A},
    {0xBCD32FBE, 0x151CCE72, 0x494BB1F7, 0x83CA5F87, 0x117D895F, 0x1516FBE4, 0x8D294347, 0xF0973CC6, 0x62663515,
     0x8100AA7A, 0xC3A4B2, 0xA62E05C9, 0x5FD51C2C, 0x3F96F355, 0x3ACD18, 0xBA98BFCC},
    {0x46FA4A1E, 0x28C12F9A, 0x3ECA7124, 0x2C7DA057, 0xB1F6DEA5, 0x3B38C3CA, 0xCD0AAB9E, 0xA2A1143F, 0xF63D4C8D,
     0x6B01983D, 0xB1D9279, 0x9AE2A693, 0x248F7CF5, 0x453FA341, 0xD2ACE4BF, 0x8B4E61A8},
    {0xCA2E7CA1, 0x2F9307CE, 0xEF09A271, 0x8AFAD1D8, 0x45281ED2, 0xB0AD84D7, 0xC2789679, 0x19B1EACB, 0xAC19BEC5,
     0xA8D67EDE, 0xC8B4D45C, 0x97C75449, 0xC7D319DD, 0xB82636C2, 0x9A24E450, 0xA9EA3663},
    {0xDBD74440, 0x68E0220E, 0xB46D10A2, 0x9C9F349B, 0x892CD99C, 0x3CFB5FF9, 0x155824FB, 0x77AB3377, 0xD27FF061,
     0xBCE5EE1E, 0x2179144B, 0x7F7C169B, 0x22A3EEE5, 0x4A22A3E6, 0xB14D74A8, 0x8C22761B},
    {0x9936A71D, 0x984EA407, 0x8BBBE368, 0x5B282A32, 0xE21AA8AD, 0xCC1494B7, 0xAA5337D8, 0x7B079650, 0x6DAE83F1,
     0xA2737583, 0xB16641, 0x68D2103F, 0xA0D1DB5F, 0x9574967D, 0x46CB5F, 0xDB02C1A6},
    {0x574DF501, 0x8CF67FF8, 0x69C3DCB3, 0xDCD833A1, 0x3818D9BC, 0x8F5E051C, 0xBC4AEC7C, 0xDFB3FC4B, 0x90D474FB,
     0x66EBB83C, 0x51B8A5C, 0x829CC867, 0x2B3276D3, 0x336236AD, 0x65F66597, 0x8A3EACEC},
    {0x723030EB, 0x8482AA88, 0xC3CF59C5, 0x8BFFB3AE, 0xB5C22243, 0x6ADB5167, 0x80FB7BD8, 0x7BBE09C4, 0x2B0FC4CF,
     0x8F98D73, 0x85CC53CC, 0x335A9595, 0x243852C3, 0xC330A3CD, 0x5A5457E0, 0x9840DCC9},
    {0x1D990E44, 0x6D68205A, 0x6B5078B5, 0xC9BF2C3C, 0x8C97152C, 0xF1891F2E, 0xE0D7B3E1, 0x432B22A, 0x24FC83EA,
     0x3817246B, 0xD0433C50, 0x3ED8A69B, 0xD4A8AF39, 0xC38D0C07, 0x4CB4ED1B, 0x94B5B2F},
    {0xA2A05FE6, 0xDAC971E6, 0xFC88E4F1, 0x81CE8469, 0xA63CA14, 0x1CB42D62, 0x2BE72EDC, 0xE64E8928, 0x627CCCAB,
     0x7C5D6357, 0x415B273B, 0x26754C3F, 0xEE222B8A, 0x79F08B77, 0x266063D5, 0x2E3EA231},
    {0xE1D74D22, 0xDD8B1F98, 0x55F69FDF, 0xF2D1B345, 0x55BAF126, 0x8648D1B1, 0xBD57C807, 0xA9D5EE62, 0x597363B4,
     0xE2F31A86, 0x9BEA3A13, 0x44D855C7, 0x7EDC893, 0xB05E0B75, 0x7E74C578, 0x2829922B},
    {0x36E55362, 0xD6838F30, 0xA3266D9A, 0xCE85B5FF, 0x34B8020F, 0x6CF08B9C, 0x94B72684, 0xADCED0EA, 0x170583F1,
     0x5EE0BA8A, 0x567D2C91, 0x45E19636, 0xA8EEC3C1, 0x85C494B1, 0x620F8541, 0x3D602E0},
    {0xAFFB34D4, 0xF8CCE6AD, 0x2A207B8E, 0xEB8A3FAD, 0x3F024AF0, 0x34343682, 0xC63B2A01, 0x1852F97C, 0x50989964,
     0x12F8D0F2, 0x47B7F146, 0x87CA10C2, 0x49D05DBB, 0x11E2B290, 0xC5A84F7C, 0xFFE7C04D},
    {0xD7B70195, 0x862D33FD, 0xC34DEDEF, 0xF9BE92C1, 0x13B0580B, 0x90C1129D, 0x9A11D575, 0xD54941EF, 0x6A5FF105,
     0x5F863DBE, 0xDDBA4F03, 0x9C5B436A, 0x6F99C9F0, 0x52CD3D21, 0x32C27639, 0x1C650F38},
    {0xB1BC1378, 0xF4361073, 0x82850D6E, 0x26196953, 0x3F10EC24, 0xD23F57F6, 0x6B71A541, 0x1CC9EBF0, 0x8834028D,
     0x3C2C34A0, 0xF11837D3, 0xCDB96B41, 0x921E6273, 0x5C9CA011, 0x53C62DDA, 0x6BAC8E0D},
    {0xAA78450F, 0x8E6F9B6, 0x905F5746, 0x334CE4BB, 0xCD6CCA4A, 0xF296175F, 0xF1FD4AC4, 0xE502E78D, 0x77EFDA34,
     0xCFEBEB0A, 0x581E9794, 0x2A2ACC3C, 0xD0A75CA2, 0xBDFACB7D, 0x84202BA, 0x387979C4},
    {0x27F94AA3, 0xAB17FDDD, 0x332B9383, 0xA32053DD, 0xCB451646, 0xCA5FD603, 0xBE184E0D, 0x9B60DD5E, 0x21E843FF,
     0x399B5F79, 0x99A1E881, 0x66BFC071, 0x4F183FEE, 0xE62B794, 0x9B4FDF09, 0x263DA94F},
    {0xC54DC80B, 0x727D033E, 0x579A7F81, 0xD9EA6174, 0xD748A6C6, 0xB3D16F26, 0x61FD0C6B, 0x8D12C19, 0x9F6770C5,
     0x78782BBF, 0xFDF432A, 0xF44911F6, 0x6A05FD53, 0x48D53446, 0xAE31E199, 0x5CEEBB38},
    {0x79319C64, 0x58CB0786, 0xC217DE65, 0x9296E8F, 0xAD1210F3, 0xC5B73FEB, 0x63005B21, 0x1EF1A1E, 0xEE130A60,
     0x8D8F075F, 0x4009A33E, 0x5D75FF95, 0xECB5485B, 0x2D467CFE, 0xBF116972, 0xBB2CAFBF},
    {0x1EE73058, 0x7A222ECD, 0x5891E7D7, 0xBFE79AA8, 0x613E39E9, 0xB82013AF, 0x11EB0F0, 0xA049E5FB, 0x2F15CBB9,
     0x29F7F1C0, 0x452814D1, 0x535A871F, 0xA4F1C272, 0xA35F44AF, 0xEFEDC2BF, 0xF5B007C3},
    {0x60768B57, 0x349A10D2, 0xE59D984F, 0x36CDDE32, 0xEE1CA167, 0x47E35098, 0x2BD25098, 0x867270FE, 0x80172DAB,
     0xD0CE3316, 0x538DF15C, 0xD1BA63A, 0x7F089294, 0xFED0F93A, 0x6AE54BE9, 0xA3FBA740},
    {0x8F07968B, 0x20C63C12, 0xD4A4422E, 0xC25597EA, 0xFDA9C63E, 0xA2F3A37B, 0x52DA83EE, 0x89D1C71A, 0x3BB90CD4,
     0x65466992, 0x373221B8, 0x5D1B27A2, 0x7CCA1A4A, 0xD66F9A52, 0x48A15FA2, 0xB33901B6},
    {0xBFD8C872, 0xAAD186E8, 0x4ABAFE89, 0x5655BAA2, 0xCF16F4A5, 0xEF00C192, 0x9778DE75, 0x659DD4D6, 0x63A6E6A0,
     0xCA445F83, 0x838D1A1, 0x8F66B52B, 0xAAA63ECD, 0x985F24BB, 0x69279E72, 0x33294E2F},
    {0xC9748B20, 0xEF070ABA, 0xC0177ADA, 0x1AB4993D, 0x120596DD, 0x604F83AF, 0xD3DD5726, 0xD4236B5, 0x7D4491EB,
     0x5A169934, 0x5B07ADB0, 0x5ABCCCD1, 0xA0DCC6, 0x17BD1608, 0x83D92995, 0xF15DA0EC},
    {0x8757D301, 0x3F09FC9B, 0xBADA3097, 0x95BD822A, 0x62470C54, 0x65DFD8AC, 0x3E2194A2, 0x78E5B449, 0xF70544FF,
     0xAAE37CBB, 0x1F3F76F9, 0x65B8A3C0, 0xC4580190, 0xB30919A9, 0x8092DEEF, 0x2482F8A7},
    {0xC6D8BC47, 0x730D7C61, 0x169AA70, 0xF54B1311, 0xF55F939B, 0xA1C36DAD, 0x1036A4DE, 0x3125F537, 0xF931D197,
     0x6019E36B, 0x6F70EA41, 0xB137E8D2, 0x93860792, 0x83C461FA, 0xE7260093, 0x9C879DB5},
    {0xC32D733F, 0x2CC85157, 0x93BED5D4, 0xDDA1E67, 0xCA5D2378, 0x5BBD7124, 0x91854AFB, 0xB2F12353, 0x18F4E2A1,
     0xA2CED601, 0x2ECF3ABC, 0x422C3D7F, 0xEFA4DA3A, 0x9DE8F48, 0xFFE2B0CA, 0x6B6A3351},
    {0x7374980, 0x1D26F4F3, 0x28FE088B, 0xA0DC0498, 0x76E973AA, 0x725E8A74, 0x46A3652C, 0x514FAB7A, 0x435CD18E,
     0x8E7A6E17, 0x62066B0B, 0xAC1AAA10, 0x5BDC8C69, 0x8E206F36, 0xC82596B0, 0x5DE98C81},
    {0xDDB6B40E, 0x716D5073, 0x83257A18, 0xD4505393, 0x83206EB7, 0x4A221A1E, 0x1F8CC9FE, 0xCBB656A3, 0xE978D556,
     0x1BBFDB20, 0x93C90E16, 0x5F28000A, 0x3F2194AF, 0x20C12C8B, 0x968CCCF8, 0x69FAB55E},
    {0xF9B7224C, 0x968A0C77, 0xF1358B90, 0x468C5F7D, 0x8407FB01, 0x740DA10A, 0x4676307E, 0xE481E94C, 0xCB670670,
     0x9E225E09, 0xADBE9EA1, 0x7C733F0A, 0x51161E, 0x8FB6B0D4, 0x4CE230C, 0xB83B603C},
    {0x1F08E6A9, 0x6FD4AD66, 0xBF1DF6A, 0xFCC78974, 0x18CF3713, 0xF353D48D, 0x92383EDA, 0x4EFAC30C, 0xF7E3D404,
     0x73F2B94D, 0xFC5FF2FE, 0x9BF2D768, 0x2379A272, 0x2BED3A27, 0x1B37A90, 0xC7B9BA0C},
    {0x5FB272BE, 0x2B55EA1F, 0xBABA28C3, 0x663F7422, 0xE4DAEFA5, 0x81184BFA, 0x5DCD919, 0x1A19002, 0xC93F088F,
     0xE91B1771, 0x8A0BAC22, 0xD1DDAB63, 0xED14890F, 0x9B4A3893, 0x4E9EF7DC, 0x2D26F381},
    {0xB2A95EDD, 0x7103179E, 0xED44724, 0x6765ABDE, 0xBF102895, 0xE7CA338, 0x515E1DFA, 0x15B0869F, 0xF5B2E686,
     0x4501392E, 0xBF202722, 0x259113A4, 0x655C266A, 0xCFBE1006, 0xE30D402F, 0x2A6ECC2B},
    {0x3E38CC04, 0x301F98B3, 0x8A62EFA8, 0xD8BC771, 0xDD00D415, 0x1AE3BE83, 0x8D4AEE04, 0xFAB941D0, 0x95403918,
     0xA3B1E000, 0xAA447C92, 0xBAFA9F0D, 0xBDCB3B5D, 0xCF620C6F, 0x62895B4E, 0xE8892DCB},
    {0xC55D0423, 0x764FED65, 0x83D81800, 0x49EEFC66, 0x30F35731, 0x2B499310, 0xA5C6E20A, 0x39AA26EE, 0xBF8AC353,
     0x1D713476, 0xC6236336, 0xA9E4A1F, 0xFBC54972, 0x15D1AD3, 0x4E2FA6A, 0xDA3528F2},
    {0x47D2BCB1, 0xF0CB77F4, 0xF438438E, 0xCE28F643, 0xAF9C2B7E, 0x83B8AE41, 0xAA307AB6, 0x86C68B45, 0x53638ED2,
     0xE226692A, 0xC6DD0E88, 0x65DD6AB3, 0x11730F4A, 0x4A86AC37, 0x35F3F1B9, 0xF6364D1E},
    {0x65BB6B, 0xD826C7B9, 0xE059C26E, 0xF2A1C2F0, 0x8C73F6B5, 0xF9F36451, 0xEC807F0A, 0x7E802360, 0xB7B45069,
     0x3DE644EE, 0x7CCE900, 0x89318E5E, 0x59FDBB7F, 0xBDDA7CBD, 0x2459172F, 0xA11E2275},
    {0xE209AD22, 0xCF2672C0, 0xBF8E0C99, 0xEB75C9D3, 0xEFE78FA2, 0x6F4A47CA, 0x737E4613, 0xEFB74E4B, 0x91E4BBA2,
     0xB6D931A4, 0x59704FE2, 0xEC4B07DE, 0xD29E10FA, 0xD69E7799, 0xDA4F2053, 0x1D06A8DD},
    {0x1199B5EA, 0xD89DE17C, 0xA2B5F01B, 0xA804FB1D, 0xC4171B9C, 0x7B9A2F1A, 0x1AED18EB, 0xAE9C30, 0x8518673B,
     0x1C525235, 0x47916BA5, 0x5A67ADD9, 0xDD2435D5, 0xD9DF489D, 0x91BA130, 0xD84D3C88},
    {0x4D527FD, 0x6D99D9D5, 0xA518506F, 0x30C35101, 0x969ECB09, 0x159B6AA6, 0x4C1A7B0C, 0xB17A446F, 0x9EEBE9D5,
     0xE8E37B4D, 0x9B2552CA, 0x78E73D1C, 0xCC5A644C, 0x7E18C689, 0xC9ECB10B, 0x87BF1F34},
    {0x770DCB3A, 0xDA5D2AFF, 0x9FC5E484, 0xF887DFF7, 0x3EF2D9AA, 0x5127C406, 0x285D8759, 0x23E674EA, 0xCF32DB,
     0x7BE2DAFE, 0xCAA451C2, 0xAA02D0BD, 0x5C8D87B, 0x2BA51525, 0x8EB74B61, 0x33D0A760},
    {0x758F74F5, 0x6E373044, 0xEC19B7FD, 0x80AC6939, 0xF1A4DB75, 0x8C6995C2, 0x558BA32C, 0xDD2CE424, 0x2492EDBF,
     0x6FAF24A7, 0x7F5021BE, 0x686FE475, 0x9B335E3F, 0xABE4CE35, 0x878F8ACD, 0x6739985B},
    {0xF2F710C8, 0xBC80F619, 0x91F03FDB, 0xFB0A5CFB, 0x11729E44, 0x5C7AA25, 0x41573900, 0x99ADACF9, 0x7970AB7E,
     0x8E64D437, 0x52EF393A, 0xB0A0B5C2, 0xBD4153A4, 0x52F18323, 0xCD745D9D, 0x707AA5F7},
    {0xF785FDC9, 0x649EA4AC, 0x277CA61A, 0xA40A4168, 0xB3E58B09, 0x5CC406F3, 0x75D3AE97, 0x4CE80CB8, 0xB6684FAC,
     0x50D03058, 0x60F9F9A5, 0xD9D6B56C, 0xA2ACF2B2, 0xB62365CC, 0xDFBCA41D, 0x7FE91886},
    {0x6EF13DB8, 0xEF1AEB32, 0xBF466283, 0x3461C89B, 0x63239571, 0xFAD22151, 0xAE2A84C0, 0x10C85060, 0xCDBD76,
     0x357C3657, 0x6FA3169C, 0xD858A106, 0x1F0D368B, 0xB493FCCF, 0x6116DBBF, 0xA8305715},
    {0xE07CBCA8, 0x79DC3A8F, 0x1DE5D947, 0xA83CB5D7, 0xF4B3BFAE, 0x25CB5F8A, 0xE7FCDA53, 0x5FFD9BD4, 0xCE91C176,
     0xD3009652, 0x4337AE5A, 0x2733ED15, 0xC2B7A4B3, 0xF234E9CB, 0x62D4FE34, 0x91B8D1D7},
    {0xD418DB44, 0x5356F8E2, 0x87073D6, 0x5CB8DF4E, 0x5C0EB638, 0x3CA0C93E, 0x2050E3D8, 0xE959760D, 0xBBFAC411,
     0x2F3F405F, 0x1CADFEF7, 0x2DA7F2D8, 0xE41FCA7F, 0x9444814F, 0x8CC6CB96, 0xCA27173A},
    {0xA8E6C873, 0xE65006E2, 0x6486E9C4, 0xA5718734, 0x7CE40569, 0x739555A, 0x772B70B0, 0xC365715, 0x7A87AAA6,
     0x745257D1, 0x652A3B49, 0x1E563EF0, 0x7D4C322C, 0x10421710, 0x1CD6C5BF, 0xFB5E05FB},
    {0x685A2132, 0xBA716FD1, 0x621DAEC7, 0x6BD2B15B, 0x77C7AD35, 0x8646CD10, 0xB5156DFF, 0x5CD00DBC, 0xC84842B2,
     0xFAA101AA, 0x9CB1BC8D, 0x22B4785D, 0xC961D7D1, 0x65613BA3, 0x7885DAF5, 0xDA3F6D4E},
    {0x68F9EE7D, 0x7176A52B, 0x69A37CEE, 0x55DC7883, 0xC8D5B165, 0x417BCDF3, 0xCCF09061, 0x3DACF37, 0x5DAE6647,
     0x35D820F4, 0xFF174C5B, 0x2C2DFD08, 0x5056C1E5, 0x1865E723, 0x4AE75B38, 0x757F15B1},
    {0xC4034ECF, 0x1B5D026E, 0x86D6A3CE, 0x3A68EBE7, 0x426933DB, 0x8CB35BC3, 0xF31359F1, 0xCD873A92, 0x655E5FF9,
     0x3BB4C011, 0x935683AA, 0x53DDBA76, 0xFB7FCC93, 0x1DB6FBA5, 0x42DD583C, 0x563A215C},
    {0xA32FCC7D, 0x89EAFC9E, 0xE5EE7B88, 0xD0E25569, 0xB9551C86, 0x23772497, 0x7185AA87, 0x30E0404F, 0x625C51FD,
     0xDFC52A89, 0x2C1956BD, 0x2B28693C, 0xAA491B13, 0x95AA0F1A, 0xAE2BBD55, 0xE3ECA0A4},
    {0x68246552, 0x533350CD, 0x16E86186, 0xFD5A1FC6, 0x5D04887A, 0x638FBA67, 0x4F52FA1, 0xC87B1DAD, 0xC94122A2,
     0x5D50C507, 0x8382B24C, 0xB1E5E408, 0x4C214728, 0x26B0DF21, 0xD98044C3, 0x4545B466},
    {0x9B7D8CF7, 0xF4948156, 0x1E2F435D, 0x5BD0BEDA, 0x88896728, 0x3F8F1766, 0xF494734E, 0x42C5EFC0, 0x817EF1A,
     0x5D95A4C6, 0x6B292D5A, 0x3FBFAC0A, 0xA8BFAD48, 0xDDA91D6, 0x301BEA00, 0xF6A7D604},
    {0xC9B935CC, 0x9471BE90, 0x70989A04, 0x13C1B9B1, 0xC339E68F, 0xFBBED322, 0x222F112, 0xC9C69771, 0xB24D5933,
     0xB9B8F79E, 0x7DA37177, 0x7A5702FC, 0x558BF1DB, 0xCECA8E80, 0x8B377373, 0x6377318C},
    {0x5F75BC65, 0x8177CB95, 0x52D8CF50, 0x5DD45AFC, 0x6EA7008E, 0x5D4CE690, 0xC28A73D2, 0x41EF5D2D, 0x1DA1D357,
     0x6D822578, 0x89C347C4, 0xB2B2F8E0, 0xA94FF065, 0xD25C8313, 0x8C2AB649, 0x1A935A51},
    {0xA130DEF5, 0x6F7D0118, 0x525E70BB, 0x48B9B158, 0x88199605, 0x5FCD7676, 0x4C927119, 0x547A24E2, 0x9D48CB3F,
     0x99FE5063, 0x986F37F6, 0x794EBC5D, 0x6FA5818D, 0x4410EA21, 0x81A23E01, 0x809DA895},
    {0x8FDBCAD3, 0xC1511FE9, 0xDE74A12F, 0x5527BF93, 0x13FC1290, 0xC7A115BB, 0x5091E360, 0xEBBF06DD, 0x4F93EE2F,
     0xA3174B12, 0x2C18695, 0x84D8D8CA, 0x83A32A49, 0x36116558, 0x12597C08, 0xBB931334},
    {0xD1B47C92, 0x88CF2531, 0x21FC9233, 0x3536DFC2, 0x6A11CC3B, 0x6D7B1B3A, 0xD0362921, 0x16FC5398, 0xD9342FE1,
     0x6B8EAB00, 0xC897EDE9, 0xA6EE884F, 0xECFCDA2F, 0x1FB5907D, 0x5BAFC7BF, 0x3F78C638},
    {0x1F72045, 0xDBB08BAC, 0x38CBDEB6, 0xBDFA525A, 0x8ECC6AA4, 0x71CB447B, 0xAE20133, 0xE7CAA0A8, 0x7C716780,
     0x41CDFD4A, 0xA2F737E5, 0x77E296ED, 0x409F0342, 0xBFB5023D, 0x6422394F, 0xA15F319F},
    {0xBD9B461A, 0xE6925144, 0xF8F9868A, 0xF7C2232D, 0x5654B74B, 0x4A8BAC05, 0xC24ECAA0, 0xFB8A363F, 0xD2F9A1C5,
     0x16A92546, 0x12A1C04, 0x483D2229, 0x6B2C6313, 0xA5A7B764, 0x752341F6, 0x758CF2C},
    {0x758C490B, 0x978AC903, 0xCE746302, 0x557E6B74, 0x1F267427, 0xD146414C, 0x84A91370, 0x401C6D5, 0xEE65C2F3,
     0x21EA30D0, 0x802EDF91, 0x1A4A6240, 0xABC3B146, 0x6D550A70, 0x7AFA668F, 0x46D06DC2},
    {0x974FC239, 0x97F8AB87, 0x8D8679E5, 0x4D7AF4AD, 0xB28B1A0A, 0x6BB8D95A, 0xAF2C3F2E, 0xA1F0A5B9, 0xE8767033,
     0x30E050B2, 0xFE2E5617, 0xA903ED55, 0x24C59E63, 0xCB661A3A, 0x1776266E, 0xA4CA9DA7},
    {0x4DFA302E, 0xBF0168CA, 0x555A1C02, 0x68E28849, 0x1EB6946E, 0xEDC13AC8, 0xCE370ED7, 0xDAB93F52, 0x4E817196,
     0x5C37375E, 0x5B40BE11, 0x5366CCB, 0xADA6DCE9, 0x91B54183, 0x31800327, 0xB88F5073},
    {0x295ECF8B, 0x467EE9D4, 0x557FB87B, 0x6042155A, 0xE431F399, 0x19DF05C9, 0x4D26A23B, 0xA430719C, 0xADC655C0,
     0xFFA993AF, 0x175E7EC1, 0xCBE638F4, 0x74251A44, 0xF7442F00, 0x7C30E559, 0x49787ABD},
    {0x7558FE9D, 0x18DFA266, 0x77FD80CD, 0x648F0BC8, 0xA56EFF91, 0x97078ABD, 0xFF5BC83E, 0xC16CCE9F, 0x880655CB,
     0x661714BD, 0x91429F75, 0x5FE50E60, 0xCCA73611, 0x355DF769, 0x55C663B0, 0xB7AE6A8E},
    {0x4EF7C4C8, 0x6FEC7EB4, 0x749172C, 0x9C4E427E, 0x8F964230, 0x2E600E4C, 0xF9C5268F, 0x6BF23619, 0x41BCF00A,
     0xDABE47CB, 0xAE7368B6, 0x9288E1D8, 0xC2B14588, 0x24A1A317, 0xA3987AE0, 0xFC639E30},
    {0x73FD4A99, 0x80632023, 0x5FB33866, 0xCDDA48CA, 0x6549751B, 0xC358CA78, 0x6A917C2A, 0xA1E1FA84, 0xB5DB8662,
     0x58191C7E, 0x1FCB7DE2, 0x53A6C0D5, 0x79ECD728, 0x648AA6B7, 0x7E3B263B, 0x5962428E},
    {0x4D5CC4BC, 0xF5737F07, 0x8600F61A, 0xA11C17AE, 0xC2076262, 0x1D32AE1, 0x9BA8A769, 0x5A4A8D3E, 0x89E9E1FC,
     0xC1E4CF93, 0xC15652C2, 0xC2EA5E23, 0x3C96791D, 0x3F40A302, 0xC3F115C4, 0xA0206388},
    {0x549DF0F2, 0xADE70712, 0xCE08A4CE, 0x33151F4, 0xF35342F0, 0x496BBBA6, 0x70CD2DBF, 0x509683FB, 0xFD7DA282,
     0xB6783E2A, 0xCFF6A162, 0x101ECBD7, 0x81764726, 0xF53DA880, 0xCA9F4BB3, 0x36B33C8B},
    {0x8B1B8623, 0x9AC3C034, 0x786D1545, 0x522415EA, 0x90E1F8BB, 0x4340DAF4, 0x96C510F3, 0x1F27452C, 0xBB15250C,
     0x56B65090, 0x63E913B4, 0x73D243C, 0xAD3F60B9, 0x1F69C83C, 0xE9A24BAE, 0xDC326EFF},
    {0x6C4CD639, 0xE10AE02D, 0x354F5444, 0xCE738F21, 0xF748D40B, 0x91C04D40, 0x1574FC0C, 0x29C70AB9, 0x9A9BAC45,
     0x37ADB2A1, 0x600F679A, 0x18671159, 0x813A3044, 0xAC3F6245, 0x593EA554, 0xFAB9AC49},
    {0x33F88FA2, 0x4B210D7C, 0x40F3B382, 0x54EFF0B1, 0x2CB99ED4, 0x811A5B5, 0x80A7FCFD, 0xB7A2DD20, 0xEA2D03FD,
     0x2C6DA37A, 0x4DA7BF5F, 0xC0E7ADCF, 0x85094432, 0x878E97E6, 0x16960369, 0xBE36EAA6},
    {0xF6389ED8, 0x7D4D3416, 0xFECB67F6, 0xA160DEAD, 0xA26ED80E, 0xFA7C8E4A, 0x60F454EE, 0x9670FFC0, 0x8D932E9C,
     0x1A86D624, 0x787E0DA4, 0x6F79E, 0x1CAF7FE6, 0x1CE21C5F, 0x2D9A3444, 0xE8122EA5},
    {0xD71075F3, 0x79C3AF52, 0xEF9AAFD7, 0xCF3FEBA0, 0xB6551778, 0xDCC5993A, 0xB44F43F6, 0xA2F628E8, 0xC30E621F,
     0x10BB4C14, 0x72DBF541, 0x65F6E7D, 0x28BB569C, 0xC09AF19A, 0xE75D5C4, 0x5786ACD0},
    {0x6B66034, 0x3B4737AA, 0x70FE6A22, 0x2D582E33, 0xE65B9ADF, 0xD11063BC, 0x61392941, 0xA705FA3, 0x71D9C492,
     0x34956722, 0xBCDE5F55, 0xEEFF2CD6, 0x88A8B9EF, 0x4420E3C0, 0xDF68B499, 0x559385F1},
    {0x34C48529, 0x65C32EF0, 0x1FD0801, 0x8A3EF85C, 0xB7C3DCDB, 0xAA2E0178, 0x9D1CBDF3, 0xC27CD974, 0x8F026BE3,
     0x276B982D, 0x5B5AE621, 0x30434972, 0x39178EE9, 0x4FF114FA, 0x5FD9585C, 0x7E5A62F9}};
uint32_t test_ecddoublemul_result[128][2 * 8] = {
    {0x790A3222, 0xB5256EA5, 0xEBAC59B6, 0x3D6CC1A3, 0xAA6B774B, 0x7CD4F372, 0x30CBD1BA, 0x62C77EAD, 0x53D37C49,
     0xF3BBB15C, 0x3CCEB161, 0xD097FCED, 0x2569B718, 0xBBD7D72F, 0x7F3F544D, 0xAB816DC7},
    {0x8E201F7A, 0xF478C12C, 0xEEEAFCEC, 0xCC86681B, 0xDD93FEC7, 0x45829FB4, 0xCF69C0D7, 0x296C1D0F, 0xBB665A7C,
     0xD1CE3EEC, 0xDF543B31, 0x2FD5359D, 0x32396288, 0x9B6B4BCE, 0x1E77FA4E, 0xEC7B3AC9},
    {0x628E8316, 0xAFC2525A, 0x20B2F946, 0x2A5A488D, 0x5C817904, 0x6BD82EF7, 0xC43C8ACF, 0xE6D7F20A, 0x75BC58D6,
     0x4A1FE715, 0xBD0D2011, 0xC907A7F2, 0xF156F9DA, 0xEAB3396C, 0xFE1B845F, 0x48592E9B},
    {0xE0B8FCDD, 0xEF9C9F7A, 0xBEB44117, 0x842BE5D9, 0x3D377117, 0xDB4C8F5F, 0x3FF8AA83, 0xE6EE54E9, 0xDA1DF635,
     0xB4269458, 0x42935E0D, 0x6DDBF881, 0x80FD279F, 0xC85F96C5, 0x505A816F, 0x7EAF3159},
    {0x922D3124, 0x2DF61163, 0xB65AEBD8, 0xBFB6D2B8, 0xFA1D93A5, 0xB024315, 0xF2B07E18, 0x96F13D98, 0x406832BC,
     0x73CB0639, 0xD54DB560, 0x40F4CF17, 0xF5975058, 0x64983288, 0x91390D33, 0x51FC699E},
    {0xA9C6AD20, 0x6B0ABE4A, 0xADE9ACE5, 0xE1194368, 0x134C1D1E, 0x17422847, 0xD887A111, 0x46025976, 0x4F16C09D,
     0x4529A9C3, 0x67F0E58C, 0xFD1059DF, 0x6D111432, 0xCD5AB0E, 0xCC45A137, 0x5DDF7EF5},
    {0xAAA89492, 0xDA91C1A, 0x979767C6, 0x6D008BB0, 0xCE414B69, 0x372221F3, 0x8A9532BC, 0xC40F74BF, 0x4B4E3B6C,
     0x5F76F02F, 0xB3D487FB, 0x4A4BA9B1, 0xD9D915ED, 0xF8F4344, 0x7B79C699, 0xCD5AE3C6},
    {0xA1AD5A61, 0x292FE86D, 0xECFBFE7F, 0x343DFA91, 0x42452492, 0x7DEE468C, 0x19E51039, 0xF958E2B8, 0x9E7CF21,
     0x2B0D691, 0x67F18142, 0xC494B86E, 0x70DB6958, 0xCB38EE56, 0xC83D7B21, 0x55A291F3},
    {0x15BA564E, 0x7BD4A448, 0xF7B4E1B, 0x5C77A271, 0x4CA725D8, 0xC28A0449, 0x90A8C2AE, 0x9EA6AF14, 0xB0B126C7,
     0x35FCB2E5, 0x1FCFF898, 0x48756E4B, 0x70944F88, 0x196A6C81, 0x27C0CBA3, 0x910677D7},
    {0x57AA9DC2, 0x862B5209, 0x378C0372, 0x5534B48E, 0x2308B3BC, 0xB7929150, 0x8465AFA1, 0x72B3DE3E, 0xB78C0284,
     0x5E96B386, 0x90BE84F6, 0x168702A2, 0x405210DB, 0x1856A86, 0xB071978F, 0x28AF9151},
    {0xCB1F9740, 0x214AC372, 0x7136F6B, 0x8594D473, 0x6281C937, 0x8DF90270, 0x4E6BD06F, 0xC694BB9, 0xBC886F99,
     0xF26C6480, 0x89BB7377, 0xCB02FAE2, 0x6BA3B09D, 0x82684C53, 0xCCD9E670, 0x57C479A4},
    {0xE0C69D8A, 0x515A3640, 0xDEC9053A, 0xB82C94B7, 0xCF54CDB6, 0x37CDA730, 0x1CA47624, 0xC51DE9B7, 0x515078C0,
     0x4592D88D, 0x82EAF1DC, 0x422C8D0B, 0xA4D64900, 0x4C3BB3C2, 0xCB089633, 0xC6ED69FD},
    {0x9F4E3214, 0x16AEF9DB, 0xC0F85AD7, 0xDC690B11, 0xBE4DCF7F, 0xAD52B08A, 0x7993006D, 0x3971A176, 0xCADD9CB7,
     0x736E0E11, 0xEF91D63E, 0xBBCD834D, 0x81187DAD, 0xAD206A53, 0xEA6E483, 0x3C668641},
    {0xC5745915, 0x610DE690, 0x4582566B, 0x8F23732D, 0xC92DC78E, 0x6B42B6E2, 0x2F78ABE8, 0x4C644972, 0x9BC8436F,
     0xAFD2A41B, 0xAFF93670, 0x26FD32AB, 0xBD8EC817, 0xDE48586A, 0x1F1B39FC, 0x37FBD9AB},
    {0xED9DE21A, 0x13B08EF5, 0x299DA33C, 0x354E35CB, 0x290B88B4, 0xCC26BF6C, 0x99E2E75B, 0x69999F22, 0x36BA15DA,
     0x857A8A19, 0xC22A071D, 0x2D145C2E, 0x94DEB989, 0xFD443D02, 0xFC46982F, 0x8E4ADCF6},
    {0x4AC37A75, 0x908A3F9D, 0xDCBA9760, 0x67042E7, 0x4503EFE0, 0x2FAACC86, 0xAF616B08, 0xC7A9AF75, 0xA003E20B,
     0x3557B092, 0x696DBC34, 0x11B5D91B, 0x6CBA14B, 0x7DABB35C, 0xF602D721, 0xA006B90E},
    {0xB992B7DC, 0xB6EBBF20, 0xD2D598FF, 0xE5C0ABB7, 0x989AF848, 0x46723C73, 0x52EB7F38, 0x97737640, 0x32C2CF64,
     0xF3FA95C2, 0xAE5BDECA, 0xF1995F10, 0x9A32EC86, 0xD05FCD85, 0xAA8D724C, 0xA8D07E9},
    {0xC8AAFACB, 0x18FE312F, 0x5333CFD7, 0x17CB4AC9, 0xD797574D, 0x93E7D390, 0x32908F7D, 0x81C8E617, 0x39CCA3B8,
     0xEE66A181, 0xEDB5FB00, 0x21EF14E4, 0xD7EF08B6, 0x9A55268F, 0x5C7E2318, 0x6A6C56C8},
    {0x127EDFB5, 0xE69AE9D0, 0x3AD21A91, 0xDED86AB9, 0x9AB59607, 0x947BCA6F, 0xA21AEB10, 0x4DB1472, 0xE4572E5A,
     0x2222E8FC, 0x575A354D, 0xDC689217, 0x4ABE115F, 0x8B182ECA, 0x3FCC9713, 0x430B4B00},
    {0x71C96078, 0xE04125B4, 0x4748FFBA, 0xD39973A7, 0xBE505954, 0xE9121DFB, 0x82F0FF52, 0x8D131B9C, 0xD7FD8E01,
     0x7EEE6569, 0xDCE48D4B, 0x1C934545, 0x3D49716B, 0xD7428AB0, 0x821F2F9D, 0x29A20E1E},
    {0xAC7E6551, 0xC3C09889, 0x103B05D1, 0x6D82C15E, 0xCD4341BB, 0xEC8A6D34, 0x6B805277, 0x682A551E, 0x9300333A,
     0xA9F19945, 0x63F5F97E, 0xE729B61F, 0x896B53E8, 0xE4ABAAAF, 0xD6408FF5, 0x4BC5293F},
    {0x569FEF59, 0x6D9CE6BC, 0x4D98A46A, 0xB224CBC2, 0xEAA2A1ED, 0xB786D7E8, 0x10D42824, 0x337EC9FC, 0xEBC48225,
     0xCF998718, 0x43A5D2E3, 0x345B970D, 0x7A8A552A, 0xF8C25693, 0xE9DDF6FA, 0xF133D933},
    {0x36C96A8, 0x38543E94, 0xA9B97CDC, 0xAAB6DD9, 0xD9456182, 0xDC9F8ECD, 0xB448970B, 0xF2500DD, 0x9D4522A8,
     0xA309EEC7, 0x37D39B67, 0x3D0B4B8E, 0x767FE0A0, 0xED46C21F, 0xE72524DC, 0x1E66E6C5},
    {0x81B65CAF, 0xC90B686F, 0xDFB09248, 0xB2DDE597, 0x6D728920, 0xEA040E2F, 0x725CE8D, 0x1AD4BC2, 0xC1F6FC17,
     0xD0475F92, 0x91F994FA, 0x7300B312, 0x5D7D8B67, 0x15B1C7B1, 0xF94ACC1D, 0x476EE0E4},
    {0x8A5AF9FC, 0xD98CA93E, 0x89E79091, 0xBEB2D457, 0xF69EBC9F, 0x26162905, 0x92A6C059, 0x6332AE42, 0x408D0C76,
     0xE30A5E80, 0xE17C2BCC, 0x9813D80A, 0x5418BA45, 0x9E777E02, 0x9EB59C1E, 0x1D531665},
    {0x57FC853, 0x8765FA48, 0xF494F4DE, 0xC4621D17, 0xCAE6C26B, 0x6BB7A5F3, 0xFA8465DC, 0x60CE0A2F, 0x511F5A2B,
     0x461F4375, 0x617A83F8, 0x2A2D149A, 0x6F002721, 0x886310F2, 0x13F15EB4, 0x4EB82E22},
    {0xEB8582F2, 0x3D1ADB64, 0x5A549BB7, 0xE573002, 0x45D5FAB9, 0x88018B93, 0xDF281CB5, 0x6F226229, 0xCAD731A7,
     0x1E2B7F4D, 0xA5FE4841, 0xE0DBF8A2, 0xA847CD44, 0xFB4DBE3, 0xD7DAE5D6, 0xCBB326E3},
    {0x268DC287, 0xB6881C54, 0x4407179A, 0x94D31BB9, 0x8229EAF0, 0xA68EC6A4, 0x5D991D13, 0x332017F2, 0x80EB419,
     0xB3C25801, 0xFB770868, 0x25787008, 0x8A41E487, 0x19A15821, 0xC813F830, 0xBC0D516F},
    {0x3DD783A0, 0xDC3F076A, 0xE9011AD7, 0x4CC178A8, 0x269179A3, 0x75A2CFD1, 0xD324C956, 0x2AAD8066, 0xAD5349B7,
     0xAB00E24A, 0xDCD9BB18, 0xB9C52A91, 0x8DE47ECE, 0x8ACF35FC, 0xDF66BD7B, 0xBB54AA9},
    {0x98BBFBF0, 0x70DE4706, 0xC3ED33D5, 0x5C5C03A2, 0xA7B76DF1, 0x698CAABE, 0x47A932FD, 0x96EC134A, 0xB93A5113,
     0x49CE4EAC, 0x1E557F95, 0x84A7F1CB, 0x32366079, 0x227F9259, 0x8B2F9B38, 0x1209BF82},
    {0x8F7F2AF9, 0x48DFE1FE, 0xC40741C2, 0xAA0DF4EE, 0xC20F1D2D, 0x902AC9F7, 0xFBECDBDF, 0x3E4D91B9, 0x661D53D1,
     0x50382D7, 0xA8910B64, 0xCCE46222, 0x985097BC, 0x234D6265, 0x236B8DDC, 0x8C66278B},
    {0xB0F225FA, 0x12FDB022, 0x16949A67, 0x71CD28C6, 0xD1B83FD7, 0x8EA59ED9, 0x4D9F8500, 0x8FD4FF95, 0xF9C91358,
     0x27A1D586, 0x6F34D8C1, 0x846C8DDE, 0xEF0F2490, 0x5812D5BB, 0x20C2D3DD, 0xFCF7FA58},
    {0xB06033B3, 0x4459A74F, 0x4915D4B, 0xF1A6BB92, 0x7AFAFC1D, 0x209B057F, 0xB13ADE0B, 0x875F5E00, 0x5AFF7DCC,
     0x8AF7FBF0, 0x68F8CDC7, 0x61E12FE4, 0xF537D244, 0x3989EA43, 0x10601DEB, 0x3D805198},
    {0x4CCC45EA, 0x12BB7A1, 0x41AA91EC, 0x63B19F26, 0x979784F7, 0xC893CC18, 0xED91FE7D, 0x9B932F79, 0x5B0207E8,
     0x1CEE51EA, 0xB0470CA1, 0x2EE38D4D, 0x5858D8E8, 0x6B7145B0, 0x205E098A, 0x28A09DC3},
    {0x5C22333, 0x873BB2E8, 0x8D5EC318, 0xE04D15E0, 0xC5C02DCA, 0x8058BF20, 0x2F9CFB41, 0x8F70432D, 0x9827025E,
     0xE44EFE02, 0xCE5BAF1A, 0xDE02C776, 0x35A66550, 0x745EC7A9, 0x604B07FA, 0x629874F4},
    {0x2E1352E1, 0x1D28FE9B, 0xCD61412F, 0x1291DE31, 0x1C415C3E, 0x5B36B7D1, 0x7D7C4975, 0xFA27357B, 0x6B87E777,
     0x483F91D1, 0xE3744069, 0x24F3F830, 0xFD6CA7FD, 0xD0D43B2D, 0x70947985, 0xE7CC8C08},
    {0xC5D596C2, 0x34BC6686, 0x5413CB10, 0x5F75351, 0xB8EF5C1A, 0x315E6015, 0x995AF8B7, 0x4C03090F, 0x7DFD3810,
     0x917B8FA1, 0xCD5AFA7F, 0x294580F, 0xED676146, 0x4FEA7AA, 0x25255129, 0x81EC35C6},
    {0x1182013B, 0x35551D07, 0x38B2FA69, 0xFF85B123, 0x82CFF9F, 0x56CBB727, 0x597A643B, 0xDD934F0F, 0x42FCDF0F,
     0xEAFBE2B7, 0x608F9EDA, 0xA0691AD0, 0x59010A93, 0x6CE4267C, 0x22CA6FB2, 0x4F0FA34A},
    {0x48349BDA, 0x4F798DC7, 0x52BE0CDD, 0xEDDF522D, 0xD84A3680, 0x7F9026AB, 0x4EF822AF, 0x7060E59, 0xC331815B,
     0xDA99713E, 0x513D0EE5, 0x67E7BE47, 0xA532E51, 0xCB7079E9, 0x4EDE568E, 0x5339C46D},
    {0xEE13341A, 0x7D7AA060, 0xEE65D8B7, 0xF553CFCA, 0x62EE74A3, 0x27AB1180, 0x1DFE06F8, 0x477FB131, 0xD11503C,
     0x477F6348, 0x98048FC1, 0xBE7EA514, 0xDFFE4986, 0x1F77E841, 0x47A9CE7A, 0xE240E57},
    {0x6FFAED9, 0x5C6A5A23, 0x8C1B1797, 0x339D9706, 0x9CBBEA37, 0x183191B4, 0x7ABBBC41, 0x150C93B6, 0xE44A586,
     0xB88771EE, 0xE857B22C, 0xC24A022, 0xDBDEEC56, 0x6ACEFADB, 0x31749C65, 0xABC770BD},
    {0x258C4C71, 0x1A8ECECC, 0xF264F2F0, 0x7C996090, 0x8CF5564A, 0x76C27B4E, 0xAE56E6E2, 0x306C5C15, 0x5137F4CC,
     0xED4242B0, 0x2CAC3839, 0x39F3BE46, 0x11F968EA, 0x3A838519, 0x70AE1529, 0xF0EEEAF5},
    {0x9353655E, 0xEE7B451E, 0x612D106E, 0xEF1709BB, 0x2ED02EDB, 0x7619A879, 0xA30941DD, 0x2DF4DC7E, 0x28F098F2,
     0xF50ED545, 0x5C989C46, 0xCF88A4C2, 0x56FF19E4, 0xF728BAC, 0xAE91CDFC, 0xF26686DE},
    {0x91417E41, 0xA13658EF, 0x84826D4D, 0xF6CD3CA, 0xF785FB32, 0xD10A2571, 0xE341E3EC, 0x105A7CD5, 0xC0107EDE,
     0xF0D153FC, 0xD6298228, 0x56245116, 0x9C53EF5, 0xD21D0BA3, 0xE9C7A462, 0xA5CAF3F},
    {0xB8CAC3B, 0x4CF87D9A, 0xEE7B59CC, 0x228FF34, 0xDFD3ECE7, 0x1A2CE51, 0x8A014232, 0x4F4F0889, 0xFF5B3914,
     0xA5CD5C04, 0x1DBB84A1, 0xFE311475, 0xF3F6E011, 0x4BF87A82, 0x9A8499EE, 0xDEF582C6},
    {0x7E55A388, 0xA1A97E09, 0x5061AC8A, 0xD0685FDC, 0x7609FDA, 0x1E4FDE44, 0xF1FABD62, 0xB01899AC, 0xCB4B1D42,
     0xF5B0AD79, 0x817B149B, 0x65FB6BE7, 0x83C0429F, 0x467AC9AB, 0x9F90BF1F, 0x6B5AF4FB},
    {0x9DB61DE9, 0xC6504A99, 0x490922A8, 0xCF3FD6E7, 0xB201E4A4, 0xCCFC5087, 0xE19ABFD5, 0x4A6FEF52, 0xD3FEE9B0,
     0xCDB436C6, 0xA5565EDF, 0x89941038, 0xD396C89E, 0xEACB5946, 0xD36EB6F5, 0x27D5194D},
    {0xDED4ABFE, 0x22BEDAE, 0xAA6D8DB5, 0xDBAA5B4, 0xE35A2F85, 0xD271E25B, 0x986357AF, 0x34CBB76A, 0xFF776A84,
     0xF346226D, 0x7138F8CD, 0xCF24CD4, 0x9FBA3934, 0x7DD08A77, 0x96BED063, 0xB156694F},
    {0xE34AB5A1, 0xB8E41239, 0x7A44DE09, 0x407EB33C, 0xF0D0AE5F, 0xFF9CA243, 0xA42DC764, 0x8582FB0F, 0x3D693D36,
     0x9F6B0F3E, 0x890B583A, 0x86013730, 0xF51821BF, 0xF7ED4AFA, 0xD1D6E54B, 0xF82438EE},
    {0x41AB2401, 0x31BD01F9, 0x43696F7F, 0x629EEB14, 0xFAC3238F, 0xD4B03926, 0x2B266C66, 0xC98F13E, 0x95B03B75,
     0x544FC9D0, 0xE6D0FFFC, 0x61E682B6, 0xC7BF12E3, 0x9959ECD5, 0x88AD983, 0xF3590897},
    {0xD8CAFD97, 0x260BB060, 0x6617FCF2, 0xA329AA38, 0xB6FF023F, 0xC06C1896, 0xD2F7EB59, 0x56F7F0E9, 0x2B34966D,
     0x88B1B834, 0xE543765E, 0x87B897F8, 0xAA1F37A0, 0x3007FF46, 0x74BE791E, 0xC71C15E9},
    {0x24DEB545, 0x48A6959A, 0x245C99D1, 0x19CD1BA0, 0x9B7DD701, 0x96951079, 0x7678F515, 0x7BF0EA0A, 0x8591666F,
     0xE22AE719, 0x5D712238, 0x4EFB0B00, 0x3055CCFD, 0x84882543, 0xEEB812E7, 0xE1126CFE},
    {0xA7CBA715, 0x8532CA11, 0xC275C0EC, 0x3B82E66B, 0x424F5E4C, 0x19736D5E, 0x3D59F757, 0xD4C7304B, 0x71C6EACF,
     0x63780C3, 0x342C847A, 0xF9411641, 0xFBF6EF86, 0x77914703, 0xD45ACBA3, 0xBFA11500},
    {0xDDFFBC26, 0xA771E000, 0xE5207523, 0xF5CB9BB4, 0xE35B71D1, 0xB6D5ED3A, 0x24E25277, 0xFFC4851B, 0x3AC9FF4C,
     0x3586C9AB, 0xF8D3AE45, 0x6A48225D, 0x83C1696, 0xB3A581A4, 0x88A3C7E6, 0x2C2913F3},
    {0x8E93B82E, 0x9D45B1, 0x614B18E0, 0xA4795179, 0x30808ECA, 0x999ADBD6, 0xC9386D3F, 0xE0A8C229, 0x74632071,
     0x822467A7, 0x9F3AFF2B, 0x8C2252D0, 0xA797CFD, 0x4D0BC9B3, 0xD9048EEE, 0x376CF97F},
    {0x661556BD, 0x452A00D9, 0xAEC11219, 0xC8DB2BFC, 0xC1C3A233, 0x49242FB1, 0x3D01BCB9, 0xF27E84A1, 0xCC186077,
     0x91B36BB, 0xB9DD126D, 0x12C3DCA7, 0x2AE3615F, 0xD760AA5F, 0x2103222A, 0xA6FC73F3},
    {0xD9BCF8A7, 0xE4A44A6A, 0x38730C20, 0x4F470E9A, 0x48AFD39A, 0x254E0A4A, 0xD143DD75, 0xF16811EF, 0x677C1693,
     0x626086C4, 0x883E3B5, 0xCC1E1A15, 0xC8BFD246, 0x553F2FEC, 0xA9B4FEC7, 0xE64FA01B},
    {0xE5EA35D0, 0xB1A15FFF, 0x49AB7823, 0x1CCBF936, 0x49856916, 0x16E74DBF, 0xC3D7A75C, 0x9697EB2C, 0x87F0BFDC,
     0x3976225A, 0xB39666CC, 0x78E81F1B, 0x8A5631AE, 0xEB80BF05, 0x7EE4B8AB, 0x8DD601AB},
    {0x71EF8C38, 0x8F5F34B2, 0xA0FC5FBD, 0xD8E05633, 0x387BADA, 0x3270290D, 0x1ACA0317, 0x6D5E645D, 0xB0C418EA,
     0x6890ACCF, 0x86B2BCBD, 0x389C537B, 0x132DC8, 0x77A7A15B, 0x12E0838E, 0xBBF6AAD9},
    {0x14341C, 0x4BFB4C70, 0x48CD9884, 0xD33C36DC, 0x1105EB82, 0xA00F7E11, 0x347EEB8F, 0x3910A877, 0x5721A990,
     0x47E365CF, 0xFD092512, 0x3A9DE0AE, 0x548928F2, 0xCE9D5F8D, 0xB5B3016A, 0x1E556059},
    {0xA595B114, 0x39A25CC6, 0xD34E62AD, 0x340A9861, 0xD0472D27, 0xD90900F1, 0x4B9A8A79, 0x9AE02AC2, 0x6AA0F77F,
     0x27425EB0, 0xE8B7F763, 0xA31A1A61, 0x644B276A, 0xA44DF01B, 0x8F98FD1A, 0x46999EA7},
    {0xC7FD12D2, 0xD27586EB, 0x169CB228, 0xF9EEF3DD, 0x720E707B, 0x9622E0F7, 0x1F4333ED, 0x8E39B161, 0xABE5AB8C,
     0xE6594FA1, 0xD421ADA5, 0xA805D41, 0x2FAC127B, 0x4BB84D65, 0xF260D994, 0x9C5ADA59},
    {0x3826D501, 0xAEEA694, 0x60DD5D82, 0xEA576B7B, 0xC6CA2C86, 0x79BEAB63, 0x7A77F86A, 0x2201A2B9, 0xD67EC21B,
     0x968EAACB, 0xF5DCD146, 0x6B6BDD1B, 0x43276BB4, 0x3C250D76, 0x14680D72, 0x445EE3E6},
    {0xDF935917, 0x2D1FE315, 0x718F550E, 0x3637D9AD, 0x5DC5FE89, 0x323FC92C, 0xBED8D95, 0xF2511F77, 0x30DD275C,
     0x31726F47, 0x2CC614AE, 0xC96F00DC, 0xB892B75A, 0xD5492F, 0xA71FCC0, 0x3942D03C},
    {0x43311591, 0xB8356081, 0x78ABD7F, 0xDABB4E65, 0xBE61C295, 0xFE5A00BF, 0xE57225C7, 0xF072CB78, 0x22CE0AC6,
     0xE8D8A673, 0xD33D2B2E, 0x85EFE4F5, 0x1FA20737, 0xCB425078, 0xBDF80EA2, 0x7AB30359},
    {0xE20EA804, 0x2DA46FB0, 0x59C14DBE, 0xB5A0BCA7, 0x7D6989FC, 0x2BA5FFF7, 0x171DA818, 0x9FDC6520, 0xE9134AAA,
     0xA77928C2, 0x26CC8879, 0xE3E11008, 0x9BBAFA68, 0x4219998C, 0x4E76752F, 0xBCACF63C},
    {0x29877D41, 0x6439311B, 0x9F8B6D00, 0xA96C0693, 0x9AFF6F7D, 0x2C85CDE1, 0x70C3B52C, 0x696B4D97, 0x1055F743,
     0x21CD4D13, 0x48C60C69, 0x2BAEA6CF, 0xCD21DC16, 0xCC9EE637, 0x1DFCF34E, 0x93D65B6},
    {0x29FCF6A7, 0x297E663D, 0xD1EE1F97, 0x79ED33EA, 0xA0703AD8, 0x1E8EA0E1, 0x9A0B1911, 0x82A3CB1C, 0x51563C80,
     0x4CD390AF, 0x67AD8898, 0x9F28DDCD, 0xA65AB0F, 0x442B6F9, 0x4DD6A6CB, 0x72117872},
    {0x527963BF, 0x9B9EB62F, 0x13226CCF, 0x5FDE01E4, 0xA0BE006A, 0x383D0870, 0x65CE9E16, 0x50236051, 0x6C7383F0,
     0x335F84A3, 0x3B639DDC, 0x29473D67, 0xE53C6B2E, 0x4BA5C6F, 0xF4C755E3, 0xC3B3A0B},
    {0x1DF739EE, 0xD32A89CA, 0x4F8D0205, 0xA45B5180, 0xC229CCA7, 0x10A9C500, 0xFC3BA647, 0x3E0666B9, 0x730D435,
     0xD7AF16DB, 0x9723F51F, 0x3F209686, 0xEF02AB1, 0x85D5BAC4, 0x68C65752, 0x7CEFBAFB},
    {0x26524D37, 0x408D6A41, 0xC221F35, 0xAB32BF61, 0xB1D27748, 0x9844F795, 0xA8B7BD47, 0x7C7EE94B, 0x4C43FDCC,
     0x6E2DB75, 0x3B951CC8, 0x4E61477C, 0xA564DEEA, 0x6D5DE5E2, 0xCB94606E, 0xDD77C848},
    {0x481EBD85, 0xA4F7D82A, 0x6549B9CA, 0xA029CAA0, 0xE3AA1BE9, 0x800C7EA0, 0x97592EB3, 0x13EF3357, 0xE54CA59E,
     0xE0974190, 0xEAE70963, 0xC043C890, 0x402CCA5C, 0xFD69D6A7, 0xDC95E2DF, 0xBC427588},
    {0x8C25B3, 0x8D9DED60, 0xE4F38CE9, 0xE24E48AB, 0xC532F159, 0xEF21CA2C, 0xE7E094F8, 0x30AB9F56, 0x9523ED79,
     0x6149A1F2, 0x3213FB09, 0xC2D90C21, 0xEB782A49, 0xFE1F1F06, 0x9CF6F23, 0xC38B2C7},
    {0x556AFA05, 0x33973E67, 0x86FAD60E, 0xB84F71FA, 0x4A2E88B1, 0xAE076A63, 0x228A073D, 0xC5A0A6ED, 0xD12847DD,
     0x3735D202, 0x794CB5BD, 0x24FD66FD, 0x62A4679D, 0x197BDE00, 0x9B928BD8, 0x62AEDFE4},
    {0x57090393, 0xA83D97A3, 0x20254DEE, 0x3025AC72, 0xBD7990AC, 0xF9A47663, 0x73025764, 0xC13E4B47, 0x8B9843F9,
     0x76D919D1, 0x6C75E2E, 0x153DAC34, 0xE608D66E, 0x481B0810, 0x20ABD8CA, 0x1E93020A},
    {0x18961E73, 0x95A7BD7D, 0x6279CAB2, 0x5D422D22, 0x59FAC2A4, 0x87AE630F, 0x5A8B4973, 0xA19433E1, 0x2084FEB5,
     0xA0015AD4, 0x22765F75, 0x8684F8F0, 0x23114695, 0xCB990DDA, 0xBCF84492, 0x4502912C},
    {0x8F6038A2, 0x57D0BE0B, 0x14CFCBD0, 0xAF6D60FF, 0xAD00B1B2, 0x26316B8F, 0xB0A48852, 0x74D3A139, 0x95FCFFB4,
     0x37449071, 0xA5FBC30, 0x425BECEE, 0xF7DDAFAD, 0x3F8B110A, 0x8D336C6C, 0x9C97268},
    {0x408F8CBE, 0xB1D17C39, 0xAAFD337D, 0xA860F0E2, 0x7E6D531A, 0xCA28DFA9, 0xC11A9F34, 0xA9CEEEFF, 0x78FE927F,
     0xB4AF92F5, 0xA7BD01B8, 0x9EC53468, 0xD21732C9, 0x46C45678, 0x7FF1E63B, 0xBB628E31},
    {0xA74AF650, 0x722025F9, 0x77F67846, 0x9BCCBD3D, 0x5AFDEB0, 0x89812757, 0x250C0250, 0x422B1DFC, 0xCC711556,
     0x69668049, 0x564DFE2E, 0x14E92AE5, 0x9DB2CC8B, 0x61635111, 0xAFC4A6B0, 0xA0C45A09},
    {0x3EE7C71A, 0xB2303A11, 0xE0C5BADA, 0xC5C71975, 0xF8BF1970, 0xEBAE33C0, 0x8B36622A, 0x81AF6C06, 0xB7D78673,
     0x9FA4127D, 0xB4A841A4, 0x59FE7154, 0x9D66CFE9, 0x800B67CA, 0x3114A1F7, 0x3B5BDA1D},
    {0x3A09F5B0, 0x824B8F5B, 0x360D25DF, 0x981AA9F, 0x25E50BBC, 0x68032F8B, 0x73278351, 0xCF473383, 0x3B06A123,
     0x20AD0865, 0x8F5953C5, 0x709D48ED, 0x4F3C1B97, 0x52A27E5E, 0x832EB788, 0xC0AF765},
    {0xC841C458, 0x5B16FAB6, 0x1DC29199, 0xA2EB27D, 0xB18823FE, 0x820B806B, 0x6AD273EA, 0xB9420D7D, 0x5D504EA3,
     0x83A1C7AC, 0x2847D6EE, 0x931A3C1E, 0xF83C19B, 0xA12E8555, 0x9765771D, 0xE9B42355},
    {0x8052D6C6, 0x86811433, 0x762AA758, 0xC6D1FAA6, 0xABF5E8DA, 0x47FDC89F, 0xD22613C9, 0xDD622663, 0x27C15317,
     0xCFE4191C, 0xAFF0DD09, 0x9B3742C1, 0x656127E0, 0x72D3077, 0xC9F27E48, 0x530C39AB},
    {0xC2613CD6, 0x76ED5893, 0x406BACCD, 0x7C78B3BE, 0xF07C9E42, 0xCACA7052, 0x4466EEA9, 0xBEB23C98, 0x54A1F3B,
     0x2A17E1CA, 0xA5695A3, 0xEA40159E, 0x47096372, 0xB39E60D0, 0xC2501403, 0x219D6300},
    {0xC8E2E76E, 0xB64D24C6, 0x30E4014A, 0x9AB03C1D, 0xC728C99, 0x75800732, 0xEE28E006, 0xD7306725, 0x1E6667F7,
     0x4FCDAE7A, 0x9E811A67, 0x42171106, 0x3B534224, 0x5127B31A, 0xA0181B0B, 0x26607D31},
    {0xAE000391, 0xF8866109, 0x2AC15C93, 0x687D9CB2, 0x81AB7A99, 0x677EBCE6, 0x2AAFEC0B, 0xDF34EE3F, 0x3E6E8F3B,
     0x1B30301C, 0x63F9694C, 0x67F03EFE, 0x248277A5, 0x8F37899B, 0xF9D1C004, 0x292AC179},
    {0x6B7361CD, 0xF3083F5C, 0xED5A7B34, 0x4817A417, 0xEDEE5F74, 0xA6FFFCBC, 0x285D46F9, 0x71AADF8A, 0x724965FC,
     0x7334A3EC, 0x9198A40, 0x7599D01F, 0xDE744918, 0x97170910, 0x628B69B9, 0x3BA30576},
    {0x50518550, 0x10013B5F, 0xC4E23D1C, 0x8A04D538, 0x43875091, 0x2E82E188, 0x278A7476, 0x515825B2, 0x402BAF7E,
     0x23F05B69, 0x35CAD03C, 0x4996D77F, 0xF69D5E, 0x3B7B11DB, 0xC9C0D9D3, 0xB3ED1FC8},
    {0x35D516B, 0x618B52DE, 0x8F889C6, 0xEEC66E3A, 0x22689733, 0x9DFB5AC8, 0x84517AF3, 0x41D4248E, 0x7F087968,
     0xEC42F7A2, 0x1EABB220, 0x52C53CE8, 0xF1807A44, 0x70F35253, 0xE57312C4, 0xAC564B8E},
    {0x6592884B, 0xDDC906DA, 0x63AC2066, 0x855DF4F9, 0x8BE187FE, 0xB521268B, 0x260D0D88, 0x583649C0, 0xA158D4E,
     0xE61D9DFF, 0x265A105E, 0xE50F25CB, 0xB178CBDB, 0x444E5A0A, 0xB7CE2875, 0x8D86874D},
    {0xB7F0CF87, 0xF7BBF72A, 0x8440B99E, 0x87948CAF, 0xD9EBA7F3, 0xEAE2BEE, 0x486297B2, 0x32D35CD3, 0xCC5AED3D,
     0x389AC22D, 0x6EC247BF, 0x9358110A, 0x8687CBC0, 0x98D0D507, 0xBBC33C70, 0x4C1E5624},
    {0x28D328C8, 0xFBB17581, 0xAC13E59, 0x5C9DC076, 0x7996D880, 0x91029676, 0xD0C5AB17, 0x262BDB94, 0xC4F1F605,
     0x25096773, 0xA626D062, 0xCFDDC59A, 0x2A6FEE87, 0xB31E08BE, 0x31F86E6B, 0x3C9EDEC2},
    {0x883ACDC7, 0x9C8707E3, 0x6A3A4570, 0x5FC1D0CF, 0xA12DE28C, 0x813B6F, 0x25B8C58, 0x3888FC31, 0xF5EEFEDC,
     0xC6FD1C83, 0x1BF20E9D, 0x51D9A84C, 0x9592DD5E, 0x28075D4F, 0xF31AA9B0, 0x42AD77C9},
    {0x55BE72B2, 0x92381DDF, 0xBD629F8F, 0x91BA4230, 0xFB34B2CE, 0x46CF7F7B, 0xE364A93E, 0x26441660, 0x910D9356,
     0xF9311F85, 0x8D859034, 0x2FA33045, 0xD6ED20C4, 0xC68B7222, 0x41B8DCAD, 0x80E7141},
    {0x899289F5, 0xB980AD99, 0x3A805551, 0x280F33C0, 0xDEE200F, 0xB4A563AE, 0x743FD536, 0xCB913741, 0xA234D20,
     0x23E1456D, 0xD7CEF721, 0x6EA19C35, 0xD6BE80AE, 0x524B7C7D, 0xD67ABF9, 0xEB393732},
    {0xFF8D0638, 0x2B8AD052, 0xBF1FCF8D, 0x702AF53E, 0x5E622488, 0xEDB102BC, 0x959B48A3, 0x7315505D, 0x565FC36E,
     0x904E6193, 0xECCC2008, 0xBEA06454, 0x61445258, 0x5343219C, 0xDFDD9789, 0xE8C723F8},
    {0x2525F058, 0xC93938F8, 0xD2A087FA, 0x91F0B5B8, 0x197C7C08, 0x15E87C6D, 0x8A5A0D2F, 0x8447B43, 0x1FD4823D,
     0xEC99B989, 0xD34AB844, 0x89AB24BC, 0x3737833C, 0xC15A38F4, 0x1B1B2478, 0x57D321C0},
    {0x3CB32860, 0x3D9020CA, 0xFE8E8561, 0x9BF00E3B, 0xC0B1A00B, 0x42AB23C5, 0x1C0C9E69, 0xBFB7573A, 0x8B33DD4D,
     0x1DBA6E23, 0x210FC70C, 0x52DEDDA3, 0x84C5EF3A, 0xDF7B469, 0xE4C62087, 0xB9CCF7CE},
    {0xC58B4C7D, 0xE7A4EE71, 0xC45974F0, 0x1F516E77, 0xFF6A4C47, 0x81C574E0, 0x504ACD1F, 0x5140AB3F, 0x3B1586,
     0xCE8F4D64, 0xA9686174, 0x186AC558, 0xEFAAB231, 0x4354A869, 0x3F98EEB, 0xBE3F7C0A},
    {0xE73BA492, 0xDA80DC4D, 0x1E56329C, 0xB762E84B, 0xCEBFD5E5, 0x6B9078AF, 0x507EACFE, 0xCEA9E07, 0xE8CD9ADE,
     0x102CC344, 0xD6CC1D52, 0x8538F9E, 0x7D6DB778, 0x36CCBC96, 0x14071BB1, 0x52287B36},
    {0xB677EC2A, 0x958FB02D, 0xD75A335B, 0x8610AAE6, 0xB22C0A90, 0xB8F40710, 0xC710407A, 0x6679B63, 0xB76A675F,
     0xE65BB8F9, 0xDA735D09, 0xE58D0852, 0x3B4BCE0D, 0xCA9D2DE7, 0xCA343D39, 0x12387C0E},
    {0xDA2E046, 0x8D80D882, 0x47AB338, 0x3D89DBDA, 0xBC81E4F3, 0xB908BFDE, 0xB8C2C7E0, 0xE17E4B11, 0xB5C6B6EF,
     0x831A9D5A, 0xAF5D7AD5, 0x72E75406, 0x59DBA0AB, 0x13130056, 0x9B091976, 0xE8F9BE8C},
    {0x8CC25674, 0x8A622BF1, 0x34BDF05A, 0xBEC3792D, 0x42A18CDC, 0x7E721FFF, 0x2C4C15AA, 0xB7468BF9, 0xDA218E2,
     0xE6A1E3BD, 0x3B7FBE2E, 0x956993C3, 0x8B56AD84, 0xFF37960F, 0x7FD36B37, 0x8DF6655B},
    {0xD4B9279, 0x9B9E2541, 0x431ED296, 0xC1DEED0A, 0xDE9E444C, 0xA6F96737, 0x643D091, 0x66EC5536, 0x1B68D644,
     0x5DB1362C, 0xAF9DF7A7, 0xACFA7368, 0x2891206C, 0x4370CD6C, 0x5FFFD2A6, 0x13FA0353},
    {0x6AFFF9FF, 0xC1A2C21B, 0x6592D152, 0x52014CC3, 0xBC8A29DA, 0xD0436165, 0x140522F3, 0xF851369B, 0x64778824,
     0x4056BE4A, 0xE92B8B12, 0x86186801, 0xFC80518, 0x6590BD33, 0x91A7EECC, 0x3EF20F2B},
    {0xD5E80328, 0x13B77236, 0x2F871BD0, 0xBA8680CD, 0xAB0DFC9, 0x9A95B48B, 0xA63F9774, 0xD62032EA, 0x2B38A2F8,
     0x2538B796, 0x48A74AC1, 0xD949E56D, 0xA0D54459, 0x66BF1D72, 0x68F29A7F, 0xA7B898FD},
    {0x8D859C7E, 0x10FE035E, 0xE46CC89B, 0x9720B064, 0x3073CB68, 0x1F4FD6C7, 0x4FF2AD5E, 0x6DE17E69, 0x7D149F59,
     0xD6F3CE59, 0x65035E35, 0xD3682D47, 0x773969DC, 0x8725379E, 0x448FEAFE, 0xBBB2D9B6},
    {0x481F4C37, 0x1BC4D485, 0xE3EF3245, 0xEFCD956, 0x6F0A2575, 0x916DAD9, 0xF78B470B, 0x6DE23C9F, 0x443A4430,
     0x18C36167, 0xB8FA899E, 0x585F43B1, 0xB5B52CD7, 0xE1AF842A, 0x1340FE6D, 0x7A207622},
    {0x47429C38, 0x32895172, 0x3A15A2A4, 0x341261D9, 0x934FE67A, 0xDE6B140C, 0x7277D3AC, 0xBC312AAE, 0xD5F73596,
     0x9C69DBDE, 0x3B91BCA3, 0x4DAD808C, 0x8B4AD10, 0x6B7C6300, 0xA67F757E, 0x91184FF4},
    {0x89A357CF, 0x88FA9689, 0x41E2E499, 0xB4EF76C7, 0x3928C773, 0xF5AF198F, 0x870C7411, 0x1F143329, 0x3806E555,
     0x920C42CE, 0xC24355C8, 0xB11BF716, 0xC8474CE0, 0xE0304369, 0xC44BEBD4, 0x28BE46FC},
    {0xCCE9EDE7, 0x8C4956DB, 0x8C057D18, 0x9E004558, 0xDBFD13F0, 0xAE4E6EE8, 0xBBEAE6A4, 0x6A2E2775, 0x7C088FEE,
     0x90093511, 0x5A4C7016, 0xB4DD2E69, 0x6B582533, 0x36AA5756, 0xA875DF43, 0xA8902C07},
    {0xD14B1384, 0xB082EB45, 0xB519BCC2, 0xADDC8F0E, 0xE1B25D36, 0xF9F3A08A, 0xAAEDD1B9, 0x1A499CA3, 0x23AC6D9B,
     0x2C008896, 0x35C40D68, 0x549F78D4, 0xA9633CA6, 0xB945A7D2, 0x9C4E61A6, 0x6B42F288},
    {0xE8633497, 0xA53C5E1A, 0x2D98A421, 0xE1151DC1, 0xEA0682FF, 0x9463DED8, 0x7E0EB7A5, 0x25E248EB, 0x8D352B81,
     0xD463D75A, 0xB74DD6EC, 0x5F002769, 0x4E770B60, 0xD5ED042D, 0x58DC1145, 0xB2F6C05E},
    {0x63FAB131, 0x5162E97A, 0x50F8B3DC, 0xF51687EE, 0x724C97BD, 0xF899ACD0, 0x7ADA7BB6, 0xBDB7B193, 0x5C5D192E,
     0x58201ADA, 0x66AF2D6C, 0x880774F2, 0x71DD25F6, 0x922E22CB, 0x13AACFF9, 0x2F4E0877},
    {0x98014177, 0x7C894C0E, 0x76D93C20, 0xAF09FDF2, 0x83032342, 0x278F29B7, 0x3E3A8068, 0xF9E0BEF3, 0xDB4D07D0,
     0x16E3309E, 0x1DF178C4, 0xC66F694C, 0x1F490C25, 0x27E78699, 0xF89564C, 0xB636684A},
    {0x6FE3DDC8, 0x948FCE97, 0x5B6E007D, 0x7CCB3697, 0x22ED6D7B, 0xBBA132C5, 0x9F6A0E47, 0xA72E51A5, 0x2FD0D9FD,
     0x3D4C214E, 0x2DD2289B, 0x7C9598A5, 0xE14B3EF9, 0xC4FCC372, 0x2EF64DED, 0x153C0B7F},
    {0x73576C50, 0xBC4B9D45, 0xC3CABB82, 0xCC68C9C6, 0x555F7F01, 0x83A4DD19, 0x7B0AE50D, 0x7A7C782D, 0xDDB939ED,
     0x75126F92, 0x5AD59F22, 0x499D4CE8, 0x66102A7D, 0x3B8AAD9F, 0xB125E392, 0xB2DB590D},
    {0xBB7440A4, 0x383851A8, 0x1CA060FC, 0x15F6E1, 0x2D058F38, 0xFE94AD7A, 0xE916C25A, 0x6444AC1, 0xE2330731,
     0x518538A9, 0xA25E1EAC, 0x43BC1D4C, 0xE5F13E68, 0x34AB5E73, 0xBB695144, 0xC0E793CD},
    {0x4DA11562, 0xE4ABB172, 0x6D898133, 0x4D10D246, 0x27712F2E, 0x36C51772, 0x3D12F49E, 0x609BD2D6, 0x3C686A4B,
     0xBA1E5E4C, 0xA2301A70, 0x32058A37, 0xD0C287CB, 0x1632B89B, 0x675CC731, 0xD50C7613},
    {0xD0858E44, 0x46DFF5A5, 0xE0560281, 0x9229E913, 0xBB7B27C6, 0xA532F11F, 0x8A48163D, 0x8AAF3D40, 0xE93A7412,
     0xBC2C454B, 0xC88D704F, 0xCB1478BE, 0x9B91A0B5, 0x65DB5ADD, 0x355E7CFC, 0x9ABF2D3B},
    {0xFDBEBC6D, 0x9CF1019F, 0x4474857E, 0x2E9FC6DC, 0x39DE3FA2, 0x6F3BC748, 0x3EC7D854, 0xB9B53111, 0x3B2A6474,
     0xB50BE888, 0x863A7330, 0xBD198C23, 0x3B00310E, 0x960C9ED3, 0xCAC319D6, 0x4E7DCB70},
    {0xEA5BDF6B, 0x1F5BB436, 0x2314F5ED, 0x3EC5D28C, 0x39E8086E, 0x7F83B941, 0xECAE909F, 0xB08F0CA9, 0x3DB0897C,
     0xECDCE244, 0x43B87890, 0x20BE4D40, 0xAD2377A9, 0x394B8643, 0x8E9D3B11, 0xCCD21AD},
    {0x24C2DF50, 0x8FA34F51, 0x8BF0B6A4, 0x942DDB09, 0x5DEF076, 0x5D4B1133, 0x35EDBBF1, 0x73395808, 0xF0624341,
     0x93184A88, 0x85D875A9, 0x6A1E33C2, 0xD0DB4E0E, 0xA75457AB, 0xBDA7F209, 0xCE94D2FE},
    {0xA30AB2D, 0xF970B09D, 0xD9CF6747, 0x7EEF336A, 0x132245D, 0x978106B0, 0xB28142A8, 0xB5698683, 0xD4170D6E,
     0x51EC5CF5, 0x69089B50, 0xECF249B6, 0xD3433CF9, 0x78EA16C5, 0x262FA874, 0x5ADE6C7D},
    {0x17184337, 0x891D7C5D, 0xF479F4D1, 0xCCEAB5ED, 0xBAF1B5E6, 0x3426BE1B, 0xC044AEBA, 0xC61334FB, 0xDCF67F2F,
     0xD99933DF, 0x27A45F8B, 0xD97FA757, 0x55464745, 0x46CA4C76, 0x5F9522F9, 0xC08E72D2},
    {0x7FEDD37B, 0xF526A454, 0xF618DDC7, 0xBEB81BF2, 0x7FF8EBEC, 0x91CDCB6D, 0x3E2AA23F, 0xB8AFC3ED, 0xA9063363,
     0x53577C7D, 0xA7BC6D13, 0x2F199C74, 0xCAAB2B19, 0x1E602BA0, 0xF6EF75CD, 0x6C1E9442},
    {0xE77A973E, 0xB5B32767, 0xD39D4E68, 0x43CDE03C, 0x74F46855, 0x6CF21A62, 0x5A4B5311, 0x9C1D8240, 0x17B2D800,
     0x16D4C4C2, 0xAF5C5BB1, 0xDE2C4500, 0x868C1C2A, 0x55E6734B, 0x4631A042, 0x4246FA4A},
    {0x553DF029, 0x6264DCEF, 0x54CA7906, 0xDC43EC0, 0xF1986B52, 0x249E2F59, 0xEBD94CB6, 0xE331D6CD, 0xCA72384,
     0xCE65E6E, 0x299380B6, 0x12F69A50, 0x75CBB12, 0x4E524A14, 0x64503454, 0xF0B7EC04}};

#endif /* __TEST_ECDOUBLEMUL_H */
