/*!
* @file controller_parameter_list.c
*
* @author  
*
* @version 1.0
*
* @date Mar-14-2016
*
* @brief 
*
********************************************************************************
*
* Copyright (c) 2016, Freescale Semiconductor.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*******************************************************************************
* Header Files
*******************************************************************************/
#include "controller_parameter_list.h"

/*******************************************************************************
* Controller parameters
*******************************************************************************/
controller_parameter_list_t controllerParameterList [3] = {
  /* LG Controller parameters */
  {
    .controllerTimingParameters = {
      .headerOnTime = 8994,               
      .headerOffTime = 4417,              
      .logic0OnTime = 590,              
      .logic0OffTime = 511,              
      .logic1OnTime = 590,             
      .logic1OffTime = 1649,            
      .stopTime = 568,                  
      .gapTime = 107287,                 
      .carrierOnTime = 64,            
      .carrierOffTime = 128,
    },
    .controllerCommands = {
      0x20DF10EF,   //Power On/Off
      0x20DF906F,   //Mute
      0x20DF40BF,   //Volume +
      0x20DFC03F,   //Volume -
      0x20D00FF,   //Channel +
      0x20DF807F,   //Channel -
    },
    .bitsPerCommand = 32,
    .commandRepeatTimes = 1,
  },
  /* Samsung controller parameters */
  {
    .controllerTimingParameters = {
      .headerOnTime = 4465,               
      .headerOffTime = 4528,              
      .logic0OnTime = 555,              
      .logic0OffTime = 569,              
      .logic1OnTime = 555,             
      .logic1OffTime = 1665,            
      .stopTime = 550,                  
      .gapTime = 47048,                 
      .carrierOnTime = 64,            
      .carrierOffTime = 128,
    },
    .controllerCommands = {
      0xE0E040BF,   //Power On/Off
      0xE0E0F00F,   //Mute
      0xE0E0E01F,   //Volume +
      0xE0E0D02F,   //Volume -
      0xE0E048B7,   //Channel +
      0xE0E008F7,   //Channel -
    },
    .bitsPerCommand = 32,
    .commandRepeatTimes = 1,
  },
  /* SONY controller parameters */
  {
    .controllerTimingParameters = {
      .headerOnTime = 2463,               
      .headerOffTime = 550,              
      .logic0OnTime = 649,              
      .logic0OffTime = 548,              
      .logic1OnTime = 1250,             
      .logic1OffTime = 548,            
      .stopTime = 649,                  
      .gapTime = 45072,                 
      .carrierOnTime = 64,            
      .carrierOffTime = 128,
    },
    .controllerCommands = {
      0xA9000000,   //Power On/Off
      0x29000000,   //Mute
      0x49000000,   //Volume +
      0xC9000000,   //Volume -
      0x09000000,   //Channel +
      0x89000000,   //Channel -
    },
    .bitsPerCommand = 11,
    .commandRepeatTimes = 3,
  }
};