/*! *********************************************************************************
* \addtogroup fxos8700cq
* @{
********************************************************************************** */
/*!
* @file FXOS8700CQ_registers.h
*
* @author  
*
* @version 1.0
*
* @date Mar-14-2016
*
* @brief 
*
********************************************************************************
*
* Copyright (c) 2016, Freescale Semiconductor.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
* \defgroup fxos8700cq_registers FXOS8700CQ Registers
* @{
* This module defines all the registers present in the FXOS8700CQ sensor.
* See the FXOS8700CQ datasheet for more information.
*/

#ifndef _FXOS8700CQ_REGISTERS_H_
#define _FXOS8700CQ_REGISTERS_H_

/************************************************************************************
* Register definition
************************************************************************************/
//#define FXOS8700CQ
#define FXOS8700CQ_STATUS                       0x00
#define FXOS8700CQ_OUT_X_MSB                    0x01
#define FXOS8700CQ_OUT_X_LSB                    0x02
#define FXOS8700CQ_OUT_Y_MSB                    0x03
#define FXOS8700CQ_OUT_Y_LSB                    0x04
#define FXOS8700CQ_OUT_Z_MSB                    0x05
#define FXOS8700CQ_OUT_Z_LSB                    0x06
#define FXOS8700CQ_F_SETUP                      0x09
#define FXOS8700CQ_TRIG_CFG                     0x0A
#define FXOS8700CQ_SYSMOD                       0x0B
#define FXOS8700CQ_INT_SOURCE                   0x0C
#define FXOS8700CQ_WHO_AM_I                     0x0D
#define FXOS8700CQ_XYZ_DATA_CFG                 0x0E
#define FXOS8700CQ_HP_FILTER_CUTOFF             0x0F
#define FXOS8700CQ_PL_STATUS                    0x10
#define FXOS8700CQ_PL_CFG                       0x11
#define FXOS8700CQ_PL_COUNT                     0x12
#define FXOS8700CQ_PL_BF_ZCOMP                  0x13
#define FXOS8700CQ_PL_THS_REG                   0x14
#define FXOS8700CQ_A_FFMT_CFG                   0x15
#define FXOS8700CQ_A_FFMT_SRC                   0x16
#define FXOS8700CQ_A_FFMT_THS                   0x17
#define FXOS8700CQ_A_FFMT_COUNT                 0x18
#define FXOS8700CQ_TRANSIENT_CFG                0x1D
#define FXOS8700CQ_TRANSIENT_SRC                0x1E
#define FXOS8700CQ_TRANSIENT_THS                0x1F
#define FXOS8700CQ_TRANSIENT_COUNT              0x20
#define FXOS8700CQ_PULSE_CFG                    0x21
#define FXOS8700CQ_PULSE_SRC                    0x22
#define FXOS8700CQ_PULSE_THSX                   0x23
#define FXOS8700CQ_PULSE_THSY                   0x24
#define FXOS8700CQ_PULSE_THSZ                   0x25
#define FXOS8700CQ_PULSE_TMLT                   0x26
#define FXOS8700CQ_PULSE_LTCY                   0x27
#define FXOS8700CQ_PULSE_WIND                   0x28
#define FXOS8700CQ_ASLP_COUNT                   0x29
#define FXOS8700CQ_CTRL_REG1                    0x2A
#define FXOS8700CQ_CTRL_REG2                    0x2B
#define FXOS8700CQ_CTRL_REG3                    0x2C
#define FXOS8700CQ_CTRL_REG4                    0x2D
#define FXOS8700CQ_CTRL_REG5                    0x2E
#define FXOS8700CQ_OFF_X                        0x2F
#define FXOS8700CQ_OFF_Y                        0x30
#define FXOS8700CQ_OFF_Z                        0x31
#define FXOS8700CQ_M_DR_STATUS                  0x32
#define FXOS8700CQ_M_OUT_X_MSB                  0x33
#define FXOS8700CQ_M_OUT_X_LSB                  0x34
#define FXOS8700CQ_M_OUT_Y_MSB                  0x35
#define FXOS8700CQ_M_OUT_Y_LSB                  0x36
#define FXOS8700CQ_M_OUT_Z_MSB                  0x37
#define FXOS8700CQ_M_OUT_Z_LSB                  0x38
#define FXOS8700CQ_CMP_X_MSB                    0x39
#define FXOS8700CQ_CMP_X_LSB                    0x3A
#define FXOS8700CQ_CMP_Y_MSB                    0x3B
#define FXOS8700CQ_CMP_Y_LSB                    0x3C
#define FXOS8700CQ_CMP_Z_MSB                    0x3D
#define FXOS8700CQ_CMP_Z_LSB                    0x3E
#define FXOS8700CQ_M_OFF_X_MSB                  0x3F
#define FXOS8700CQ_M_OFF_X_LSB                  0x40
#define FXOS8700CQ_M_OFF_Y_MSB                  0x41
#define FXOS8700CQ_M_OFF_Y_LSB                  0x42
#define FXOS8700CQ_M_OFF_Z_MSB                  0x43
#define FXOS8700CQ_M_OFF_Z_LSB                  0x44
#define FXOS8700CQ_MAX_X_MSB                    0x45
#define FXOS8700CQ_MAX_X_LSB                    0x46
#define FXOS8700CQ_MAX_Y_MSB                    0x47
#define FXOS8700CQ_MAX_Y_LSB                    0x48
#define FXOS8700CQ_MAX_Z_MSB                    0x49
#define FXOS8700CQ_MAX_Z_LSB                    0x4A
#define FXOS8700CQ_MIN_X_MSB                    0x4B
#define FXOS8700CQ_MIN_X_LSB                    0x4C
#define FXOS8700CQ_MIN_Y_MSB                    0x4D
#define FXOS8700CQ_MIN_Y_LSB                    0x4E
#define FXOS8700CQ_MIN_Z_MSB                    0x4F
#define FXOS8700CQ_MIN_Z_LSB                    0x50
#define FXOS8700CQ_TEMP                         0x51
#define FXOS8700CQ_M_THS_CFG                    0x52
#define FXOS8700CQ_M_THS_SRC                    0x53
#define FXOS8700CQ_M_THS_X_MSB                  0x54
#define FXOS8700CQ_M_THS_X_LSB                  0x55
#define FXOS8700CQ_M_THS_Y_MSB                  0x56
#define FXOS8700CQ_M_THS_Y_LSB                  0x57
#define FXOS8700CQ_M_THS_Z_MSB                  0x58
#define FXOS8700CQ_M_THS_Z_LSB                  0x59
#define FXOS8700CQ_M_THS_COUNT                  0x5A
#define FXOS8700CQ_M_CTRL_REG1                  0x5B
#define FXOS8700CQ_M_CTRL_REG2                  0x5C
#define FXOS8700CQ_M_CTRL_REG3                  0x5D
#define FXOS8700CQ_M_INT_SRC                    0x5E
#define FXOS8700CQ_A_VECM_CFG                   0x5F
#define FXOS8700CQ_A_VECM_THS_MSB               0x60
#define FXOS8700CQ_A_VECM_THS_LSB               0x61
#define FXOS8700CQ_A_VECM_CNT                   0x62
#define FXOS8700CQ_A_VECM_INITX_MSB             0x63
#define FXOS8700CQ_A_VECM_INITX_LSB             0x64
#define FXOS8700CQ_A_VECM_INITY_MSB             0x65
#define FXOS8700CQ_A_VECM_INITY_LSB             0x66
#define FXOS8700CQ_A_VECM_INITZ_MSB             0x67
#define FXOS8700CQ_A_VECM_INITZ_LSB             0x68
#define FXOS8700CQ_M_VECM_CFG                   0x69
#define FXOS8700CQ_M_THS_MSB                    0x6A
#define FXOS8700CQ_M_THS_LSB                    0x6B
#define FXOS8700CQ_M_VECM_CNT                   0x6C
#define FXOS8700CQ_M_VECM_INITX_MSB             0x6D
#define FXOS8700CQ_M_VECM_INITX_LSB             0x6E
#define FXOS8700CQ_M_VECM_INITY_MSB             0x6F
#define FXOS8700CQ_M_VECM_INITY_LSB             0x70
#define FXOS8700CQ_M_VECM_INITZ_MSB             0x71
#define FXOS8700CQ_M_VECM_INITZ_LSB             0x72
#define FXOS8700CQ_A_FFMT_THS_X_MSB             0x73
#define FXOS8700CQ_A_FFMT_THS_X_LSB             0x74
#define FXOS8700CQ_A_FFMT_THS_Y_MSB             0x75
#define FXOS8700CQ_A_FFMT_THS_Y_LSB             0x76
#define FXOS8700CQ_A_FFMT_THS_Z_MSB             0x77
#define FXOS8700CQ_A_FFMT_THS_Z_LSB             0x78

/************************************************************************************
* Register memory map
************************************************************************************/
typedef union _FXOS8700CQ_CTRL_REG1_map{
  unsigned char ctrl_reg1;
  struct{
  unsigned char active: 1;
  unsigned char f_read: 1;
  unsigned char lnoise: 1;
  unsigned char dr: 3;
  unsigned char aslp_rate : 2;
  }ctrl_reg1_map;
}FXOS8700CQ_CTRL_REG1_map_t;

typedef union _FXOS8700CQ_CTRL_REG2_map{
  unsigned char ctrl_reg2;
  struct{
  unsigned char mods: 2;
  unsigned char slpe: 1;
  unsigned char smods: 2;
  unsigned char reserved: 1;
  unsigned char rst: 1;
  unsigned char st: 1;
  }ctrl_reg2_map;
}FXOS8700CQ_CTRL_REG2_map_t;

typedef union _FXOS8700CQ_XYZ_DATA_CFG_map{
  unsigned char xyz_data_cfg;
  struct{
  unsigned char fs: 2;
  unsigned char reserved0: 2;
  unsigned char hpf_out: 1;
  unsigned char reserved1: 3;
  }xyz_data_cfg_map;
}FXOS8700CQ_XYZ_DATA_CFG_map_t;

typedef union _FXOS8700CQ_M_CTRL_REG1_map{
  unsigned char m_ctrl_reg1;
  struct{
    unsigned char m_hms : 2;
    unsigned char m_os: 3;
    unsigned char m_ost: 1;
    unsigned char m_rst: 1;
    unsigned char m_acal: 1;
  }m_ctrl_reg1_map;
}FXOS8700CQ_M_CTRL_REG1_map_t;

typedef union _FXOS8700CQ_M_CTRL_REG2_map{
  unsigned char m_ctrl_reg2;
  struct{
  unsigned char m_rst_cnt: 2;
  unsigned char m_maxmin_rst: 1;
  unsigned char m_maxmin_dis_ths: 1;
  unsigned char m_maxmin_dis: 1;
  unsigned char hyb_autoinc_mode: 1;
  unsigned char reserved: 2;
  }m_ctrl_reg2_map;
}FXOS8700CQ_M_CTRL_REG2_map_t;

typedef union _FXOS8700CQ_M_CTRL_REG3_map{
  unsigned char m_ctrl_reg3;
  struct{
  unsigned char reserved: 3;
  unsigned char m_ths_xys_update: 1;
  unsigned char m_aslp_os: 3;
  unsigned char m_raw: 1;
  }m_ctrl_reg3_map;
}FXOS8700CQ_M_CTRL_REG3_map_t;

/************************************************************************************
* Register parameters definition
************************************************************************************/
/*! 
  Defines output data rate. 
  - Single mode: Accelerometer or Magnetometer only
  - Hybrid mode: Accelerometer and Magnetometer
*/
typedef enum _FXOS8700CQ_data_rate_hz{
  kDataRate0,    /*<! Data rate option 0: 800 Hz single mode, 400 Hz hybrid mode */
  kDataRate1,    /*<! Data rate option 1: 400 Hz single mode, 200 Hz hybrid mode */
  kDataRate2,    /*<! Data rate option 2: 200 Hz single mode, 100 Hz hybrid mode */
  kDataRate3,    /*<! Data rate option 3: 100 Hz single mode, 50 Hz hybrid mode */
  kDataRate4,    /*<! Data rate option 4: 50 Hz single mode, 25 Hz hybrid mode */
  kDataRate5,    /*<! Data rate option 5: 12.5 Hz single mode, 6.25 Hz hybrid mode */
  kDataRate6,    /*<! Data rate option 6: 6.25 Hz single mode, 3.125 Hz hybrid mode */
  kDataRate7,    /*<! Data rate option 7: 1.5625 Hz single mode, 0.7813 Hz hybrid mode */
}FXOS8700CQ_data_rate_hz_t;

/*! 
  Defines enabled sensors
*/
typedef enum _FXOS8700CQ_sensor_enable{
  kAccelerometerOnly,   /*!< Only accelerometer is enabled */
  kMagnetometerOnly,    /*!< Only magnetometer is enabled */
  kHybridMode = 0x03u,  /*!< Accelerometer and magnetometer are enabled */
}FXOS8700CQ_sensor_enable_t;

/*!
  Available interrupt sources
*/
typedef enum _FXOS8700CQ_interrupt_sources{
  kInterruptSleep = (1<<7),              /*!< Sleep interrupt */
  kInterruptFIFO = (1<<6),               /*!< FIFO interrupt */        
  kInterruptTransient = (1<<5),          /*!< Transient interrupt */
  kInterruptOrientation = (1<<4),        /*!< Orientation interrupt */
  kInterruptPulse = (1<<3),              /*!< Pulse interrupt */
  kInterruptFFMT = (1<<2),               /*!< Freefall/Motion interrupt */
  kInterruptVECM = (1<<1),               /*!< Acceleration vector-magnitude interrupt */
  kInterruptDataReady = (1<<0),          /*!< Data ready interrupt */
  kInterruptDisabled = 0,                /*!< All interrupt sources are disabled */
}FXOS8700CQ_interrupt_sources_t;

/*!
  Interrupt pin mapping
  - 0: Interrupt mapped to INT1 pin
  - 1: Interrupt mapped to INT2 pin
*/
typedef enum _FXOS8700CQ_interrupt_pin_map{
  kInterruptSleepPinIsInt1 = (1<<7),              /*!< Sleep interrupt is mapped to INT1 */
  kInterruptFIFOPinIsInt1 = (1<<6),               /*!< FIFO interrupt is mapped to INT1 */        
  kInterruptTransientPinIsInt1 = (1<<5),          /*!< Transient interrupt is mapped to INT1 */
  kInterruptOrientationPinIsInt1 = (1<<4),        /*!< Orientation interrupt is mapped to INT1 */
  kInterruptPulsePinIsInt1 = (1<<3),              /*!< Pulse interrupt is mapped to INT1 */
  kInterruptFFMTPinIsInt1 = (1<<2),               /*!< Freefall/Motion interrupt is mapped to INT1 */
  kInterruptVECMPinIsInt1 = (1<<1),               /*!< Acceleration vector-magnitude interrupt is mapped to INT1 */
  kInterruptDataReadyPinIsInt1 = (1<<0),          /*!< Data ready interrupt is mapped to INT1 */
  kInterruptAllPinsAreInt2 = 0,                   /*!< All interrupt sources are routed to INT2 */
}FXOS8700CQ_interrupt_pin_map_t;

/*!
  Sensitivity options
*/
typedef enum _FXOS8700CQ_sensitivity{
  kSensitivity2g,                       /*!< +-2g Sensitivity */
  kSensitivity4g,                       /*!< +-4g Sensitivity */
  kSensitivity8g,                       /*!< +-8g Sensitivity */
}FXOS8700CQ_sensitivity_t;

/*!
  Accelerometer Oversampling Mods
*/
typedef enum _FXOS8700CQ_oversampling_mods{
  kNormal,                              /*!< Normal mode */
  kLowNoiseLowPower,                    /*!< Low-Noise + Low-Power mode */
  kHighResolution,                      /*!< High-resolution mode */
  kLowPower,                            /*!< Low-Power Mode */
}FXOS8700CQ_oversampling_mods_t;

/*!
  Magnetometer Oversampling Ratio
*/
typedef enum _FXOS8700CQ_magnetometer_osr{
  kMagnetometerOSR0,                    /*!< Magnetometer oversampling ratio = 0 */
  kMagnetometerOSR1,                    /*!< Magnetometer oversampling ratio = 1 */
  kMagnetometerOSR2,                    /*!< Magnetometer oversampling ratio = 2 */
  kMagnetometerOSR3,                    /*!< Magnetometer oversampling ratio = 3 */
  kMagnetometerOSR4,                    /*!< Magnetometer oversampling ratio = 4 */
  kMagnetometerOSR5,                    /*!< Magnetometer oversampling ratio = 5 */
  kMagnetometerOSR6,                    /*!< Magnetometer oversampling ratio = 6 */
  kMagnetometerOSR7,                    /*!< Magnetometer oversampling ratio = 7 */
}FXOS8700CQ_magnetometer_osr_t;

/*!
  Magnetic Sensor Reset Frequency
*/
typedef enum _FXOS8700CQ_magnetic_sensor_reset{
  kMagneticAutoReset1,                  /*!< Automatic magnetic sensor reset every 1 ODR cycle */
  kMagneticAutoReset16,                 /*!< Automatic magnetic sensor reset every 16 ODR cycles */
  kMagneticAutoReset512,                /*!< Automatic magnetic sensor reset every 512 ODR cycles */                              
  kMagneticAutoResetDisabled,           /*!< Automatic magnetic sensor reset disabled (must be manually reset) */                   
}FXOS8700CQ_magnetic_sensor_reset_t;

/*!
* @} End of fxos8700cq_registers
*/

#endif //End of file