/*! *********************************************************************************
 * \defgroup Temperature Sensor
 * @{
 ********************************************************************************** */
/*!
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * \file app.h
 * This file is the interface file for the Temperature Sensor application
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _APP_H_
#define _APP_H_

/*************************************************************************************
**************************************************************************************
* Public macros
**************************************************************************************
*************************************************************************************/

/* App Configuration */
     
/*! Enable/disable bonding capability */
#ifndef gBondingSupported_d
#define gBondingSupported_d  TRUE
#endif

/*! Enable/disable service security */
#ifndef gUseServiceSecurity_d
#define gUseServiceSecurity_d  TRUE
#endif


#define gPasskeyValue_c                999999

/* Profile Parameters */

#define gReducedPowerMinAdvInterval_c   1600 /* 1 s */
#define gReducedPowerMaxAdvInterval_c   4000 /* 2.5 s */

#define gAdvTime_c                      60 /* 10 s*/
#define gGoToSleepAfterDataTime_c       3 /* 3 s*/

//Application definitions
#define gAccelerometerUpdateTime_c      100     /*!< Accelerometer update time in mS */
#define gCompassHeadingUpdateTime_c     100     /*!< E-Compass update time in mS */
#define gTsiUpdateTime_c                150     /*!< TSI update time in mS */
#define gChipTemperatureUpdateTime_c    2000    /*!< Chip temperature update time in mS */
#define gPotentiometerUpdateTime_c      200     /*!< Potentiometer update time in mS */

/************************************************************************************
*************************************************************************************
* Type definitions
*************************************************************************************
********************************************************************************** */
typedef struct signed_32_bit_average{
  uint32_t averageElements;
  uint32_t positionCounter;
  int32_t* elementsArrayPtr;
}signed_32_bit_average_t;

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
extern gapAdvertisingData_t     gAppAdvertisingData;
extern gapScanResponseData_t    gAppScanRspData;
extern gapAdvertisingParameters_t gAdvParameters;

#if gBondingSupported_d
extern gapSmpKeys_t gSmpKeys;
extern gapPairingParameters_t gPairingParameters;
#endif

extern gapDeviceSecurityRequirements_t deviceSecurityRequirements;
/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

void BleApp_Start(void);

void BleApp_Init(void);
void BleApp_HandleKeys(key_event_t events);
void BleApp_GenericCallback (gapGenericEvent_t* pGenericEvent);

#ifdef __cplusplus
}
#endif 


#endif /* _APP_H_ */

/*! *********************************************************************************
 * @}
 ********************************************************************************** */
