/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MainMenu.h"
#include "ButtonsHandler.h"
#include "TSS_API.h"
  
/*****************************************************************************/
/*                               Definitions
/*****************************************************************************/

#define MAX_WAITING_TIME    80
  
#define UP                  1
#define DOWN                2
#define LEFT                3
#define RIGHT               4
#define CENTER              5
#define MULT                6
  
/*****************************************************************************/
/*                          Externs and Globals
/*****************************************************************************/

extern UINT16 tss_au16ElecBaseline[TSS_N_ELECTRODES];
extern UINT16 u16temp[TSS_N_ELECTRODES];
extern UINT16 u16ExitCounter;

UINT16 u16Counter;
UINT16 u16ErrorCounter;
 
UINT8 u8TouchSelect;
UINT8 u8TouchDetect;

UINT8 u8Exit;
UINT8 u8ExitCount;
UINT8 u8ExitTimer;

/*****************************************************************************/
/*                           Function Prototypes
/*****************************************************************************/

void MCU_Init(void);
void TSS_Config(void);
void TSS_fOnFault(void);
void fCallBack0(void);

/*****************************************************************************/
/*                              Main Routine
/*****************************************************************************/

void main(void){

  MCU_Init();      // MCU Configuration 
  TSS_Config();    // Touch Sensing Configuration
  TIMER2_Init();   // Init Main Timer for Touch, ECG and Time-Tracking
  SYS_Init();      // System Init Routine   
  vfnMainMenu();   // Init Main Menu Application

}

/*****************************************************************************/
/*                                MCU INIT
/*****************************************************************************/

void MCU_Init(void){

/* Disables Watchdog, enables RST and BKG pins */ 
  SOPT1 = SOPT1_RSTPE_MASK | SOPT1_BKGDPE_MASK;

/* Configure Vref for ECG */  
  VREFTRM = 0x80;
  VREFSC_MODE=0x02;
  VREFSC_VREFEN=1;
  
/* Turn LCD_BackLight On */
  PTJDD_PTJDD7=1;
  PTJD_PTJD7=1;
  
  EnableInterrupts; // Enable Interrupts

/* MCG Registers Configuration */  
  MCGC1 = 0x98;
  MCGC2 = 0x37;
  MCGC3 = 0x46;
     
  while(!MCGSC_OSCINIT){}
  MCGC1 = 0x18;
  while(!MCGSC_LOCK){}
     
}

/*****************************************************************************/
/*                              TSS Error Detection
/*****************************************************************************/

void  TSS_fOnFault(void){

  u16ErrorCounter++;
        
/* Check type of error */
   
  if(tss_CSSys.Faults.ChargeTimeout){
  }else if (tss_CSSys.Faults.DataCorruption){
  }else if (tss_CSSys.Faults. SmallCapacitor){
  }  

  (void)TSS_SetSystemConfig(System_Faults_Register,0);
  
  (void)TSS_SetSystemConfig(System_ElectrodeEnablers_Register,1);
  
  (void)TSS_SetSystemConfig(System_SystemConfig_Register,TSS_SYSTEM_RESET_MASK);
   
  for(u16Counter=0;u16Counter<200;u16Counter++);

  (void)TSS_SetSystemConfig(System_SystemConfig_Register,(TSS_SYSTEM_EN_MASK | TSS_DC_TRACKER_EN_MASK|TSS_SWI_EN_MASK));
     
}

/*****************************************************************************/
/*                               TSS Configuration
/*****************************************************************************/

void TSS_Config(void){
 
  TSS_Init(); // Initializes the TSS
     
/* Sets the response time value */ 
  
  (void)TSS_SetSystemConfig(System_ResponseTime_Register,5);

/* Sets the number of samples */ 
  
  (void)TSS_SetSystemConfig(System_NSamples_Register,10);
  (void)TSS_SetSystemConfig(System_DCTrackerRate_Register,1);  
   
/* Enables the TSS. Enables DC Tracker. Enables software interrupt */
  
  (void)TSS_SetSystemConfig(System_SystemConfig_Register,(TSS_SYSTEM_EN_MASK|TSS_DC_TRACKER_EN_MASK));  
  for(u16Counter=0;u16Counter<200;u16Counter++)TSS_Task();
  for(u16Counter=0;u16Counter<TSS_N_ELECTRODES;u16Counter++)tss_au16ElecBaseline[u16Counter] = u16temp[u16Counter];  
      
 
/* Sets the Sensitivity value for each electrode */

  (void)TSS_SetSystemConfig(System_Sensitivity_Register,20); 
  (void)TSS_SetSystemConfig(System_Sensitivity_Register+1,20);
  (void)TSS_SetSystemConfig(System_Sensitivity_Register+2,20);  
  (void)TSS_SetSystemConfig(System_Sensitivity_Register+3,20); 
  (void)TSS_SetSystemConfig(System_Sensitivity_Register+4,20);
  (void)TSS_SetSystemConfig(System_Sensitivity_Register+5,20);                                                                   

/* Disable the TSS to setup parameters*/
  
  (void)TSS_SetSystemConfig(System_SystemConfig_Register,0);  
    
/* Configure the TSS to report the touch and release events */
        
  (void)TSS_KeypadConfig(cKey0.ControlId,Keypad_Events_Register,(TSS_KEYPAD_TOUCH_EVENT_EN_MASK|TSS_KEYPAD_RELEASE_EVENT_EN_MASK));

/* Enables Callback function. Enables the control */
    
  (void)TSS_KeypadConfig(cKey0.ControlId,Keypad_ControlConfig_Register,(TSS_KEYPAD_CALLBACK_EN_MASK|TSS_KEYPAD_CONTROL_EN_MASK));
   
/* Enables the TSS. Enables the DC Tracking feature. Default DC Tracking values is 0x64 */
    
  (void)TSS_SetSystemConfig(System_SystemConfig_Register,(TSS_SYSTEM_EN_MASK | TSS_DC_TRACKER_EN_MASK|TSS_SWI_EN_MASK));
  (void)TSS_SetSystemConfig(System_DCTrackerRate_Register,20);

}

/*****************************************************************************/
/*                           Button Detection Routine
/*****************************************************************************/                                                                            
                                                                            
void fCallBack0(void){                                                               
  
  UINT8 u8Key;                                                                                   
                                                                                                                                         /* While unread events in the buffer */                
  while (!TSS_KEYPAD_BUFFER_EMPTY(cKey0)){
    
    /* Read the buffer */                                   
    TSS_KEYPAD_BUFFER_READ(u8Key,cKey0);                     
                                                                                            
    switch(u8Key){         
      
      /* UP electrode */                 
      case 0:
        if(u8TouchDetect !=MULT)                                                         
          u8TouchDetect=UP;
        else{
          gu8ButtonStatus=BUTTON_UP;
          u8Exit=TRUE; 
        }
        break;
      
      /* RIGHT electrode */                
      case 1:
        if(u8TouchDetect !=MULT)                                                         
          u8TouchDetect=RIGHT;
        else 
          gu8ButtonStatus=BUTTON_RIGHT;
        break;
             
      /* MULT electrode case*/
      case 2:
        switch(u8TouchDetect){
          
          /* UP Touch detected */
          case UP:
            gu8ButtonStatus = BUTTON_UP;
            u8Exit=TRUE;   // Look for Exit Routine Flag
            break;
          
          /* DOWN Touch detected */     
          case DOWN:
            gu8ButtonStatus=BUTTON_DOWN; 
            break;
          
          /* RIGHT Touch detected */     
          case RIGHT:
            gu8ButtonStatus=BUTTON_RIGHT;
            break;
              
          /* LEFT Touch detected */ 
          case LEFT:
            gu8ButtonStatus=BUTTON_LEFT;
            break;
              
          /* CENTER Touch detected */ 
          case CENTER:
            gu8ButtonStatus=BUTTON_SELECT;
            break;
        }
        u8TouchDetect=MULT;
        break;
      
      /* DOWN electrode */       
      case 3:
        if(u8TouchDetect !=MULT)                                                         
          u8TouchDetect=DOWN;
        else 
          gu8ButtonStatus=BUTTON_DOWN;
        break;
      
      /* SELECT electrode */       
      case 4:
        if(u8TouchDetect !=MULT)                                                         
          u8TouchDetect=CENTER;
        else 
          gu8ButtonStatus=BUTTON_SELECT;
        break;
      
      /* LEFT electrode */    
      case 5:
        if(u8TouchDetect !=MULT)                                                         
          u8TouchDetect=LEFT;
        else 
          gu8ButtonStatus=BUTTON_LEFT;
        break;
      
      /* IDDLE */    
      default:
        gu8ButtonStatus=BUTTON_IDDLE;  
        u8TouchDetect=0; 
        if(u8Key&0x80){
          u8Exit=FALSE;
          u16ExitCounter=0;
        }                   
        break;
    }
             
  }
      
}