/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   TSS_SystemSetupData.c
*
* @brief  Defines the structs and information needed for the configuration and decoders usage 
*
* @version 1.0.33.0
* 
* @date Jun-4-2010
* 
* All the declarations of structures and information are bassed in the values
* provided by the user in the SystemSetup.h file                             
*
***********************************************************************************************************************/


#include "TSS_SystemSetup.h"
#include "TSS_API.h"
#include "TSS_SystemSetupVal.h"
#include "derivative.h" 
#include "TSS_GPIO.h"

/* The section below declares all the structures needed for each decoder */

#if TSS_N_CONTROLS > 0
    #if (TSS_C0_TYPE == TSS_CT_KEYPAD)                  /* Validates the Controler Type */
        TSS_CSKeypad TSS_C0_STRUCTURE;                  /* Declares the control KeyPad Structure */
        TSS_KeypadContext TSS_C0_STRUCTURE_CONTEXT;     /* Declares the context KeyPad Structure */
        #define C0_BUFFMASK_BIT 0u                      /* Defines 1 bit to determinate if is a KeyPad or Slider/Rotary*/
        #define C0_BUFFLN       16u                 
        #define C0_DECODER      TSS_KeypadDecoder       /* Defines a reference constant for the Decodet type function */
    #elif (TSS_C0_TYPE == TSS_CT_SLIDER)                /* Validates the Controler Type */
        TSS_CSSlider TSS_C0_STRUCTURE;                  /* Declares the control Slider Structure */
        TSS_SingleContext TSS_C0_STRUCTURE_CONTEXT;     /* Declares the context Slider Structure */
        #define C0_BUFFMASK_BIT 1u                      /* Defines 1 bit to determinate if is a KeyPad or Slider/Rotary */
        #define C0_DECODER      TSS_SliderDecoder       /* Defines a reference constant for the Decodet type functions */
    #else
        TSS_CSRotary TSS_C0_STRUCTURE;                  /* Declares the control Rotary Structure */
        TSS_SingleContext    TSS_C0_STRUCTURE_CONTEXT;  /* Declares the context Rotary Structure */
        #define C0_BUFFMASK_BIT 1u                      /* Defines 1 bit to determinate if is a KeyPad (0) or Slider/Rotary (1) */
        #define C0_DECODER      TSS_SliderDecoder       /* Defines a reference constant for the Decoder type functions */
    #endif
    #define C0_CONTROLID (UINT8)(TSS_C0_TYPE << 4u)     /* Assign a control ID (4 LSB) and a control type (4 MSB)*/
    #define C0_BUFFMASK (UINT8)(C0_BUFFMASK_BIT)        /* Assign each CO_MASK_BIT a diferent position depending on the number of control*/ 
    void TSS_C0_CALLBACK(UINT8 u8ControlId);            /* Declares the callback fucntion */
    void C0_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer); /* Declares the decoder type function */
#endif

/* Depending on the number of controls declared by the user the strcutures are created */
#if TSS_N_CONTROLS > 1                                  
    #if (TSS_C1_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C1_STRUCTURE;
        TSS_KeypadContext TSS_C1_STRUCTURE_CONTEXT;
        #define C1_BUFFMASK_BIT 0u
        #define C1_BUFFLN       16u
        #define C1_DECODER      TSS_KeypadDecoder
    #elif (TSS_C1_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C1_STRUCTURE;
        TSS_SingleContext TSS_C1_STRUCTURE_CONTEXT;
        #define C1_BUFFMASK_BIT 1u
        #define C1_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C1_STRUCTURE;
        TSS_SingleContext TSS_C1_STRUCTURE_CONTEXT;
        #define C1_BUFFMASK_BIT 1u
        #define C1_DECODER      TSS_SliderDecoder
    #endif
    #define C1_CONTROLID ((UINT8)(TSS_C1_TYPE << 4u) | 1u)
    #define C1_BUFFMASK (UINT8)(C1_BUFFMASK_BIT << 1u)
    void TSS_C1_CALLBACK(UINT8 u8ControlId);
    void C1_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 2
    #if (TSS_C2_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C2_STRUCTURE;
        TSS_KeypadContext TSS_C2_STRUCTURE_CONTEXT;
        #define C2_BUFFMASK_BIT 0u
        #define C2_BUFFLN       16u
        #define C2_DECODER      TSS_KeypadDecoder
    #elif (TSS_C2_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C2_STRUCTURE;
        TSS_SingleContext TSS_C2_STRUCTURE_CONTEXT;
        #define C2_BUFFMASK_BIT 1u
        #define C2_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C2_STRUCTURE;
        TSS_SingleContext TSS_C2_STRUCTURE_CONTEXT;
        #define C2_BUFFMASK_BIT 1u
        #define C2_DECODER      TSS_SliderDecoder
    #endif
    #define C2_CONTROLID ((UINT8)(TSS_C2_TYPE << 4u) | 2u)
    #define C2_BUFFMASK (UINT8)(C2_BUFFMASK_BIT << 2u)
    void TSS_C2_CALLBACK(UINT8 u8ControlId);
    void C2_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 3
    #if (TSS_C3_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C3_STRUCTURE;
        TSS_KeypadContext TSS_C3_STRUCTURE_CONTEXT;
        #define C3_BUFFMASK_BIT 0u
        #define C3_BUFFLN       16u
        #define C3_DECODER      TSS_KeypadDecoder
    #elif (TSS_C3_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C3_STRUCTURE;
        TSS_SingleContext    TSS_C3_STRUCTURE_CONTEXT;
        #define C3_BUFFMASK_BIT 1u
        #define C3_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C3_STRUCTURE;
        TSS_SingleContext TSS_C3_STRUCTURE_CONTEXT;
        #define C3_BUFFMASK_BIT 1u
        #define C3_DECODER      TSS_SliderDecoder
    #endif
    #define C3_CONTROLID ((UINT8)(TSS_C3_TYPE << 4u) | 3u)
    #define C3_BUFFMASK (UINT8)(C3_BUFFMASK_BIT << 3u)
    void TSS_C3_CALLBACK(UINT8 u8ControlId);
    void C3_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 4
    #if (TSS_C4_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C4_STRUCTURE;
        TSS_KeypadContext TSS_C4_STRUCTURE_CONTEXT;
        #define C4_BUFFMASK_BIT 0u
        #define C4_BUFFLN       16u
        #define C4_DECODER      TSS_KeypadDecoder
    #elif (TSS_C4_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C4_STRUCTURE;
        TSS_SingleContext    TSS_C4_STRUCTURE_CONTEXT;
        #define C4_BUFFMASK_BIT 1u
        #define C4_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C4_STRUCTURE;
        TSS_SingleContext TSS_C4_STRUCTURE_CONTEXT;
        #define C4_BUFFMASK_BIT 1u
        #define C4_DECODER      TSS_SliderDecoder
    #endif
    #define C4_CONTROLID ((UINT8)(TSS_C4_TYPE << 4u) | 4u)
    #define C4_BUFFMASK (UINT8)(C4_BUFFMASK_BIT << 4u)
    void TSS_C4_CALLBACK(UINT8 u8ControlId);
    void C4_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 5
    #if (TSS_C5_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C5_STRUCTURE;
        TSS_KeypadContext TSS_C5_STRUCTURE_CONTEXT;
        #define C5_BUFFMASK_BIT 0u
        #define C5_BUFFLN       16u
        #define C5_DECODER      TSS_KeypadDecoder
    #elif (TSS_C5_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C5_STRUCTURE;
        TSS_SingleContext    TSS_C5_STRUCTURE_CONTEXT;
        #define C5_BUFFMASK_BIT 1u
        #define C5_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C5_STRUCTURE;
        TSS_SingleContext TSS_C5_STRUCTURE_CONTEXT;
        #define C5_BUFFMASK_BIT 1u
        #define C5_DECODER      TSS_SliderDecoder
    #endif
    #define C5_CONTROLID ((UINT8)(TSS_C5_TYPE << 4u) | 5u)
    #define C5_BUFFMASK (UINT8)(C5_BUFFMASK_BIT << 5u)
    void TSS_C5_CALLBACK(UINT8 u8ControlId);
    void C5_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 6
    #if (TSS_C6_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C6_STRUCTURE;
        TSS_KeypadContext TSS_C6_STRUCTURE_CONTEXT;
        #define C6_BUFFMASK_BIT 0u
        #define C6_BUFFLN       16u
        #define C6_DECODER      TSS_KeypadDecoder
    #elif (TSS_C6_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C6_STRUCTURE;
        TSS_SingleContext    TSS_C6_STRUCTURE_CONTEXT;
        #define C6_BUFFMASK_BIT 1u
        #define C6_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C6_STRUCTURE;
        TSS_SingleContext TSS_C6_STRUCTURE_CONTEXT;
        #define C6_BUFFMASK_BIT 1u
        #define C6_DECODER      TSS_SliderDecoder
    #endif
    #define C6_CONTROLID ((UINT8)(TSS_C6_TYPE << 4u) | 6u)
    #define C6_BUFFMASK (UINT8)(C6_BUFFMASK_BIT << 6u)
    void TSS_C6_CALLBACK(UINT8 u8ControlId);
    void C6_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 7
    #if (TSS_C7_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C7_STRUCTURE;
        TSS_KeypadContext TSS_C7_STRUCTURE_CONTEXT;
        #define C7_BUFFMASK_BIT 0u
        #define C7_BUFFLN       16u
        #define C7_DECODER      TSS_KeypadDecoder
    #elif (TSS_C7_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C7_STRUCTURE;
        TSS_SingleContext    TSS_C7_STRUCTURE_CONTEXT;
        #define C7_BUFFMASK_BIT 1u
        #define C7_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C7_STRUCTURE;
        TSS_SingleContext TSS_C7_STRUCTURE_CONTEXT;
        #define C7_BUFFMASK_BIT 1u
        #define C7_DECODER      TSS_SliderDecoder
    #endif
    #define C7_CONTROLID ((UINT8)(TSS_C7_TYPE << 4u) | 7u)
    #define C7_BUFFMASK (UINT8)(C7_BUFFMASK_BIT << 7u)
    void TSS_C7_CALLBACK(UINT8 u8ControlId);
    void C7_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 8
    #if (TSS_C8_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C8_STRUCTURE;
        TSS_KeypadContext TSS_C8_STRUCTURE_CONTEXT;
        #define C8_BUFFMASK_BIT 0u
        #define C8_BUFFLN       16u
        #define C8_DECODER      TSS_KeypadDecoder
    #elif (TSS_C8_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C8_STRUCTURE;
        TSS_SingleContext    TSS_C8_STRUCTURE_CONTEXT;
        #define C8_BUFFMASK_BIT 1u
        #define C8_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C8_STRUCTURE;
        TSS_SingleContext TSS_C8_STRUCTURE_CONTEXT;
        #define C8_BUFFMASK_BIT 1u
        #define C8_DECODER      TSS_SliderDecoder
    #endif
    #define C8_CONTROLID ((UINT8)(TSS_C8_TYPE << 4u) | 8u)
    #define C8_BUFFMASK (UINT8)(C8_BUFFMASK_BIT << 0u)
    void TSS_C8_CALLBACK(UINT8 u8ControlId);
    void C8_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 9
    #if (TSS_C9_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C9_STRUCTURE;
        TSS_KeypadContext TSS_C9_STRUCTURE_CONTEXT;
        #define C9_BUFFMASK_BIT 0u
        #define C9_BUFFLN       16u
        #define C9_DECODER      TSS_KeypadDecoder
    #elif (TSS_C9_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C9_STRUCTURE;
        TSS_SingleContext    TSS_C9_STRUCTURE_CONTEXT;
        #define C9_BUFFMASK_BIT 1u
        #define C9_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C9_STRUCTURE;
        TSS_SingleContext TSS_C9_STRUCTURE_CONTEXT;
        #define C9_BUFFMASK_BIT 1u
        #define C9_DECODER      TSS_SliderDecoder
    #endif
    #define C9_CONTROLID ((UINT8)(TSS_C9_TYPE << 4u) | 9u)
    #define C9_BUFFMASK (UINT8)(C9_BUFFMASK_BIT << 1u)
    void TSS_C9_CALLBACK(UINT8 u8ControlId);
    void C9_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 10
    #if (TSS_C10_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C10_STRUCTURE;
        TSS_KeypadContext TSS_C10_STRUCTURE_CONTEXT;
        #define C10_BUFFMASK_BIT 0u
        #define C10_BUFFLN       16u
        #define C10_DECODER      TSS_KeypadDecoder
    #elif (TSS_C10_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C10_STRUCTURE;
        TSS_SingleContext    TSS_C10_STRUCTURE_CONTEXT;
        #define C10_BUFFMASK_BIT 1u
        #define C10_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C10_STRUCTURE;
        TSS_SingleContext TSS_C10_STRUCTURE_CONTEXT;
        #define C10_BUFFMASK_BIT 1u
        #define C10_DECODER      TSS_SliderDecoder
    #endif
    #define C10_CONTROLID ((UINT8)(TSS_C10_TYPE << 4u) | 10u)
    #define C10_BUFFMASK (UINT8)(C10_BUFFMASK_BIT << 2u)
    void TSS_C10_CALLBACK(UINT8 u8ControlId);
    void C10_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 11
    #if (TSS_C11_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C11_STRUCTURE;
        TSS_KeypadContext TSS_C11_STRUCTURE_CONTEXT;
        #define C11_BUFFMASK_BIT 0u
        #define C11_BUFFLN       16u
        #define C11_DECODER      TSS_KeypadDecoder
    #elif (TSS_C11_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C11_STRUCTURE;
        TSS_SingleContext    TSS_C11_STRUCTURE_CONTEXT;
        #define C11_BUFFMASK_BIT 1u
        #define C11_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C11_STRUCTURE;
        TSS_SingleContext TSS_C11_STRUCTURE_CONTEXT;
        #define C11_BUFFMASK_BIT 1u
        #define C11_DECODER      TSS_SliderDecoder
    #endif
    #define C11_CONTROLID ((UINT8)(TSS_C11_TYPE << 4u) | 11u)
    #define C11_BUFFMASK (UINT8)(C11_BUFFMASK_BIT << 3u)
    void TSS_C11_CALLBACK(UINT8 u8ControlId);
    void C11_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 12
    #if (TSS_C12_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C12_STRUCTURE;
        TSS_KeypadContext TSS_C12_STRUCTURE_CONTEXT;
        #define C12_BUFFMASK_BIT 0u
        #define C12_BUFFLN       16u
        #define C12_DECODER      TSS_KeypadDecoder
    #elif (TSS_C12_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C12_STRUCTURE;
        TSS_SingleContext    TSS_C12_STRUCTURE_CONTEXT;
        #define C12_BUFFMASK_BIT 1u
        #define C12_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C12_STRUCTURE;
        TSS_SingleContext TSS_C12_STRUCTURE_CONTEXT;
        #define C12_BUFFMASK_BIT 1u
        #define C12_DECODER      TSS_SliderDecoder
    #endif
    #define C12_CONTROLID ((UINT8)(TSS_C12_TYPE << 4u) | 12u)
    #define C12_BUFFMASK (UINT8)(C12_BUFFMASK_BIT << 4u)
    void TSS_C12_CALLBACK(UINT8 u8ControlId);
    void C12_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 13
    #if (TSS_C13_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C13_STRUCTURE;
        TSS_KeypadContext TSS_C13_STRUCTURE_CONTEXT;
        #define C13_BUFFMASK_BIT 0u
        #define C13_BUFFLN       16u
        #define C13_DECODER      TSS_KeypadDecoder
    #elif (TSS_C13_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C13_STRUCTURE;
        TSS_SingleContext    TSS_C13_STRUCTURE_CONTEXT;
        #define C13_BUFFMASK_BIT 1u
        #define C13_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C13_STRUCTURE;
        TSS_SingleContext TSS_C13_STRUCTURE_CONTEXT;
        #define C13_BUFFMASK_BIT 1u
        #define C13_DECODER      TSS_SliderDecoder
    #endif
    #define C13_CONTROLID ((UINT8)(TSS_C13_TYPE << 4u) | 13u)
    #define C13_BUFFMASK (UINT8)(C13_BUFFMASK_BIT << 5u)
    void TSS_C13_CALLBACK(UINT8 u8ControlId);
    void C13_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 14
    #if (TSS_C14_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C14_STRUCTURE;
        TSS_KeypadContext TSS_C14_STRUCTURE_CONTEXT;
        #define C14_BUFFMASK_BIT 0u
        #define C14_BUFFLN       16u
        #define C14_DECODER      TSS_KeypadDecoder
    #elif (TSS_C14_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C14_STRUCTURE;
        TSS_SingleContext    TSS_C14_STRUCTURE_CONTEXT;
        #define C14_BUFFMASK_BIT 1u
        #define C14_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C14_STRUCTURE;
        TSS_SingleContext TSS_C14_STRUCTURE_CONTEXT;
        #define C14_BUFFMASK_BIT 1u
        #define C14_DECODER      TSS_SliderDecoder
    #endif
    #define C14_CONTROLID ((UINT8)(TSS_C14_TYPE << 4u) | 14u)
    #define C14_BUFFMASK (UINT8)(C14_BUFFMASK_BIT << 6u)
    void TSS_C14_CALLBACK(UINT8 u8ControlId);
    void C14_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

#if TSS_N_CONTROLS > 15
    #if (TSS_C15_TYPE == TSS_CT_KEYPAD)
        TSS_CSKeypad TSS_C15_STRUCTURE;
        TSS_KeypadContext TSS_C15_STRUCTURE_CONTEXT;
        #define C15_BUFFMASK_BIT 0u
        #define C15_BUFFLN       16u
        #define C15_DECODER      TSS_KeypadDecoder
    #elif (TSS_C15_TYPE == TSS_CT_SLIDER)
        TSS_CSSlider TSS_C15_STRUCTURE;
        TSS_SingleContext    TSS_C15_STRUCTURE_CONTEXT;
        #define C15_BUFFMASK_BIT 1u
        #define C15_DECODER      TSS_SliderDecoder
    #else
        TSS_CSRotary TSS_C15_STRUCTURE;
        TSS_SingleContext TSS_C15_STRUCTURE_CONTEXT;
        #define C15_BUFFMASK_BIT 1u
        #define C15_DECODER      TSS_SliderDecoder
    #endif
    #define C15_CONTROLID ((UINT8)(TSS_C15_TYPE << 4u) | 15u)
    #define C15_BUFFMASK (UINT8)(C15_BUFFMASK_BIT << 7u)
    void TSS_C15_CALLBACK(UINT8 u8ControlId);
    void C15_DECODER(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

/*
 *  The section below defines all the CX_BUFFMASK elements 
 *  that have not been defined with "0"
 */

#ifndef C0_BUFFMASK
    #define C0_BUFFMASK 0u
#endif
#ifndef C1_BUFFMASK
    #define C1_BUFFMASK 0u
#endif
#ifndef C2_BUFFMASK
    #define C2_BUFFMASK 0u
#endif
#ifndef C3_BUFFMASK
    #define C3_BUFFMASK 0u
#endif
#ifndef C4_BUFFMASK
    #define C4_BUFFMASK 0u
#endif
#ifndef C5_BUFFMASK
    #define C5_BUFFMASK 0u
#endif
#ifndef C6_BUFFMASK
    #define C6_BUFFMASK 0u
#endif
#ifndef C7_BUFFMASK
    #define C7_BUFFMASK 0u
#endif
/* 8 decoders can only be represented by a Byte, if more decoders are needed another Byte must be used */
#if TSS_N_CONTROLS > 7   
    #ifndef C8_BUFFMASK                  
        #define C8_BUFFMASK 0u
    #endif
    #ifndef C9_BUFFMASK
        #define C9_BUFFMASK 0u
    #endif
    #ifndef C10_BUFFMASK
        #define C10_BUFFMASK 0u
    #endif
    #ifndef C11_BUFFMASK
        #define C11_BUFFMASK 0u
    #endif
    #ifndef C12_BUFFMASK
        #define C12_BUFFMASK 0u
    #endif
    #ifndef C13_BUFFMASK
        #define C13_BUFFMASK 0u
    #endif
    #ifndef C14_BUFFMASK
        #define C14_BUFFMASK 0u
    #endif
    #ifndef C15_BUFFMASK
        #define C15_BUFFMASK 0u
    #endif
#endif

/*
 * The section below defines an array of pointers to 
 * all the callback functions defined by the user for each decoder
 * 
 */

#if TSS_N_CONTROLS != 0
/* Pointer to Callback functions */
void (* const tss_faCallback[TSS_N_CONTROLS])(UINT8 u8ControlId) = 
{
    TSS_C0_CALLBACK,
    #if TSS_N_CONTROLS > 1
        TSS_C1_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 2
        TSS_C2_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 3
        TSS_C3_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 4
        TSS_C4_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 5
        TSS_C5_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 6
        TSS_C6_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 7
        TSS_C7_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 8
        TSS_C8_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 9
        TSS_C9_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 10
        TSS_C10_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 11
        TSS_C11_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 12
        TSS_C12_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 13
        TSS_C13_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 14
        TSS_C14_CALLBACK,
    #endif
    #if TSS_N_CONTROLS > 15
        TSS_C15_CALLBACK,
    #endif
};
#else          /* If there are no defined controlers a single element array es created */
    void (* const tss_faCallback[1])(UINT8 u8ControlId);  
#endif


/*
 * The section below declares an array of pointers with the
 * direction of all the decoders controls context structures
 * created in the sections above
 */

/* Array of pointers to decoders controls context data */ 
#if TSS_N_CONTROLS != 0
UINT8 * const tss_acpsDecContext[TSS_N_CONTROLS] = {
    (UINT8 *)&TSS_C0_STRUCTURE_CONTEXT,
    #if TSS_N_CONTROLS > 1
        (UINT8 *)&TSS_C1_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 2
        (UINT8 *)&TSS_C2_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 3
        (UINT8 *)&TSS_C3_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 4
        (UINT8 *)&TSS_C4_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 5
        (UINT8 *)&TSS_C5_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 6
        (UINT8 *)&TSS_C6_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 7
        (UINT8 *)&TSS_C7_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 8
        (UINT8 *)&TSS_C8_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 9
        (UINT8 *)&TSS_C9_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 10
        (UINT8 *)&TSS_C10_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 11
        (UINT8 *)&TSS_C11_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 12
        (UINT8 *)&TSS_C12_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 13
        (UINT8 *)&TSS_C13_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 14
        (UINT8 *)&TSS_C14_STRUCTURE_CONTEXT,
    #endif
    #if TSS_N_CONTROLS > 15
        (UINT8 *)&TSS_C15_STRUCTURE_CONTEXT,
    #endif
};
#else        /* If there are no defined controlers a single element array es created */
    UINT8 * const tss_acpsDecContext[1];
#endif

/*
 * The section below declares an array of pointers with the
 * direction of all the decoders controls system structures
 * created in the sections above
 */

#if TSS_N_CONTROLS != 0
/* Array of pointers to controls structure data */ 
const UINT8 * const tss_acpsCSStructs[TSS_N_CONTROLS] = {
    (UINT8 *)&TSS_C0_STRUCTURE,
    #if TSS_N_CONTROLS > 1
        (UINT8 *)&TSS_C1_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 2
        (UINT8 *)&TSS_C2_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 3
        (UINT8 *)&TSS_C3_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 4
        (UINT8 *)&TSS_C4_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 5
        (UINT8 *)&TSS_C5_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 6
        (UINT8 *)&TSS_C6_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 7
        (UINT8 *)&TSS_C7_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 8
        (UINT8 *)&TSS_C8_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 9
        (UINT8 *)&TSS_C9_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 10
        (UINT8 *)&TSS_C10_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 11
        (UINT8 *)&TSS_C11_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 12
        (UINT8 *)&TSS_C12_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 13
        (UINT8 *)&TSS_C13_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 14
        (UINT8 *)&TSS_C14_STRUCTURE,
    #endif
    #if TSS_N_CONTROLS > 15
        (UINT8 *)&TSS_C15_STRUCTURE,
    #endif
};
#else          /* If there are no defined controlers a single element array es created */
    const UINT8 * const tss_acpsCSStructs[1] = 
    {
        NULL
    };
#endif

/*
 * The section below declares an array with al the controls ID
 */

#if TSS_N_CONTROLS != 0
/* Array of Controls Id's declared as UINT8 */ 
const UINT8 tss_cau8CtrlIds[TSS_N_CONTROLS] = {
    C0_CONTROLID,
    #if TSS_N_CONTROLS > 1
        C1_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 2
        C2_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 3
        C3_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 4
        C4_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 5
        C5_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 6
        C6_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 7
        C7_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 8
        C8_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 9
        C9_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 10
        C10_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 11
        C11_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 12
        C12_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 13
        C13_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 14
        C14_CONTROLID,
    #endif
    #if TSS_N_CONTROLS > 15
        C15_CONTROLID,
    #endif
};
#else            /* If there are no defined controlers a single element array es created */
    const UINT8 tss_cau8CtrlIds[1] = 
    {
        0u
    };
#endif

/*
*
*
*
*/

#ifndef C0_BUFFLN
    #define C0_BUFFLN 0u
#endif
#ifndef C1_BUFFLN
    #define C1_BUFFLN 0u
#endif
#ifndef C2_BUFFLN
    #define C2_BUFFLN 0u
#endif
#ifndef C3_BUFFLN
    #define C3_BUFFLN 0u
#endif
#ifndef C4_BUFFLN
    #define C4_BUFFLN 0u
#endif
#ifndef C5_BUFFLN
    #define C5_BUFFLN 0u
#endif
#ifndef C6_BUFFLN
    #define C6_BUFFLN 0u
#endif
#ifndef C7_BUFFLN
    #define C7_BUFFLN 0u
#endif
#ifndef C8_BUFFLN
    #define C8_BUFFLN 0u
#endif
#ifndef C9_BUFFLN
    #define C9_BUFFLN 0u
#endif
#ifndef C10_BUFFLN
    #define C10_BUFFLN 0u
#endif
#ifndef C11_BUFFLN
    #define C11_BUFFLN 0u
#endif
#ifndef C12_BUFFLN
    #define C12_BUFFLN 0u
#endif
#ifndef C13_BUFFLN
    #define C13_BUFFLN 0u
#endif
#ifndef C14_BUFFLN
    #define C14_BUFFLN 0u
#endif
#ifndef C15_BUFFLN
    #define C15_BUFFLN 0u
#endif

#define BUFFLN_SUM (C0_BUFFLN + C1_BUFFLN + C2_BUFFLN + C3_BUFFLN + C4_BUFFLN + C5_BUFFLN + C6_BUFFLN + C7_BUFFLN + C8_BUFFLN + C9_BUFFLN + C10_BUFFLN + C11_BUFFLN + C12_BUFFLN + C13_BUFFLN + C14_BUFFLN + C15_BUFFLN)

#if (BUFFLN_SUM != 0u)
    UINT8 tss_au8EventsBuff[BUFFLN_SUM];
    UINT8 * const tss_pau8EventsBuff = tss_au8EventsBuff;
#else
    UINT8 * const tss_pau8EventsBuff = NULL;
#endif

/*
 * The section below determines the number of elements assigned to the defined decoders.
 * This provides information to the decoders allowing to reserve the required memory space
 *  
 */

#ifdef TSS_C0_ELECTRODES
    #if TSS_N_CONTROLS == 1
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 2
        #define N_BUFF_ELEMENTS ((UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES)
    #endif
    #if TSS_N_CONTROLS == 3
        #define N_BUFF_ELEMENTS ((UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES)
    #endif
    #if TSS_N_CONTROLS == 4
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 5
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 6
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 7
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 8
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 9
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 10
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 11
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 12
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 13
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES
        #endif
    #if TSS_N_CONTROLS == 14
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES + (UINT8)TSS_C13_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 15
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES + (UINT8)TSS_C13_ELECTRODES + (UINT8)TSS_C14_ELECTRODES
    #endif
    #if TSS_N_CONTROLS == 16
        #define N_BUFF_ELEMENTS (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES + (UINT8)TSS_C13_ELECTRODES + (UINT8)TSS_C14_ELECTRODES + (UINT8)TSS_C15_ELECTRODES
    #endif
#else
    #define N_BUFF_ELEMENTS 0u   /* If there are no elements assigned to any control N_BUFF_ELEMENTS is 0 */
#endif


/*
*
* The section below declares an array where strores the
* number of electrodes per decoder
*/


#if TSS_N_CONTROLS != 0
/* Sumatory of electrodes arranged by control */
const UINT8 tss_cau8GrpElecBound[TSS_N_CONTROLS] = {
    (UINT8)TSS_C0_ELECTRODES,
    #if TSS_N_CONTROLS > 1
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 2
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 3
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 4
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 5
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 6
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 7
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 8
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 9
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 10
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 11
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 12
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 13
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES + (UINT8)TSS_C13_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 14
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES + (UINT8)TSS_C13_ELECTRODES + (UINT8)TSS_C14_ELECTRODES,
    #endif
    #if TSS_N_CONTROLS > 15
        (UINT8)TSS_C0_ELECTRODES + (UINT8)TSS_C1_ELECTRODES + (UINT8)TSS_C2_ELECTRODES + (UINT8)TSS_C3_ELECTRODES + (UINT8)TSS_C4_ELECTRODES + (UINT8)TSS_C5_ELECTRODES + (UINT8)TSS_C6_ELECTRODES + (UINT8)TSS_C7_ELECTRODES + (UINT8)TSS_C8_ELECTRODES + (UINT8)TSS_C9_ELECTRODES + (UINT8)TSS_C10_ELECTRODES + (UINT8)TSS_C11_ELECTRODES + (UINT8)TSS_C12_ELECTRODES + (UINT8)TSS_C13_ELECTRODES + (UINT8)TSS_C14_ELECTRODES + (UINT8)TSS_C15_ELECTRODES,
    #endif
};
#else
    const UINT8 tss_cau8GrpElecBound[1] =
    {
        (TSS_N_ELECTRODES - 1)
    };
#endif

/*
 * The section below declares an array where all the 
 * CX_BUFFER_MASK are joint into a two elemments array
 */

#if TSS_N_CONTROLS != 0
    const UINT8 tss_cau8BuffMask[(((TSS_N_CONTROLS - 1) / 8) + 1)] = 
    {
        C0_BUFFMASK | C1_BUFFMASK | C2_BUFFMASK | C3_BUFFMASK | C4_BUFFMASK | C5_BUFFMASK | C6_BUFFMASK | C7_BUFFMASK,
        #if TSS_N_CONTROLS > 8
            C8_BUFFMASK | C9_BUFFMASK | C10_BUFFMASK | C11_BUFFMASK | C12_BUFFMASK | C13_BUFFMASK | C14_BUFFMASK | C15_BUFFMASK,
        #endif
    };
#else       /* If there are no defined controlers a single element array es created */
    const UINT8 tss_cau8BuffMask[1] = 
    {
        0x00u
    };
#endif


/*
 * The section below defines an array of pointers to 
 * all the decoders functions defined above
 * 
 */

#if TSS_N_CONTROLS != 0
/* Pointer to Decoders functions */
void (* const tss_faDecoders[TSS_N_CONTROLS])(UINT8 u8CtrlNum, UINT8 *pu8Buffer) = 
{
    C0_DECODER,
    #if TSS_N_CONTROLS > 1
        C1_DECODER,
    #endif
    #if TSS_N_CONTROLS > 2
        C2_DECODER,
    #endif
    #if TSS_N_CONTROLS > 3
        C3_DECODER,
    #endif
    #if TSS_N_CONTROLS > 4
        C4_DECODER,
    #endif
    #if TSS_N_CONTROLS > 5
        C5_DECODER,
    #endif
    #if TSS_N_CONTROLS > 6
        C6_DECODER,
    #endif
    #if TSS_N_CONTROLS > 7
        C7_DECODER,
    #endif
    #if TSS_N_CONTROLS > 8
        C8_DECODER,
    #endif
    #if TSS_N_CONTROLS > 9
        C9_DECODER,
    #endif
    #if TSS_N_CONTROLS > 10
        C10_DECODER,
    #endif
    #if TSS_N_CONTROLS > 11
        C11_DECODER,
    #endif
    #if TSS_N_CONTROLS > 12
        C12_DECODER,
    #endif
    #if TSS_N_CONTROLS > 13
        C13_DECODER,
    #endif
    #if TSS_N_CONTROLS > 14
        C14_DECODER,
    #endif
    #if TSS_N_CONTROLS > 15
        C15_DECODER,
    #endif
};
#else          /* If there are no defined controlers a single element array es created */
    void (* const tss_faDecoders[1])(UINT8 u8CtrlNum, UINT8 *pu8Buffer);
#endif

/*
 * The section below defines STRENGTH control of the pins
 * 
 */


#ifdef PTADS_PTADS0
  #define PTADS0_EXISTS       1
#else
  #define PTADS0_EXISTS       0
#endif
#ifdef PTADS_PTADS1
  #define PTADS1_EXISTS       1
#else
  #define PTADS1_EXISTS       0
#endif
#ifdef PTADS_PTADS2
  #define PTADS2_EXISTS       1
#else
  #define PTADS2_EXISTS       0
#endif
#ifdef PTADS_PTADS3
  #define PTADS3_EXISTS       1
#else
  #define PTADS3_EXISTS       0
#endif
#ifdef PTADS_PTADS4
  #define PTADS4_EXISTS       1
#else
  #define PTADS4_EXISTS       0
#endif
#ifdef PTADS_PTADS5
  #define PTADS5_EXISTS       1
#else
  #define PTADS5_EXISTS       0
#endif
#ifdef PTADS_PTADS6
  #define PTADS6_EXISTS       1
#else
  #define PTADS6_EXISTS       0
#endif
#ifdef PTADS_PTADS7
  #define PTADS7_EXISTS       1
#else
  #define PTADS7_EXISTS       0
#endif

#ifdef PTBDS_PTBDS0
  #define PTBDS0_EXISTS       1
#else
  #define PTBDS0_EXISTS       0
#endif
#ifdef PTBDS_PTBDS1
  #define PTBDS1_EXISTS       1
#else
  #define PTBDS1_EXISTS       0
#endif
#ifdef PTBDS_PTBDS2
  #define PTBDS2_EXISTS       1
#else
  #define PTBDS2_EXISTS       0
#endif
#ifdef PTBDS_PTBDS3
  #define PTBDS3_EXISTS       1
#else
  #define PTBDS3_EXISTS       0
#endif
#ifdef PTBDS_PTBDS4
  #define PTBDS4_EXISTS       1
#else
  #define PTBDS4_EXISTS       0
#endif
#ifdef PTBDS_PTBDS5
  #define PTBDS5_EXISTS       1
#else
  #define PTBDS5_EXISTS       0
#endif
#ifdef PTBDS_PTBDS6
  #define PTBDS6_EXISTS       1
#else
  #define PTBDS6_EXISTS       0
#endif
#ifdef PTBDS_PTBDS7
  #define PTBDS7_EXISTS       1
#else
  #define PTBDS7_EXISTS       0
#endif

#ifdef PTCDS_PTCDS0
  #define PTCDS0_EXISTS       1
#else
  #define PTCDS0_EXISTS       0
#endif
#ifdef PTCDS_PTCDS1
  #define PTCDS1_EXISTS       1
#else
  #define PTCDS1_EXISTS       0
#endif
#ifdef PTCDS_PTCDS2
  #define PTCDS2_EXISTS       1
#else
  #define PTCDS2_EXISTS       0
#endif
#ifdef PTCDS_PTCDS3
  #define PTCDS3_EXISTS       1
#else
  #define PTCDS3_EXISTS       0
#endif
#ifdef PTCDS_PTCDS4
  #define PTCDS4_EXISTS       1
#else
  #define PTCDS4_EXISTS       0
#endif
#ifdef PTCDS_PTCDS5
  #define PTCDS5_EXISTS       1
#else
  #define PTCDS5_EXISTS       0
#endif
#ifdef PTCDS_PTCDS6
  #define PTCDS6_EXISTS       1
#else
  #define PTCDS6_EXISTS       0
#endif
#ifdef PTCDS_PTCDS7
  #define PTCDS7_EXISTS       1
#else
  #define PTCDS7_EXISTS       0
#endif

#ifdef PTDDS_PTDDS0
  #define PTDDS0_EXISTS       1
#else
  #define PTDDS0_EXISTS       0
#endif
#ifdef PTDDS_PTDDS1
  #define PTDDS1_EXISTS       1
#else
  #define PTDDS1_EXISTS       0
#endif
#ifdef PTDDS_PTDDS2
  #define PTDDS2_EXISTS       1
#else
  #define PTDDS2_EXISTS       0
#endif
#ifdef PTDDS_PTDDS3
  #define PTDDS3_EXISTS       1
#else
  #define PTDDS3_EXISTS       0
#endif
#ifdef PTDDS_PTDDS4
  #define PTDDS4_EXISTS       1
#else
  #define PTDDS4_EXISTS       0
#endif
#ifdef PTDDS_PTDDS5
  #define PTDDS5_EXISTS       1
#else
  #define PTDDS5_EXISTS       0
#endif
#ifdef PTDDS_PTDDS6
  #define PTDDS6_EXISTS       1
#else
  #define PTDDS6_EXISTS       0
#endif
#ifdef PTDDS_PTDDS7
  #define PTDDS7_EXISTS       1
#else
  #define PTDDS7_EXISTS       0
#endif

#ifdef PTEDS_PTEDS0
  #define PTEDS0_EXISTS       1
#else
  #define PTEDS0_EXISTS       0
#endif
#ifdef PTEDS_PTEDS1
  #define PTEDS1_EXISTS       1
#else
  #define PTEDS1_EXISTS       0
#endif
#ifdef PTEDS_PTEDS2
  #define PTEDS2_EXISTS       1
#else
  #define PTEDS2_EXISTS       0
#endif
#ifdef PTEDS_PTEDS3
  #define PTEDS3_EXISTS       1
#else
  #define PTEDS3_EXISTS       0
#endif
#ifdef PTEDS_PTEDS4
  #define PTEDS4_EXISTS       1
#else
  #define PTEDS4_EXISTS       0
#endif
#ifdef PTEDS_PTEDS5
  #define PTEDS5_EXISTS       1
#else
  #define PTEDS5_EXISTS       0
#endif
#ifdef PTEDS_PTEDS6
  #define PTEDS6_EXISTS       1
#else
  #define PTEDS6_EXISTS       0
#endif
#ifdef PTEDS_PTEDS7
  #define PTEDS7_EXISTS       1
#else
  #define PTEDS7_EXISTS       0
#endif

#ifdef PTFDS_PTFDS0
  #define PTFDS0_EXISTS       1
#else
  #define PTFDS0_EXISTS       0
#endif
#ifdef PTFDS_PTFDS1
  #define PTFDS1_EXISTS       1
#else
  #define PTFDS1_EXISTS       0
#endif
#ifdef PTFDS_PTFDS2
  #define PTFDS2_EXISTS       1
#else
  #define PTFDS2_EXISTS       0
#endif
#ifdef PTFDS_PTFDS3
  #define PTFDS3_EXISTS       1
#else
  #define PTFDS3_EXISTS       0
#endif
#ifdef PTFDS_PTFDS4
  #define PTFDS4_EXISTS       1
#else
  #define PTFDS4_EXISTS       0
#endif
#ifdef PTFDS_PTFDS5
  #define PTFDS5_EXISTS       1
#else
  #define PTFDS5_EXISTS       0
#endif
#ifdef PTFDS_PTFDS6
  #define PTFDS6_EXISTS       1
#else
  #define PTFDS6_EXISTS       0
#endif
#ifdef PTFDS_PTFDS7
  #define PTFDS7_EXISTS       1
#else
  #define PTFDS7_EXISTS       0
#endif

#ifdef PTGDS_PTGDS0
  #define PTGDS0_EXISTS       1
#else
  #define PTGDS0_EXISTS       0
#endif
#ifdef PTGDS_PTGDS1
  #define PTGDS1_EXISTS       1
#else
  #define PTGDS1_EXISTS       0
#endif
#ifdef PTGDS_PTGDS2
  #define PTGDS2_EXISTS       1
#else
  #define PTGDS2_EXISTS       0
#endif
#ifdef PTGDS_PTGDS3
  #define PTGDS3_EXISTS       1
#else
  #define PTGDS3_EXISTS       0
#endif
#ifdef PTGDS_PTGDS4
  #define PTGDS4_EXISTS       1
#else
  #define PTGDS4_EXISTS       0
#endif
#ifdef PTGDS_PTGDS5
  #define PTGDS5_EXISTS       1
#else
  #define PTGDS5_EXISTS       0
#endif
#ifdef PTGDS_PTGDS6
  #define PTGDS6_EXISTS       1
#else
  #define PTGDS6_EXISTS       0
#endif
#ifdef PTGDS_PTGDS7
  #define PTGDS7_EXISTS       1
#else
  #define PTGDS7_EXISTS       0
#endif

#ifdef PTHDS_PTHDS0
  #define PTHDS0_EXISTS       1
#else
  #define PTHDS0_EXISTS       0
#endif
#ifdef PTHDS_PTHDS1
  #define PTHDS1_EXISTS       1
#else
  #define PTHDS1_EXISTS       0
#endif
#ifdef PTHDS_PTHDS2
  #define PTHDS2_EXISTS       1
#else
  #define PTHDS2_EXISTS       0
#endif
#ifdef PTHDS_PTHDS3
  #define PTHDS3_EXISTS       1
#else
  #define PTHDS3_EXISTS       0
#endif
#ifdef PTHDS_PTHDS4
  #define PTHDS4_EXISTS       1
#else
  #define PTHDS4_EXISTS       0
#endif
#ifdef PTHDS_PTHDS5
  #define PTHDS5_EXISTS       1
#else
  #define PTHDS5_EXISTS       0
#endif
#ifdef PTHDS_PTHDS6
  #define PTHDS6_EXISTS       1
#else
  #define PTHDS6_EXISTS       0
#endif
#ifdef PTHDS_PTHDS7
  #define PTHDS7_EXISTS       1
#else
  #define PTHDS7_EXISTS       0
#endif

#ifdef PTIDS_PTIDS0
  #define PTIDS0_EXISTS       1
#else
  #define PTIDS0_EXISTS       0
#endif
#ifdef PTIDS_PTIDS1
  #define PTIDS1_EXISTS       1
#else
  #define PTIDS1_EXISTS       0
#endif
#ifdef PTIDS_PTIDS2
  #define PTIDS2_EXISTS       1
#else
  #define PTIDS2_EXISTS       0
#endif
#ifdef PTIDS_PTIDS3
  #define PTIDS3_EXISTS       1
#else
  #define PTIDS3_EXISTS       0
#endif
#ifdef PTIDS_PTIDS4
  #define PTIDS4_EXISTS       1
#else
  #define PTIDS4_EXISTS       0
#endif
#ifdef PTIDS_PTIDS5
  #define PTIDS5_EXISTS       1
#else
  #define PTIDS5_EXISTS       0
#endif
#ifdef PTIDS_PTIDS6
  #define PTIDS6_EXISTS       1
#else
  #define PTIDS6_EXISTS       0
#endif
#ifdef PTIDS_PTIDS7
  #define PTIDS7_EXISTS       1
#else
  #define PTIDS7_EXISTS       0
#endif

#ifdef PTJDS_PTJDS0
  #define PTJDS0_EXISTS       1
#else
  #define PTJDS0_EXISTS       0
#endif
#ifdef PTJDS_PTJDS1
  #define PTJDS1_EXISTS       1
#else
  #define PTJDS1_EXISTS       0
#endif
#ifdef PTJDS_PTJDS2
  #define PTJDS2_EXISTS       1
#else
  #define PTJDS2_EXISTS       0
#endif
#ifdef PTJDS_PTJDS3
  #define PTJDS3_EXISTS       1
#else
  #define PTJDS3_EXISTS       0
#endif
#ifdef PTJDS_PTJDS4
  #define PTJDS4_EXISTS       1
#else
  #define PTJDS4_EXISTS       0
#endif
#ifdef PTJDS_PTJDS5
  #define PTJDS5_EXISTS       1
#else
  #define PTJDS5_EXISTS       0
#endif
#ifdef PTJDS_PTJDS6
  #define PTJDS6_EXISTS       1
#else
  #define PTJDS6_EXISTS       0
#endif
#ifdef PTJDS_PTJDS7
  #define PTJDS7_EXISTS       1
#else
  #define PTJDS7_EXISTS       0
#endif

#ifdef PTKDS_PTKDS0
  #define PTKDS0_EXISTS       1
#else
  #define PTKDS0_EXISTS       0
#endif
#ifdef PTKDS_PTKDS1
  #define PTKDS1_EXISTS       1
#else
  #define PTKDS1_EXISTS       0
#endif
#ifdef PTKDS_PTKDS2
  #define PTKDS2_EXISTS       1
#else
  #define PTKDS2_EXISTS       0
#endif
#ifdef PTKDS_PTKDS3
  #define PTKDS3_EXISTS       1
#else
  #define PTKDS3_EXISTS       0
#endif
#ifdef PTKDS_PTKDS4
  #define PTKDS4_EXISTS       1
#else
  #define PTKDS4_EXISTS       0
#endif
#ifdef PTKDS_PTKDS5
  #define PTKDS5_EXISTS       1
#else
  #define PTKDS5_EXISTS       0
#endif
#ifdef PTKDS_PTKDS6
  #define PTKDS6_EXISTS       1
#else
  #define PTKDS6_EXISTS       0
#endif
#ifdef PTKDS_PTKDS7
  #define PTKDS7_EXISTS       1
#else
  #define PTKDS7_EXISTS       0
#endif

#ifdef PTLDS_PTLDS0
  #define PTLDS0_EXISTS       1
#else
  #define PTLDS0_EXISTS       0
#endif
#ifdef PTLDS_PTLDS1
  #define PTLDS1_EXISTS       1
#else
  #define PTLDS1_EXISTS       0
#endif
#ifdef PTLDS_PTLDS2
  #define PTLDS2_EXISTS       1
#else
  #define PTLDS2_EXISTS       0
#endif
#ifdef PTLDS_PTLDS3
  #define PTLDS3_EXISTS       1
#else
  #define PTLDS3_EXISTS       0
#endif
#ifdef PTLDS_PTLDS4
  #define PTLDS4_EXISTS       1
#else
  #define PTLDS4_EXISTS       0
#endif
#ifdef PTLDS_PTLDS5
  #define PTLDS5_EXISTS       1
#else
  #define PTLDS5_EXISTS       0
#endif
#ifdef PTLDS_PTLDS6
  #define PTLDS6_EXISTS       1
#else
  #define PTLDS6_EXISTS       0
#endif
#ifdef PTLDS_PTLDS7
  #define PTLDS7_EXISTS       1
#else
  #define PTLDS7_EXISTS       0
#endif

#if TSS_USE_GPIO_STRENGTH
/***************************************************************************//*!
*
* @brief  Performs setting of Strength on each defined GPIO pin
*
* @param  Nothing
*
* @return Status Code
*
* @remarks If the setting is not possible the function shows a Warning
*
****************************************************************************/
UINT8 TSS_SetPinStrength(void)
{
    UINT8 ret = TSS_STATUS_OK;                /* Sets return status code */
    
    #if TSS_N_ELECTRODES > 0
      #if TSS_ELECTRODE_STRENGTH_CHECK(E0)
        TSS_ELECTRODE_STRENGTH_SET(E0);
      #else 
        #warning "Sorry ... the electrode E0 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 1
      #if TSS_ELECTRODE_STRENGTH_CHECK(E1)
        TSS_ELECTRODE_STRENGTH_SET(E1);
      #else 
        #warning "Sorry ... the electrode E1 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 2
      #if TSS_ELECTRODE_STRENGTH_CHECK(E2)
        TSS_ELECTRODE_STRENGTH_SET(E2);
      #else 
        #warning "Sorry ... the electrode E2 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 3
      #if TSS_ELECTRODE_STRENGTH_CHECK(E3)
        TSS_ELECTRODE_STRENGTH_SET(E3);
      #else 
        #warning "Sorry ... the electrode E3 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 4
      #if TSS_ELECTRODE_STRENGTH_CHECK(E4)
        TSS_ELECTRODE_STRENGTH_SET(E4);
      #else 
        #warning "Sorry ... the electrode E4 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 5
      #if TSS_ELECTRODE_STRENGTH_CHECK(E5)
        TSS_ELECTRODE_STRENGTH_SET(E5);
      #else 
        #warning "Sorry ... the electrode E5 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 6
      #if TSS_ELECTRODE_STRENGTH_CHECK(E6)
        TSS_ELECTRODE_STRENGTH_SET(E6);
      #else 
        #warning "Sorry ... the electrode E6 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 7
      #if TSS_ELECTRODE_STRENGTH_CHECK(E7)
        TSS_ELECTRODE_STRENGTH_SET(E7);
      #else 
        #warning "Sorry ... the electrode E7 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 8
      #if TSS_ELECTRODE_STRENGTH_CHECK(E8)
        TSS_ELECTRODE_STRENGTH_SET(E8);
      #else 
        #warning "Sorry ... the electrode E8 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 9
      #if TSS_ELECTRODE_STRENGTH_CHECK(E9)
        TSS_ELECTRODE_STRENGTH_SET(E9);
      #else 
        #warning "Sorry ... the electrode E9 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 10
      #if TSS_ELECTRODE_STRENGTH_CHECK(E10)
        TSS_ELECTRODE_STRENGTH_SET(E10);
      #else 
        #warning "Sorry ... the electrode E10 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 11
      #if TSS_ELECTRODE_STRENGTH_CHECK(E11)
        TSS_ELECTRODE_STRENGTH_SET(E11);
      #else 
        #warning "Sorry ... the electrode E11 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 12
      #if TSS_ELECTRODE_STRENGTH_CHECK(E12)
        TSS_ELECTRODE_STRENGTH_SET(E12);
      #else 
        #warning "Sorry ... the electrode E12 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 13
      #if TSS_ELECTRODE_STRENGTH_CHECK(E13)
        TSS_ELECTRODE_STRENGTH_SET(E13);
      #else 
        #warning "Sorry ... the electrode E13 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 14
      #if TSS_ELECTRODE_STRENGTH_CHECK(E14)
        TSS_ELECTRODE_STRENGTH_SET(E14);
      #else 
        #warning "Sorry ... the electrode E14 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 15
      #if TSS_ELECTRODE_STRENGTH_CHECK(E15)
        TSS_ELECTRODE_STRENGTH_SET(E15);
      #else 
        #warning "Sorry ... the electrode E15 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 16
      #if TSS_ELECTRODE_STRENGTH_CHECK(E16)
        TSS_ELECTRODE_STRENGTH_SET(E16);
      #else 
        #warning "Sorry ... the electrode E16 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 17
      #if TSS_ELECTRODE_STRENGTH_CHECK(E17)
        TSS_ELECTRODE_STRENGTH_SET(E17);
      #else 
        #warning "Sorry ... the electrode E17 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 18
      #if TSS_ELECTRODE_STRENGTH_CHECK(E18)
        TSS_ELECTRODE_STRENGTH_SET(E18);
      #else 
        #warning "Sorry ... the electrode E18 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 19
      #if TSS_ELECTRODE_STRENGTH_CHECK(E19)
        TSS_ELECTRODE_STRENGTH_SET(E19);
      #else 
        #warning "Sorry ... the electrode E19 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 20
      #if TSS_ELECTRODE_STRENGTH_CHECK(E20)
        TSS_ELECTRODE_STRENGTH_SET(E20);
      #else 
        #warning "Sorry ... the electrode E20 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 21
      #if TSS_ELECTRODE_STRENGTH_CHECK(E21)
        TSS_ELECTRODE_STRENGTH_SET(E21);
      #else 
        #warning "Sorry ... the electrode E21 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 22
      #if TSS_ELECTRODE_STRENGTH_CHECK(E22)
        TSS_ELECTRODE_STRENGTH_SET(E22);
      #else 
        #warning "Sorry ... the electrode E22 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 23
      #if TSS_ELECTRODE_STRENGTH_CHECK(E23)
        TSS_ELECTRODE_STRENGTH_SET(E23);
      #else 
        #warning "Sorry ... the electrode E23 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 24
      #if TSS_ELECTRODE_STRENGTH_CHECK(E24)
        TSS_ELECTRODE_STRENGTH_SET(E24);
      #else 
        #warning "Sorry ... the electrode E24 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 25
      #if TSS_ELECTRODE_STRENGTH_CHECK(E25)
        TSS_ELECTRODE_STRENGTH_SET(E25);
      #else 
        #warning "Sorry ... the electrode E25 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 26
      #if TSS_ELECTRODE_STRENGTH_CHECK(E26)
        TSS_ELECTRODE_STRENGTH_SET(E26);
      #else 
        #warning "Sorry ... the electrode E26 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 27
      #if TSS_ELECTRODE_STRENGTH_CHECK(E27)
        TSS_ELECTRODE_STRENGTH_SET(E27);
      #else 
        #warning "Sorry ... the electrode E27 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 28
      #if TSS_ELECTRODE_STRENGTH_CHECK(E28)
        TSS_ELECTRODE_STRENGTH_SET(E28);
      #else 
        #warning "Sorry ... the electrode E28 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 29
      #if TSS_ELECTRODE_STRENGTH_CHECK(E29)
        TSS_ELECTRODE_STRENGTH_SET(E29);
      #else 
        #warning "Sorry ... the electrode E29 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 30
      #if TSS_ELECTRODE_STRENGTH_CHECK(E30)
        TSS_ELECTRODE_STRENGTH_SET(E30);
      #else 
        #warning "Sorry ... the electrode E30 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 31
      #if TSS_ELECTRODE_STRENGTH_CHECK(E31)
        TSS_ELECTRODE_STRENGTH_SET(E31);
      #else 
        #warning "Sorry ... the electrode E31 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 32
      #if TSS_ELECTRODE_STRENGTH_CHECK(E32)
        TSS_ELECTRODE_STRENGTH_SET(E32);
      #else 
        #warning "Sorry ... the electrode E32 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 33
      #if TSS_ELECTRODE_STRENGTH_CHECK(E33)
        TSS_ELECTRODE_STRENGTH_SET(E33);
      #else 
        #warning "Sorry ... the electrode E33 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 34
      #if TSS_ELECTRODE_STRENGTH_CHECK(E34)
        TSS_ELECTRODE_STRENGTH_SET(E34);
      #else 
        #warning "Sorry ... the electrode E34 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 35
      #if TSS_ELECTRODE_STRENGTH_CHECK(E35)
        TSS_ELECTRODE_STRENGTH_SET(E35);
      #else 
        #warning "Sorry ... the electrode E35 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 36
      #if TSS_ELECTRODE_STRENGTH_CHECK(E36)
        TSS_ELECTRODE_STRENGTH_SET(E36);
      #else 
        #warning "Sorry ... the electrode E36 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 37
      #if TSS_ELECTRODE_STRENGTH_CHECK(E37)
        TSS_ELECTRODE_STRENGTH_SET(E37);
      #else 
        #warning "Sorry ... the electrode E37 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 38
      #if TSS_ELECTRODE_STRENGTH_CHECK(E38)
        TSS_ELECTRODE_STRENGTH_SET(E38);
      #else 
        #warning "Sorry ... the electrode E38 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 39
      #if TSS_ELECTRODE_STRENGTH_CHECK(E39)
        TSS_ELECTRODE_STRENGTH_SET(E39);
      #else 
        #warning "Sorry ... the electrode E39 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 40
      #if TSS_ELECTRODE_STRENGTH_CHECK(E40)
        TSS_ELECTRODE_STRENGTH_SET(E40);
      #else 
        #warning "Sorry ... the electrode E40 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 41
      #if TSS_ELECTRODE_STRENGTH_CHECK(E41)
        TSS_ELECTRODE_STRENGTH_SET(E41);
      #else 
        #warning "Sorry ... the electrode E41 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 42
      #if TSS_ELECTRODE_STRENGTH_CHECK(E42)
        TSS_ELECTRODE_STRENGTH_SET(E42);
      #else 
        #warning "Sorry ... the electrode E42 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 43
      #if TSS_ELECTRODE_STRENGTH_CHECK(E43)
        TSS_ELECTRODE_STRENGTH_SET(E43);
      #else 
        #warning "Sorry ... the electrode E43 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 44
      #if TSS_ELECTRODE_STRENGTH_CHECK(E44)
        TSS_ELECTRODE_STRENGTH_SET(E44);
      #else 
        #warning "Sorry ... the electrode E44 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 45
      #if TSS_ELECTRODE_STRENGTH_CHECK(E45)
        TSS_ELECTRODE_STRENGTH_SET(E45);
      #else 
        #warning "Sorry ... the electrode E45 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 46
      #if TSS_ELECTRODE_STRENGTH_CHECK(E46)
        TSS_ELECTRODE_STRENGTH_SET(E46);
      #else 
        #warning "Sorry ... the electrode E46 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 47
      #if TSS_ELECTRODE_STRENGTH_CHECK(E47)
        TSS_ELECTRODE_STRENGTH_SET(E47);
      #else 
        #warning "Sorry ... the electrode E47 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 48
      #if TSS_ELECTRODE_STRENGTH_CHECK(E48)
        TSS_ELECTRODE_STRENGTH_SET(E48);
      #else 
        #warning "Sorry ... the electrode E48 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 49
      #if TSS_ELECTRODE_STRENGTH_CHECK(E49)
        TSS_ELECTRODE_STRENGTH_SET(E49);
      #else 
        #warning "Sorry ... the electrode E49 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 50
      #if TSS_ELECTRODE_STRENGTH_CHECK(E50)
        TSS_ELECTRODE_STRENGTH_SET(E50);
      #else 
        #warning "Sorry ... the electrode E50 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 51
      #if TSS_ELECTRODE_STRENGTH_CHECK(E51)
        TSS_ELECTRODE_STRENGTH_SET(E51);
      #else 
        #warning "Sorry ... the electrode E51 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 52
      #if TSS_ELECTRODE_STRENGTH_CHECK(E52)
        TSS_ELECTRODE_STRENGTH_SET(E52);
      #else 
        #warning "Sorry ... the electrode E52 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 53
      #if TSS_ELECTRODE_STRENGTH_CHECK(E53)
        TSS_ELECTRODE_STRENGTH_SET(E53);
      #else
        #warning "Sorry ... the electrode E53 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 54
      #if TSS_ELECTRODE_STRENGTH_CHECK(E54)
        TSS_ELECTRODE_STRENGTH_SET(E54);
      #else 
        #warning "Sorry ... the electrode E54 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 55
      #if TSS_ELECTRODE_STRENGTH_CHECK(E55)
        TSS_ELECTRODE_STRENGTH_SET(E55);
      #else 
        #warning "Sorry ... the electrode E55 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 56
      #if TSS_ELECTRODE_STRENGTH_CHECK(E56)
        TSS_ELECTRODE_STRENGTH_SET(E56);
      #else 
        #warning "Sorry ... the electrode E56 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 57
      #if TSS_ELECTRODE_STRENGTH_CHECK(E57)
        TSS_ELECTRODE_STRENGTH_SET(E57);
      #else 
        #warning "Sorry ... the electrode E57 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 58
      #if TSS_ELECTRODE_STRENGTH_CHECK(E58)
        TSS_ELECTRODE_STRENGTH_SET(E58);
      #else 
        #warning "Sorry ... the electrode E58 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 59
      #if TSS_ELECTRODE_STRENGTH_CHECK(E59)
        TSS_ELECTRODE_STRENGTH_SET(E59);
      #else 
        #warning "Sorry ... the electrode E59 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 60
      #if TSS_ELECTRODE_STRENGTH_CHECK(E60)
        TSS_ELECTRODE_STRENGTH_SET(E60);
      #else 
        #warning "Sorry ... the electrode E60 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 61
      #if TSS_ELECTRODE_STRENGTH_CHECK(E61)
        TSS_ELECTRODE_STRENGTH_SET(E61);
      #else 
        #warning "Sorry ... the electrode E61 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 62
      #if TSS_ELECTRODE_STRENGTH_CHECK(E62)
        TSS_ELECTRODE_STRENGTH_SET(E62);
      #else 
        #warning "Sorry ... the electrode E62 doesn't provide STRENGTH settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 63
      #if TSS_ELECTRODE_STRENGTH_CHECK(E63)
        TSS_ELECTRODE_STRENGTH_SET(E63);
      #else
        #warning "Sorry ... the electrode E63 doesn't provide STRENGTH settings"
      #endif
    #endif
    
    ret = TSS_STATUS_OK;                /* Sets return status code */

    return ret;
}

#endif


/*
 * The section below defines SLEW RATE control of the pins
 * 
 */


#ifdef PTASE_PTASE0
  #define PTASE0_EXISTS       1
#else
  #define PTASE0_EXISTS       0
#endif
#ifdef PTASE_PTASE1
  #define PTASE1_EXISTS       1
#else
  #define PTASE1_EXISTS       0
#endif
#ifdef PTASE_PTASE2
  #define PTASE2_EXISTS       1
#else
  #define PTASE2_EXISTS       0
#endif
#ifdef PTASE_PTASE3
  #define PTASE3_EXISTS       1
#else
  #define PTASE3_EXISTS       0
#endif
#ifdef PTASE_PTASE4
  #define PTASE4_EXISTS       1
#else
  #define PTASE4_EXISTS       0
#endif
#ifdef PTASE_PTASE5
  #define PTASE5_EXISTS       1
#else
  #define PTASE5_EXISTS       0
#endif
#ifdef PTASE_PTASE6
  #define PTASE6_EXISTS       1
#else
  #define PTASE6_EXISTS       0
#endif
#ifdef PTASE_PTASE7
  #define PTASE7_EXISTS       1
#else
  #define PTASE7_EXISTS       0
#endif

#ifdef PTBSE_PTBSE0
  #define PTBSE0_EXISTS       1
#else
  #define PTBSE0_EXISTS       0
#endif
#ifdef PTBSE_PTBSE1
  #define PTBSE1_EXISTS       1
#else
  #define PTBSE1_EXISTS       0
#endif
#ifdef PTBSE_PTBSE2
  #define PTBSE2_EXISTS       1
#else
  #define PTBSE2_EXISTS       0
#endif
#ifdef PTBSE_PTBSE3
  #define PTBSE3_EXISTS       1
#else
  #define PTBSE3_EXISTS       0
#endif
#ifdef PTBSE_PTBSE4
  #define PTBSE4_EXISTS       1
#else
  #define PTBSE4_EXISTS       0
#endif
#ifdef PTBSE_PTBSE5
  #define PTBSE5_EXISTS       1
#else
  #define PTBSE5_EXISTS       0
#endif
#ifdef PTBSE_PTBSE6
  #define PTBSE6_EXISTS       1
#else
  #define PTBSE6_EXISTS       0
#endif
#ifdef PTBSE_PTBSE7
  #define PTBSE7_EXISTS       1
#else
  #define PTBSE7_EXISTS       0
#endif

#ifdef PTCSE_PTCSE0
  #define PTCSE0_EXISTS       1
#else
  #define PTCSE0_EXISTS       0
#endif
#ifdef PTCSE_PTCSE1
  #define PTCSE1_EXISTS       1
#else
  #define PTCSE1_EXISTS       0
#endif
#ifdef PTCSE_PTCSE2
  #define PTCSE2_EXISTS       1
#else
  #define PTCSE2_EXISTS       0
#endif
#ifdef PTCSE_PTCSE3
  #define PTCSE3_EXISTS       1
#else
  #define PTCSE3_EXISTS       0
#endif
#ifdef PTCSE_PTCSE4
  #define PTCSE4_EXISTS       1
#else
  #define PTCSE4_EXISTS       0
#endif
#ifdef PTCSE_PTCSE5
  #define PTCSE5_EXISTS       1
#else
  #define PTCSE5_EXISTS       0
#endif
#ifdef PTCSE_PTCSE6
  #define PTCSE6_EXISTS       1
#else
  #define PTCSE6_EXISTS       0
#endif
#ifdef PTCSE_PTCSE7
  #define PTCSE7_EXISTS       1
#else
  #define PTCSE7_EXISTS       0
#endif

#ifdef PTDSE_PTDSE0
  #define PTDSE0_EXISTS       1
#else
  #define PTDSE0_EXISTS       0
#endif
#ifdef PTDSE_PTDSE1
  #define PTDSE1_EXISTS       1
#else
  #define PTDSE1_EXISTS       0
#endif
#ifdef PTDSE_PTDSE2
  #define PTDSE2_EXISTS       1
#else
  #define PTDSE2_EXISTS       0
#endif
#ifdef PTDSE_PTDSE3
  #define PTDSE3_EXISTS       1
#else
  #define PTDSE3_EXISTS       0
#endif
#ifdef PTDSE_PTDSE4
  #define PTDSE4_EXISTS       1
#else
  #define PTDSE4_EXISTS       0
#endif
#ifdef PTDSE_PTDSE5
  #define PTDSE5_EXISTS       1
#else
  #define PTDSE5_EXISTS       0
#endif
#ifdef PTDSE_PTDSE6
  #define PTDSE6_EXISTS       1
#else
  #define PTDSE6_EXISTS       0
#endif
#ifdef PTDSE_PTDSE7
  #define PTDSE7_EXISTS       1
#else
  #define PTDSE7_EXISTS       0
#endif

#ifdef PTESE_PTESE0
  #define PTESE0_EXISTS       1
#else
  #define PTESE0_EXISTS       0
#endif
#ifdef PTESE_PTESE1
  #define PTESE1_EXISTS       1
#else
  #define PTESE1_EXISTS       0
#endif
#ifdef PTESE_PTESE2
  #define PTESE2_EXISTS       1
#else
  #define PTESE2_EXISTS       0
#endif
#ifdef PTESE_PTESE3
  #define PTESE3_EXISTS       1
#else
  #define PTESE3_EXISTS       0
#endif
#ifdef PTESE_PTESE4
  #define PTESE4_EXISTS       1
#else
  #define PTESE4_EXISTS       0
#endif
#ifdef PTESE_PTESE5
  #define PTESE5_EXISTS       1
#else
  #define PTESE5_EXISTS       0
#endif
#ifdef PTESE_PTESE6
  #define PTESE6_EXISTS       1
#else
  #define PTESE6_EXISTS       0
#endif
#ifdef PTESE_PTESE7
  #define PTESE7_EXISTS       1
#else
  #define PTESE7_EXISTS       0
#endif

#ifdef PTFSE_PTFSE0
  #define PTFSE0_EXISTS       1
#else
  #define PTFSE0_EXISTS       0
#endif
#ifdef PTFSE_PTFSE1
  #define PTFSE1_EXISTS       1
#else
  #define PTFSE1_EXISTS       0
#endif
#ifdef PTFSE_PTFSE2
  #define PTFSE2_EXISTS       1
#else
  #define PTFSE2_EXISTS       0
#endif
#ifdef PTFSE_PTFSE3
  #define PTFSE3_EXISTS       1
#else
  #define PTFSE3_EXISTS       0
#endif
#ifdef PTFSE_PTFSE4
  #define PTFSE4_EXISTS       1
#else
  #define PTFSE4_EXISTS       0
#endif
#ifdef PTFSE_PTFSE5
  #define PTFSE5_EXISTS       1
#else
  #define PTFSE5_EXISTS       0
#endif
#ifdef PTFSE_PTFSE6
  #define PTFSE6_EXISTS       1
#else
  #define PTFSE6_EXISTS       0
#endif
#ifdef PTFSE_PTFSE7
  #define PTFSE7_EXISTS       1
#else
  #define PTFSE7_EXISTS       0
#endif

#ifdef PTGSE_PTGSE0
  #define PTGSE0_EXISTS       1
#else
  #define PTGSE0_EXISTS       0
#endif
#ifdef PTGSE_PTGSE1
  #define PTGSE1_EXISTS       1
#else
  #define PTGSE1_EXISTS       0
#endif
#ifdef PTGSE_PTGSE2
  #define PTGSE2_EXISTS       1
#else
  #define PTGSE2_EXISTS       0
#endif
#ifdef PTGSE_PTGSE3
  #define PTGSE3_EXISTS       1
#else
  #define PTGSE3_EXISTS       0
#endif
#ifdef PTGSE_PTGSE4
  #define PTGSE4_EXISTS       1
#else
  #define PTGSE4_EXISTS       0
#endif
#ifdef PTGSE_PTGSE5
  #define PTGSE5_EXISTS       1
#else
  #define PTGSE5_EXISTS       0
#endif
#ifdef PTGSE_PTGSE6
  #define PTGSE6_EXISTS       1
#else
  #define PTGSE6_EXISTS       0
#endif
#ifdef PTGSE_PTGSE7
  #define PTGSE7_EXISTS       1
#else
  #define PTGSE7_EXISTS       0
#endif

#ifdef PTHSE_PTHSE0
  #define PTHSE0_EXISTS       1
#else
  #define PTHSE0_EXISTS       0
#endif
#ifdef PTHSE_PTHSE1
  #define PTHSE1_EXISTS       1
#else
  #define PTHSE1_EXISTS       0
#endif
#ifdef PTHSE_PTHSE2
  #define PTHSE2_EXISTS       1
#else
  #define PTHSE2_EXISTS       0
#endif
#ifdef PTHSE_PTHSE3
  #define PTHSE3_EXISTS       1
#else
  #define PTHSE3_EXISTS       0
#endif
#ifdef PTHSE_PTHSE4
  #define PTHSE4_EXISTS       1
#else
  #define PTHSE4_EXISTS       0
#endif
#ifdef PTHSE_PTHSE5
  #define PTHSE5_EXISTS       1
#else
  #define PTHSE5_EXISTS       0
#endif
#ifdef PTHSE_PTHSE6
  #define PTHSE6_EXISTS       1
#else
  #define PTHSE6_EXISTS       0
#endif
#ifdef PTHSE_PTHSE7
  #define PTHSE7_EXISTS       1
#else
  #define PTHSE7_EXISTS       0
#endif

#ifdef PTISE_PTISE0
  #define PTISE0_EXISTS       1
#else
  #define PTISE0_EXISTS       0
#endif
#ifdef PTISE_PTISE1
  #define PTISE1_EXISTS       1
#else
  #define PTISE1_EXISTS       0
#endif
#ifdef PTISE_PTISE2
  #define PTISE2_EXISTS       1
#else
  #define PTISE2_EXISTS       0
#endif
#ifdef PTISE_PTISE3
  #define PTISE3_EXISTS       1
#else
  #define PTISE3_EXISTS       0
#endif
#ifdef PTISE_PTISE4
  #define PTISE4_EXISTS       1
#else
  #define PTISE4_EXISTS       0
#endif
#ifdef PTISE_PTISE5
  #define PTISE5_EXISTS       1
#else
  #define PTISE5_EXISTS       0
#endif
#ifdef PTISE_PTISE6
  #define PTISE6_EXISTS       1
#else
  #define PTISE6_EXISTS       0
#endif
#ifdef PTISE_PTISE7
  #define PTISE7_EXISTS       1
#else
  #define PTISE7_EXISTS       0
#endif

#ifdef PTJSE_PTJSE0
  #define PTJSE0_EXISTS       1
#else
  #define PTJSE0_EXISTS       0
#endif
#ifdef PTJSE_PTJSE1
  #define PTJSE1_EXISTS       1
#else
  #define PTJSE1_EXISTS       0
#endif
#ifdef PTJSE_PTJSE2
  #define PTJSE2_EXISTS       1
#else
  #define PTJSE2_EXISTS       0
#endif
#ifdef PTJSE_PTJSE3
  #define PTJSE3_EXISTS       1
#else
  #define PTJSE3_EXISTS       0
#endif
#ifdef PTJSE_PTJSE4
  #define PTJSE4_EXISTS       1
#else
  #define PTJSE4_EXISTS       0
#endif
#ifdef PTJSE_PTJSE5
  #define PTJSE5_EXISTS       1
#else
  #define PTJSE5_EXISTS       0
#endif
#ifdef PTJSE_PTJSE6
  #define PTJSE6_EXISTS       1
#else
  #define PTJSE6_EXISTS       0
#endif
#ifdef PTJSE_PTJSE7
  #define PTJSE7_EXISTS       1
#else
  #define PTJSE7_EXISTS       0
#endif

#ifdef PTKSE_PTKSE0
  #define PTKSE0_EXISTS       1
#else
  #define PTKSE0_EXISTS       0
#endif
#ifdef PTKSE_PTKSE1
  #define PTKSE1_EXISTS       1
#else
  #define PTKSE1_EXISTS       0
#endif
#ifdef PTKSE_PTKSE2
  #define PTKSE2_EXISTS       1
#else
  #define PTKSE2_EXISTS       0
#endif
#ifdef PTKSE_PTKSE3
  #define PTKSE3_EXISTS       1
#else
  #define PTKSE3_EXISTS       0
#endif
#ifdef PTKSE_PTKSE4
  #define PTKSE4_EXISTS       1
#else
  #define PTKSE4_EXISTS       0
#endif
#ifdef PTKSE_PTKSE5
  #define PTKSE5_EXISTS       1
#else
  #define PTKSE5_EXISTS       0
#endif
#ifdef PTKSE_PTKSE6
  #define PTKSE6_EXISTS       1
#else
  #define PTKSE6_EXISTS       0
#endif
#ifdef PTKSE_PTKSE7
  #define PTKSE7_EXISTS       1
#else
  #define PTKSE7_EXISTS       0
#endif

#ifdef PTLSE_PTLSE0
  #define PTLSE0_EXISTS       1
#else
  #define PTLSE0_EXISTS       0
#endif
#ifdef PTLSE_PTLSE1
  #define PTLSE1_EXISTS       1
#else
  #define PTLSE1_EXISTS       0
#endif
#ifdef PTLSE_PTLSE2
  #define PTLSE2_EXISTS       1
#else
  #define PTLSE2_EXISTS       0
#endif
#ifdef PTLSE_PTLSE3
  #define PTLSE3_EXISTS       1
#else
  #define PTLSE3_EXISTS       0
#endif
#ifdef PTLSE_PTLSE4
  #define PTLSE4_EXISTS       1
#else
  #define PTLSE4_EXISTS       0
#endif
#ifdef PTLSE_PTLSE5
  #define PTLSE5_EXISTS       1
#else
  #define PTLSE5_EXISTS       0
#endif
#ifdef PTLSE_PTLSE6
  #define PTLSE6_EXISTS       1
#else
  #define PTLSE6_EXISTS       0
#endif
#ifdef PTLSE_PTLSE7
  #define PTLSE7_EXISTS       1
#else
  #define PTLSE7_EXISTS       0
#endif


#if TSS_USE_GPIO_SLEW_RATE
/***************************************************************************//*!
*
* @brief  Performs setting of Slew Rate on each defined GPIO pin
*
* @param  Nothing
*
* @return Status Code
*
* @remarks If the setting is not possible the function shows a Warning
*
****************************************************************************/
UINT8 TSS_SetPinSlewRate(void)
{
    UINT8 ret = TSS_STATUS_OK;                /* Sets return status code */
    
    #if TSS_N_ELECTRODES > 0
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E0)
        TSS_ELECTRODE_SLEWRATE_SET(E0);
      #else 
        #warning "Sorry ... the electrode E0 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 1
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E1)
        TSS_ELECTRODE_SLEWRATE_SET(E1);
      #else 
        #warning "Sorry ... the electrode E1 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 2
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E2)
        TSS_ELECTRODE_SLEWRATE_SET(E2);
      #else 
        #warning "Sorry ... the electrode E2 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 3
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E3)
        TSS_ELECTRODE_SLEWRATE_SET(E3);
      #else 
        #warning "Sorry ... the electrode E3 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 4
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E4)
        TSS_ELECTRODE_SLEWRATE_SET(E4);
      #else 
        #warning "Sorry ... the electrode E4 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 5
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E5)
        TSS_ELECTRODE_SLEWRATE_SET(E5);
      #else 
        #warning "Sorry ... the electrode E5 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 6
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E6)
        TSS_ELECTRODE_SLEWRATE_SET(E6);
      #else 
        #warning "Sorry ... the electrode E6 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 7
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E7)
        TSS_ELECTRODE_SLEWRATE_SET(E7);
      #else 
        #warning "Sorry ... the electrode E7 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 8
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E8)
        TSS_ELECTRODE_SLEWRATE_SET(E8);
      #else 
        #warning "Sorry ... the electrode E8 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 9
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E9)
        TSS_ELECTRODE_SLEWRATE_SET(E9);
      #else 
        #warning "Sorry ... the electrode E9 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 10
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E10)
        TSS_ELECTRODE_SLEWRATE_SET(E10);
      #else 
        #warning "Sorry ... the electrode E10 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 11
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E11)
        TSS_ELECTRODE_SLEWRATE_SET(E11);
      #else 
        #warning "Sorry ... the electrode E11 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 12
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E12)
        TSS_ELECTRODE_SLEWRATE_SET(E12);
      #else 
        #warning "Sorry ... the electrode E12 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 13
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E13)
        TSS_ELECTRODE_SLEWRATE_SET(E13);
      #else 
        #warning "Sorry ... the electrode E13 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 14
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E14)
        TSS_ELECTRODE_SLEWRATE_SET(E14);
      #else 
        #warning "Sorry ... the electrode E14 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 15
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E15)
        TSS_ELECTRODE_SLEWRATE_SET(E15);
      #else 
        #warning "Sorry ... the electrode E15 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 16
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E16)
        TSS_ELECTRODE_SLEWRATE_SET(E16);
      #else 
        #warning "Sorry ... the electrode E16 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 17
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E17)
        TSS_ELECTRODE_SLEWRATE_SET(E17);
      #else 
        #warning "Sorry ... the electrode E17 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 18
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E18)
        TSS_ELECTRODE_SLEWRATE_SET(E18);
      #else 
        #warning "Sorry ... the electrode E18 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 19
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E19)
        TSS_ELECTRODE_SLEWRATE_SET(E19);
      #else 
        #warning "Sorry ... the electrode E19 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 20
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E20)
        TSS_ELECTRODE_SLEWRATE_SET(E20);
      #else 
        #warning "Sorry ... the electrode E20 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 21
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E21)
        TSS_ELECTRODE_SLEWRATE_SET(E21);
      #else 
        #warning "Sorry ... the electrode E21 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 22
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E22)
        TSS_ELECTRODE_SLEWRATE_SET(E22);
      #else 
        #warning "Sorry ... the electrode E22 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 23
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E23)
        TSS_ELECTRODE_SLEWRATE_SET(E23);
      #else 
        #warning "Sorry ... the electrode E23 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 24
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E24)
        TSS_ELECTRODE_SLEWRATE_SET(E24);
      #else 
        #warning "Sorry ... the electrode E24 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 25
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E25)
        TSS_ELECTRODE_SLEWRATE_SET(E25);
      #else 
        #warning "Sorry ... the electrode E25 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 26
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E26)
        TSS_ELECTRODE_SLEWRATE_SET(E26);
      #else 
        #warning "Sorry ... the electrode E26 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 27
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E27)
        TSS_ELECTRODE_SLEWRATE_SET(E27);
      #else 
        #warning "Sorry ... the electrode E27 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 28
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E28)
        TSS_ELECTRODE_SLEWRATE_SET(E28);
      #else 
        #warning "Sorry ... the electrode E28 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 29
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E29)
        TSS_ELECTRODE_SLEWRATE_SET(E29);
      #else 
        #warning "Sorry ... the electrode E29 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 30
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E30)
        TSS_ELECTRODE_SLEWRATE_SET(E30);
      #else 
        #warning "Sorry ... the electrode E30 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 31
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E31)
        TSS_ELECTRODE_SLEWRATE_SET(E31);
      #else 
        #warning "Sorry ... the electrode E31 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 32
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E32)
        TSS_ELECTRODE_SLEWRATE_SET(E32);
      #else 
        #warning "Sorry ... the electrode E32 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 33
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E33)
        TSS_ELECTRODE_SLEWRATE_SET(E33);
      #else 
        #warning "Sorry ... the electrode E33 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 34
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E34)
        TSS_ELECTRODE_SLEWRATE_SET(E34);
      #else 
        #warning "Sorry ... the electrode E34 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 35
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E35)
        TSS_ELECTRODE_SLEWRATE_SET(E35);
      #else 
        #warning "Sorry ... the electrode E35 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 36
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E36)
        TSS_ELECTRODE_SLEWRATE_SET(E36);
      #else 
        #warning "Sorry ... the electrode E36 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 37
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E37)
        TSS_ELECTRODE_SLEWRATE_SET(E37);
      #else 
        #warning "Sorry ... the electrode E37 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 38
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E38)
        TSS_ELECTRODE_SLEWRATE_SET(E38);
      #else 
        #warning "Sorry ... the electrode E38 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 39
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E39)
        TSS_ELECTRODE_SLEWRATE_SET(E39);
      #else 
        #warning "Sorry ... the electrode E39 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 40
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E40)
        TSS_ELECTRODE_SLEWRATE_SET(E40);
      #else 
        #warning "Sorry ... the electrode E40 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 41
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E41)
        TSS_ELECTRODE_SLEWRATE_SET(E41);
      #else 
        #warning "Sorry ... the electrode E41 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 42
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E42)
        TSS_ELECTRODE_SLEWRATE_SET(E42);
      #else 
        #warning "Sorry ... the electrode E42 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 43
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E43)
        TSS_ELECTRODE_SLEWRATE_SET(E43);
      #else 
        #warning "Sorry ... the electrode E43 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 44
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E44)
        TSS_ELECTRODE_SLEWRATE_SET(E44);
      #else 
        #warning "Sorry ... the electrode E44 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 45
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E45)
        TSS_ELECTRODE_SLEWRATE_SET(E45);
      #else 
        #warning "Sorry ... the electrode E45 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 46
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E46)
        TSS_ELECTRODE_SLEWRATE_SET(E46);
      #else 
        #warning "Sorry ... the electrode E46 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 47
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E47)
        TSS_ELECTRODE_SLEWRATE_SET(E47);
      #else 
        #warning "Sorry ... the electrode E47 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 48
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E48)
        TSS_ELECTRODE_SLEWRATE_SET(E48);
      #else 
        #warning "Sorry ... the electrode E48 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 49
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E49)
        TSS_ELECTRODE_SLEWRATE_SET(E49);
      #else 
        #warning "Sorry ... the electrode E49 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 50
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E50)
        TSS_ELECTRODE_SLEWRATE_SET(E50);
      #else 
        #warning "Sorry ... the electrode E50 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 51
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E51)
        TSS_ELECTRODE_SLEWRATE_SET(E51);
      #else 
        #warning "Sorry ... the electrode E51 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 52
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E52)
        TSS_ELECTRODE_SLEWRATE_SET(E52);
      #else 
        #warning "Sorry ... the electrode E52 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 53
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E53)
        TSS_ELECTRODE_SLEWRATE_SET(E53);
      #else
        #warning "Sorry ... the electrode E53 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 54
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E54)
        TSS_ELECTRODE_SLEWRATE_SET(E54);
      #else 
        #warning "Sorry ... the electrode E54 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 55
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E55)
        TSS_ELECTRODE_SLEWRATE_SET(E55);
      #else 
        #warning "Sorry ... the electrode E55 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 56
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E56)
        TSS_ELECTRODE_SLEWRATE_SET(E56);
      #else 
        #warning "Sorry ... the electrode E56 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 57
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E57)
        TSS_ELECTRODE_SLEWRATE_SET(E57);
      #else 
        #warning "Sorry ... the electrode E57 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 58
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E58)
        TSS_ELECTRODE_SLEWRATE_SET(E58);
      #else 
        #warning "Sorry ... the electrode E58 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 59
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E59)
        TSS_ELECTRODE_SLEWRATE_SET(E59);
      #else 
        #warning "Sorry ... the electrode E59 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    #if TSS_N_ELECTRODES > 60
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E60)
        TSS_ELECTRODE_SLEWRATE_SET(E60);
      #else 
        #warning "Sorry ... the electrode E60 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 61
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E61)
        TSS_ELECTRODE_SLEWRATE_SET(E61);
      #else 
        #warning "Sorry ... the electrode E61 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 62
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E62)
        TSS_ELECTRODE_SLEWRATE_SET(E62);
      #else 
        #warning "Sorry ... the electrode E62 doesn't provide SLEWRATE settings"
      #endif
    #endif
    #if TSS_N_ELECTRODES > 63
      #if TSS_ELECTRODE_SLEWRATE_CHECK(E63)
        TSS_ELECTRODE_SLEWRATE_SET(E63);
      #else
        #warning "Sorry ... the electrode E63 doesn't provide SLEWRATE settings"
      #endif
    #endif
    
    ret = TSS_STATUS_OK;                /* Sets return status code */

    return ret;
}
#endif

/*
 * Declaration of Noise Window Size array 
 */

#if TSS_USE_NOISE_WINDOWING

/* Determination of final default Noise Window Sizez according to used Low Level */ 
#if TSS_USE_ATL_LOW_LEVEL
   #define TSS_DEFAULT_NOISE_WINDOW_SIZE      ATL_DEFAULT_NOISE_WINDOW_SIZE
#else 
   #define TSS_DEFAULT_NOISE_WINDOW_SIZE      CTS_DEFAULT_NOISE_WINDOW_SIZE    
#endif

/* Array of Widnow delta Limit values */ 
const INT8 tss_cai8WindowDeltaLimit[TSS_N_ELECTRODES] = {
    #if TSS_N_ELECTRODES > 0
      #ifdef TSS_E0_NOISE_WINDOW_SIZE
        TSS_E0_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 1
      #ifdef TSS_E1_NOISE_WINDOW_SIZE
        TSS_E1_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 2
      #ifdef TSS_E2_NOISE_WINDOW_SIZE
        TSS_E2_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 3
      #ifdef TSS_E3_NOISE_WINDOW_SIZE
        TSS_E3_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 4
      #ifdef TSS_E4_NOISE_WINDOW_SIZE
        TSS_E4_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 5
      #ifdef TSS_E5_NOISE_WINDOW_SIZE
        TSS_E5_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 6
      #ifdef TSS_E6_NOISE_WINDOW_SIZE
        TSS_E6_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 7
      #ifdef TSS_E7_NOISE_WINDOW_SIZE
        TSS_E7_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 8
      #ifdef TSS_E8_NOISE_WINDOW_SIZE
        TSS_E8_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 9
      #ifdef TSS_E9_NOISE_WINDOW_SIZE
        TSS_E9_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 10
      #ifdef TSS_E10_NOISE_WINDOW_SIZE
        TSS_E10_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 11
      #ifdef TSS_E11_NOISE_WINDOW_SIZE
        TSS_E11_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 12
      #ifdef TSS_E12_NOISE_WINDOW_SIZE
        TSS_E12_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 13
      #ifdef TSS_E13_NOISE_WINDOW_SIZE
        TSS_E13_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 14
      #ifdef TSS_E14_NOISE_WINDOW_SIZE
        TSS_E14_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 15
      #ifdef TSS_E15_NOISE_WINDOW_SIZE
        TSS_E15_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 16
      #ifdef TSS_E16_NOISE_WINDOW_SIZE
        TSS_E16_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 17
      #ifdef TSS_E17_NOISE_WINDOW_SIZE
        TSS_E17_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 18
      #ifdef TSS_E18_NOISE_WINDOW_SIZE
        TSS_E18_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 19
      #ifdef TSS_E19_NOISE_WINDOW_SIZE
        TSS_E19_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 20
      #ifdef TSS_E20_NOISE_WINDOW_SIZE
        TSS_E20_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 21
      #ifdef TSS_E21_NOISE_WINDOW_SIZE
        TSS_E21_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 22
      #ifdef TSS_E22_NOISE_WINDOW_SIZE
        TSS_E22_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 23
      #ifdef TSS_E23_NOISE_WINDOW_SIZE
        TSS_E23_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 24
      #ifdef TSS_E24_NOISE_WINDOW_SIZE
        TSS_E24_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 25
      #ifdef TSS_E25_NOISE_WINDOW_SIZE
        TSS_E25_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 26
      #ifdef TSS_E26_NOISE_WINDOW_SIZE
        TSS_E26_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 27
      #ifdef TSS_E27_NOISE_WINDOW_SIZE
        TSS_E27_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 28
      #ifdef TSS_E28_NOISE_WINDOW_SIZE
        TSS_E28_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 29
      #ifdef TSS_E29_NOISE_WINDOW_SIZE
        TSS_E29_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 30
      #ifdef TSS_E30_NOISE_WINDOW_SIZE
        TSS_E30_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 31
      #ifdef TSS_E31_NOISE_WINDOW_SIZE
        TSS_E31_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 32
      #ifdef TSS_E32_NOISE_WINDOW_SIZE
        TSS_E32_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 33
      #ifdef TSS_E33_NOISE_WINDOW_SIZE
        TSS_E33_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 34
      #ifdef TSS_E34_NOISE_WINDOW_SIZE
        TSS_E34_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 35
      #ifdef TSS_E35_NOISE_WINDOW_SIZE
        TSS_E35_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 36
      #ifdef TSS_E36_NOISE_WINDOW_SIZE
        TSS_E36_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 37
      #ifdef TSS_E37_NOISE_WINDOW_SIZE
        TSS_E37_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 38
      #ifdef TSS_E38_NOISE_WINDOW_SIZE
        TSS_E38_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 39
      #ifdef TSS_E39_NOISE_WINDOW_SIZE
        TSS_E39_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 40
      #ifdef TSS_E40_NOISE_WINDOW_SIZE
        TSS_E40_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 41
      #ifdef TSS_E41_NOISE_WINDOW_SIZE
        TSS_E41_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 42
      #ifdef TSS_E42_NOISE_WINDOW_SIZE
        TSS_E42_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 43
      #ifdef TSS_E43_NOISE_WINDOW_SIZE
        TSS_E43_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 44
      #ifdef TSS_E44_NOISE_WINDOW_SIZE
        TSS_E44_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 45
      #ifdef TSS_E45_NOISE_WINDOW_SIZE
        TSS_E45_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 46
      #ifdef TSS_E46_NOISE_WINDOW_SIZE
        TSS_E46_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 47
      #ifdef TSS_E47_NOISE_WINDOW_SIZE
        TSS_E47_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 48
      #ifdef TSS_E48_NOISE_WINDOW_SIZE
        TSS_E48_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 49
      #ifdef TSS_E49_NOISE_WINDOW_SIZE
        TSS_E49_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 50
      #ifdef TSS_E50_NOISE_WINDOW_SIZE
        TSS_E50_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 51
      #ifdef TSS_E51_NOISE_WINDOW_SIZE
        TSS_E51_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 52
      #ifdef TSS_E52_NOISE_WINDOW_SIZE
        TSS_E52_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 53
      #ifdef TSS_E53_NOISE_WINDOW_SIZE
        TSS_E53_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 54
      #ifdef TSS_E54_NOISE_WINDOW_SIZE
        TSS_E54_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 55
      #ifdef TSS_E55_NOISE_WINDOW_SIZE
        TSS_E55_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 56
      #ifdef TSS_E56_NOISE_WINDOW_SIZE
        TSS_E56_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 57
      #ifdef TSS_E57_NOISE_WINDOW_SIZE
        TSS_E57_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 58
      #ifdef TSS_E58_NOISE_WINDOW_SIZE
        TSS_E58_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 59
      #ifdef TSS_E59_NOISE_WINDOW_SIZE
        TSS_E59_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 60
      #ifdef TSS_E60_NOISE_WINDOW_SIZE
        TSS_E60_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 61
      #ifdef TSS_E61_NOISE_WINDOW_SIZE
        TSS_E61_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 62
      #ifdef TSS_E62_NOISE_WINDOW_SIZE
        TSS_E62_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
    #if TSS_N_ELECTRODES > 63
      #ifdef TSS_E63_NOISE_WINDOW_SIZE
        TSS_E63_NOISE_WINDOW_SIZE / 2,
      #else
        TSS_DEFAULT_NOISE_WINDOW_SIZE / 2,
      #endif
    #endif
};
#endif

/*
 * Declaration of main structures and arrays used by TSS 
 */

TSS_CSSystem tss_CSSys;
UINT8 tss_au8Sensitivity[TSS_N_ELECTRODES];
UINT8 tss_au8ElectrodeEnablers[((TSS_N_ELECTRODES - 1)/ 8) + 1];
UINT8 tss_au8ElectrodeStatus[((TSS_N_ELECTRODES - 1)/ 8) + 1];

#ifndef U16CHECKSUM
    UINT8 tss_u8ConfCheckSum;
#else
    UINT16 u16ConfCheckSum;
    #define tss_u8ConfCheckSum ((UINT8)u16ConfCheckSum)
#endif

UINT16 tss_au16ElecBaseline[TSS_N_ELECTRODES];

#if TSS_USE_IIR_FILTER
    UINT16 tss_au16PrevCapSample[TSS_N_ELECTRODES];
#endif

#if TSS_USE_DELTA_LOG 
    INT8 tss_ai8InstantDelta[TSS_N_ELECTRODES];
#endif

/* Declaration of arrays used to store electrode behavior values */
INT8  tss_ai8CalPrevDelta[TSS_N_ELECTRODES];
INT8  tss_ai8ReleaseThreshold[TSS_N_ELECTRODES];
UINT8 tss_au8DebounceCount[TSS_N_ELECTRODES];
UINT8 tss_au8TouchCount[TSS_N_ELECTRODES];
UINT8 tss_au8ReleaseCount[TSS_N_ELECTRODES];
UINT8 tss_au8StuckCount[TSS_N_ELECTRODES];
UINT8 tss_au8ElecState[TSS_N_ELECTRODES];
UINT8 tss_au8Buffers[N_BUFF_ELEMENTS + 1u];                     /* The extra byte is because of the end of character */

/* Evaluate No of Controls */
#if TSS_N_CONTROLS != 0
    UINT8 tss_au8ScheduleCount[TSS_N_CONTROLS];
    UINT8 tss_au8IdleCounter[TSS_N_CONTROLS];
    UINT8 tss_au8IdleState[((TSS_N_CONTROLS - 1)/ 8) + 1];
    UINT8 tss_au8ChangeSignal[((TSS_N_CONTROLS - 1)/ 8) + 1];
    UINT8 tss_au8GrpEnablers[((TSS_N_CONTROLS - 1)/ 8) + 1];    /* Enablers for scaning */
    UINT8 tss_au8GrpState[((TSS_N_CONTROLS - 1)/ 8) + 1];       /* idle state flags */
#else
    UINT8 tss_au8ScheduleCount[1];
    UINT8 tss_au8IdleCounter[1];
    UINT8 tss_au8IdleState[1];
    UINT8 tss_au8ChangeSignal[1];
    UINT8 tss_au8GrpEnablers[1];                                /* Enablers for scaning */
    UINT8 tss_au8GrpState[1];                                   /* idle state flags */
#endif

const UINT8 tss_cu8NumElecs = (UINT8)TSS_N_ELECTRODES;
const UINT8 tss_cu8NumCtrls = (UINT8)TSS_N_CONTROLS;
const UINT8 tss_cu8ElecBitFldLn = (UINT8)(((UINT8)TSS_N_ELECTRODES - 1U) / 8U) + 1U;

#if TSS_N_CONTROLS != 0
    const UINT8 tss_cu8CtrlBitFldLn = (UINT8)(((UINT8)TSS_N_CONTROLS - 1U) / 8u) + 1u;
#else
    const UINT8 tss_cu8CtrlBitFldLn = 1U;
#endif


/*
 * The section below defines separation of the functions 
 * called in low level functions according to selected low level ATL/CTS by user
 * 
 */

#if TSS_USE_IIR_FILTER
    extern void TSS_CalculateIIRFilter(UINT8 u8ElecNum);
    extern void TSS_InitIIRFilter(UINT8 u8ElecNum);
   
    void (* const tss_fCalculateIIRFilter) (UINT8 u8ElecNum) = TSS_CalculateIIRFilter;
    void (* const tss_fInitIIRFilter) (UINT8 u8ElecNum) = TSS_InitIIRFilter;
#else
    void (* const tss_fCalculateIIRFilter) (UINT8 u8ElecNum) = NULL;
    void (* const tss_fInitIIRFilter) (UINT8 u8ElecNum) = NULL;
#endif

#if TSS_USE_DELTA_LOG
    extern void TSS_FillDeltaLogBuffer(UINT8 u8ElecNum, INT8 i8Delta);
   
    void (* const tss_fFillDeltaLoglBuffer) (UINT8 u8ElecNum, INT8 i8Delta) = TSS_FillDeltaLogBuffer;
#else
    void (* const tss_fFillDeltaLoglBuffer) (UINT8 u8ElecNum, INT8 i8Delta) = NULL;
#endif

#if TSS_USE_GPIO_STRENGTH
    UINT8 (* const tss_fSetPinStrength) (void) = TSS_SetPinStrength;
#else
    UINT8 (* const tss_fSetPinStrength) (void) = NULL;
#endif

#if TSS_USE_GPIO_SLEW_RATE
    UINT8 (* const tss_fSetPinSlewRate) (void) = TSS_SetPinSlewRate;
#else
    UINT8 (* const tss_fSetPinSlewRate) (void) = NULL;
#endif

#if TSS_USE_ATL_LOW_LEVEL
    
    extern UINT8 ATL_SampleElectrode(UINT8 u8ElecNum);
    extern UINT8 ATL_SensorInit(void);
  
    UINT8 (* const tss_fSampleElectrode) (UINT8 u8ElecNum) = ATL_SampleElectrode;
    UINT8 (* const tss_fRecalibrateElectrode) (UINT8 u8ElecNum) = NULL;
    UINT8 (* const tss_fSensorInit) (void) = ATL_SensorInit;
  
#else /*TSS_USE_CTS_LOW_LEVEL*/
    
    extern UINT8 CTS_SampleElectrode(UINT8 u8ElecNum);
    extern UINT8 CTS_GetTurbo(UINT8 u8ElecNum);
    extern UINT8 CTS_SensorInit(void);
  
    UINT8 (* const tss_fSampleElectrode) (UINT8 u8ElecNum) = CTS_SampleElectrode;
    UINT8 (* const tss_fRecalibrateElectrode) (UINT8 u8ElecNum) = CTS_GetTurbo;
    UINT8 (* const tss_fSensorInit) (void) = CTS_SensorInit;  
    
#endif /*TSS_USE_CTS_LOW_LEVEL*/

#ifdef TSS_ONFAULT_CALLBACK
    extern void TSS_ONFAULT_CALLBACK(void);
  
    void (* const tss_fOnFault) (void) = TSS_ONFAULT_CALLBACK;
#else 
    void (* const tss_fOnFault) (void) = NULL;
#endif


