/**********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************************************************//*!
*
* @file   TSS_StatusCodes.h
*
* @brief  Header file that defines the Return Status Codes used by the TSS Library
*
* @version 1.0.10.0
* 
* @date May-20-2010
* 
* These Return Status Codes are used by the User Application Level and also internally in the Library
*
***********************************************************************************************************************/


#ifndef __TSS_STAT_CODES_H__
  #define __TSS_STAT_CODES_H__

  /* Generic Status Codes */
  #define TSS_STATUS_OK                           0u
  #define TSS_CALIBRATION_CHANGED                 1u
  #define TSS_STATUS_PROCESSING                   6u

  /* ATL/CTS Sensor Status Codes */
  #define TSS_ERROR_INVALID_CMD                   2u      /* Return value from the ATL_ElectrodesSetState function */
  #define TSS_ERROR_CHARGE_TIMEOUT                3u      /* Return value from the ATL_SampleElectrode function */
  #define TSS_RECALIBRATION_REQUEST_LOCAP         4u      /* Return value from the ATL_SampleElectrode function */
  #define TSS_RECALIBRATION_REQUEST_HICAP         5u      /* Return value from the ATL_SampleElectrode function */

  /* Key Detector Status Codes */
  #define TSS_ERROR_KEYDETECT_LARGE_CAP           0x01u   /* Return value from the KeyDetectorInit function */
  #define TSS_ERROR_KEYDETECT_SMALL_CAP           0x02u   /* Return value from the KeyDetectorInit function */        

  /* Keypad Decoder Status Codes */
  #define TSS_ERROR_KEYPAD_NOT_IDLE               0x11u   /* Return values from the KeyPadConfig function */
  #define TSS_ERROR_KEYPAD_ILEGAL_PARAMETER       0x12u   /* Return values from the KeyPadConfig function */
  #define TSS_ERROR_KEYPAD_READ_ONLY_PARAMETER    0x13u   /* Return values from the KeyPadConfig function */
  #define TSS_ERROR_KEYPAD_OUT_OF_RANGE           0x14u   /* Return values from the KeyPadConfig function */
  #define TSS_ERROR_KEYPAD_ILEGAL_CONTROL_TYPE    0x15u   /* Return values from the KeyPadConfig function */

  /* Slider Decoder Status Codes */
  #define TSS_ERROR_SLIDER_NOT_IDLE               0x21u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_SLIDER_ILEGAL_PARAMETER       0x22u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_SLIDER_READ_ONLY_PARAMETER    0x23u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_SLIDER_OUT_OF_RANGE           0x24u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_SLIDER_ILEGAL_CONTROL_TYPE    0x25u

  /* Rotary Decoder Status Codes */
  #define TSS_ERROR_ROTARY_NOT_IDLE               0x31u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_ROTARY_ILEGAL_PARAMETER       0x32u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_ROTARY_READ_ONLY_PARAMETER    0x33u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_ROTARY_OUT_OF_RANGE           0x34u   /* Return values from the TSS_SliderConfig function */
  #define TSS_ERROR_ROTARY_ILEGAL_CONTROL_TYPE    0x35u

  /* System Config & Mgnt Status Codes */
  #define TSS_ERROR_CONFSYS_NOT_IDLE              0x41u    /* Return values from the Config & Sys Mgt Config function */
  #define TSS_ERROR_CONFSYS_ILEGAL_PARAMETER      0x42u    /* Return values from the Config & Sys Mgt Config function */
  #define TSS_ERROR_CONFSYS_READ_ONLY_PARAMETER   0x43u    /* Return values from the Config & Sys Mgt Config function */
  #define TSS_ERROR_CONFSYS_OUT_OF_RANGE          0x44u    /* Return values from the Config & Sys Mgt Config function */

#endif /* __TSS_STAT_CODES_H__ */