/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   TSS_GPIO.h
*
* @brief  Macros and constants to control the GPIOs
*
* @version 1.0.9.0
* 
* @date Jun-7-2010
* 
*
***********************************************************************************************************************/


#ifndef __TSS_GPIO_H__
  #define __TSS_GPIO_H__

  #include "derivative.h" 

  /*******************************************************
   ************ GPIOs Constants Definitions **************
   *******************************************************/

  #define TSS_GPIO_DIR_IN    0U
  #define TSS_GPIO_DIR_OUT   1U

  /*******************************************************
   ******************* GPIOs Tasks Macros ****************
   *******************************************************/

  #define TSS_GPIO_PORT(port)            PT##port##D                     /* Defines the port register name */
  #define TSS_GPIO_PIN_DD(port, pin)     PT##port##DD_PT##port##DD##pin  /* Defines the port-pin register name */
  #define TSS_GPIO_PIN(port, pin)        PT##port##D_PT##port##D##pin    /* Defines the port-pin direction register name */

  #define TSS_GPIO_IN(port, pin)         (TSS_GPIO_PIN_DD(port, pin) = TSS_GPIO_DIR_IN)  /* Sets port-pin as input */
  #define TSS_GPIO_OUT(port, pin)        (TSS_GPIO_PIN_DD(port, pin) = TSS_GPIO_DIR_OUT) /* Sets port-pin as output */
  #define TSS_GPIO_READ(port, pin)       (TSS_GPIO_PORT(port) & (1u << pin) ) /* Reads port-pin */
  #define TSS_GPIO_SET(port, pin)        (TSS_GPIO_PIN(port, pin) = 1U)       /* Writes "1" to the port-pin */
  #define TSS_GPIO_CLEAR(port, pin)      (TSS_GPIO_PIN(port, pin) = 0U)       /* Writes "0" to the port-pin */
  #define TSS_GPIO_PORT_ADR(port)        (&TSS_GPIO_PORT(port))       /* Gets the electrode port address */
  #define TSS_GPIO_BIT_NUM(port)         (TSS_GPIO_BIT(pin))         /* Gets the electrode bit number */

  /*******************************************************
   *************** Srength Settings Macros ***************
   *******************************************************/
 
  #define TSS_GPIO_PIN_STR(port, pin)           PT##port##DS_PT##port##DS##pin      /* Defines the port-pin strength register name */
  #define TSS_GPIO_PIN_STR_CHK(port, pin)       PT##port##DS##pin##_EXISTS          /* Defines the port-pin strength register name */  

  #define TSS_GPIO_STRENGTH_SET(port, pin)      (TSS_GPIO_PIN_STR(port, pin) = 1U)  /* Writes "1" to the strength-pin register */
  #define TSS_GPIO_STRENGTH_CLEAR(port, pin)    (TSS_GPIO_PIN_STR(port, pin) = 0U)  /* Writes "0" to the strength-pin register */
  #define TSS_GPIO_STRENGTH_CHECK(port, pin)    TSS_GPIO_PIN_STR_CHK(port, pin)          
  #define EL2GPIO_CONV_STR_SET(port, pin)		    TSS_GPIO_STRENGTH_SET(port, pin)
  #define EL2GPIO_CONV_STR_CLEAR(port, pin)		  TSS_GPIO_STRENGTH_CLEAR(port, pin)
  #define EL2GPIO_CONV_STR_CHECK(port, pin)		  TSS_GPIO_STRENGTH_CHECK(port, pin)
  #define TSS_ELECTRODE_STRENGTH_SET(elec)      EL2GPIO_CONV_STR_SET(TSS_##elec##_P,TSS_##elec##_B)
  #define TSS_ELECTRODE_STRENGTH_CLEAR(elec)    EL2GPIO_CONV_STR_CLEAR(TSS_##elec##_P,TSS_##elec##_B)
  #define TSS_ELECTRODE_STRENGTH_CHECK(elec)    EL2GPIO_CONV_STR_CHECK(TSS_##elec##_P,TSS_##elec##_B)
  
  /*******************************************************
   *************** Slew Rate Settings Macros *************
   *******************************************************/
 
  #define TSS_GPIO_PIN_SLW(port, pin)           PT##port##SE_PT##port##SE##pin      /* Defines the port-pin slewrate register name */
  #define TSS_GPIO_PIN_SLW_CHK(port, pin)       PT##port##SE##pin##_EXISTS          /* Defines the port-pin slewrate register name */  

  #define TSS_GPIO_SLEWRATE_SET(port, pin)      (TSS_GPIO_PIN_SLW(port, pin) = 1U)  /* Writes "1" to the slewrate-pin register */
  #define TSS_GPIO_SLEWRATE_CLEAR(port, pin)    (TSS_GPIO_PIN_SLW(port, pin) = 0U)  /* Writes "0" to the slewrate-pin register */
  #define TSS_GPIO_SLEWRATE_CHECK(port, pin)    TSS_GPIO_PIN_SLW_CHK(port, pin)          
  #define EL2GPIO_CONV_SLW_SET(port, pin)		    TSS_GPIO_SLEWRATE_SET(port, pin)
  #define EL2GPIO_CONV_SLW_CLEAR(port, pin)		  TSS_GPIO_SLEWRATE_CLEAR(port, pin)
  #define EL2GPIO_CONV_SLW_CHECK(port, pin)		  TSS_GPIO_SLEWRATE_CHECK(port, pin)
  #define TSS_ELECTRODE_SLEWRATE_SET(elec)      EL2GPIO_CONV_SLW_SET(TSS_##elec##_P,TSS_##elec##_B)
  #define TSS_ELECTRODE_SLEWRATE_CLEAR(elec)    EL2GPIO_CONV_SLW_CLEAR(TSS_##elec##_P,TSS_##elec##_B)
  #define TSS_ELECTRODE_SLEWRATE_CHECK(elec)    EL2GPIO_CONV_SLW_CHECK(TSS_##elec##_P,TSS_##elec##_B)

#endif  /* End of __TSS_GPIO_H__ */