/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   CTS_McuTypes.h
*
* @brief  CTS (Capacitive Turbo Sensing) - Mcu_Layer : Platforms
*
* @version 1.0.4.0
* 
* @date Jul-23-2009
* 
*
***********************************************************************************************************************/


#ifndef CTS_McuTypes_H
  #define CTS_McuTypes_H

  /*******************************************************************************
  ****    CTS platform - SELECTOR
  *******************************************************************************/
  //C08,S08,RS08
  //C12,S12,S12X,XGATE
  //DSC
  //MCF(V1..V4)
  //MPC(55..58)


  /*M08[CSR] -------------------------------------------------------------------*/

  #if (defined(__HC08__) || defined(__RS08__))
      

      /*CTS_PLATFORM*/
              #define __M08__       //[HC08|HCS08|RS08]


      //ASSEMBLER/COMPILER            [  COMBINATION  ]   ->  LIB/__DEF__      (SELECTOR
      //================================================================================================
      //   -C08  /-C08                [HC08|HCS08|____]          /__M08CS__    (__HC08__               
      //   -Cs08 /-Cs08               [____|HCS08|____]   ->  S08/__M08S__     (__HCS08__              
      //   -Csr08/empty               [____|_____|RS08]   ->  R08/__M08R__     (__RS08__               
      //                              [HC08|_____|____]   ->  C08/__M08C__     (__HC08__  && !__HCS08__
      //------------------------------------------------------------------------------------------------
      //                              [____|HCS08|RS08]          /__M08SR__    (__HCS08__ ||  __RS08__ 
      //                              [HC08|HCS08|RS08]          /__M08__      (__HC08__  ||  __RS08__ 
              
      /*LIBRARY*/
          #if (defined(__HC08__) && !defined(__HCS08__))
              #define __M08C__      //[HC08|_____|____]
          #elif (defined(__HCS08__))
              #define __M08S__      //[____|HCS08|____]
          #elif (defined(__RS08__))
              #define __M08R__      //[____|_____|RS08]
          #endif
          
      /*BASIC_COMBINATION*/
          #if (defined(__HC08__))
              #define __M08CS__     //[HC08|HCS08|____]
          #endif
          #if (defined(__HCS08__) || defined(__RS08__))
              #define __M08SR__     //[____|HCS08|RS08]        
          #endif
              
      /*CW coding*/
          #define __asf     //NA
          #define __asi asm 
          #define __aso
          
          #define __BGND //??? 
              
          #define __CW_COMPILER__    __VERSION__  // __VERSION_STR__
          #define _ctsabi  //NA
              
          #ifdef __M08CS__
              #define __DCX_EXPANSION_ENABLED__
              #define __DCB   DCB
              #define __DCW   DCW
              #define __DCL   DCL
          #else //M08R
              //EXPANSION: NO .. but char in string (macro defined) can be indexed (MACRO_STRING:idx)
              #define __DCX_EXPANSION_DISABLED__ //NO expansion
              #define __DCB   DC.B
              #define __DCW   DC.W
              #define __DCL   DC.L
          #endif
              
  #endif /*M08*/
      



      
      
      
      
  /*M12[CSXE] ------------------------------------------------------------------*/

  #if  (defined(__HC12__))
      //-Cpu(CPU12|HCS12|HCS12X|HCS12XE)
   

      /*CTS_PLATFORM*/            
              #define __M12__       //[HC12|HCS12|HCS12X|HCS12XE]


      //  ASSEMBLER/COMPILER          [ COMBINATION             ] ->  LIB/__DEF__     (SELECTOR
      //============================================================================================================
      //-CpuCPU12  /-CpuCPU12         [HC12|HCS12|HCS12X|HCS12XE]        /__M12__     (__HC12__           
      //-CpuHCS12  /-CpuHCS12         [____|HCS12|HCS12X|HCS12XE]        /__M12SXE__  (__HCS12__
      //-CpuHCS12X /-CpuHCS12X        [____|_____|HCS12X|HCS12XE]        /__M12XE__   (__HCS12X__
      //-CpuHCS12XE/-CpuHCS12XE       [____|_____|______|HCS12XE] ->  E12/__M12E__    (__HCS12XE__
      //                              [____|_____|HCS12X|_______] ->  X12/__M12X__    (__HCS12X__ && !__HCS12XE__
      //                              [____|HCS12|______|_______] ->  S12/__M12S__    (__HCS12__ && !__HCS12X__ && !__HCS12XE__
      //                              [HC12|_____|______|_______] ->  C12/__M12C__    (__HC12__ && !__HCS12__ && !__HCS12X__ && !__HCS12XE__
      //------------------------------------------------------------------------------------------------------------
      //                              [HC12|HCS12|______|_______]        /__M12CS__   (custom
      //                              [HC12|_____|HCS12X|_______]        /__M12CX__   (custom
      //                              [____|HCS12|HCS12X|_______]        /__M12SX__   (custom
      //                              [HC12|HCS12|HCS12X|_______]        /__M12CSX__  (custom
      //                              [HC12|_____|______|HCS12XE]        /__M12CE__   (custom
      //                              [____|HCS12|______|HCS12XE]        /__M12SE__   (custom
      //                              [HC12|HCS12|______|HCS12XE]        /__M12CSE__  (custom
      //                              [HC12|_____|HCS12X|HCS12XE]        /__M12CXE__  (custom


      /*LIBRARY*/
          #if (defined(__HC12__) && !defined(__HCS12__)  && !defined(__HCS12X__)  && !defined(__HCS12XE__))
              #define __M12C__      //[HC12|_____|______|_______]
          #elif  (defined(__HCS12__)  && !defined(__HCS12X__)  && !defined(__HCS12XE__))
              #define __M12S__      //[____|HCS12|______|_______]
          #elif  (defined(__HCS12X__)  && !defined(__HCS12XE__))
              #define __M12X__      //[____|_____|HCS12X|_______]
          #elif  (defined(__HCS12XE__))
              #define __M12E__      //[____|_____|______|HCS12XE]
          #endif

      /*BASIC_COMBINATION*/
          #if (defined(__HCS12__))
              #define __M12SXE__    //[____|HCS12|HCS12X|HCS12XE]
          #endif
          #if (defined(__HCS12X__))
              #define __M12XE__     //[____|_____|HCS12X|HCS12XE]
          #endif

      /*CW coding*/
          #define __asf     //NA
          #define __asi asm 
          #define __aso 
          
          #define __BGND //???
              
          #define __CW_COMPILER__    __VERSION__  // __VERSION_STR__
          #define _ctsabi  //NA
              
          #define __DCX_EXPANSION_ENABLED__
          #define __DCB   DC.B
          #define __DCW   DC.W
          #define __DCL   DC.L
              
  #endif /*M12*/








  #if (defined(__XGATE__))
     
      #ifdef XGATE_MSG_ENABLED
      #warning "\n\
      Note that CTS routines could be interrupted by priority 4-7 ... only on XE version of XGATE core.\n\
      XD version is OK because this XGATE has no ability interrupt executed trigger routines anyway!!!"
      #endif
              #define __MXG__                                 //XGATE
        
              
      /*CW coding*/
          #define __asf     //NA
          #define __asi asm 
          #define __aso 
          
          #define __BGND asm BGND    //"Enter Background Debug Mode" == hard stop
              
          #define __CW_COMPILER__    __VERSION__  // __VERSION_STR__
          #define _ctsabi  //NA
              
          #define __DCX_EXPANSION_ENABLED__
          #define __DCB   DC.B
          #define __DCW   DC.W
          #define __DCL   DC.L
  #endif








  /*M56, MFC, DSC  ------------------------------------------------------------------*/
  /*
  DSC56800E
  =========
  DSP56F80x
  DSP56F82x
  DSP5685x
  MC56F800x
  MC56F801x
  MC56F802x
  MC56F803x
  MC56F81xx
  MC56F83xx
  */
  #if (defined(__m56800__) || defined(__m56800E__))
      #error "Sorry ... this MCU is not supported by CTS at this time!!!"
  #endif







  /*MCF[1234] ------------------------------------------------------------------*/

  #if  (defined(__COLDFIRE__))
      
      #define __MCF__
      
      #if !(__COLDFIRE__ == __MCF51QE__ || __COLDFIRE__ == __MCF51AC__ || __COLDFIRE__ == __MCF51JM__)
      #endif
      
      
      
          #define __MCF1__
          #define __FLEXIS__
      

      /* CW coding*/
          #define __asf asm         //asm FUNCTION
          #define __asi asm{        //asm( asm{
          #define __aso     }       //    )    }
    
          #define __BGND //???
          
          #define __CW_COMPILER__     __BACKENDVERSION__          // __MWERKS__  __CWCC__
          #define _ctsabi            __declspec(register_abi)    //standard_abi (the default), compact_abi
              
          #define __DCX_EXPANSION_ENABLED__
          #define __DCB   DC.B
          #define __DCW   DC.W
          #define __DCL   DC.L

      // CAUTION CTS use D0 and SP so when ISR is in C compiler maintain PUSH/PULL of D0
      // ... thus CTS routines are interruptible in CW/FSL and shoudl be in ECLIPS/FSL (CW10 www.codesourcery.com)
      // not tested in development environments: MULTI/GHS, Diab/WindRiver, GCC
      // not tested in RTOS: MQX/FSL, AUTOSAR/FSL, RTOS/GHS

      
      
      
  #endif






  /*i.MX and others ------------------------------------------------------------------*/
  #if  (defined(__arm))
      #error "Sorry ... this MCU is not supported by CTS at this time!!!"
  #endif

  #if  (defined(__MC68K__) || defined(__INTEL__) || defined(__POWERPC__) || defined(__MIPS__) || defined (__MCORE__) || defined (_ENTERPRISE_C_) || defined(__PPCGEKKO__) || defined(__PPC_EABI__) || defined (__SH__))
      #error "Sorry ... this MCU is not supported by CTS at this time!!!"
  #endif















  /*******************************************************************************
  ****    CTS platform - ILOPs
  *******************************************************************************/
      #define ILOP_M08CS      asm DCB $8d       // all HC08 & HCS08 (HCS08 instruction) 
      #define ILOP_M08C       asm DCB $32       // all RS08 & HC08 (HC08 instruction)
      #define ILOP_M08R       asm DC.B $32      // all RS08 & HC08 (RS08 instruction)
      #define ILOP_M12        asm DC.W $1832    // TRAP($18)<<8 | unimplemented opcode
      #define ILOP_MXG        asm DC.W $1001    // see AN3555 or XGATE specs (Instruction Coding)
      #define ILOP_MCF1       asm(DC.W 0x4AFC)  // ILLEGAL, Take Illegal Instruction Trap













  /*******************************************************************************
  ****    CTS platform - DEFINES
  *******************************************************************************/

  /*CTS_M08*--------------------------------------------------------------------*/

      #ifdef __M08__
          #define __CTS_M08__
      
      /*C = H111, (not)H121 bacause no pullup*/
          #ifdef __M08C__ 
              #define __CTS_M08C__
              #define CTS_PLATFORM_STR    "CTS_M08C"
              #define CTS_ILOP            ILOP_M08CS
          #endif
          
      /*S = H111,H112*/
          #ifdef __M08S__
              #define __CTS_M08S__
              #define CTS_PLATFORM_STR    "CTS_M08S"
              #define CTS_ILOP            ILOP_M08CS
          #endif
          
      /*R = H112,H122*/
          #ifdef __M08R__
              #define __CTS_M08R__
              #define CTS_PLATFORM_STR    "CTS_M08R"
              #define CTS_ILOP            ILOP_M08R
          #endif
          
      #endif /*__M08__*/



  /*CTS_M12*--------------------------------------------------------------------*/
      //be carefule about known code-ready-prediction issue when the code is
      //located close to the end of (PageN) and prediction mechanism pre-read
      //the code which will be on (PageN+1) so the next execution will be related
      //to (PageN) and the the right page (PageN+1)
      
      #ifdef __M12__
          #define __CTS_M12__
          
      /*C = H222*/
          #ifdef __M12C__ 
              #define __CTS_M12C__
              #define CTS_PLATFORM_STR    "CTS_M12C"
              #define CTS_ILOP            ILOP_M12
          #endif
          
      /*S = H222*/
          #ifdef __M12S__
              #define __CTS_M08S__
              #define CTS_PLATFORM_STR    "CTS_M12S"
              #define CTS_ILOP            ILOP_M12
          #endif
          
      /*X = H222*/
          #ifdef __M12X__
              #define __CTS_M12X__
              #define CTS_PLATFORM_STR    "CTS_M12X"
              #define CTS_ILOP            ILOP_M12
          #endif
          
      /*E = H222*/
          #ifdef __M12E__
              #define __CTS_M12E__
              #define CTS_PLATFORM_STR    "CTS_M12E"
              #define CTS_ILOP            ILOP_M12
          #endif

      
      #endif /*__M12__*/
      
      /*D,R = H222*/
      #ifdef __MXG__
          //recognize XD vs. XE versions!!!
              #define __CTS_MXG__
              
              #define CTS_PLATFORM_STR    "CTS_MXG" //D,E
              #define CTS_ILOP            ILOP_MXG
      #endif


  /*CTS_M56*--------------------------------------------------------------------*/
      #ifdef __M56__
          #define __CTS_M56__
          
      /*1 = H222*/
          #ifdef __M56__ 
              #define __CTS_M56__
              #define CTS_PLATFORM_STR    "CTS_M56"
              #define CTS_ILOP            ILOP_M56
          #endif
      
      #endif /*__MCF__*/
      

  /*CTS_MCF*--------------------------------------------------------------------*/

      #ifdef __MCF__ //__M68__
          #define __CTS_MCF__
          
      /*1 = H444*/
          #ifdef __MCF1__ 
              #define __CTS_MCF1__
              #define CTS_PLATFORM_STR    "CTS_MCF1"
              #define CTS_ILOP            ILOP_MCF1
          #endif
      
      #endif /*__MCF__*/
      










  /*******************************************************************************
  ****    CTS platform - HARDWARE
  *******************************************************************************/


  #if defined(__M08SR__) || defined(__MCF1__)
      //RS08[A-E],S08[A-L],MCF1[A-J]
  //A
      #define __CTS_A_p__ 0
      #define __CTS_A0t__ defined(PTADD_PTADD0) && defined(PTAPE_PTAPE0)
      #define __CTS_A1t__ defined(PTADD_PTADD1) && defined(PTAPE_PTAPE1)
      #define __CTS_A2t__ defined(PTADD_PTADD2) && defined(PTAPE_PTAPE2)
      #define __CTS_A3t__ defined(PTADD_PTADD3) && defined(PTAPE_PTAPE3)
      #define __CTS_A4t__ defined(PTADD_PTADD4) && defined(PTAPE_PTAPE4)
      #define __CTS_A5t__ defined(PTADD_PTADD5) && defined(PTAPE_PTAPE5)
      #define __CTS_A6t__ defined(PTADD_PTADD6) && defined(PTAPE_PTAPE6)
      #define __CTS_A7t__ defined(PTADD_PTADD7) && defined(PTAPE_PTAPE7)
  //B
      #define __CTS_B_p__ 0
      #define __CTS_B0t__ defined(PTBDD_PTBDD0) && defined(PTBPE_PTBPE0)
      #define __CTS_B1t__ defined(PTBDD_PTBDD1) && defined(PTBPE_PTBPE1)
      #define __CTS_B2t__ defined(PTBDD_PTBDD2) && defined(PTBPE_PTBPE2)
      #define __CTS_B3t__ defined(PTBDD_PTBDD3) && defined(PTBPE_PTBPE3)
      #define __CTS_B4t__ defined(PTBDD_PTBDD4) && defined(PTBPE_PTBPE4)
      #define __CTS_B5t__ defined(PTBDD_PTBDD5) && defined(PTBPE_PTBPE5)
      #define __CTS_B6t__ defined(PTBDD_PTBDD6) && defined(PTBPE_PTBPE6)
      #define __CTS_B7t__ defined(PTBDD_PTBDD7) && defined(PTBPE_PTBPE7)
  //C
      #define __CTS_C_p__ 0
      #define __CTS_C0t__ defined(PTCDD_PTCDD0) && defined(PTCPE_PTCPE0)
      #define __CTS_C1t__ defined(PTCDD_PTCDD1) && defined(PTCPE_PTCPE1)
      #define __CTS_C2t__ defined(PTCDD_PTCDD2) && defined(PTCPE_PTCPE2)
      #define __CTS_C3t__ defined(PTCDD_PTCDD3) && defined(PTCPE_PTCPE3)
      #define __CTS_C4t__ defined(PTCDD_PTCDD4) && defined(PTCPE_PTCPE4)
      #define __CTS_C5t__ defined(PTCDD_PTCDD5) && defined(PTCPE_PTCPE5)
      #define __CTS_C6t__ defined(PTCDD_PTCDD6) && defined(PTCPE_PTCPE6)
      #define __CTS_C7t__ defined(PTCDD_PTCDD7) && defined(PTCPE_PTCPE7)
  //D
      #define __CTS_D_p__ 0
      #define __CTS_D0t__ defined(PTDDD_PTDDD0) && defined(PTDPE_PTDPE0)
      #define __CTS_D1t__ defined(PTDDD_PTDDD1) && defined(PTDPE_PTDPE1)
      #define __CTS_D2t__ defined(PTDDD_PTDDD2) && defined(PTDPE_PTDPE2)
      #define __CTS_D3t__ defined(PTDDD_PTDDD3) && defined(PTDPE_PTDPE3)
      #define __CTS_D4t__ defined(PTDDD_PTDDD4) && defined(PTDPE_PTDPE4)
      #define __CTS_D5t__ defined(PTDDD_PTDDD5) && defined(PTDPE_PTDPE5)
      #define __CTS_D6t__ defined(PTDDD_PTDDD6) && defined(PTDPE_PTDPE6)
      #define __CTS_D7t__ defined(PTDDD_PTDDD7) && defined(PTDPE_PTDPE7)
  //E
      #define __CTS_E_p__ 0
      #define __CTS_E0t__ defined(PTEDD_PTEDD0) && defined(PTEPE_PTEPE0)
      #define __CTS_E1t__ defined(PTEDD_PTEDD1) && defined(PTEPE_PTEPE1)
      #define __CTS_E2t__ defined(PTEDD_PTEDD2) && defined(PTEPE_PTEPE2)
      #define __CTS_E3t__ defined(PTEDD_PTEDD3) && defined(PTEPE_PTEPE3)
      #define __CTS_E4t__ defined(PTEDD_PTEDD4) && defined(PTEPE_PTEPE4)
      #define __CTS_E5t__ defined(PTEDD_PTEDD5) && defined(PTEPE_PTEPE5)
      #define __CTS_E6t__ defined(PTEDD_PTEDD6) && defined(PTEPE_PTEPE6)
      #define __CTS_E7t__ defined(PTEDD_PTEDD7) && defined(PTEPE_PTEPE7)
  //F
      #define __CTS_F_p__ 0
      #define __CTS_F0t__ defined(PTFDD_PTFDD0) && defined(PTFPE_PTFPE0)
      #define __CTS_F1t__ defined(PTFDD_PTFDD1) && defined(PTFPE_PTFPE1)
      #define __CTS_F2t__ defined(PTFDD_PTFDD2) && defined(PTFPE_PTFPE2)
      #define __CTS_F3t__ defined(PTFDD_PTFDD3) && defined(PTFPE_PTFPE3)
      #define __CTS_F4t__ defined(PTFDD_PTFDD4) && defined(PTFPE_PTFPE4)
      #define __CTS_F5t__ defined(PTFDD_PTFDD5) && defined(PTFPE_PTFPE5)
      #define __CTS_F6t__ defined(PTFDD_PTFDD6) && defined(PTFPE_PTFPE6)
      #define __CTS_F7t__ defined(PTFDD_PTFDD7) && defined(PTFPE_PTFPE7)
  //G
      #define __CTS_G_p__ 0
      #define __CTS_G0t__ defined(PTGDD_PTGDD0) && defined(PTGPE_PTGPE0)
      #define __CTS_G1t__ defined(PTGDD_PTGDD1) && defined(PTGPE_PTGPE1)
      #define __CTS_G2t__ defined(PTGDD_PTGDD2) && defined(PTGPE_PTGPE2)
      #define __CTS_G3t__ defined(PTGDD_PTGDD3) && defined(PTGPE_PTGPE3)
      #define __CTS_G4t__ defined(PTGDD_PTGDD4) && defined(PTGPE_PTGPE4)
      #define __CTS_G5t__ defined(PTGDD_PTGDD5) && defined(PTGPE_PTGPE5)
      #define __CTS_G6t__ defined(PTGDD_PTGDD6) && defined(PTGPE_PTGPE6)
      #define __CTS_G7t__ defined(PTGDD_PTGDD7) && defined(PTGPE_PTGPE7)
  //H
      #define __CTS_H_p__ 0
      #define __CTS_H0t__ defined(PTHDD_PTHDD0) && defined(PTHPE_PTHPE0)
      #define __CTS_H1t__ defined(PTHDD_PTHDD1) && defined(PTHPE_PTHPE1)
      #define __CTS_H2t__ defined(PTHDD_PTHDD2) && defined(PTHPE_PTHPE2)
      #define __CTS_H3t__ defined(PTHDD_PTHDD3) && defined(PTHPE_PTHPE3)
      #define __CTS_H4t__ defined(PTHDD_PTHDD4) && defined(PTHPE_PTHPE4)
      #define __CTS_H5t__ defined(PTHDD_PTHDD5) && defined(PTHPE_PTHPE5)
      #define __CTS_H6t__ defined(PTHDD_PTHDD6) && defined(PTHPE_PTHPE6)
      #define __CTS_H7t__ defined(PTHDD_PTHDD7) && defined(PTHPE_PTHPE7)
  //J
      #define __CTS_I_p__ 0
      #define __CTS_I0t__ defined(PTIDD_PTIDD0) && defined(PTIPE_PTIPE0)
      #define __CTS_I1t__ defined(PTIDD_PTIDD1) && defined(PTIPE_PTIPE1)
      #define __CTS_I2t__ defined(PTIDD_PTIDD2) && defined(PTIPE_PTIPE2)
      #define __CTS_I3t__ defined(PTIDD_PTIDD3) && defined(PTIPE_PTIPE3)
      #define __CTS_I4t__ defined(PTIDD_PTIDD4) && defined(PTIPE_PTIPE4)
      #define __CTS_I5t__ defined(PTIDD_PTIDD5) && defined(PTIPE_PTIPE5)
      #define __CTS_I6t__ defined(PTIDD_PTIDD6) && defined(PTIPE_PTIPE6)
      #define __CTS_I7t__ defined(PTIDD_PTIDD7) && defined(PTIPE_PTIPE7)
  //J
      #define __CTS_J_p__ 0
      #define __CTS_J0t__ defined(PTJDD_PTJDD0) && defined(PTJPE_PTJPE0)
      #define __CTS_J1t__ defined(PTJDD_PTJDD1) && defined(PTJPE_PTJPE1)
      #define __CTS_J2t__ defined(PTJDD_PTJDD2) && defined(PTJPE_PTJPE2)
      #define __CTS_J3t__ defined(PTJDD_PTJDD3) && defined(PTJPE_PTJPE3)
      #define __CTS_J4t__ defined(PTJDD_PTJDD4) && defined(PTJPE_PTJPE4)
      #define __CTS_J5t__ defined(PTJDD_PTJDD5) && defined(PTJPE_PTJPE5)
      #define __CTS_J6t__ defined(PTJDD_PTJDD6) && defined(PTJPE_PTJPE6)
      #define __CTS_J7t__ defined(PTJDD_PTJDD7) && defined(PTJPE_PTJPE7)
  //K
      #define __CTS_K_p__ 0
      #define __CTS_K0t__ defined(PTKDD_PTKDD0) && defined(PTKPE_PTKPE0)
      #define __CTS_K1t__ defined(PTKDD_PTKDD1) && defined(PTKPE_PTKPE1)
      #define __CTS_K2t__ defined(PTKDD_PTKDD2) && defined(PTKPE_PTKPE2)
      #define __CTS_K3t__ defined(PTKDD_PTKDD3) && defined(PTKPE_PTKPE3)
      #define __CTS_K4t__ defined(PTKDD_PTKDD4) && defined(PTKPE_PTKPE4)
      #define __CTS_K5t__ defined(PTKDD_PTKDD5) && defined(PTKPE_PTKPE5)
      #define __CTS_K6t__ defined(PTKDD_PTKDD6) && defined(PTKPE_PTKPE6)
      #define __CTS_K7t__ defined(PTKDD_PTKDD7) && defined(PTKPE_PTKPE7)
  //L
      #define __CTS_L_p__ 0
      #define __CTS_L0t__ defined(PTLDD_PTLDD0) && defined(PTLPE_PTLPE0)
      #define __CTS_L1t__ defined(PTLDD_PTLDD1) && defined(PTLPE_PTLPE1)
      #define __CTS_L2t__ defined(PTLDD_PTLDD2) && defined(PTLPE_PTLPE2)
      #define __CTS_L3t__ defined(PTLDD_PTLDD3) && defined(PTLPE_PTLPE3)
      #define __CTS_L4t__ defined(PTLDD_PTLDD4) && defined(PTLPE_PTLPE4)
      #define __CTS_L5t__ defined(PTLDD_PTLDD5) && defined(PTLPE_PTLPE5)
      #define __CTS_L6t__ defined(PTLDD_PTLDD6) && defined(PTLPE_PTLPE6)
      #define __CTS_L7t__ defined(PTLDD_PTLDD7) && defined(PTLPE_PTLPE7)
  #endif /*S08,RS08,MCF1*/






  #if defined(__M08C__)
  //   ISSUE :: PTxPUE_PTxPUEn can be on ~2% of HC08 labeled as PTxPUE_PTxnPUE !!!! 
  //   ... this case is unsupported by CTS now!!! Why? HC08 are old devices and it is very specific issue!!!

      //C08[A-E]
      #define __CTS_A_p__ 0
      #define __CTS_A0t__ defined(DDRA_DDRA0) && defined(PTAPUE_PTAPUE1)
      #define __CTS_A1t__ defined(DDRA_DDRA1) && defined(PTAPUE_PTAPUE1)
      #define __CTS_A2t__ defined(DDRA_DDRA2) && defined(PTAPUE_PTAPUE2)
      #define __CTS_A3t__ defined(DDRA_DDRA3) && defined(PTAPUE_PTAPUE3)
      #define __CTS_A4t__ defined(DDRA_DDRA4) && defined(PTAPUE_PTAPUE4)
      #define __CTS_A5t__ defined(DDRA_DDRA5) && defined(PTAPUE_PTAPUE5)
      #define __CTS_A6t__ defined(DDRA_DDRA6) && defined(PTAPUE_PTAPUE6)
      #define __CTS_A7t__ defined(DDRA_DDRA7) && defined(PTAPUE_PTAPUE7)
      
      #define __CTS_B_p__ 0
      #define __CTS_B0t__ defined(DDRB_DDRB0) && defined(PTBPUE_PTBPUE0)
      #define __CTS_B1t__ defined(DDRB_DDRB1) && defined(PTBPUE_PTBPUE1)
      #define __CTS_B2t__ defined(DDRB_DDRB2) && defined(PTBPUE_PTBPUE2)
      #define __CTS_B3t__ defined(DDRB_DDRB3) && defined(PTBPUE_PTBPUE3)
      #define __CTS_B4t__ defined(DDRB_DDRB4) && defined(PTBPUE_PTBPUE4)
      #define __CTS_B5t__ defined(DDRB_DDRB5) && defined(PTBPUE_PTBPUE5)
      #define __CTS_B6t__ defined(DDRB_DDRB6) && defined(PTBPUE_PTBPUE6)
      #define __CTS_B7t__ defined(DDRB_DDRB7) && defined(PTBPUE_PTBPUE7)

      #define __CTS_C_p__ 0
      #define __CTS_C0t__ defined(DDRC_DDRC0) && defined(PTCPUE_PTCPUE0)
      #define __CTS_C1t__ defined(DDRC_DDRC1) && defined(PTCPUE_PTCPUE1)
      #define __CTS_C2t__ defined(DDRC_DDRC2) && defined(PTCPUE_PTCPUE2)
      #define __CTS_C3t__ defined(DDRC_DDRC3) && defined(PTCPUE_PTCPUE3)
      #define __CTS_C4t__ defined(DDRC_DDRC4) && defined(PTCPUE_PTCPUE4)
      #define __CTS_C5t__ defined(DDRC_DDRC5) && defined(PTCPUE_PTCPUE5)
      #define __CTS_C6t__ defined(DDRC_DDRC6) && defined(PTCPUE_PTCPUE6)
      #define __CTS_C7t__ defined(DDRC_DDRC7) && defined(PTCPUE_PTCPUE7)

      #define __CTS_D_p__ 0
      #define __CTS_D0t__ defined(DDRD_DDRD0) && defined(PTDPUE_PTDPUE0)
      #define __CTS_D1t__ defined(DDRD_DDRD1) && defined(PTDPUE_PTDPUE1)
      #define __CTS_D2t__ defined(DDRD_DDRD2) && defined(PTDPUE_PTDPUE2)
      #define __CTS_D3t__ defined(DDRD_DDRD3) && defined(PTDPUE_PTDPUE3)
      #define __CTS_D4t__ defined(DDRD_DDRD4) && defined(PTDPUE_PTDPUE4)
      #define __CTS_D5t__ defined(DDRD_DDRD5) && defined(PTDPUE_PTDPUE5)
      #define __CTS_D6t__ defined(DDRD_DDRD6) && defined(PTDPUE_PTDPUE6)
      #define __CTS_D7t__ defined(DDRD_DDRD7) && defined(PTDPUE_PTDPUE7)

      #define __CTS_E_p__ 0
      #define __CTS_E0t__ defined(DDRE_DDRE0) && defined(PTEPUE_PTEPUE0)
      #define __CTS_E1t__ defined(DDRE_DDRE1) && defined(PTEPUE_PTEPUE1)
      #define __CTS_E2t__ defined(DDRE_DDRE2) && defined(PTEPUE_PTEPUE2)
      #define __CTS_E3t__ defined(DDRE_DDRE3) && defined(PTEPUE_PTEPUE3)
      #define __CTS_E4t__ defined(DDRE_DDRE4) && defined(PTEPUE_PTEPUE4)
      #define __CTS_E5t__ defined(DDRE_DDRE5) && defined(PTEPUE_PTEPUE5)
      #define __CTS_E6t__ defined(DDRE_DDRE6) && defined(PTEPUE_PTEPUE6)
      #define __CTS_E7t__ defined(DDRE_DDRE7) && defined(PTEPUE_PTEPUE7)
  #endif /*C08*/






  #if defined(__M12__) || defined(__MXG__)
      
  //   ISSUE :: global access is valid just for ports AB,CD,E because other global PE controlled ports 
  //  ... can have different bits in PUCR register in the C12 family (S12 have not this exception)
  //  on C12 are ports "G,H,J,K" PE-global but on S12 it is always "K" but "G,H,J" etc. can be PE-local!!!

      //M12(MXG)[]     //PUCR_PUPAE ... specialni pristup na cely port
  //PE-global
  //A:0
      #define __CTS_A_p__ 0
      #define __CTS_A0t__ defined(DDRA_DDRA0) && defined(PUCR_PUPAE)
      #define __CTS_A1t__ defined(DDRA_DDRA1) && defined(PUCR_PUPAE)
      #define __CTS_A2t__ defined(DDRA_DDRA2) && defined(PUCR_PUPAE)
      #define __CTS_A3t__ defined(DDRA_DDRA3) && defined(PUCR_PUPAE)
      #define __CTS_A4t__ defined(DDRA_DDRA4) && defined(PUCR_PUPAE)
      #define __CTS_A5t__ defined(DDRA_DDRA5) && defined(PUCR_PUPAE)
      #define __CTS_A6t__ defined(DDRA_DDRA6) && defined(PUCR_PUPAE)
      #define __CTS_A7t__ defined(DDRA_DDRA7) && defined(PUCR_PUPAE)
  //B:1
      #define __CTS_B_p__ 0
      #define __CTS_B0t__ defined(DDRB_DDRB0) && defined(PUCR_PUPBE)
      #define __CTS_B1t__ defined(DDRB_DDRB1) && defined(PUCR_PUPBE)
      #define __CTS_B2t__ defined(DDRB_DDRB2) && defined(PUCR_PUPBE)
      #define __CTS_B3t__ defined(DDRB_DDRB3) && defined(PUCR_PUPBE)
      #define __CTS_B4t__ defined(DDRB_DDRB4) && defined(PUCR_PUPBE)
      #define __CTS_B5t__ defined(DDRB_DDRB5) && defined(PUCR_PUPBE)
      #define __CTS_B6t__ defined(DDRB_DDRB6) && defined(PUCR_PUPBE)
      #define __CTS_B7t__ defined(DDRB_DDRB7) && defined(PUCR_PUPBE)
  //C:2
      #define __CTS_C_p__ 0
      #define __CTS_C0t__ defined(DDRC_DDRC0) && defined(PUCR_PUPCE)
      #define __CTS_C1t__ defined(DDRC_DDRC1) && defined(PUCR_PUPCE)
      #define __CTS_C2t__ defined(DDRC_DDRC2) && defined(PUCR_PUPCE)
      #define __CTS_C3t__ defined(DDRC_DDRC3) && defined(PUCR_PUPCE)
      #define __CTS_C4t__ defined(DDRC_DDRC4) && defined(PUCR_PUPCE)
      #define __CTS_C5t__ defined(DDRC_DDRC5) && defined(PUCR_PUPCE)
      #define __CTS_C6t__ defined(DDRC_DDRC6) && defined(PUCR_PUPCE)
      #define __CTS_C7t__ defined(DDRC_DDRC7) && defined(PUCR_PUPCE)
  //D:3
      #define __CTS_D_p__ 0
      #define __CTS_D0t__ defined(DDRD_DDRD0) && defined(PUCR_PUPDE)
      #define __CTS_D1t__ defined(DDRD_DDRD1) && defined(PUCR_PUPDE)
      #define __CTS_D2t__ defined(DDRD_DDRD2) && defined(PUCR_PUPDE)
      #define __CTS_D3t__ defined(DDRD_DDRD3) && defined(PUCR_PUPDE)
      #define __CTS_D4t__ defined(DDRD_DDRD4) && defined(PUCR_PUPDE)
      #define __CTS_D5t__ defined(DDRD_DDRD5) && defined(PUCR_PUPDE)
      #define __CTS_D6t__ defined(DDRD_DDRD6) && defined(PUCR_PUPDE)
      #define __CTS_D7t__ defined(DDRD_DDRD7) && defined(PUCR_PUPDE)
  //E:4
      #define __CTS_E_p__ 0
      #define __CTS_E0t__ defined(DDRE_DDRE0) && defined(PUCR_PUPEE)
      #define __CTS_E1t__ defined(DDRE_DDRE1) && defined(PUCR_PUPEE)
      #define __CTS_E2t__ defined(DDRE_DDRE2) && defined(PUCR_PUPEE)
      #define __CTS_E3t__ defined(DDRE_DDRE3) && defined(PUCR_PUPEE)
      #define __CTS_E4t__ defined(DDRE_DDRE4) && defined(PUCR_PUPEE)
      #define __CTS_E5t__ defined(DDRE_DDRE5) && defined(PUCR_PUPEE)
      #define __CTS_E6t__ defined(DDRE_DDRE6) && defined(PUCR_PUPEE)
      #define __CTS_E7t__ defined(DDRE_DDRE7) && defined(PUCR_PUPEE)
  //K:7
      #define __CTS_K_p__ 0
      #define __CTS_K0t__ defined(DDRK_DDRK0) && defined(PUCR_PUPKE)
      #define __CTS_K1t__ defined(DDRK_DDRK1) && defined(PUCR_PUPKE)
      #define __CTS_K2t__ defined(DDRK_DDRK2) && defined(PUCR_PUPKE)
      #define __CTS_K3t__ defined(DDRK_DDRK3) && defined(PUCR_PUPKE)
      #define __CTS_K4t__ defined(DDRK_DDRK4) && defined(PUCR_PUPKE)
      #define __CTS_K5t__ defined(DDRK_DDRK5) && defined(PUCR_PUPKE)
      #define __CTS_K6t__ defined(DDRK_DDRK6) && defined(PUCR_PUPKE)
      #define __CTS_K7t__ defined(DDRK_DDRK7) && defined(PUCR_PUPKE)

  //PE-local with polarity access //PPSx_PPSxn
  #if !defined(__M12C__) //GHJ could be PE-global on C12!!!
  //H,J,L,M,P,Q,R,S,T,U,V,W
  //H
      #define __CTS_H_p__ defined(PPSH)
      #define __CTS_H0t__ defined(DDRH_DDRH0) && defined(PERH_PERH0)
      #define __CTS_H1t__ defined(DDRH_DDRH1) && defined(PERH_PERH1)
      #define __CTS_H2t__ defined(DDRH_DDRH2) && defined(PERH_PERH2)
      #define __CTS_H3t__ defined(DDRH_DDRH3) && defined(PERH_PERH3)
      #define __CTS_H4t__ defined(DDRH_DDRH4) && defined(PERH_PERH4)
      #define __CTS_H5t__ defined(DDRH_DDRH5) && defined(PERH_PERH5)
      #define __CTS_H6t__ defined(DDRH_DDRH6) && defined(PERH_PERH6)
      #define __CTS_H7t__ defined(DDRH_DDRH7) && defined(PERH_PERH7)
  //J
      #define __CTS_J_p__ defined(PPSJ)
      #define __CTS_J0t__ defined(DDRJ_DDRJ0) && defined(PERJ_PERJ0)
      #define __CTS_J1t__ defined(DDRJ_DDRJ1) && defined(PERJ_PERJ1)
      #define __CTS_J2t__ defined(DDRJ_DDRJ2) && defined(PERJ_PERJ2)
      #define __CTS_J3t__ defined(DDRJ_DDRJ3) && defined(PERJ_PERJ3)
      #define __CTS_J4t__ defined(DDRJ_DDRJ4) && defined(PERJ_PERJ4)
      #define __CTS_J5t__ defined(DDRJ_DDRJ5) && defined(PERJ_PERJ5)
      #define __CTS_J6t__ defined(DDRJ_DDRJ6) && defined(PERJ_PERJ6)
      #define __CTS_J7t__ defined(DDRJ_DDRJ7) && defined(PERJ_PERJ7)
  //L
      #define __CTS_L_p__ defined(PPSL)
      #define __CTS_L0t__ defined(DDRL_DDRL0) && defined(PERL_PERL0)
      #define __CTS_L1t__ defined(DDRL_DDRL1) && defined(PERL_PERL1)
      #define __CTS_L2t__ defined(DDRL_DDRL2) && defined(PERL_PERL2)
      #define __CTS_L3t__ defined(DDRL_DDRL3) && defined(PERL_PERL3)
      #define __CTS_L4t__ defined(DDRL_DDRL4) && defined(PERL_PERL4)
      #define __CTS_L5t__ defined(DDRL_DDRL5) && defined(PERL_PERL5)
      #define __CTS_L6t__ defined(DDRL_DDRL6) && defined(PERL_PERL6)
      #define __CTS_L7t__ defined(DDRL_DDRL7) && defined(PERL_PERL7)
  //M
      #define __CTS_M_p__ defined(PPSM)
      #define __CTS_M0t__ defined(DDRM_DDRM0) && defined(PERM_PERM0)
      #define __CTS_M1t__ defined(DDRM_DDRM1) && defined(PERM_PERM1)
      #define __CTS_M2t__ defined(DDRM_DDRM2) && defined(PERM_PERM2)
      #define __CTS_M3t__ defined(DDRM_DDRM3) && defined(PERM_PERM3)
      #define __CTS_M4t__ defined(DDRM_DDRM4) && defined(PERM_PERM4)
      #define __CTS_M5t__ defined(DDRM_DDRM5) && defined(PERM_PERM5)
      #define __CTS_M6t__ defined(DDRM_DDRM6) && defined(PERM_PERM6)
      #define __CTS_M7t__ defined(DDRM_DDRM7) && defined(PERM_PERM7)
  //P
      #define __CTS_P_p__ defined(PPSP)
      #define __CTS_P0t__ defined(DDRP_DDRP0) && defined(PERP_PERP0)
      #define __CTS_P1t__ defined(DDRP_DDRP1) && defined(PERP_PERP1)
      #define __CTS_P2t__ defined(DDRP_DDRP2) && defined(PERP_PERP2)
      #define __CTS_P3t__ defined(DDRP_DDRP3) && defined(PERP_PERP3)
      #define __CTS_P4t__ defined(DDRP_DDRP4) && defined(PERP_PERP4)
      #define __CTS_P5t__ defined(DDRP_DDRP5) && defined(PERP_PERP5)
      #define __CTS_P6t__ defined(DDRP_DDRP6) && defined(PERP_PERP6)
      #define __CTS_P7t__ defined(DDRP_DDRP7) && defined(PERP_PERP7)
  //Q
      #define __CTS_Q_p__ defined(PPSQ)
      #define __CTS_Q0t__ defined(DDRQ_DDRQ0) && defined(PERQ_PERQ0)
      #define __CTS_Q1t__ defined(DDRQ_DDRQ1) && defined(PERQ_PERQ1)
      #define __CTS_Q2t__ defined(DDRQ_DDRQ2) && defined(PERQ_PERQ2)
      #define __CTS_Q3t__ defined(DDRQ_DDRQ3) && defined(PERQ_PERQ3)
      #define __CTS_Q4t__ defined(DDRQ_DDRQ4) && defined(PERQ_PERQ4)
      #define __CTS_Q5t__ defined(DDRQ_DDRQ5) && defined(PERQ_PERQ5)
      #define __CTS_Q6t__ defined(DDRQ_DDRQ6) && defined(PERQ_PERQ6)
      #define __CTS_Q7t__ defined(DDRQ_DDRQ7) && defined(PERQ_PERQ7)
  //R
      #define __CTS_R_p__ defined(PPSR)
      #define __CTS_R0t__ defined(DDRR_DDRR0) && defined(PERR_PERR0)
      #define __CTS_R1t__ defined(DDRR_DDRR1) && defined(PERR_PERR1)
      #define __CTS_R2t__ defined(DDRR_DDRR2) && defined(PERR_PERR2)
      #define __CTS_R3t__ defined(DDRR_DDRR3) && defined(PERR_PERR3)
      #define __CTS_R4t__ defined(DDRR_DDRR4) && defined(PERR_PERR4)
      #define __CTS_R5t__ defined(DDRR_DDRR5) && defined(PERR_PERR5)
      #define __CTS_R6t__ defined(DDRR_DDRR6) && defined(PERR_PERR6)
      #define __CTS_R7t__ defined(DDRR_DDRR7) && defined(PERR_PERR7)
  //S
      #define __CTS_S_p__ defined(PPSS)
      #define __CTS_S0t__ defined(DDRS_DDRS0) && defined(PERS_PERS0)
      #define __CTS_S1t__ defined(DDRS_DDRS1) && defined(PERS_PERS1)
      #define __CTS_S2t__ defined(DDRS_DDRS2) && defined(PERS_PERS2)
      #define __CTS_S3t__ defined(DDRS_DDRS3) && defined(PERS_PERS3)
      #define __CTS_S4t__ defined(DDRS_DDRS4) && defined(PERS_PERS4)
      #define __CTS_S5t__ defined(DDRS_DDRS5) && defined(PERS_PERS5)
      #define __CTS_S6t__ defined(DDRS_DDRS6) && defined(PERS_PERS6)
      #define __CTS_S7t__ defined(DDRS_DDRS7) && defined(PERS_PERS7)
  //T
      #define __CTS_T_p__ defined(PPST)
      #define __CTS_T0t__ defined(DDRT_DDRT0) && defined(PERT_PERT0)
      #define __CTS_T1t__ defined(DDRT_DDRT1) && defined(PERT_PERT1)
      #define __CTS_T2t__ defined(DDRT_DDRT2) && defined(PERT_PERT2)
      #define __CTS_T3t__ defined(DDRT_DDRT3) && defined(PERT_PERT3)
      #define __CTS_T4t__ defined(DDRT_DDRT4) && defined(PERT_PERT4)
      #define __CTS_T5t__ defined(DDRT_DDRT5) && defined(PERT_PERT5)
      #define __CTS_T6t__ defined(DDRT_DDRT6) && defined(PERT_PERT6)
      #define __CTS_T7t__ defined(DDRT_DDRT7) && defined(PERT_PERT7)
  //U
      #define __CTS_U_p__ defined(PPSU)
      #define __CTS_U0t__ defined(DDRU_DDRU0) && defined(PERU_PERU0)
      #define __CTS_U1t__ defined(DDRU_DDRU1) && defined(PERU_PERU1)
      #define __CTS_U2t__ defined(DDRU_DDRU2) && defined(PERU_PERU2)
      #define __CTS_U3t__ defined(DDRU_DDRU3) && defined(PERU_PERU3)
      #define __CTS_U4t__ defined(DDRU_DDRU4) && defined(PERU_PERU4)
      #define __CTS_U5t__ defined(DDRU_DDRU5) && defined(PERU_PERU5)
      #define __CTS_U6t__ defined(DDRU_DDRU6) && defined(PERU_PERU6)
      #define __CTS_U7t__ defined(DDRU_DDRU7) && defined(PERU_PERU7)
  //V
      #define __CTS_V_p__ defined(PPSV)
      #define __CTS_V0t__ defined(DDRV_DDRV0) && defined(PERV_PERV0)
      #define __CTS_V1t__ defined(DDRV_DDRV1) && defined(PERV_PERV1)
      #define __CTS_V2t__ defined(DDRV_DDRV2) && defined(PERV_PERV2)
      #define __CTS_V3t__ defined(DDRV_DDRV3) && defined(PERV_PERV3)
      #define __CTS_V4t__ defined(DDRV_DDRV4) && defined(PERV_PERV4)
      #define __CTS_V5t__ defined(DDRV_DDRV5) && defined(PERV_PERV5)
      #define __CTS_V6t__ defined(DDRV_DDRV6) && defined(PERV_PERV6)
      #define __CTS_V7t__ defined(DDRV_DDRV7) && defined(PERV_PERV7)
  //W
      #define __CTS_W_p__ defined(PPSW)
      #define __CTS_W0t__ defined(DDRW_DDRW0) && defined(PERW_PERW0)
      #define __CTS_W1t__ defined(DDRW_DDRW1) && defined(PERW_PERW1)
      #define __CTS_W2t__ defined(DDRW_DDRW2) && defined(PERW_PERW2)
      #define __CTS_W3t__ defined(DDRW_DDRW3) && defined(PERW_PERW3)
      #define __CTS_W4t__ defined(DDRW_DDRW4) && defined(PERW_PERW4)
      #define __CTS_W5t__ defined(DDRW_DDRW5) && defined(PERW_PERW5)
      #define __CTS_W6t__ defined(DDRW_DDRW6) && defined(PERW_PERW6)
      #define __CTS_W7t__ defined(DDRW_DDRW7) && defined(PERW_PERW7)

  #endif /*!C12*/

  #endif /*M12,XGT*/





  /*******************************************************************************
  ****    CTS platform - pull-up/-down 1x polarity && 8x test redefines
  *******************************************************************************/

  //_A
  #ifndef             __CTS_A_p__
      #define         __CTS_A_p__ 0
  #endif
  #ifndef             __CTS_A0t__
      #define         __CTS_A0t__ 0
  #endif
  #ifndef             __CTS_A1t__
      #define         __CTS_A1t__ 0
  #endif
  #ifndef             __CTS_A2t__
      #define         __CTS_A2t__ 0
  #endif
  #ifndef             __CTS_A3t__
      #define         __CTS_A3t__ 0
  #endif
  #ifndef             __CTS_A4t__
      #define         __CTS_A4t__ 0
  #endif
  #ifndef             __CTS_A5t__
      #define         __CTS_A5t__ 0
  #endif
  #ifndef             __CTS_A6t__
      #define         __CTS_A6t__ 0
  #endif
  #ifndef             __CTS_A7t__
      #define         __CTS_A7t__ 0
  #endif
  //_B
  #ifndef             __CTS_B_p__
      #define         __CTS_B_p__ 0
  #endif
  #ifndef             __CTS_B0t__
      #define         __CTS_B0t__ 0
  #endif
  #ifndef             __CTS_B1t__
      #define         __CTS_B1t__ 0
  #endif
  #ifndef             __CTS_B2t__
      #define         __CTS_B2t__ 0
  #endif
  #ifndef             __CTS_B3t__
      #define         __CTS_B3t__ 0
  #endif
  #ifndef             __CTS_B4t__
      #define         __CTS_B4t__ 0
  #endif
  #ifndef             __CTS_B5t__
      #define         __CTS_B5t__ 0
  #endif
  #ifndef             __CTS_B6t__
      #define         __CTS_B6t__ 0
  #endif
  #ifndef             __CTS_B7t__
      #define         __CTS_B7t__ 0
  #endif
  //_C
  #ifndef             __CTS_C_p__
      #define         __CTS_C_p__ 0
  #endif
  #ifndef             __CTS_C0t__
      #define         __CTS_C0t__ 0
  #endif
  #ifndef             __CTS_C1t__
      #define         __CTS_C1t__ 0
  #endif
  #ifndef             __CTS_C2t__
      #define         __CTS_C2t__ 0
  #endif
  #ifndef             __CTS_C3t__
      #define         __CTS_C3t__ 0
  #endif
  #ifndef             __CTS_C4t__
      #define         __CTS_C4t__ 0
  #endif
  #ifndef             __CTS_C5t__
      #define         __CTS_C5t__ 0
  #endif
  #ifndef             __CTS_C6t__
      #define         __CTS_C6t__ 0
  #endif
  #ifndef             __CTS_C7t__
      #define         __CTS_C7t__ 0
  #endif
  //_D
  #ifndef             __CTS_D_p__
      #define         __CTS_D_p__ 0
  #endif
  #ifndef             __CTS_D0t__
      #define         __CTS_D0t__ 0
  #endif
  #ifndef             __CTS_D1t__
      #define         __CTS_D1t__ 0
  #endif
  #ifndef             __CTS_D2t__
      #define         __CTS_D2t__ 0
  #endif
  #ifndef             __CTS_D3t__
      #define         __CTS_D3t__ 0
  #endif
  #ifndef             __CTS_D4t__
      #define         __CTS_D4t__ 0
  #endif
  #ifndef             __CTS_D5t__
      #define         __CTS_D5t__ 0
  #endif
  #ifndef             __CTS_D6t__
      #define         __CTS_D6t__ 0
  #endif
  #ifndef             __CTS_D7t__
      #define         __CTS_D7t__ 0
  #endif
  //_E
  #ifndef             __CTS_E_p__
      #define         __CTS_E_p__ 0
  #endif
  #ifndef             __CTS_E0t__
      #define         __CTS_E0t__ 0
  #endif
  #ifndef             __CTS_E1t__
      #define         __CTS_E1t__ 0
  #endif
  #ifndef             __CTS_E2t__
      #define         __CTS_E2t__ 0
  #endif
  #ifndef             __CTS_E3t__
      #define         __CTS_E3t__ 0
  #endif
  #ifndef             __CTS_E4t__
      #define         __CTS_E4t__ 0
  #endif
  #ifndef             __CTS_E5t__
      #define         __CTS_E5t__ 0
  #endif
  #ifndef             __CTS_E6t__
      #define         __CTS_E6t__ 0
  #endif
  #ifndef             __CTS_E7t__
      #define         __CTS_E7t__ 0
  #endif
  //_F
  #ifndef             __CTS_F_p__
      #define         __CTS_F_p__ 0
  #endif
  #ifndef             __CTS_F0t__
      #define         __CTS_F0t__ 0
  #endif
  #ifndef             __CTS_F1t__
      #define         __CTS_F1t__ 0
  #endif
  #ifndef             __CTS_F2t__
      #define         __CTS_F2t__ 0
  #endif
  #ifndef             __CTS_F3t__
      #define         __CTS_F3t__ 0
  #endif
  #ifndef             __CTS_F4t__
      #define         __CTS_F4t__ 0
  #endif
  #ifndef             __CTS_F5t__
      #define         __CTS_F5t__ 0
  #endif
  #ifndef             __CTS_F6t__
      #define         __CTS_F6t__ 0
  #endif
  #ifndef             __CTS_F7t__
      #define         __CTS_F7t__ 0
  #endif
  //_G
  #ifndef             __CTS_G_p__
      #define         __CTS_G_p__ 0
  #endif
  #ifndef             __CTS_G0t__
      #define         __CTS_G0t__ 0
  #endif
  #ifndef             __CTS_G1t__
      #define         __CTS_G1t__ 0
  #endif
  #ifndef             __CTS_G2t__
      #define         __CTS_G2t__ 0
  #endif
  #ifndef             __CTS_G3t__
      #define         __CTS_G3t__ 0
  #endif
  #ifndef             __CTS_G4t__
      #define         __CTS_G4t__ 0
  #endif
  #ifndef             __CTS_G5t__
      #define         __CTS_G5t__ 0
  #endif
  #ifndef             __CTS_G6t__
      #define         __CTS_G6t__ 0
  #endif
  #ifndef             __CTS_G7t__
      #define         __CTS_G7t__ 0
  #endif
  //_H
  #ifndef             __CTS_H_p__
      #define         __CTS_H_p__ 0
  #endif
  #ifndef             __CTS_H0t__
      #define         __CTS_H0t__ 0
  #endif
  #ifndef             __CTS_H1t__
      #define         __CTS_H1t__ 0
  #endif
  #ifndef             __CTS_H2t__
      #define         __CTS_H2t__ 0
  #endif
  #ifndef             __CTS_H3t__
      #define         __CTS_H3t__ 0
  #endif
  #ifndef             __CTS_H4t__
      #define         __CTS_H4t__ 0
  #endif
  #ifndef             __CTS_H5t__
      #define         __CTS_H5t__ 0
  #endif
  #ifndef             __CTS_H6t__
      #define         __CTS_H6t__ 0
  #endif
  #ifndef             __CTS_H7t__
      #define         __CTS_H7t__ 0
  #endif
  //_I
  #ifndef             __CTS_I_p__
      #define         __CTS_I_p__ 0
  #endif
  #ifndef             __CTS_I0t__
      #define         __CTS_I0t__ 0
  #endif
  #ifndef             __CTS_I1t__
      #define         __CTS_I1t__ 0
  #endif
  #ifndef             __CTS_I2t__
      #define         __CTS_I2t__ 0
  #endif
  #ifndef             __CTS_I3t__
      #define         __CTS_I3t__ 0
  #endif
  #ifndef             __CTS_I4t__
      #define         __CTS_I4t__ 0
  #endif
  #ifndef             __CTS_I5t__
      #define         __CTS_I5t__ 0
  #endif
  #ifndef             __CTS_I6t__
      #define         __CTS_I6t__ 0
  #endif
  #ifndef             __CTS_I7t__
      #define         __CTS_I7t__ 0
  #endif
  //_J
  #ifndef             __CTS_J_p__
      #define         __CTS_J_p__ 0
  #endif
  #ifndef             __CTS_J0t__
      #define         __CTS_J0t__ 0
  #endif
  #ifndef             __CTS_J1t__
      #define         __CTS_J1t__ 0
  #endif
  #ifndef             __CTS_J2t__
      #define         __CTS_J2t__ 0
  #endif
  #ifndef             __CTS_J3t__
      #define         __CTS_J3t__ 0
  #endif
  #ifndef             __CTS_J4t__
      #define         __CTS_J4t__ 0
  #endif
  #ifndef             __CTS_J5t__
      #define         __CTS_J5t__ 0
  #endif
  #ifndef             __CTS_J6t__
      #define         __CTS_J6t__ 0
  #endif
  #ifndef             __CTS_J7t__
      #define         __CTS_J7t__ 0
  #endif
  //_K
  #ifndef             __CTS_K_p__
      #define         __CTS_K_p__ 0
  #endif
  #ifndef             __CTS_K0t__
      #define         __CTS_K0t__ 0
  #endif
  #ifndef             __CTS_K1t__
      #define         __CTS_K1t__ 0
  #endif
  #ifndef             __CTS_K2t__
      #define         __CTS_K2t__ 0
  #endif
  #ifndef             __CTS_K3t__
      #define         __CTS_K3t__ 0
  #endif
  #ifndef             __CTS_K4t__
      #define         __CTS_K4t__ 0
  #endif
  #ifndef             __CTS_K5t__
      #define         __CTS_K5t__ 0
  #endif
  #ifndef             __CTS_K6t__
      #define         __CTS_K6t__ 0
  #endif
  #ifndef             __CTS_K7t__
      #define         __CTS_K7t__ 0
  #endif
  //_L
  #ifndef             __CTS_L_p__
      #define         __CTS_L_p__ 0
  #endif
  #ifndef             __CTS_L0t__
      #define         __CTS_L0t__ 0
  #endif
  #ifndef             __CTS_L1t__
      #define         __CTS_L1t__ 0
  #endif
  #ifndef             __CTS_L2t__
      #define         __CTS_L2t__ 0
  #endif
  #ifndef             __CTS_L3t__
      #define         __CTS_L3t__ 0
  #endif
  #ifndef             __CTS_L4t__
      #define         __CTS_L4t__ 0
  #endif
  #ifndef             __CTS_L5t__
      #define         __CTS_L5t__ 0
  #endif
  #ifndef             __CTS_L6t__
      #define         __CTS_L6t__ 0
  #endif
  #ifndef             __CTS_L7t__
      #define         __CTS_L7t__ 0
  #endif
  //_M
  #ifndef             __CTS_M_p__
      #define         __CTS_M_p__ 0
  #endif
  #ifndef             __CTS_M0t__
      #define         __CTS_M0t__ 0
  #endif
  #ifndef             __CTS_M1t__
      #define         __CTS_M1t__ 0
  #endif
  #ifndef             __CTS_M2t__
      #define         __CTS_M2t__ 0
  #endif
  #ifndef             __CTS_M3t__
      #define         __CTS_M3t__ 0
  #endif
  #ifndef             __CTS_M4t__
      #define         __CTS_M4t__ 0
  #endif
  #ifndef             __CTS_M5t__
      #define         __CTS_M5t__ 0
  #endif
  #ifndef             __CTS_M6t__
      #define         __CTS_M6t__ 0
  #endif
  #ifndef             __CTS_M7t__
      #define         __CTS_M7t__ 0
  #endif
  //_N
  #ifndef             __CTS_N_p__
      #define         __CTS_N_p__ 0
  #endif
  #ifndef             __CTS_N0t__
      #define         __CTS_N0t__ 0
  #endif
  #ifndef             __CTS_N1t__
      #define         __CTS_N1t__ 0
  #endif
  #ifndef             __CTS_N2t__
      #define         __CTS_N2t__ 0
  #endif
  #ifndef             __CTS_N3t__
      #define         __CTS_N3t__ 0
  #endif
  #ifndef             __CTS_N4t__
      #define         __CTS_N4t__ 0
  #endif
  #ifndef             __CTS_N5t__
      #define         __CTS_N5t__ 0
  #endif
  #ifndef             __CTS_N6t__
      #define         __CTS_N6t__ 0
  #endif
  #ifndef             __CTS_N7t__
      #define         __CTS_N7t__ 0
  #endif
  //_P
  #ifndef             __CTS_P_p__
      #define         __CTS_P_p__ 0
  #endif
  #ifndef             __CTS_P0t__
      #define         __CTS_P0t__ 0
  #endif
  #ifndef             __CTS_P1t__
      #define         __CTS_P1t__ 0
  #endif
  #ifndef             __CTS_P2t__
      #define         __CTS_P2t__ 0
  #endif
  #ifndef             __CTS_P3t__
      #define         __CTS_P3t__ 0
  #endif
  #ifndef             __CTS_P4t__
      #define         __CTS_P4t__ 0
  #endif
  #ifndef             __CTS_P5t__
      #define         __CTS_P5t__ 0
  #endif
  #ifndef             __CTS_P6t__
      #define         __CTS_P6t__ 0
  #endif
  #ifndef             __CTS_P7t__
      #define         __CTS_P7t__ 0
  #endif
  //_Q
  #ifndef             __CTS_Q_p__
      #define         __CTS_Q_p__ 0
  #endif
  #ifndef             __CTS_Q0t__
      #define         __CTS_Q0t__ 0
  #endif
  #ifndef             __CTS_Q1t__
      #define         __CTS_Q1t__ 0
  #endif
  #ifndef             __CTS_Q2t__
      #define         __CTS_Q2t__ 0
  #endif
  #ifndef             __CTS_Q3t__
      #define         __CTS_Q3t__ 0
  #endif
  #ifndef             __CTS_Q4t__
      #define         __CTS_Q4t__ 0
  #endif
  #ifndef             __CTS_Q5t__
      #define         __CTS_Q5t__ 0
  #endif
  #ifndef             __CTS_Q6t__
      #define         __CTS_Q6t__ 0
  #endif
  #ifndef             __CTS_Q7t__
      #define         __CTS_Q7t__ 0
  #endif
  //_R
  #ifndef             __CTS_R_p__
      #define         __CTS_R_p__ 0
  #endif
  #ifndef             __CTS_R0t__
      #define         __CTS_R0t__ 0
  #endif
  #ifndef             __CTS_R1t__
      #define         __CTS_R1t__ 0
  #endif
  #ifndef             __CTS_R2t__
      #define         __CTS_R2t__ 0
  #endif
  #ifndef             __CTS_R3t__
      #define         __CTS_R3t__ 0
  #endif
  #ifndef             __CTS_R4t__
      #define         __CTS_R4t__ 0
  #endif
  #ifndef             __CTS_R5t__
      #define         __CTS_R5t__ 0
  #endif
  #ifndef             __CTS_R6t__
      #define         __CTS_R6t__ 0
  #endif
  #ifndef             __CTS_R7t__
      #define         __CTS_R7t__ 0
  #endif
  //_S
  #ifndef             __CTS_S_p__
      #define         __CTS_S_p__ 0
  #endif
  #ifndef             __CTS_S0t__
      #define         __CTS_S0t__ 0
  #endif
  #ifndef             __CTS_S1t__
      #define         __CTS_S1t__ 0
  #endif
  #ifndef             __CTS_S2t__
      #define         __CTS_S2t__ 0
  #endif
  #ifndef             __CTS_S3t__
      #define         __CTS_S3t__ 0
  #endif
  #ifndef             __CTS_S4t__
      #define         __CTS_S4t__ 0
  #endif
  #ifndef             __CTS_S5t__
      #define         __CTS_S5t__ 0
  #endif
  #ifndef             __CTS_S6t__
      #define         __CTS_S6t__ 0
  #endif
  #ifndef             __CTS_S7t__
      #define         __CTS_S7t__ 0
  #endif
  //_T
  #ifndef             __CTS_T_p__
      #define         __CTS_T_p__ 0
  #endif
  #ifndef             __CTS_T0t__
      #define         __CTS_T0t__ 0
  #endif
  #ifndef             __CTS_T1t__
      #define         __CTS_T1t__ 0
  #endif
  #ifndef             __CTS_T2t__
      #define         __CTS_T2t__ 0
  #endif
  #ifndef             __CTS_T3t__
      #define         __CTS_T3t__ 0
  #endif
  #ifndef             __CTS_T4t__
      #define         __CTS_T4t__ 0
  #endif
  #ifndef             __CTS_T5t__
      #define         __CTS_T5t__ 0
  #endif
  #ifndef             __CTS_T6t__
      #define         __CTS_T6t__ 0
  #endif
  #ifndef             __CTS_T7t__
      #define         __CTS_T7t__ 0
  #endif
  //_U
  #ifndef             __CTS_U_p__
      #define         __CTS_U_p__ 0
  #endif
  #ifndef             __CTS_U0t__
      #define         __CTS_U0t__ 0
  #endif
  #ifndef             __CTS_U1t__
      #define         __CTS_U1t__ 0
  #endif
  #ifndef             __CTS_U2t__
      #define         __CTS_U2t__ 0
  #endif
  #ifndef             __CTS_U3t__
      #define         __CTS_U3t__ 0
  #endif
  #ifndef             __CTS_U4t__
      #define         __CTS_U4t__ 0
  #endif
  #ifndef             __CTS_U5t__
      #define         __CTS_U5t__ 0
  #endif
  #ifndef             __CTS_U6t__
      #define         __CTS_U6t__ 0
  #endif
  #ifndef             __CTS_U7t__
      #define         __CTS_U7t__ 0
  #endif
  //_V
  #ifndef             __CTS_V_p__
      #define         __CTS_V_p__ 0
  #endif
  #ifndef             __CTS_V0t__
      #define         __CTS_V0t__ 0
  #endif
  #ifndef             __CTS_V1t__
      #define         __CTS_V1t__ 0
  #endif
  #ifndef             __CTS_V2t__
      #define         __CTS_V2t__ 0
  #endif
  #ifndef             __CTS_V3t__
      #define         __CTS_V3t__ 0
  #endif
  #ifndef             __CTS_V4t__
      #define         __CTS_V4t__ 0
  #endif
  #ifndef             __CTS_V5t__
      #define         __CTS_V5t__ 0
  #endif
  #ifndef             __CTS_V6t__
      #define         __CTS_V6t__ 0
  #endif
  #ifndef             __CTS_V7t__
      #define         __CTS_V7t__ 0
  #endif
  //_W
  #ifndef             __CTS_W_p__
      #define         __CTS_W_p__ 0
  #endif
  #ifndef             __CTS_W0t__
      #define         __CTS_W0t__ 0
  #endif
  #ifndef             __CTS_W1t__
      #define         __CTS_W1t__ 0
  #endif
  #ifndef             __CTS_W2t__
      #define         __CTS_W2t__ 0
  #endif
  #ifndef             __CTS_W3t__
      #define         __CTS_W3t__ 0
  #endif
  #ifndef             __CTS_W4t__
      #define         __CTS_W4t__ 0
  #endif
  #ifndef             __CTS_W5t__
      #define         __CTS_W5t__ 0
  #endif
  #ifndef             __CTS_W6t__
      #define         __CTS_W6t__ 0
  #endif
  #ifndef             __CTS_W7t__
      #define         __CTS_W7t__ 0
  #endif





  /*******************************************************************************
  ****    CTS platform - BLUE detection
  *******************************************************************************/
  //_A
  #if                 __CTS_A0t__
      #define         __CTS_A0H__
      #if             __CTS_A_p__
          #define     __CTS_A0L__
      #endif
  #endif
  #if                 __CTS_A1t__
      #define         __CTS_A1H__
      #if             __CTS_A_p__
          #define     __CTS_A1L__
      #endif
  #endif
  #if                 __CTS_A2t__
      #define         __CTS_A2H__
      #if             __CTS_A_p__
          #define     __CTS_A2L__
      #endif
  #endif
  #if                 __CTS_A3t__
      #define         __CTS_A3H__
      #if             __CTS_A_p__
          #define     __CTS_A3L__
      #endif
  #endif
  #if                 __CTS_A4t__
      #define         __CTS_A4H__
      #if             __CTS_A_p__
          #define     __CTS_A4L__
      #endif
  #endif
  #if                 __CTS_A5t__
      #define         __CTS_A5H__
      #if             __CTS_A_p__
          #define     __CTS_A5L__
      #endif
  #endif
  #if                 __CTS_A6t__
      #define         __CTS_A6H__
      #if             __CTS_A_p__
          #define     __CTS_A6L__
      #endif
  #endif
  #if                 __CTS_A7t__
      #define         __CTS_A7H__
      #if             __CTS_A_p__
          #define     __CTS_A7L__
      #endif
  #endif


  //_B
  #if                 __CTS_B0t__
      #define         __CTS_B0H__
      #if             __CTS_B_p__
          #define     __CTS_B0L__
      #endif
  #endif
  #if                 __CTS_B1t__
      #define         __CTS_B1H__
      #if             __CTS_B_p__
          #define     __CTS_B1L__
      #endif
  #endif
  #if                 __CTS_B2t__
      #define         __CTS_B2H__
      #if             __CTS_B_p__
          #define     __CTS_B2L__
      #endif
  #endif
  #if                 __CTS_B3t__
      #define         __CTS_B3H__
      #if             __CTS_B_p__
          #define     __CTS_B3L__
      #endif
  #endif
  #if                 __CTS_B4t__
      #define         __CTS_B4H__
      #if             __CTS_B_p__
          #define     __CTS_B4L__
      #endif
  #endif
  #if                 __CTS_B5t__
      #define         __CTS_B5H__
      #if             __CTS_B_p__
          #define     __CTS_B5L__
      #endif
  #endif
  #if                 __CTS_B6t__
      #define         __CTS_B6H__
      #if             __CTS_B_p__
          #define     __CTS_B6L__
      #endif
  #endif
  #if                 __CTS_B7t__
      #define         __CTS_B7H__
      #if             __CTS_B_p__
          #define     __CTS_B7L__
      #endif
  #endif


  //_C
  #if                 __CTS_C0t__
      #define         __CTS_C0H__
      #if             __CTS_C_p__
          #define     __CTS_C0L__
      #endif
  #endif
  #if                 __CTS_C1t__
      #define         __CTS_C1H__
      #if             __CTS_C_p__
          #define     __CTS_C1L__
      #endif
  #endif
  #if                 __CTS_C2t__
      #define         __CTS_C2H__
      #if             __CTS_C_p__
          #define     __CTS_C2L__
      #endif
  #endif
  #if                 __CTS_C3t__
      #define         __CTS_C3H__
      #if             __CTS_C_p__
          #define     __CTS_C3L__
      #endif
  #endif
  #if                 __CTS_C4t__
      #define         __CTS_C4H__
      #if             __CTS_C_p__
          #define     __CTS_C4L__
      #endif
  #endif
  #if                 __CTS_C5t__
      #define         __CTS_C5H__
      #if             __CTS_C_p__
          #define     __CTS_C5L__
      #endif
  #endif
  #if                 __CTS_C6t__
      #define         __CTS_C6H__
      #if             __CTS_C_p__
          #define     __CTS_C6L__
      #endif
  #endif
  #if                 __CTS_C7t__
      #define         __CTS_C7H__
      #if             __CTS_C_p__
          #define     __CTS_C7L__
      #endif
  #endif


  //_D
  #if                 __CTS_D0t__
      #define         __CTS_D0H__
      #if             __CTS_D_p__
          #define     __CTS_D0L__
      #endif
  #endif
  #if                 __CTS_D1t__
      #define         __CTS_D1H__
      #if             __CTS_D_p__
          #define     __CTS_D1L__
      #endif
  #endif
  #if                 __CTS_D2t__
      #define         __CTS_D2H__
      #if             __CTS_D_p__
          #define     __CTS_D2L__
      #endif
  #endif
  #if                 __CTS_D3t__
      #define         __CTS_D3H__
      #if             __CTS_D_p__
          #define     __CTS_D3L__
      #endif
  #endif
  #if                 __CTS_D4t__
      #define         __CTS_D4H__
      #if             __CTS_D_p__
          #define     __CTS_D4L__
      #endif
  #endif
  #if                 __CTS_D5t__
      #define         __CTS_D5H__
      #if             __CTS_D_p__
          #define     __CTS_D5L__
      #endif
  #endif
  #if                 __CTS_D6t__
      #define         __CTS_D6H__
      #if             __CTS_D_p__
          #define     __CTS_D6L__
      #endif
  #endif
  #if                 __CTS_D7t__
      #define         __CTS_D7H__
      #if             __CTS_D_p__
          #define     __CTS_D7L__
      #endif
  #endif


  //_E
  #if                 __CTS_E0t__
      #define         __CTS_E0H__
      #if             __CTS_E_p__
          #define     __CTS_E0L__
      #endif
  #endif
  #if                 __CTS_E1t__
      #define         __CTS_E1H__
      #if             __CTS_E_p__
          #define     __CTS_E1L__
      #endif
  #endif
  #if                 __CTS_E2t__
      #define         __CTS_E2H__
      #if             __CTS_E_p__
          #define     __CTS_E2L__
      #endif
  #endif
  #if                 __CTS_E3t__
      #define         __CTS_E3H__
      #if             __CTS_E_p__
          #define     __CTS_E3L__
      #endif
  #endif
  #if                 __CTS_E4t__
      #define         __CTS_E4H__
      #if             __CTS_E_p__
          #define     __CTS_E4L__
      #endif
  #endif
  #if                 __CTS_E5t__
      #define         __CTS_E5H__
      #if             __CTS_E_p__
          #define     __CTS_E5L__
      #endif
  #endif
  #if                 __CTS_E6t__
      #define         __CTS_E6H__
      #if             __CTS_E_p__
          #define     __CTS_E6L__
      #endif
  #endif
  #if                 __CTS_E7t__
      #define         __CTS_E7H__
      #if             __CTS_E_p__
          #define     __CTS_E7L__
      #endif
  #endif


  //_F
  #if                 __CTS_F0t__
      #define         __CTS_F0H__
      #if             __CTS_F_p__
          #define     __CTS_F0L__
      #endif
  #endif
  #if                 __CTS_F1t__
      #define         __CTS_F1H__
      #if             __CTS_F_p__
          #define     __CTS_F1L__
      #endif
  #endif
  #if                 __CTS_F2t__
      #define         __CTS_F2H__
      #if             __CTS_F_p__
          #define     __CTS_F2L__
      #endif
  #endif
  #if                 __CTS_F3t__
      #define         __CTS_F3H__
      #if             __CTS_F_p__
          #define     __CTS_F3L__
      #endif
  #endif
  #if                 __CTS_F4t__
      #define         __CTS_F4H__
      #if             __CTS_F_p__
          #define     __CTS_F4L__
      #endif
  #endif
  #if                 __CTS_F5t__
      #define         __CTS_F5H__
      #if             __CTS_F_p__
          #define     __CTS_F5L__
      #endif
  #endif
  #if                 __CTS_F6t__
      #define         __CTS_F6H__
      #if             __CTS_F_p__
          #define     __CTS_F6L__
      #endif
  #endif
  #if                 __CTS_F7t__
      #define         __CTS_F7H__
      #if             __CTS_F_p__
          #define     __CTS_F7L__
      #endif
  #endif


  //_G
  #if                 __CTS_G0t__
      #define         __CTS_G0H__
      #if             __CTS_G_p__
          #define     __CTS_G0L__
      #endif
  #endif
  #if                 __CTS_G1t__
      #define         __CTS_G1H__
      #if             __CTS_G_p__
          #define     __CTS_G1L__
      #endif
  #endif
  #if                 __CTS_G2t__
      #define         __CTS_G2H__
      #if             __CTS_G_p__
          #define     __CTS_G2L__
      #endif
  #endif
  #if                 __CTS_G3t__
      #define         __CTS_G3H__
      #if             __CTS_G_p__
          #define     __CTS_G3L__
      #endif
  #endif
  #if                 __CTS_G4t__
      #define         __CTS_G4H__
      #if             __CTS_G_p__
          #define     __CTS_G4L__
      #endif
  #endif
  #if                 __CTS_G5t__
      #define         __CTS_G5H__
      #if             __CTS_G_p__
          #define     __CTS_G5L__
      #endif
  #endif
  #if                 __CTS_G6t__
      #define         __CTS_G6H__
      #if             __CTS_G_p__
          #define     __CTS_G6L__
      #endif
  #endif
  #if                 __CTS_G7t__
      #define         __CTS_G7H__
      #if             __CTS_G_p__
          #define     __CTS_G7L__
      #endif
  #endif


  //_H
  #if                 __CTS_H0t__
      #define         __CTS_H0H__
      #if             __CTS_H_p__
          #define     __CTS_H0L__
      #endif
  #endif
  #if                 __CTS_H1t__
      #define         __CTS_H1H__
      #if             __CTS_H_p__
          #define     __CTS_H1L__
      #endif
  #endif
  #if                 __CTS_H2t__
      #define         __CTS_H2H__
      #if             __CTS_H_p__
          #define     __CTS_H2L__
      #endif
  #endif
  #if                 __CTS_H3t__
      #define         __CTS_H3H__
      #if             __CTS_H_p__
          #define     __CTS_H3L__
      #endif
  #endif
  #if                 __CTS_H4t__
      #define         __CTS_H4H__
      #if             __CTS_H_p__
          #define     __CTS_H4L__
      #endif
  #endif
  #if                 __CTS_H5t__
      #define         __CTS_H5H__
      #if             __CTS_H_p__
          #define     __CTS_H5L__
      #endif
  #endif
  #if                 __CTS_H6t__
      #define         __CTS_H6H__
      #if             __CTS_H_p__
          #define     __CTS_H6L__
      #endif
  #endif
  #if                 __CTS_H7t__
      #define         __CTS_H7H__
      #if             __CTS_H_p__
          #define     __CTS_H7L__
      #endif
  #endif

  //_I
  #if                 __CTS_I0t__
      #define         __CTS_I0H__
      #if             __CTS_I_p__
          #define     __CTS_I0L__
      #endif
  #endif
  #if                 __CTS_I1t__
      #define         __CTS_I1H__
      #if             __CTS_I_p__
          #define     __CTS_I1L__
      #endif
  #endif
  #if                 __CTS_I2t__
      #define         __CTS_I2H__
      #if             __CTS_I_p__
          #define     __CTS_I2L__
      #endif
  #endif
  #if                 __CTS_I3t__
      #define         __CTS_I3H__
      #if             __CTS_I_p__
          #define     __CTS_I3L__
      #endif
  #endif
  #if                 __CTS_I4t__
      #define         __CTS_I4H__
      #if             __CTS_I_p__
          #define     __CTS_I4L__
      #endif
  #endif
  #if                 __CTS_I5t__
      #define         __CTS_I5H__
      #if             __CTS_I_p__
          #define     __CTS_I5L__
      #endif
  #endif
  #if                 __CTS_I6t__
      #define         __CTS_I6H__
      #if             __CTS_I_p__
          #define     __CTS_I6L__
      #endif
  #endif
  #if                 __CTS_I7t__
      #define         __CTS_I7H__
      #if             __CTS_I_p__
          #define     __CTS_I7L__
      #endif
  #endif
  
  //_J
  #if                 __CTS_J0t__
      #define         __CTS_J0H__
      #if             __CTS_J_p__
          #define     __CTS_J0L__
      #endif
  #endif
  #if                 __CTS_J1t__
      #define         __CTS_J1H__
      #if             __CTS_J_p__
          #define     __CTS_J1L__
      #endif
  #endif
  #if                 __CTS_J2t__
      #define         __CTS_J2H__
      #if             __CTS_J_p__
          #define     __CTS_J2L__
      #endif
  #endif
  #if                 __CTS_J3t__
      #define         __CTS_J3H__
      #if             __CTS_J_p__
          #define     __CTS_J3L__
      #endif
  #endif
  #if                 __CTS_J4t__
      #define         __CTS_J4H__
      #if             __CTS_J_p__
          #define     __CTS_J4L__
      #endif
  #endif
  #if                 __CTS_J5t__
      #define         __CTS_J5H__
      #if             __CTS_J_p__
          #define     __CTS_J5L__
      #endif
  #endif
  #if                 __CTS_J6t__
      #define         __CTS_J6H__
      #if             __CTS_J_p__
          #define     __CTS_J6L__
      #endif
  #endif
  #if                 __CTS_J7t__
      #define         __CTS_J7H__
      #if             __CTS_J_p__
          #define     __CTS_J7L__
      #endif
  #endif


  //_K
  #if                 __CTS_K0t__
      #define         __CTS_K0H__
      #if             __CTS_K_p__
          #define     __CTS_K0L__
      #endif
  #endif
  #if                 __CTS_K1t__
      #define         __CTS_K1H__
      #if             __CTS_K_p__
          #define     __CTS_K1L__
      #endif
  #endif
  #if                 __CTS_K2t__
      #define         __CTS_K2H__
      #if             __CTS_K_p__
          #define     __CTS_K2L__
      #endif
  #endif
  #if                 __CTS_K3t__
      #define         __CTS_K3H__
      #if             __CTS_K_p__
          #define     __CTS_K3L__
      #endif
  #endif
  #if                 __CTS_K4t__
      #define         __CTS_K4H__
      #if             __CTS_K_p__
          #define     __CTS_K4L__
      #endif
  #endif
  #if                 __CTS_K5t__
      #define         __CTS_K5H__
      #if             __CTS_K_p__
          #define     __CTS_K5L__
      #endif
  #endif
  #if                 __CTS_K6t__
      #define         __CTS_K6H__
      #if             __CTS_K_p__
          #define     __CTS_K6L__
      #endif
  #endif
  #if                 __CTS_K7t__
      #define         __CTS_K7H__
      #if             __CTS_K_p__
          #define     __CTS_K7L__
      #endif
  #endif


  //_L
  #if                 __CTS_L0t__
      #define         __CTS_L0H__
      #if             __CTS_L_p__
          #define     __CTS_L0L__
      #endif
  #endif
  #if                 __CTS_L1t__
      #define         __CTS_L1H__
      #if             __CTS_L_p__
          #define     __CTS_L1L__
      #endif
  #endif
  #if                 __CTS_L2t__
      #define         __CTS_L2H__
      #if             __CTS_L_p__
          #define     __CTS_L2L__
      #endif
  #endif
  #if                 __CTS_L3t__
      #define         __CTS_L3H__
      #if             __CTS_L_p__
          #define     __CTS_L3L__
      #endif
  #endif
  #if                 __CTS_L4t__
      #define         __CTS_L4H__
      #if             __CTS_L_p__
          #define     __CTS_L4L__
      #endif
  #endif
  #if                 __CTS_L5t__
      #define         __CTS_L5H__
      #if             __CTS_L_p__
          #define     __CTS_L5L__
      #endif
  #endif
  #if                 __CTS_L6t__
      #define         __CTS_L6H__
      #if             __CTS_L_p__
          #define     __CTS_L6L__
      #endif
  #endif
  #if                 __CTS_L7t__
      #define         __CTS_L7H__
      #if             __CTS_L_p__
          #define     __CTS_L7L__
      #endif
  #endif


  //_M
  #if                 __CTS_M0t__
      #define         __CTS_M0H__
      #if             __CTS_M_p__
          #define     __CTS_M0L__
      #endif
  #endif
  #if                 __CTS_M1t__
      #define         __CTS_M1H__
      #if             __CTS_M_p__
          #define     __CTS_M1L__
      #endif
  #endif
  #if                 __CTS_M2t__
      #define         __CTS_M2H__
      #if             __CTS_M_p__
          #define     __CTS_M2L__
      #endif
  #endif
  #if                 __CTS_M3t__
      #define         __CTS_M3H__
      #if             __CTS_M_p__
          #define     __CTS_M3L__
      #endif
  #endif
  #if                 __CTS_M4t__
      #define         __CTS_M4H__
      #if             __CTS_M_p__
          #define     __CTS_M4L__
      #endif
  #endif
  #if                 __CTS_M5t__
      #define         __CTS_M5H__
      #if             __CTS_M_p__
          #define     __CTS_M5L__
      #endif
  #endif
  #if                 __CTS_M6t__
      #define         __CTS_M6H__
      #if             __CTS_M_p__
          #define     __CTS_M6L__
      #endif
  #endif
  #if                 __CTS_M7t__
      #define         __CTS_M7H__
      #if             __CTS_M_p__
          #define     __CTS_M7L__
      #endif
  #endif


  //_N
  #if                 __CTS_N0t__
      #define         __CTS_N0H__
      #if             __CTS_N_p__
          #define     __CTS_N0L__
      #endif
  #endif
  #if                 __CTS_N1t__
      #define         __CTS_N1H__
      #if             __CTS_N_p__
          #define     __CTS_N1L__
      #endif
  #endif
  #if                 __CTS_N2t__
      #define         __CTS_N2H__
      #if             __CTS_N_p__
          #define     __CTS_N2L__
      #endif
  #endif
  #if                 __CTS_N3t__
      #define         __CTS_N3H__
      #if             __CTS_N_p__
          #define     __CTS_N3L__
      #endif
  #endif
  #if                 __CTS_N4t__
      #define         __CTS_N4H__
      #if             __CTS_N_p__
          #define     __CTS_N4L__
      #endif
  #endif
  #if                 __CTS_N5t__
      #define         __CTS_N5H__
      #if             __CTS_N_p__
          #define     __CTS_N5L__
      #endif
  #endif
  #if                 __CTS_N6t__
      #define         __CTS_N6H__
      #if             __CTS_N_p__
          #define     __CTS_N6L__
      #endif
  #endif
  #if                 __CTS_N7t__
      #define         __CTS_N7H__
      #if             __CTS_N_p__
          #define     __CTS_N7L__
      #endif
  #endif


  //_O
  //_P
  #if                 __CTS_P0t__
      #define         __CTS_P0H__
      #if             __CTS_P_p__
          #define     __CTS_P0L__
      #endif
  #endif
  #if                 __CTS_P1t__
      #define         __CTS_P1H__
      #if             __CTS_P_p__
          #define     __CTS_P1L__
      #endif
  #endif
  #if                 __CTS_P2t__
      #define         __CTS_P2H__
      #if             __CTS_P_p__
          #define     __CTS_P2L__
      #endif
  #endif
  #if                 __CTS_P3t__
      #define         __CTS_P3H__
      #if             __CTS_P_p__
          #define     __CTS_P3L__
      #endif
  #endif
  #if                 __CTS_P4t__
      #define         __CTS_P4H__
      #if             __CTS_P_p__
          #define     __CTS_P4L__
      #endif
  #endif
  #if                 __CTS_P5t__
      #define         __CTS_P5H__
      #if             __CTS_P_p__
          #define     __CTS_P5L__
      #endif
  #endif
  #if                 __CTS_P6t__
      #define         __CTS_P6H__
      #if             __CTS_P_p__
          #define     __CTS_P6L__
      #endif
  #endif
  #if                 __CTS_P7t__
      #define         __CTS_P7H__
      #if             __CTS_P_p__
          #define     __CTS_P7L__
      #endif
  #endif


  //_Q
  #if                 __CTS_Q0t__
      #define         __CTS_Q0H__
      #if             __CTS_Q_p__
          #define     __CTS_Q0L__
      #endif
  #endif
  #if                 __CTS_Q1t__
      #define         __CTS_Q1H__
      #if             __CTS_Q_p__
          #define     __CTS_Q1L__
      #endif
  #endif
  #if                 __CTS_Q2t__
      #define         __CTS_Q2H__
      #if             __CTS_Q_p__
          #define     __CTS_Q2L__
      #endif
  #endif
  #if                 __CTS_Q3t__
      #define         __CTS_Q3H__
      #if             __CTS_Q_p__
          #define     __CTS_Q3L__
      #endif
  #endif
  #if                 __CTS_Q4t__
      #define         __CTS_Q4H__
      #if             __CTS_Q_p__
          #define     __CTS_Q4L__
      #endif
  #endif
  #if                 __CTS_Q5t__
      #define         __CTS_Q5H__
      #if             __CTS_Q_p__
          #define     __CTS_Q5L__
      #endif
  #endif
  #if                 __CTS_Q6t__
      #define         __CTS_Q6H__
      #if             __CTS_Q_p__
          #define     __CTS_Q6L__
      #endif
  #endif
  #if                 __CTS_Q7t__
      #define         __CTS_Q7H__
      #if             __CTS_Q_p__
          #define     __CTS_Q7L__
      #endif
  #endif


  //_R
  #if                 __CTS_R0t__
      #define         __CTS_R0H__
      #if             __CTS_R_p__
          #define     __CTS_R0L__
      #endif
  #endif
  #if                 __CTS_R1t__
      #define         __CTS_R1H__
      #if             __CTS_R_p__
          #define     __CTS_R1L__
      #endif
  #endif
  #if                 __CTS_R2t__
      #define         __CTS_R2H__
      #if             __CTS_R_p__
          #define     __CTS_R2L__
      #endif
  #endif
  #if                 __CTS_R3t__
      #define         __CTS_R3H__
      #if             __CTS_R_p__
          #define     __CTS_R3L__
      #endif
  #endif
  #if                 __CTS_R4t__
      #define         __CTS_R4H__
      #if             __CTS_R_p__
          #define     __CTS_R4L__
      #endif
  #endif
  #if                 __CTS_R5t__
      #define         __CTS_R5H__
      #if             __CTS_R_p__
          #define     __CTS_R5L__
      #endif
  #endif
  #if                 __CTS_R6t__
      #define         __CTS_R6H__
      #if             __CTS_R_p__
          #define     __CTS_R6L__
      #endif
  #endif
  #if                 __CTS_R7t__
      #define         __CTS_R7H__
      #if             __CTS_R_p__
          #define     __CTS_R7L__
      #endif
  #endif


  //_S
  #if                 __CTS_S0t__
      #define         __CTS_S0H__
      #if             __CTS_S_p__
          #define     __CTS_S0L__
      #endif
  #endif
  #if                 __CTS_S1t__
      #define         __CTS_S1H__
      #if             __CTS_S_p__
          #define     __CTS_S1L__
      #endif
  #endif
  #if                 __CTS_S2t__
      #define         __CTS_S2H__
      #if             __CTS_S_p__
          #define     __CTS_S2L__
      #endif
  #endif
  #if                 __CTS_S3t__
      #define         __CTS_S3H__
      #if             __CTS_S_p__
          #define     __CTS_S3L__
      #endif
  #endif
  #if                 __CTS_S4t__
      #define         __CTS_S4H__
      #if             __CTS_S_p__
          #define     __CTS_S4L__
      #endif
  #endif
  #if                 __CTS_S5t__
      #define         __CTS_S5H__
      #if             __CTS_S_p__
          #define     __CTS_S5L__
      #endif
  #endif
  #if                 __CTS_S6t__
      #define         __CTS_S6H__
      #if             __CTS_S_p__
          #define     __CTS_S6L__
      #endif
  #endif
  #if                 __CTS_S7t__
      #define         __CTS_S7H__
      #if             __CTS_S_p__
          #define     __CTS_S7L__
      #endif
  #endif


  //_T
  #if                 __CTS_T0t__
      #define         __CTS_T0H__
      #if             __CTS_T_p__
          #define     __CTS_T0L__
      #endif
  #endif
  #if                 __CTS_T1t__
      #define         __CTS_T1H__
      #if             __CTS_T_p__
          #define     __CTS_T1L__
      #endif
  #endif
  #if                 __CTS_T2t__
      #define         __CTS_T2H__
      #if             __CTS_T_p__
          #define     __CTS_T2L__
      #endif
  #endif
  #if                 __CTS_T3t__
      #define         __CTS_T3H__
      #if             __CTS_T_p__
          #define     __CTS_T3L__
      #endif
  #endif
  #if                 __CTS_T4t__
      #define         __CTS_T4H__
      #if             __CTS_T_p__
          #define     __CTS_T4L__
      #endif
  #endif
  #if                 __CTS_T5t__
      #define         __CTS_T5H__
      #if             __CTS_T_p__
          #define     __CTS_T5L__
      #endif
  #endif
  #if                 __CTS_T6t__
      #define         __CTS_T6H__
      #if             __CTS_T_p__
          #define     __CTS_T6L__
      #endif
  #endif
  #if                 __CTS_T7t__
      #define         __CTS_T7H__
      #if             __CTS_T_p__
          #define     __CTS_T7L__
      #endif
  #endif


  //_U
  #if                 __CTS_U0t__
      #define         __CTS_U0H__
      #if             __CTS_U_p__
          #define     __CTS_U0L__
      #endif
  #endif
  #if                 __CTS_U1t__
      #define         __CTS_U1H__
      #if             __CTS_U_p__
          #define     __CTS_U1L__
      #endif
  #endif
  #if                 __CTS_U2t__
      #define         __CTS_U2H__
      #if             __CTS_U_p__
          #define     __CTS_U2L__
      #endif
  #endif
  #if                 __CTS_U3t__
      #define         __CTS_U3H__
      #if             __CTS_U_p__
          #define     __CTS_U3L__
      #endif
  #endif
  #if                 __CTS_U4t__
      #define         __CTS_U4H__
      #if             __CTS_U_p__
          #define     __CTS_U4L__
      #endif
  #endif
  #if                 __CTS_U5t__
      #define         __CTS_U5H__
      #if             __CTS_U_p__
          #define     __CTS_U5L__
      #endif
  #endif
  #if                 __CTS_U6t__
      #define         __CTS_U6H__
      #if             __CTS_U_p__
          #define     __CTS_U6L__
      #endif
  #endif
  #if                 __CTS_U7t__
      #define         __CTS_U7H__
      #if             __CTS_U_p__
          #define     __CTS_U7L__
      #endif
  #endif



  //_V
  #if                 __CTS_V0t__
      #define         __CTS_V0H__
      #if             __CTS_V_p__
          #define     __CTS_V0L__
      #endif
  #endif
  #if                 __CTS_V1t__
      #define         __CTS_V1H__
      #if             __CTS_V_p__
          #define     __CTS_V1L__
      #endif
  #endif
  #if                 __CTS_V2t__
      #define         __CTS_V2H__
      #if             __CTS_V_p__
          #define     __CTS_V2L__
      #endif
  #endif
  #if                 __CTS_V3t__
      #define         __CTS_V3H__
      #if             __CTS_V_p__
          #define     __CTS_V3L__
      #endif
  #endif
  #if                 __CTS_V4t__
      #define         __CTS_V4H__
      #if             __CTS_V_p__
          #define     __CTS_V4L__
      #endif
  #endif
  #if                 __CTS_V5t__
      #define         __CTS_V5H__
      #if             __CTS_V_p__
          #define     __CTS_V5L__
      #endif
  #endif
  #if                 __CTS_V6t__
      #define         __CTS_V6H__
      #if             __CTS_V_p__
          #define     __CTS_V6L__
      #endif
  #endif
  #if                 __CTS_V7t__
      #define         __CTS_V7H__
      #if             __CTS_V_p__
          #define     __CTS_V7L__
      #endif
  #endif


  //_W
  #if                 __CTS_W0t__
      #define         __CTS_W0H__
      #if             __CTS_W_p__
          #define     __CTS_W0L__
      #endif
  #endif
  #if                 __CTS_W1t__
      #define         __CTS_W1H__
      #if             __CTS_W_p__
          #define     __CTS_W1L__
      #endif
  #endif
  #if                 __CTS_W2t__
      #define         __CTS_W2H__
      #if             __CTS_W_p__
          #define     __CTS_W2L__
      #endif
  #endif
  #if                 __CTS_W3t__
      #define         __CTS_W3H__
      #if             __CTS_W_p__
          #define     __CTS_W3L__
      #endif
  #endif
  #if                 __CTS_W4t__
      #define         __CTS_W4H__
      #if             __CTS_W_p__
          #define     __CTS_W4L__
      #endif
  #endif
  #if                 __CTS_W5t__
      #define         __CTS_W5H__
      #if             __CTS_W_p__
          #define     __CTS_W5L__
      #endif
  #endif
  #if                 __CTS_W6t__
      #define         __CTS_W6H__
      #if             __CTS_W_p__
          #define     __CTS_W6L__
      #endif
  #endif
  #if                 __CTS_W7t__
      #define         __CTS_W7H__
      #if             __CTS_W_p__
          #define     __CTS_W7L__
      #endif
  #endif


  //_X
  //_Y
  //_Z


  /*******************************************************************************
  * Utils
  *******************************************************************************/

  #define Nibs2Char(H,L)  (H<<4|L)
  #define NibH2Char(H,B)  ((B&0x0F)|(H<<4))
  #define NibL2Char(L,B)  ((B&0xF0)|(L))
  #define Char2NibH(HL)   (HL>>4)
  #define Char2NibL(HL)   (HL&0x0F)

#endif /*CTS_LowTypes_H*/
